/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.block.painted;

import com.enderio.core.common.util.NullHelper;
import com.google.common.base.Predicate;
import crazypants.enderio.util.CapturedMob;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.EntityShulker;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.passive.EntitySkeletonHorse;
import net.minecraft.entity.passive.EntityZombieHorse;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IStringSerializable;

public enum EnumPressurePlateType implements IStringSerializable
{
    WOOD(true, Entity.class),
    STONE(true, EntityLivingBase.class),
    IRON(true, CountingMode.ENTITIES, Entity.class),
    GOLD(true, CountingMode.ITEMS, EntityItem.class),
    DARKSTEEL(false, EntityPlayer.class),
    SOULARIUM(false, EntityLiving.class, EntitySlime.class, EntityGhast.class, EntityMob.class, EntitySkeletonHorse.class, EntityZombieHorse.class, EntityShulker.class),
    TUNED(false, EntityLivingBase.class){

        @Override
        @Nonnull
        public Predicate<Entity> getPredicate(final @Nullable CapturedMob capturedMob) {
            return new Predicate<Entity>(){

                public boolean apply(@Nullable Entity entity) {
                    if (capturedMob == null || entity == null || !entity.func_70089_S() || entity.func_145773_az() || entity instanceof EntityPlayer && ((EntityPlayer)entity).func_175149_v()) {
                        return false;
                    }
                    return capturedMob.isSameType(entity);
                }

                public int hashCode() {
                    return super.hashCode();
                }

                public boolean equals(@Nullable Object obj) {
                    return super.equals(obj);
                }
            };
        }
    };

    private final boolean shadowsVanilla;
    @Nonnull
    private final CountingMode countingMode;
    @Nonnull
    private final Class<? extends Entity> searchClass;
    @Nonnull
    private final List<Class<? extends Entity>> whiteClasses;

    private EnumPressurePlateType(boolean shadowsVanilla, Class<? extends Entity> searchClass) {
        this.shadowsVanilla = shadowsVanilla;
        this.countingMode = CountingMode.BINARY;
        this.searchClass = searchClass;
        this.whiteClasses = Collections.emptyList();
    }

    private EnumPressurePlateType(boolean shadowsVanilla, Class<? extends Entity> searchClass, Class<? extends Entity> ... whiteClasses) {
        this.shadowsVanilla = shadowsVanilla;
        this.countingMode = CountingMode.BINARY;
        this.searchClass = searchClass;
        this.whiteClasses = Arrays.asList(whiteClasses);
    }

    private EnumPressurePlateType(@Nonnull boolean shadowsVanilla, CountingMode countingMode, Class<? extends Entity> searchClass) {
        this.shadowsVanilla = shadowsVanilla;
        this.countingMode = countingMode;
        this.searchClass = searchClass;
        this.whiteClasses = Collections.emptyList();
    }

    private EnumPressurePlateType(@Nonnull boolean shadowsVanilla, CountingMode countingMode, Class<? extends Entity> searchClass, Class<? extends Entity> ... whiteClasses) {
        this.shadowsVanilla = shadowsVanilla;
        this.countingMode = countingMode;
        this.searchClass = searchClass;
        this.whiteClasses = Arrays.asList(whiteClasses);
    }

    @Nonnull
    public String func_176610_l() {
        return this.name().toLowerCase(Locale.ENGLISH);
    }

    @Nonnull
    public String getUnlocName(@Nonnull Item me) {
        return me.func_77658_a() + "." + this.func_176610_l();
    }

    @Nonnull
    public static EnumPressurePlateType getTypeFromMeta(int meta) {
        int meta1 = meta >> 1;
        return (EnumPressurePlateType)((Object)NullHelper.notnullJ((Object)((Object)EnumPressurePlateType.values()[meta1 >= 0 && meta1 < EnumPressurePlateType.values().length ? meta1 : 0]), (String)"Enum.values()"));
    }

    public static boolean getSilentFromMeta(int meta) {
        return (meta & 1) != 0;
    }

    public static int getMetaFromType(EnumPressurePlateType value, boolean isSilent) {
        return value.ordinal() << 1 | (isSilent ? 1 : 0);
    }

    public int getMetaFromType(boolean isSilent) {
        return EnumPressurePlateType.getMetaFromType(this, isSilent);
    }

    public int getMetaFromType() {
        return EnumPressurePlateType.getMetaFromType(this, false);
    }

    @Nonnull
    protected CountingMode getCountingMode() {
        return this.countingMode;
    }

    @Nonnull
    public Class<? extends Entity> getSearchClass() {
        return this.searchClass;
    }

    @Nonnull
    public Predicate<Entity> getPredicate(final @Nullable CapturedMob capturedMob) {
        return new Predicate<Entity>(){

            public boolean apply(@Nullable Entity entity) {
                if (entity == null) {
                    return false;
                }
                if (!entity.func_70089_S() || entity.func_145773_az() || entity instanceof EntityPlayer && ((EntityPlayer)entity).func_175149_v() || capturedMob != null && !capturedMob.isSameType(entity)) {
                    return false;
                }
                if (EnumPressurePlateType.this.searchClass.isInstance(entity) && EnumPressurePlateType.this.whiteClasses.isEmpty()) {
                    return true;
                }
                for (Class clazz : EnumPressurePlateType.this.whiteClasses) {
                    if (!clazz.isInstance(entity)) continue;
                    return true;
                }
                return false;
            }

            public int hashCode() {
                return super.hashCode();
            }

            public boolean equals(@Nullable Object obj) {
                return super.equals(obj);
            }
        };
    }

    public boolean isShadowsVanilla() {
        return this.shadowsVanilla;
    }

    public static enum CountingMode {
        BINARY{

            @Override
            public int count(List<Entity> list) {
                return list.isEmpty() ? 0 : 15;
            }
        }
        ,
        ENTITIES{

            @Override
            public int count(List<Entity> list) {
                return Math.min(15, list.size());
            }
        }
        ,
        ITEMS{

            @Override
            public int count(List<Entity> list) {
                int result = 0;
                for (Entity entity : list) {
                    ItemStack stack;
                    if (!(entity instanceof EntityItem) || (result += (stack = ((EntityItem)entity).func_92059_d()).func_190916_E()) < 15) continue;
                    return 15;
                }
                return Math.min(15, result);
            }
        };


        public abstract int count(List<Entity> var1);
    }
}

