/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.compat.opencomputers;

import blusunrize.immersiveengineering.common.blocks.TileEntityIEBase;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityMixer;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityMultiblockMetal;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.compat.opencomputers.ManagedEnvironmentIE;
import java.util.Map;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.ManagedEnvironment;
import li.cil.oc.api.prefab.DriverSidedTileEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class MixerDriver
extends DriverSidedTileEntity {
    public ManagedEnvironment createEnvironment(World w, BlockPos bp, EnumFacing facing) {
        TileEntityMixer arc;
        TileEntityMixer master;
        TileEntity te = w.func_175625_s(bp);
        if (te instanceof TileEntityMixer && (master = (TileEntityMixer)(arc = (TileEntityMixer)te).master()) != null && arc.isRedstonePos()) {
            return new MixerEnvironment(w, master.func_174877_v(), TileEntityMixer.class);
        }
        return null;
    }

    public Class<?> getTileEntityClass() {
        return TileEntityMixer.class;
    }

    public class MixerEnvironment
    extends ManagedEnvironmentIE.ManagedEnvMultiblock<TileEntityMixer> {
        public MixerEnvironment(World w, BlockPos p, Class<? extends TileEntityIEBase> teClass) {
            super(w, p, teClass);
        }

        @Callback(doc="function():int -- gets the maximum amount of energy stored")
        public Object[] getMaxEnergyStored(Context context, Arguments args) {
            return new Object[]{((TileEntityMixer)this.getTileEntity()).energyStorage.getMaxEnergyStored()};
        }

        @Callback(doc="function():int -- gets the amount of energy stored")
        public Object[] getEnergyStored(Context context, Arguments args) {
            return new Object[]{((TileEntityMixer)this.getTileEntity()).energyStorage.getEnergyStored()};
        }

        @Callback(doc="function():boolean -- checks whether the mixer is currently active")
        public Object[] isActive(Context context, Arguments args) {
            return new Object[]{((TileEntityMixer)this.getTileEntity()).shouldRenderAsActive()};
        }

        @Callback(doc="function(stack:int):table -- returns the specified input stack as described in the manual")
        public Object[] getInputStack(Context context, Arguments args) {
            int slot = args.checkInteger(0);
            if (slot < 1 || slot > 12) {
                throw new IllegalArgumentException("Input slots are 1-12");
            }
            TileEntityMixer master = (TileEntityMixer)this.getTileEntity();
            Map<String, Object> stack = Utils.saveStack((ItemStack)master.inventory.get(slot - 1));
            block0: for (TileEntityMultiblockMetal.MultiblockProcess p : master.processQueue) {
                for (int i : ((TileEntityMultiblockMetal.MultiblockProcessInMachine)p).getInputSlots()) {
                    if (i != slot - 1) continue;
                    stack.put("progress", p.processTick);
                    stack.put("maxProgress", p.maxTicks);
                    break block0;
                }
            }
            if (!stack.containsKey("progress")) {
                stack.put("progress", 0);
                stack.put("maxProgress", 0);
            }
            return new Object[]{stack};
        }

        @Callback(doc="function():table -- get bottom fluid in tank")
        public Object[] getTank(Context context, Arguments args) {
            return new Object[]{((TileEntityMixer)this.getTileEntity()).tank.getInfo()};
        }

        @Callback(doc="function():boolean -- check whether a valid recipe exists for the current inputs")
        public Object[] isValidRecipe(Context context, Arguments args) {
            return new Object[]{((TileEntityMultiblockMetal.MultiblockProcess)((TileEntityMixer)this.getTileEntity()).processQueue.get((int)0)).recipe != null};
        }

        @Override
        @Callback(doc="function(enabled:bool):nil -- Enables or disables computer control for the attached machine")
        public Object[] enableComputerControl(Context context, Arguments args) {
            return super.enableComputerControl(context, args);
        }

        @Override
        @Callback(doc="function(enabled:bool):nil -- Enables or disables the machine. Call \"enableComputerControl(true)\" before using this and disable computer control before removing the computer")
        public Object[] setEnabled(Context context, Arguments args) {
            return super.setEnabled(context, args);
        }

        public String preferredName() {
            return "ie_mixer";
        }

        public int priority() {
            return 1000;
        }
    }
}

