/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.compat.crafttweaker;

import blusunrize.immersiveengineering.api.crafting.BottlingMachineRecipe;
import blusunrize.immersiveengineering.common.util.compat.crafttweaker.CraftTweakerHelper;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.liquid.ILiquidStack;
import java.util.List;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.immersiveengineering.BottlingMachine")
public class BottlingMachine {
    @ZenMethod
    public static void addRecipe(IItemStack output, IIngredient input, ILiquidStack fluid) {
        Object oInput = CraftTweakerHelper.toObject(input);
        if (oInput == null || output == null || fluid == null) {
            return;
        }
        BottlingMachineRecipe r = new BottlingMachineRecipe(CraftTweakerHelper.toStack(output), oInput, CraftTweakerHelper.toFluidStack(fluid));
        CraftTweakerAPI.apply((IAction)new Add(r));
    }

    @ZenMethod
    public static void removeRecipe(IItemStack output) {
        CraftTweakerAPI.apply((IAction)new Remove(CraftTweakerHelper.toStack(output)));
    }

    private static class Remove
    implements IAction {
        private final ItemStack output;
        List<BottlingMachineRecipe> removedRecipes;

        public Remove(ItemStack output) {
            this.output = output;
        }

        public void apply() {
            this.removedRecipes = BottlingMachineRecipe.removeRecipes(this.output);
        }

        public String describe() {
            return "Removing Bottling Machine Recipe for " + this.output.func_82833_r();
        }
    }

    private static class Add
    implements IAction {
        private final BottlingMachineRecipe recipe;

        public Add(BottlingMachineRecipe recipe) {
            this.recipe = recipe;
        }

        public void apply() {
            BottlingMachineRecipe.recipeList.add(this.recipe);
        }

        public String describe() {
            return "Adding Bottling Machine Recipe for " + this.recipe.output.func_82833_r();
        }
    }
}

