/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.tool;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.crafting.IngredientStack;
import java.util.ArrayList;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import org.apache.commons.lang3.tuple.Pair;

public class RailgunHandler {
    public static ArrayList<Pair<IngredientStack, RailgunProjectileProperties>> projectilePropertyMap = new ArrayList();

    public static RailgunProjectileProperties registerProjectileProperties(IngredientStack stack, double damage, double gravity) {
        RailgunProjectileProperties properties = new RailgunProjectileProperties(damage, gravity);
        projectilePropertyMap.add((Pair<IngredientStack, RailgunProjectileProperties>)Pair.of((Object)stack, (Object)properties));
        return properties;
    }

    public static RailgunProjectileProperties registerProjectileProperties(ItemStack stack, double damage, double gravity) {
        return RailgunHandler.registerProjectileProperties(ApiUtils.createIngredientStack(stack), damage, gravity);
    }

    public static RailgunProjectileProperties getProjectileProperties(ItemStack stack) {
        for (Pair<IngredientStack, RailgunProjectileProperties> pair : projectilePropertyMap) {
            if (!((IngredientStack)pair.getLeft()).matchesItemStack(stack)) continue;
            return (RailgunProjectileProperties)pair.getRight();
        }
        return null;
    }

    public static class RailgunProjectileProperties {
        public double damage;
        public double gravity;
        public int[][] colourMap = new int[][]{{0x686868, 0xA4A4A4, 0xA4A4A4, 0xA4A4A4, 0x686868}};

        public RailgunProjectileProperties(double damage, double gravity) {
            this.damage = damage;
            this.gravity = gravity;
        }

        public RailgunProjectileProperties setColourMap(int[][] map) {
            this.colourMap = map;
            return this;
        }

        public boolean overrideHitEntity(Entity entityHit, Entity shooter) {
            return false;
        }
    }
}

