/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.common.inventory;

import com.enderio.core.common.inventory.EnderInventory;
import com.enderio.core.common.inventory.InventorySlot;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;

public class EnderSlot
extends SlotItemHandler {
    @Nonnull
    protected final EnderInventory.Type type;

    public EnderSlot(@Nonnull EnderInventory.Type type, @Nonnull InventorySlot itemHandler, int xPosition, int yPosition) {
        super((IItemHandler)itemHandler, 0, xPosition, yPosition);
        this.type = type;
    }

    public EnderSlot(@Nonnull EnderInventory.Type type, @Nonnull EnderInventory enderInventory, @Nonnull String ident, int xPosition, int yPosition) {
        super((IItemHandler)enderInventory.getSlot(ident), 0, xPosition, yPosition);
        this.type = type;
    }

    public EnderSlot(@Nonnull EnderInventory.View enderInventory, @Nonnull String ident, int xPosition, int yPosition) {
        this(enderInventory.getType(), enderInventory.getParent(), ident, xPosition, yPosition);
    }

    protected EnderSlot(@Nonnull EnderInventory.Type type, @Nonnull EnderInventory enderInventory, @Nonnull Enum<?> ident, int xPosition, int yPosition) {
        super((IItemHandler)enderInventory.getSlot(ident), 0, xPosition, yPosition);
        this.type = type;
    }

    public EnderSlot(@Nonnull EnderInventory.View enderInventory, @Nonnull Enum<?> ident, int xPosition, int yPosition) {
        this(enderInventory.getType(), enderInventory.getParent(), ident, xPosition, yPosition);
    }

    public static List<EnderSlot> create(@Nonnull EnderInventory enderInventory, @Nonnull EnderInventory.Type type, int xPosition, int yPosition, int cols, int rows) {
        return EnderSlot.create(enderInventory, type, xPosition, yPosition, 18, 18, cols, rows);
    }

    public static List<EnderSlot> create(@Nonnull EnderInventory enderInventory, @Nonnull EnderInventory.Type type, int xPosition, int yPosition, int xOffset, int yOffset, int cols, int rows) {
        ArrayList<EnderSlot> result = new ArrayList<EnderSlot>();
        int x = 0;
        int y = 0;
        EnderInventory.View view = enderInventory.getView(type);
        for (int i = 0; i < view.getSlots(); ++i) {
            InventorySlot slot = view.getSlot(i);
            if (slot == null) continue;
            result.add(new EnderSlot(view.getType(), slot, xPosition + x * xOffset, yPosition + y * yOffset));
            if (++x < cols) continue;
            x = 0;
            if (++y < rows) continue;
            return result;
        }
        return result;
    }

    public void func_75215_d(@Nonnull ItemStack stack) {
        ((InventorySlot)this.getItemHandler()).set(stack);
        this.func_75218_e();
    }

    public boolean func_75214_a(@Nonnull ItemStack stack) {
        return ((InventorySlot)this.getItemHandler()).isItemValidForSlot(stack);
    }

    public int func_178170_b(@Nonnull ItemStack stack) {
        return this.func_75219_a();
    }

    public int func_75219_a() {
        return ((InventorySlot)this.getItemHandler()).getMaxStackSize();
    }

    public boolean isSameInventory(Slot other) {
        return other instanceof EnderSlot && ((InventorySlot)((EnderSlot)other).getItemHandler()).getOwner() == ((InventorySlot)this.getItemHandler()).getOwner();
    }

    @Nonnull
    public EnderInventory.Type getType() {
        return this.type;
    }

    public boolean is(@Nonnull EnderInventory.Type typeIn) {
        return this.type == typeIn;
    }

    public static boolean is(@Nullable Slot slot, @Nonnull EnderInventory.Type typeIn) {
        return slot != null && slot instanceof EnderSlot && ((EnderSlot)slot).is(typeIn);
    }
}

