/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.common.command;

import com.enderio.core.EnderCore;
import com.enderio.core.common.event.ConfigFileChangedEvent;
import com.enderio.core.common.util.NullHelper;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.commons.lang3.ArrayUtils;

public class CommandReloadConfigs
extends CommandBase {
    @Nonnull
    public static final CommandReloadConfigs SERVER = new CommandReloadConfigs(Side.SERVER);
    @Nonnull
    public static final CommandReloadConfigs CLIENT = new CommandReloadConfigs(Side.CLIENT);
    private static List<String> validModIDs = new ArrayList<String>();
    private final Side side;

    private CommandReloadConfigs(Side side) {
        this.side = side;
    }

    @Nonnull
    public String func_71517_b() {
        return this.side == Side.SERVER ? "reloadServerConfigs" : "reloadConfigs";
    }

    @Nonnull
    public String func_71518_a(@Nonnull ICommandSender p_71518_1_) {
        return "/" + this.func_71517_b() + " <modid> (<modid2> <modid3> ...)";
    }

    public int func_82362_a() {
        return 2;
    }

    @Nonnull
    public List<String> func_184883_a(@Nonnull MinecraftServer server, @Nonnull ICommandSender sender, @Nonnull String[] args, @Nullable BlockPos pos) {
        if (args.length >= 1) {
            Object[] avail = NullHelper.notnullJ(validModIDs.toArray(new String[validModIDs.size()]), "List.toArray()");
            for (int i = 0; i < args.length - 1; ++i) {
                avail = (String[])ArrayUtils.removeElement((Object[])avail, (Object)args[i]);
            }
            return CommandReloadConfigs.func_71530_a((String[])args, (String[])avail);
        }
        return super.func_184883_a(server, sender, args, pos);
    }

    public boolean func_184882_a(@Nonnull MinecraftServer server, @Nonnull ICommandSender sender) {
        return sender.func_130014_f_().field_72995_K || super.func_184882_a(server, sender);
    }

    public void func_184881_a(@Nonnull MinecraftServer server, @Nonnull ICommandSender sender, @Nonnull String[] args) throws CommandException {
        if (this.side == Side.CLIENT == sender.func_130014_f_().field_72995_K) {
            for (String s : args) {
                boolean validModid = false;
                for (ModContainer mod : Loader.instance().getModObjectList().keySet()) {
                    if (!mod.getModId().equals(s)) continue;
                    validModid = true;
                }
                if (validModid) {
                    ConfigFileChangedEvent event = new ConfigFileChangedEvent(s);
                    MinecraftForge.EVENT_BUS.post((Event)event);
                    if (event.isSuccessful()) {
                        CommandReloadConfigs.sendResult(sender, s, "success");
                        continue;
                    }
                    CommandReloadConfigs.sendResult(sender, s, "fail");
                    continue;
                }
                CommandReloadConfigs.sendResult(sender, s, "invalid");
            }
        }
    }

    private static void sendResult(ICommandSender player, String modid, String result) {
        player.func_145747_a((ITextComponent)new TextComponentString(EnderCore.lang.localize("command.config.result." + result, modid)));
    }

    static {
        EnderCore.logger.info("Sending dummy event to all mods");
        for (ModContainer mod : Loader.instance().getActiveModList()) {
            ConfigFileChangedEvent event = new ConfigFileChangedEvent(mod.getModId());
            MinecraftForge.EVENT_BUS.post((Event)event);
            if (!event.isSuccessful()) continue;
            validModIDs.add(mod.getModId());
        }
    }
}

