/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.common;

import com.enderio.core.api.common.util.ITankAccess;
import com.enderio.core.common.TileEntityBase;
import com.enderio.core.common.util.FluidUtil;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.ChunkCache;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;

public abstract class BlockEnder<T extends TileEntityBase>
extends Block {
    @Nullable
    protected final Class<? extends T> teClass;
    private IShape<T> shape = null;

    protected BlockEnder(@Nullable Class<? extends T> teClass) {
        this(teClass, new Material(MapColor.field_151668_h), MapColor.field_151668_h);
    }

    protected BlockEnder(@Nullable Class<? extends T> teClass, @Nonnull Material mat) {
        this(teClass, mat, mat.func_151565_r());
    }

    protected BlockEnder(@Nullable Class<? extends T> teClass, @Nonnull Material mat, MapColor mapColor) {
        super(mat);
        this.teClass = teClass;
        this.func_149711_c(0.5f);
        this.func_149672_a(SoundType.field_185852_e);
        this.setHarvestLevel("pickaxe", 0);
    }

    public boolean hasTileEntity(@Nonnull IBlockState state) {
        return this.teClass != null;
    }

    @Nonnull
    public EnumPushReaction func_149656_h(@Nonnull IBlockState state) {
        return this.teClass != null ? EnumPushReaction.BLOCK : super.func_149656_h(state);
    }

    @Nonnull
    public TileEntity createTileEntity(@Nonnull World world, @Nonnull IBlockState state) {
        if (this.teClass != null) {
            try {
                TileEntityBase te = (TileEntityBase)((Object)this.teClass.newInstance());
                te.func_190201_b(world);
                te.init();
                return te;
            }
            catch (Exception e) {
                throw new RuntimeException("Could not create tile entity for block " + this.func_149732_F() + " for class " + this.teClass, e);
            }
        }
        throw new RuntimeException("Cannot create a TileEntity for a block that doesn't have a TileEntity. This is not a problem with EnderCore, this is caused by the caller.");
    }

    public boolean func_180639_a(@Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nonnull EntityPlayer playerIn, @Nonnull EnumHand hand, @Nonnull EnumFacing side, float hitX, float hitY, float hitZ) {
        if (playerIn.func_70093_af()) {
            return false;
        }
        T te = this.getTileEntity((IBlockAccess)worldIn, pos);
        if (te instanceof ITankAccess) {
            if (FluidUtil.fillInternalTankFromPlayerHandItem(worldIn, pos, playerIn, hand, (ITankAccess)te)) {
                return true;
            }
            if (FluidUtil.fillPlayerHandItemFromInternalTank(worldIn, pos, playerIn, hand, (ITankAccess)te)) {
                return true;
            }
        }
        return this.openGui(worldIn, pos, playerIn, side);
    }

    protected boolean openGui(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull EntityPlayer entityPlayer, @Nonnull EnumFacing side) {
        return false;
    }

    public boolean removedByPlayer(@Nonnull IBlockState state, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull EntityPlayer player, boolean willHarvest) {
        if (willHarvest) {
            return true;
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest);
    }

    public void func_180657_a(@Nonnull World worldIn, @Nonnull EntityPlayer player, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nullable TileEntity te, @Nonnull ItemStack stack) {
        super.func_180657_a(worldIn, player, pos, state, te, stack);
        worldIn.func_175698_g(pos);
    }

    public final void getDrops(@Nonnull NonNullList<ItemStack> drops, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull IBlockState state, int fortune) {
        T te = this.getTileEntity(world, pos);
        ItemStack drop = this.getNBTDrop(world, pos, state, fortune, te);
        if (drop != null) {
            drops.add((Object)drop);
        }
        this.getExtraDrops(drops, world, pos, state, fortune, te);
    }

    @Deprecated
    @Nonnull
    public ItemStack getPickBlock(@Nonnull IBlockState state, @Nonnull RayTraceResult target, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull EntityPlayer player) {
        ItemStack nbtDrop;
        if (player.field_71075_bZ.field_75098_d && GuiScreen.func_146271_m() && (nbtDrop = this.getNBTDrop((IBlockAccess)world, pos, state, 0, this.getTileEntity((IBlockAccess)world, pos))) != null) {
            return nbtDrop;
        }
        return this.processPickBlock(state, target, world, pos, player, super.getPickBlock(state, target, world, pos, player));
    }

    @Nonnull
    protected ItemStack processPickBlock(@Nonnull IBlockState state, @Nonnull RayTraceResult target, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull EntityPlayer player, @Nonnull ItemStack pickBlock) {
        return pickBlock;
    }

    @Nullable
    public ItemStack getNBTDrop(@Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull IBlockState state, int fortune, @Nullable T te) {
        ItemStack itemStack = new ItemStack((Block)this, 1, this.func_180651_a(state));
        this.processDrop(world, pos, te, itemStack);
        return itemStack;
    }

    protected final void processDrop(@Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nullable T te, @Nonnull ItemStack drop) {
        if (te != null) {
            ((TileEntityBase)((Object)te)).writeCustomNBT(drop);
        }
    }

    public void getExtraDrops(@Nonnull NonNullList<ItemStack> drops, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull IBlockState state, int fortune, @Nullable T te) {
    }

    public final void func_180633_a(@Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nonnull EntityLivingBase placer, @Nonnull ItemStack stack) {
        this.onBlockPlaced(worldIn, pos, state, placer, stack);
        T te = this.getTileEntity((IBlockAccess)worldIn, pos);
        if (te != null) {
            ((TileEntityBase)((Object)te)).readCustomNBT(stack);
            this.onBlockPlaced(worldIn, pos, state, placer, te);
        }
    }

    public void onBlockPlaced(@Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nonnull EntityLivingBase placer, @Nonnull ItemStack stack) {
    }

    public void onBlockPlaced(@Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nonnull EntityLivingBase placer, @Nonnull T te) {
    }

    @Nullable
    protected T getTileEntity(@Nonnull IBlockAccess world, @Nonnull BlockPos pos) {
        TileEntity te;
        Class<T> teClass2 = this.teClass;
        if (teClass2 != null && teClass2.isInstance(te = world.func_175625_s(pos))) {
            return (T)((Object)((TileEntityBase)((Object)teClass2.cast(te))));
        }
        return null;
    }

    @Nullable
    protected T getTileEntitySafe(@Nonnull IBlockAccess world, @Nonnull BlockPos pos) {
        if (world instanceof ChunkCache) {
            TileEntity te;
            Class<T> teClass2 = this.teClass;
            if (teClass2 != null && teClass2.isInstance(te = ((ChunkCache)world).func_190300_a(pos, Chunk.EnumCreateEntityType.CHECK))) {
                return (T)((Object)((TileEntityBase)((Object)teClass2.cast(te))));
            }
            return null;
        }
        return this.getTileEntity(world, pos);
    }

    @Nullable
    public static TileEntity getAnyTileEntitySafe(@Nonnull IBlockAccess world, @Nonnull BlockPos pos) {
        return BlockEnder.getAnyTileEntitySafe(world, pos, TileEntity.class);
    }

    @Nullable
    public static <Q> Q getAnyTileEntitySafe(@Nonnull IBlockAccess world, @Nonnull BlockPos pos, Class<Q> teClass) {
        TileEntity te = null;
        if (world instanceof ChunkCache) {
            te = ((ChunkCache)world).func_190300_a(pos, Chunk.EnumCreateEntityType.CHECK);
        } else if (world instanceof World) {
            if (((World)world).func_175667_e(pos)) {
                te = world.func_175625_s(pos);
            }
        } else {
            te = world.func_175625_s(pos);
        }
        if (teClass == null) {
            return (Q)te;
        }
        if (teClass.isInstance(te)) {
            return teClass.cast(te);
        }
        return null;
    }

    @Nullable
    public static <Q> Q getAnyTileEntity(@Nonnull IBlockAccess world, @Nonnull BlockPos pos, Class<Q> teClass) {
        TileEntity te = world.func_175625_s(pos);
        if (teClass == null) {
            return (Q)te;
        }
        if (teClass.isInstance(te)) {
            return teClass.cast(te);
        }
        return null;
    }

    protected boolean shouldDoWorkThisTick(@Nonnull World world, @Nonnull BlockPos pos, int interval) {
        T te = this.getTileEntity((IBlockAccess)world, pos);
        if (te == null) {
            return world.func_82737_E() % (long)interval == 0L;
        }
        return ((TileEntityBase)((Object)te)).shouldDoWorkThisTick(interval);
    }

    protected boolean shouldDoWorkThisTick(@Nonnull World world, @Nonnull BlockPos pos, int interval, int offset) {
        T te = this.getTileEntity((IBlockAccess)world, pos);
        if (te == null) {
            return (world.func_82737_E() + (long)offset) % (long)interval == 0L;
        }
        return ((TileEntityBase)((Object)te)).shouldDoWorkThisTick(interval, offset);
    }

    public Class<? extends T> getTeClass() {
        return this.teClass;
    }

    @Nonnull
    public Block func_149647_a(@Nullable CreativeTabs tab) {
        return super.func_149647_a(tab);
    }

    public void setShape(IShape<T> shape) {
        this.shape = shape;
    }

    @Nonnull
    public final BlockFaceShape func_193383_a(@Nonnull IBlockAccess worldIn, @Nonnull IBlockState state, @Nonnull BlockPos pos, @Nonnull EnumFacing face) {
        if (this.shape != null) {
            T te = this.getTileEntitySafe(worldIn, pos);
            if (te != null) {
                return this.shape.getBlockFaceShape(worldIn, state, pos, face, te);
            }
            return this.shape.getBlockFaceShape(worldIn, state, pos, face);
        }
        return super.func_193383_a(worldIn, state, pos, face);
    }

    @Nonnull
    protected IShape<T> mkShape(final @Nonnull BlockFaceShape allFaces) {
        return new IShape<T>(){

            @Override
            @Nonnull
            public BlockFaceShape getBlockFaceShape(@Nonnull IBlockAccess worldIn, @Nonnull IBlockState state, @Nonnull BlockPos pos, @Nonnull EnumFacing face) {
                return allFaces;
            }
        };
    }

    @Nonnull
    protected IShape<T> mkShape(final @Nonnull BlockFaceShape upDown, final @Nonnull BlockFaceShape allSides) {
        return new IShape<T>(){

            @Override
            @Nonnull
            public BlockFaceShape getBlockFaceShape(@Nonnull IBlockAccess worldIn, @Nonnull IBlockState state, @Nonnull BlockPos pos, @Nonnull EnumFacing face) {
                return face == EnumFacing.UP || face == EnumFacing.DOWN ? upDown : allSides;
            }
        };
    }

    @Nonnull
    protected IShape<T> mkShape(final @Nonnull BlockFaceShape down, final @Nonnull BlockFaceShape up, final @Nonnull BlockFaceShape allSides) {
        return new IShape<T>(){

            @Override
            @Nonnull
            public BlockFaceShape getBlockFaceShape(@Nonnull IBlockAccess worldIn, @Nonnull IBlockState state, @Nonnull BlockPos pos, @Nonnull EnumFacing face) {
                return face == EnumFacing.UP ? up : (face == EnumFacing.DOWN ? down : allSides);
            }
        };
    }

    @Nonnull
    protected IShape<T> mkShape(final BlockFaceShape ... faces) {
        return new IShape<T>(){

            @Override
            @Nonnull
            public BlockFaceShape getBlockFaceShape(@Nonnull IBlockAccess worldIn, @Nonnull IBlockState state, @Nonnull BlockPos pos, @Nonnull EnumFacing face) {
                return faces[face.ordinal()];
            }
        };
    }

    public static interface IShape<T> {
        @Nonnull
        public BlockFaceShape getBlockFaceShape(@Nonnull IBlockAccess var1, @Nonnull IBlockState var2, @Nonnull BlockPos var3, @Nonnull EnumFacing var4);

        @Nonnull
        default public BlockFaceShape getBlockFaceShape(@Nonnull IBlockAccess worldIn, @Nonnull IBlockState state, @Nonnull BlockPos pos, @Nonnull EnumFacing face, @Nonnull T te) {
            return this.getBlockFaceShape(worldIn, state, pos, face);
        }
    }
}

