/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.gui.element;

import cofh.core.gui.GuiContainerCore;
import cofh.core.gui.element.ElementButtonBase;
import net.minecraft.client.renderer.GlStateManager;

public abstract class ElementButtonManaged
extends ElementButtonBase {
    private String _text;

    public ElementButtonManaged(GuiContainerCore containerScreen, int posX, int posY, int sizeX, int sizeY, String text) {
        super(containerScreen, posX, posY, sizeX, sizeY);
        this._text = text;
    }

    public void setText(String text) {
        this._text = text;
    }

    public String getText() {
        return this._text;
    }

    protected void bindTexture(int mouseX, int mouseY) {
        if (!this.isEnabled()) {
            this.gui.bindTexture(DISABLED);
        } else if (this.intersectsWith(mouseX, mouseY)) {
            this.gui.bindTexture(HOVER);
        } else {
            this.gui.bindTexture(ENABLED);
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    @Override
    public void drawBackground(int mouseX, int mouseY, float gameTicks) {
        this.bindTexture(mouseX, mouseY);
        this.drawTexturedModalRect(this.posX, this.posY, 0, 0, this.sizeX / 2, this.sizeY / 2);
        this.drawTexturedModalRect(this.posX, this.posY + this.sizeY / 2, 0, 256 - this.sizeY / 2, this.sizeX / 2, this.sizeY / 2);
        this.drawTexturedModalRect(this.posX + this.sizeX / 2, this.posY, 256 - this.sizeX / 2, 0, this.sizeX / 2, this.sizeY / 2);
        this.drawTexturedModalRect(this.posX + this.sizeX / 2, this.posY + this.sizeY / 2, 256 - this.sizeX / 2, 256 - this.sizeY / 2, this.sizeX / 2, this.sizeY / 2);
    }

    @Override
    public void drawForeground(int mouseX, int mouseY) {
        String text = this.getFontRenderer().func_78269_a(this._text, this.sizeX - 4);
        this.drawCenteredString(this.getFontRenderer(), text, this.posX + this.sizeX / 2, this.posY + (this.sizeY - 8) / 2, this.getTextColor(mouseX, mouseY));
    }

    protected int getTextColor(int mouseX, int mouseY) {
        if (!this.isEnabled()) {
            return -6250336;
        }
        if (this.intersectsWith(mouseX, mouseY)) {
            return 0xFFFFA0;
        }
        return 0xE0E0E0;
    }

    @Override
    public abstract void onClick();
}

