/*
 * Decompiled with CFR 0.152.
 */
package c4.conarm.integrations.crafttweaker.brackets;

import c4.conarm.integrations.crafttweaker.materials.ConArmMaterial;
import c4.conarm.integrations.crafttweaker.materials.IConArmMaterial;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.annotations.BracketHandler;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IngredientAny;
import crafttweaker.zenscript.IBracketHandler;
import java.util.List;
import slimeknights.tconstruct.library.TinkerRegistry;
import stanhebben.zenscript.compiler.IEnvironmentGlobal;
import stanhebben.zenscript.expression.Expression;
import stanhebben.zenscript.expression.ExpressionCallStatic;
import stanhebben.zenscript.expression.ExpressionString;
import stanhebben.zenscript.expression.partial.IPartialExpression;
import stanhebben.zenscript.parser.Token;
import stanhebben.zenscript.symbols.IZenSymbol;
import stanhebben.zenscript.type.natives.IJavaMethod;
import stanhebben.zenscript.util.ZenPosition;

@BracketHandler(priority=100)
@ZenRegister
public class MaterialBracketHandler
implements IBracketHandler {
    private final IZenSymbol symbolAny = CraftTweakerAPI.getJavaStaticFieldSymbol(IngredientAny.class, (String)"INSTANCE");
    private final IJavaMethod method = CraftTweakerAPI.getJavaMethod(MaterialBracketHandler.class, (String)"getMaterial", (Class[])new Class[]{String.class});

    public static IConArmMaterial getMaterial(String name) {
        return new ConArmMaterial(TinkerRegistry.getMaterial((String)name));
    }

    public IZenSymbol resolve(IEnvironmentGlobal environment, List<Token> tokens) {
        if (tokens.size() == 1 && tokens.get(0).getValue().equals("*")) {
            return this.symbolAny;
        }
        if (tokens.size() > 2 && tokens.get(0).getValue().equals("conmat") && tokens.get(1).getValue().equals(":")) {
            return this.find(environment, tokens, 2, tokens.size());
        }
        return null;
    }

    private IZenSymbol find(IEnvironmentGlobal environment, List<Token> tokens, int startIndex, int endIndex) {
        StringBuilder valueBuilder = new StringBuilder();
        for (int i = startIndex; i < endIndex; ++i) {
            Token token = tokens.get(i);
            valueBuilder.append(token.getValue());
        }
        IConArmMaterial material = MaterialBracketHandler.getMaterial(valueBuilder.toString());
        if (!material.getName().equals("unknown")) {
            CraftTweakerAPI.logInfo((String)"Material wasn't null");
            return new MaterialReferenceSymbol(environment, valueBuilder.toString());
        }
        CraftTweakerAPI.logInfo((String)"Material was null");
        return null;
    }

    private class MaterialReferenceSymbol
    implements IZenSymbol {
        private final IEnvironmentGlobal environment;
        private final String name;

        MaterialReferenceSymbol(IEnvironmentGlobal environment, String name) {
            this.environment = environment;
            this.name = name;
        }

        public IPartialExpression instance(ZenPosition position) {
            return new ExpressionCallStatic(position, this.environment, MaterialBracketHandler.this.method, new Expression[]{new ExpressionString(position, this.name)});
        }
    }
}

