/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.WorldEntitySpawner;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.NoiseGeneratorOctaves;
import net.minecraft.world.gen.feature.WorldGenDungeons;
import net.minecraft.world.gen.feature.WorldGenLakes;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.event.terraingen.TerrainGen;
import twilightforest.TFConfig;
import twilightforest.TFFeature;
import twilightforest.biomes.TFBiomes;
import twilightforest.block.TFBlocks;
import twilightforest.world.ChunkGeneratorTFBase;
import twilightforest.world.MapGenTFHollowTree;
import twilightforest.world.TFGenCaves;
import twilightforest.world.TFGenRavine;
import twilightforest.world.TFWorld;

public class ChunkGeneratorTwilightForest
extends ChunkGeneratorTFBase {
    private final NoiseGeneratorOctaves minLimitPerlinNoise;
    private final NoiseGeneratorOctaves maxLimitPerlinNoise;
    private final NoiseGeneratorOctaves mainPerlinNoise;
    private final NoiseGeneratorOctaves noiseGen4;
    private final NoiseGeneratorOctaves depthNoise;
    private final double[] heightMap;
    private final float[] biomeWeights;
    private double[] mainNoiseRegion;
    private double[] minLimitRegion;
    private double[] maxLimitRegion;
    private double[] depthRegion;
    private final TFGenCaves caveGenerator = new TFGenCaves();
    private final TFGenRavine ravineGenerator = new TFGenRavine();
    private final MapGenTFHollowTree hollowTreeGenerator = new MapGenTFHollowTree();

    public ChunkGeneratorTwilightForest(World world, long seed, boolean enableFeatures) {
        super(world, seed, enableFeatures, true);
        this.minLimitPerlinNoise = new NoiseGeneratorOctaves(this.rand, 16);
        this.maxLimitPerlinNoise = new NoiseGeneratorOctaves(this.rand, 16);
        this.mainPerlinNoise = new NoiseGeneratorOctaves(this.rand, 8);
        this.noiseGen4 = new NoiseGeneratorOctaves(this.rand, 4);
        this.depthNoise = new NoiseGeneratorOctaves(this.rand, 16);
        this.heightMap = new double[825];
        this.biomeWeights = new float[25];
        for (int j = -2; j <= 2; ++j) {
            for (int k = -2; k <= 2; ++k) {
                float f;
                this.biomeWeights[j + 2 + (k + 2) * 5] = f = 10.0f / MathHelper.func_76129_c((float)((float)(j * j + k * k) + 0.2f));
            }
        }
    }

    public Chunk func_185932_a(int x, int z) {
        this.rand.setSeed(ChunkGeneratorTwilightForest.getSeed(x, z));
        ChunkPrimer primer = new ChunkPrimer();
        this.setBlocksInChunk(x, z, primer);
        this.squishTerrain(primer);
        this.addDarkForestCanopy2(x, z, primer);
        this.biomesForGeneration = this.world.func_72959_q().func_76933_b(this.biomesForGeneration, x * 16, z * 16, 16, 16);
        this.addGlaciers(x, z, primer, this.biomesForGeneration);
        this.deformTerrainForFeature(x, z, primer);
        this.replaceBiomeBlocks(x, z, primer, this.biomesForGeneration);
        this.caveGenerator.func_186125_a(this.world, x, z, primer);
        this.ravineGenerator.func_186125_a(this.world, x, z, primer);
        for (TFFeature feature : TFFeature.values()) {
            if (feature == TFFeature.NOTHING) continue;
            feature.getFeatureGenerator().func_186125_a(this.world, x, z, primer);
        }
        this.hollowTreeGenerator.func_186125_a(this.world, x, z, primer);
        return this.makeChunk(x, z, primer);
    }

    public void setBlocksInChunk(int x, int z, ChunkPrimer primer) {
        int seaLevel = 63;
        this.biomesForGeneration = this.world.func_72959_q().func_76937_a(this.biomesForGeneration, x * 4 - 2, z * 4 - 2, 10, 10);
        this.generateHeightmap(x * 4, 0, z * 4);
        for (int k = 0; k < 4; ++k) {
            int l = k * 5;
            int i1 = (k + 1) * 5;
            for (int j1 = 0; j1 < 4; ++j1) {
                int k1 = (l + j1) * 33;
                int l1 = (l + j1 + 1) * 33;
                int i2 = (i1 + j1) * 33;
                int j2 = (i1 + j1 + 1) * 33;
                for (int k2 = 0; k2 < 32; ++k2) {
                    double d0 = 0.125;
                    double d1 = this.heightMap[k1 + k2];
                    double d2 = this.heightMap[l1 + k2];
                    double d3 = this.heightMap[i2 + k2];
                    double d4 = this.heightMap[j2 + k2];
                    double d5 = (this.heightMap[k1 + k2 + 1] - d1) * d0;
                    double d6 = (this.heightMap[l1 + k2 + 1] - d2) * d0;
                    double d7 = (this.heightMap[i2 + k2 + 1] - d3) * d0;
                    double d8 = (this.heightMap[j2 + k2 + 1] - d4) * d0;
                    for (int l2 = 0; l2 < 8; ++l2) {
                        double d9 = 0.25;
                        double d10 = d1;
                        double d11 = d2;
                        double d12 = (d3 - d1) * d9;
                        double d13 = (d4 - d2) * d9;
                        for (int i3 = 0; i3 < 4; ++i3) {
                            double d14 = 0.25;
                            double d16 = (d11 - d10) * d14;
                            double d15 = d10 - d16;
                            for (int k3 = 0; k3 < 4; ++k3) {
                                double d;
                                d15 += d16;
                                if (d > 0.0) {
                                    primer.func_177855_a(k * 4 + i3, k2 * 8 + l2, j1 * 4 + k3, Blocks.field_150348_b.func_176223_P());
                                    continue;
                                }
                                if (k2 * 8 + l2 >= seaLevel) continue;
                                primer.func_177855_a(k * 4 + i3, k2 * 8 + l2, j1 * 4 + k3, Blocks.field_150355_j.func_176223_P());
                            }
                            d10 += d12;
                            d11 += d13;
                        }
                        d1 += d5;
                        d2 += d6;
                        d3 += d7;
                        d4 += d8;
                    }
                }
            }
        }
    }

    private void generateHeightmap(int x, int zero, int z) {
        this.depthRegion = this.depthNoise.func_76305_a(this.depthRegion, x, z, 5, 5, 200.0, 200.0, 0.5);
        this.mainNoiseRegion = this.mainPerlinNoise.func_76304_a(this.mainNoiseRegion, x, zero, z, 5, 33, 5, 8.555150000000001, 4.277575000000001, 8.555150000000001);
        this.minLimitRegion = this.minLimitPerlinNoise.func_76304_a(this.minLimitRegion, x, zero, z, 5, 33, 5, 684.412, 684.412, 684.412);
        this.maxLimitRegion = this.maxLimitPerlinNoise.func_76304_a(this.maxLimitRegion, x, zero, z, 5, 33, 5, 684.412, 684.412, 684.412);
        int terrainIndex = 0;
        int noiseIndex = 0;
        for (int ax = 0; ax < 5; ++ax) {
            for (int az = 0; az < 5; ++az) {
                float totalVariation = 0.0f;
                float totalHeight = 0.0f;
                float totalFactor = 0.0f;
                int two = 2;
                Biome biome = this.biomesForGeneration[ax + 2 + (az + 2) * 10];
                for (int ox = -two; ox <= two; ++ox) {
                    for (int oz = -two; oz <= two; ++oz) {
                        Biome biome1 = this.biomesForGeneration[ax + ox + 2 + (az + oz + 2) * 10];
                        float rootHeight = biome1.func_185355_j();
                        float heightVariation = biome1.func_185360_m();
                        if (this.terrainType == WorldType.field_151360_e && rootHeight > 0.0f) {
                            rootHeight = 1.0f + rootHeight * 2.0f;
                            heightVariation = 1.0f + heightVariation * 4.0f;
                        }
                        float heightFactor = this.biomeWeights[ox + 2 + (oz + 2) * 5] / (rootHeight + 2.0f);
                        if (biome1.func_185355_j() > biome.func_185355_j()) {
                            heightFactor /= 2.0f;
                        }
                        totalVariation += heightVariation * heightFactor;
                        totalHeight += rootHeight * heightFactor;
                        totalFactor += heightFactor;
                    }
                }
                totalVariation /= totalFactor;
                totalHeight /= totalFactor;
                totalVariation = totalVariation * 0.9f + 0.1f;
                totalHeight = (totalHeight * 4.0f - 1.0f) / 8.0f;
                double terrainNoise = this.depthRegion[noiseIndex] / 8000.0;
                if (terrainNoise < 0.0) {
                    terrainNoise = -terrainNoise * 0.3;
                }
                if ((terrainNoise = terrainNoise * 3.0 - 2.0) < 0.0) {
                    if ((terrainNoise /= 2.0) < -1.0) {
                        terrainNoise = -1.0;
                    }
                    terrainNoise /= 1.4;
                    terrainNoise /= 2.0;
                } else {
                    if (terrainNoise > 1.0) {
                        terrainNoise = 1.0;
                    }
                    terrainNoise /= 8.0;
                }
                ++noiseIndex;
                double heightCalc = totalHeight;
                double variationCalc = totalVariation;
                heightCalc += terrainNoise * 0.2;
                heightCalc = heightCalc * 8.5 / 8.0;
                double d5 = 8.5 + heightCalc * 4.0;
                for (int ay = 0; ay < 33; ++ay) {
                    double d6 = ((double)ay - d5) * 12.0 * 128.0 / 256.0 / variationCalc;
                    if (d6 < 0.0) {
                        d6 *= 4.0;
                    }
                    double d7 = this.minLimitRegion[terrainIndex] / 512.0;
                    double d8 = this.maxLimitRegion[terrainIndex] / 512.0;
                    double d9 = (this.mainNoiseRegion[terrainIndex] / 10.0 + 1.0) / 2.0;
                    double terrainCalc = MathHelper.func_151238_b((double)d7, (double)d8, (double)d9) - d6;
                    if (ay > 29) {
                        double d11 = (float)(ay - 29) / 3.0f;
                        terrainCalc = terrainCalc * (1.0 - d11) + -10.0 * d11;
                    }
                    this.heightMap[terrainIndex] = terrainCalc;
                    ++terrainIndex;
                }
            }
        }
    }

    private void squishTerrain(ChunkPrimer primer) {
        int squishHeight = TFWorld.MAXHEIGHT / 2;
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                for (int y = 0; y < TFWorld.CHUNKHEIGHT; ++y) {
                    if (y < squishHeight) {
                        primer.func_177855_a(x, y, z, primer.func_177856_a(x, y * 2 + 1, z));
                        continue;
                    }
                    primer.func_177855_a(x, y, z, Blocks.field_150350_a.func_176223_P());
                }
            }
        }
    }

    private void addGlaciers(int chunkX, int chunkZ, ChunkPrimer primer, Biome[] biomes) {
        IBlockState glacierBase = Blocks.field_150351_n.func_176223_P();
        IBlockState glacierMain = TFConfig.performance.glacierPackedIce ? Blocks.field_150403_cj.func_176223_P() : Blocks.field_150432_aD.func_176223_P();
        IBlockState glacierTop = Blocks.field_150432_aD.func_176223_P();
        for (int z = 0; z < 16; ++z) {
            for (int x = 0; x < 16; ++x) {
                Biome biome = biomes[x & 0xF | (z & 0xF) << 4];
                if (biome != TFBiomes.glacier) continue;
                int gBase = -1;
                for (int y = 127; y >= 0; --y) {
                    Block currentBlock = primer.func_177856_a(x, y, z).func_177230_c();
                    if (currentBlock != Blocks.field_150348_b) continue;
                    gBase = y + 1;
                    primer.func_177855_a(x, y, z, glacierBase);
                    break;
                }
                int gHeight = 32;
                int gTop = Math.min(gBase + gHeight, 127);
                for (int y = gBase; y < gTop; ++y) {
                    primer.func_177855_a(x, y, z, glacierMain);
                }
                primer.func_177855_a(x, gTop, z, glacierTop);
            }
        }
    }

    private void addDarkForestCanopy2(int chunkX, int chunkZ, ChunkPrimer primer) {
        int x;
        int z;
        int[] thicks = new int[25];
        for (z = 0; z < 5; ++z) {
            for (x = 0; x < 5; ++x) {
                for (int bx = -1; bx <= 1; ++bx) {
                    for (int bz = -1; bz <= 1; ++bz) {
                        Biome biome = this.biomesForGeneration[x + bx + 2 + (z + bz + 2) * 10];
                        if (biome != TFBiomes.darkForest && biome != TFBiomes.darkForestCenter) continue;
                        int n = x + z * 5;
                        thicks[n] = thicks[n] + 1;
                    }
                }
            }
        }
        for (z = 0; z < 16; ++z) {
            for (x = 0; x < 16; ++x) {
                Block currentBlock;
                boolean generateForest;
                int hz;
                int dz;
                int[] nearCenter;
                int hx;
                int dx;
                int dist;
                int qx = x / 4;
                int qz = z / 4;
                float xweight = (float)(x % 4) * 0.25f + 0.125f;
                float zweight = (float)(z % 4) * 0.25f + 0.125f;
                float thickness = 0.0f;
                thickness += (float)thicks[qx + qz * 5] * (1.0f - xweight) * (1.0f - zweight);
                thickness += (float)thicks[qx + 1 + qz * 5] * xweight * (1.0f - zweight);
                thickness += (float)thicks[qx + (qz + 1) * 5] * (1.0f - xweight) * zweight;
                thickness += (float)thicks[qx + 1 + (qz + 1) * 5] * xweight * zweight;
                thickness -= 4.0f;
                TFFeature nearFeature = TFFeature.getNearestFeature(chunkX, chunkZ, this.world);
                if (nearFeature == TFFeature.DARK_TOWER && (dist = (int)Math.sqrt((dx = x - (hx = (nearCenter = TFFeature.getNearestCenter(chunkX, chunkZ, this.world))[0])) * dx + (dz = z - (hz = nearCenter[1])) * dz)) < 24) {
                    thickness -= (float)(24 - dist);
                }
                boolean bl = generateForest = thickness > 1.0f;
                if (!generateForest) continue;
                double d = 0.03125;
                this.depthBuffer = this.noiseGen4.func_76304_a(this.depthBuffer, chunkX * 16, chunkZ * 16, 0, 16, 16, 1, d * 2.0, d * 2.0, d * 2.0);
                int topLevel = -1;
                for (int y = 127; y >= 0 && (currentBlock = primer.func_177856_a(x, y, z).func_177230_c()) != Blocks.field_150355_j; --y) {
                    if (currentBlock != Blocks.field_150348_b) continue;
                    topLevel = y;
                    break;
                }
                if (topLevel == -1) continue;
                int noise = Math.min(3, (int)(this.depthBuffer[z & 0xF | (x & 0xF) << 4] / 1.25));
                int treeBottom = topLevel + 12 - (int)(thickness * 0.5f);
                int treeTop = treeBottom + (int)(thickness * 1.5f);
                for (int y = treeBottom -= noise; y < treeTop; ++y) {
                    primer.func_177855_a(x, y, z, TFBlocks.dark_leaves.func_176223_P());
                }
            }
        }
    }

    public void func_185931_b(int x, int z) {
        BlockFalling.field_149832_M = true;
        int i = x * 16;
        int j = z * 16;
        BlockPos blockpos = new BlockPos(i, 0, j);
        Biome biome = this.world.func_180494_b(blockpos.func_177982_a(16, 0, 16));
        this.rand.setSeed(this.world.func_72905_C());
        long k = this.rand.nextLong() / 2L * 2L + 1L;
        long l = this.rand.nextLong() / 2L * 2L + 1L;
        this.rand.setSeed((long)x * k + (long)z * l ^ this.world.func_72905_C());
        boolean flag = false;
        ChunkPos chunkpos = new ChunkPos(x, z);
        ForgeEventFactory.onChunkPopulate((boolean)true, (IChunkGenerator)this, (World)this.world, (Random)this.rand, (int)x, (int)z, (boolean)flag);
        boolean disableFeatures = false;
        for (TFFeature feature : TFFeature.values()) {
            if (feature == TFFeature.NOTHING || !feature.getFeatureGenerator().func_175794_a(this.world, this.rand, chunkpos)) continue;
            disableFeatures = true;
        }
        disableFeatures = disableFeatures || !TFFeature.getNearestFeature((int)x, (int)z, (World)this.world).areChunkDecorationsEnabled;
        this.hollowTreeGenerator.func_175794_a(this.world, this.rand, chunkpos);
        if (!disableFeatures && this.rand.nextInt(4) == 0 && TerrainGen.populate((IChunkGenerator)this, (World)this.world, (Random)this.rand, (int)x, (int)x, (boolean)flag, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.LAKE)) {
            int i1 = blockpos.func_177958_n() + this.rand.nextInt(16) + 8;
            int i2 = this.rand.nextInt(TFWorld.CHUNKHEIGHT);
            int i3 = blockpos.func_177952_p() + this.rand.nextInt(16) + 8;
            if (i2 < TFWorld.SEALEVEL || this.allowSurfaceLakes(biome)) {
                new WorldGenLakes((Block)Blocks.field_150355_j).func_180709_b(this.world, this.rand, new BlockPos(i1, i2, i3));
            }
        }
        if (!disableFeatures && this.rand.nextInt(32) == 0 && TerrainGen.populate((IChunkGenerator)this, (World)this.world, (Random)this.rand, (int)x, (int)z, (boolean)flag, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.LAVA)) {
            int j1 = blockpos.func_177958_n() + this.rand.nextInt(16) + 8;
            int j2 = this.rand.nextInt(this.rand.nextInt(TFWorld.CHUNKHEIGHT - 8) + 8);
            int j3 = blockpos.func_177952_p() + this.rand.nextInt(16) + 8;
            if (j2 < TFWorld.SEALEVEL || this.allowSurfaceLakes(biome) && this.rand.nextInt(10) == 0) {
                new WorldGenLakes((Block)Blocks.field_150353_l).func_180709_b(this.world, this.rand, new BlockPos(j1, j2, j3));
            }
        }
        if (TerrainGen.populate((IChunkGenerator)this, (World)this.world, (Random)this.rand, (int)x, (int)z, (boolean)flag, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.DUNGEON)) {
            for (int k1 = 0; k1 < 8; ++k1) {
                int k2 = blockpos.func_177958_n() + this.rand.nextInt(16) + 8;
                int k3 = this.rand.nextInt(TFWorld.CHUNKHEIGHT);
                int l3 = blockpos.func_177952_p() + this.rand.nextInt(16) + 8;
                new WorldGenDungeons().func_180709_b(this.world, this.rand, new BlockPos(k2, k3, l3));
            }
        }
        biome.func_180624_a(this.world, this.rand, new BlockPos(i, 0, j));
        if (TerrainGen.populate((IChunkGenerator)this, (World)this.world, (Random)this.rand, (int)x, (int)z, (boolean)flag, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.ANIMALS)) {
            WorldEntitySpawner.func_77191_a((World)this.world, (Biome)biome, (int)(i + 8), (int)(j + 8), (int)16, (int)16, (Random)this.rand);
        }
        blockpos = blockpos.func_177982_a(8, 0, 8);
        if (TerrainGen.populate((IChunkGenerator)this, (World)this.world, (Random)this.rand, (int)x, (int)z, (boolean)flag, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.ICE)) {
            for (int k2 = 0; k2 < 16; ++k2) {
                for (int j3 = 0; j3 < 16; ++j3) {
                    BlockPos blockpos1 = this.world.func_175725_q(blockpos.func_177982_a(k2, 0, j3));
                    BlockPos blockpos2 = blockpos1.func_177977_b();
                    if (this.world.func_175675_v(blockpos2)) {
                        this.world.func_180501_a(blockpos2, Blocks.field_150432_aD.func_176223_P(), 2);
                    }
                    if (!this.world.func_175708_f(blockpos1, true)) continue;
                    this.world.func_180501_a(blockpos1, Blocks.field_150431_aC.func_176223_P(), 2);
                }
            }
        }
        ForgeEventFactory.onChunkPopulate((boolean)false, (IChunkGenerator)this, (World)this.world, (Random)this.rand, (int)x, (int)z, (boolean)flag);
        BlockFalling.field_149832_M = false;
    }

    @Override
    @Nullable
    public BlockPos func_180513_a(World world, String structureName, BlockPos position, boolean findUnexplored) {
        if (structureName.equalsIgnoreCase(this.hollowTreeGenerator.func_143025_a())) {
            return this.hollowTreeGenerator.func_180706_b(world, position, findUnexplored);
        }
        return super.func_180513_a(world, structureName, position, findUnexplored);
    }

    @Override
    public void func_180514_a(Chunk chunk, int x, int z) {
        super.func_180514_a(chunk, x, z);
        this.hollowTreeGenerator.func_186125_a(this.world, x, z, null);
    }

    @Override
    public boolean func_193414_a(World world, String structureName, BlockPos pos) {
        if (structureName.equalsIgnoreCase(this.hollowTreeGenerator.func_143025_a())) {
            return this.hollowTreeGenerator.func_175795_b(pos);
        }
        return super.func_193414_a(world, structureName, pos);
    }
}

