/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world;

import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.NoiseGeneratorPerlin;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraftforge.event.ForgeEventFactory;
import twilightforest.TFFeature;
import twilightforest.biomes.TFBiomeBase;
import twilightforest.biomes.TFBiomeDecorator;
import twilightforest.block.TFBlocks;
import twilightforest.world.TFWorld;

public abstract class ChunkGeneratorTFBase
implements IChunkGenerator {
    protected final Random rand;
    protected final NoiseGeneratorPerlin surfaceNoise;
    protected final World world;
    protected final WorldType terrainType;
    protected double[] depthBuffer = new double[256];
    protected Biome[] biomesForGeneration;
    private final boolean shouldGenerateBedrock;

    protected static long getSeed(int x, int z) {
        return (long)x * 341873128712L + (long)z * 132897987541L;
    }

    public ChunkGeneratorTFBase(World world, long seed, boolean enableFeatures, boolean shouldGenerateBedrock) {
        this.world = world;
        this.terrainType = world.func_72912_H().func_76067_t();
        this.rand = new Random(seed);
        this.surfaceNoise = new NoiseGeneratorPerlin(this.rand, 4);
        this.shouldGenerateBedrock = shouldGenerateBedrock;
    }

    protected final Chunk makeChunk(int x, int z, ChunkPrimer primer) {
        Chunk chunk = new Chunk(this.world, primer, x, z);
        byte[] chunkBiomes = chunk.func_76605_m();
        for (int i = 0; i < chunkBiomes.length; ++i) {
            chunkBiomes[i] = (byte)Biome.func_185362_a((Biome)this.biomesForGeneration[i]);
        }
        chunk.func_76603_b();
        return chunk;
    }

    public void replaceBiomeBlocks(int x, int z, ChunkPrimer primer, Biome[] biomesIn) {
        if (!ForgeEventFactory.onReplaceBiomeBlocks((IChunkGenerator)this, (int)x, (int)z, (ChunkPrimer)primer, (World)this.world)) {
            return;
        }
        double d0 = 0.03125;
        this.depthBuffer = this.surfaceNoise.func_151599_a(this.depthBuffer, (double)(x * 16), (double)(z * 16), 16, 16, 0.0625, 0.0625, 1.0);
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                Biome biome = biomesIn[j + i * 16];
                biome.func_180622_a(this.world, this.rand, primer, x * 16 + i, z * 16 + j, this.depthBuffer[j + i * 16]);
            }
        }
    }

    protected final void deformTerrainForFeature(int cx, int cz, ChunkPrimer primer) {
        TFFeature nearFeature = TFFeature.getNearestFeature(cx, cz, this.world);
        if (!nearFeature.isTerrainAltered) {
            return;
        }
        int[] nearCenter = TFFeature.getNearestCenter(cx, cz, this.world);
        int hx = nearCenter[0];
        int hz = nearCenter[1];
        if (nearFeature == TFFeature.TROLL_CAVE) {
            this.deformTerrainForTrollCloud2(primer, nearFeature, cx, cz, hx, hz);
        }
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int dx = x - hx;
                int dz = z - hz;
                if (nearFeature == TFFeature.SMALL_HILL || nearFeature == TFFeature.MEDIUM_HILL || nearFeature == TFFeature.LARGE_HILL || nearFeature == TFFeature.HYDRA_LAIR) {
                    int hdiam = (nearFeature.size * 2 + 1) * 16;
                    int dist = (int)Math.sqrt(dx * dx + dz * dz);
                    int hheight = (int)(Math.cos((double)((float)dist / (float)hdiam) * Math.PI) * (double)((float)hdiam / 3.0f));
                    this.raiseHills(primer, nearFeature, hdiam, x, z, dx, dz, hheight);
                    continue;
                }
                if (nearFeature == TFFeature.HEDGE_MAZE || nearFeature == TFFeature.NAGA_COURTYARD || nearFeature == TFFeature.QUEST_GROVE) {
                    this.flattenTerrainForFeature(primer, nearFeature, x, z, dx, dz);
                    continue;
                }
                if (nearFeature != TFFeature.YETI_CAVE) continue;
                this.deformTerrainForYetiLair(primer, nearFeature, x, z, dx, dz);
            }
        }
    }

    private void raiseHills(ChunkPrimer primer, TFFeature nearFeature, int hdiam, int x, int z, int dx, int dz, int hillHeight) {
        int y;
        int newGround = -1;
        boolean foundGroundLevel = false;
        for (int y2 = TFWorld.SEALEVEL; y2 < TFWorld.CHUNKHEIGHT; ++y2) {
            Block currentTerrain = primer.func_177856_a(x, y2, z).func_177230_c();
            if (currentTerrain != Blocks.field_150348_b && !foundGroundLevel) {
                newGround = y2 + hillHeight;
                foundGroundLevel = true;
            }
            if (!foundGroundLevel || y2 > newGround) continue;
            primer.func_177855_a(x, y2, z, Blocks.field_150348_b.func_176223_P());
        }
        int hollow = hillHeight - 4 - nearFeature.size;
        if (nearFeature == TFFeature.HYDRA_LAIR) {
            int mx = dx + 16;
            int mz = dz + 16;
            int mdist = (int)Math.sqrt(mx * mx + mz * mz);
            int mheight = (int)(Math.cos((double)mdist / ((double)hdiam / 1.5) * Math.PI) * ((double)hdiam / 1.5));
            hollow = Math.max(mheight - 4, hollow);
        }
        if (hollow < 0) {
            hollow = 0;
        }
        int hollowFloor = TFWorld.SEALEVEL - 3 - hollow / 8;
        if (nearFeature == TFFeature.HYDRA_LAIR) {
            hollowFloor = TFWorld.SEALEVEL;
        }
        if (hillHeight > 0) {
            for (y = 0; y < TFWorld.SEALEVEL; ++y) {
                if (primer.func_177856_a(x, y, z).func_177230_c() == Blocks.field_150348_b) continue;
                primer.func_177855_a(x, y, z, Blocks.field_150348_b.func_176223_P());
            }
        }
        for (y = hollowFloor + 1; y < hollowFloor + hollow; ++y) {
            primer.func_177855_a(x, y, z, Blocks.field_150350_a.func_176223_P());
        }
    }

    private void flattenTerrainForFeature(ChunkPrimer primer, TFFeature nearFeature, int x, int z, int dx, int dz) {
        int y;
        float squishFactor = 0.0f;
        int mazeHeight = TFWorld.SEALEVEL + 1;
        int FEATURE_BOUNDARY = (nearFeature.size * 2 + 1) * 8 - 8;
        if (dx <= -FEATURE_BOUNDARY) {
            squishFactor = (float)(-dx - FEATURE_BOUNDARY) / 8.0f;
        }
        if (dx >= FEATURE_BOUNDARY) {
            squishFactor = (float)(dx - FEATURE_BOUNDARY) / 8.0f;
        }
        if (dz <= -FEATURE_BOUNDARY) {
            squishFactor = Math.max(squishFactor, (float)(-dz - FEATURE_BOUNDARY) / 8.0f);
        }
        if (dz >= FEATURE_BOUNDARY) {
            squishFactor = Math.max(squishFactor, (float)(dz - FEATURE_BOUNDARY) / 8.0f);
        }
        if (squishFactor > 0.0f) {
            int newGround = -1;
            for (y = 0; y <= 127; ++y) {
                Block currentTerrain = primer.func_177856_a(x, y, z).func_177230_c();
                if (currentTerrain == Blocks.field_150348_b || newGround != -1) continue;
                int oldGround = y;
                mazeHeight = (int)((float)mazeHeight + (float)(oldGround - mazeHeight) * squishFactor);
                newGround = oldGround;
            }
        }
        for (y = 0; y <= 127; ++y) {
            Block b = primer.func_177856_a(x, y, z).func_177230_c();
            if (y < mazeHeight && (b == Blocks.field_150350_a || b == Blocks.field_150355_j)) {
                primer.func_177855_a(x, y, z, Blocks.field_150348_b.func_176223_P());
            }
            if (y < mazeHeight || b == Blocks.field_150355_j) continue;
            primer.func_177855_a(x, y, z, Blocks.field_150350_a.func_176223_P());
        }
    }

    private void deformTerrainForYetiLair(ChunkPrimer primer, TFFeature nearFeature, int x, int z, int dx, int dz) {
        int y;
        float squishFactor = 0.0f;
        int topHeight = TFWorld.SEALEVEL + 24;
        int outerBoundary = (nearFeature.size * 2 + 1) * 8 - 8;
        if (dx <= -outerBoundary) {
            squishFactor = (float)(-dx - outerBoundary) / 8.0f;
        }
        if (dx >= outerBoundary) {
            squishFactor = (float)(dx - outerBoundary) / 8.0f;
        }
        if (dz <= -outerBoundary) {
            squishFactor = Math.max(squishFactor, (float)(-dz - outerBoundary) / 8.0f);
        }
        if (dz >= outerBoundary) {
            squishFactor = Math.max(squishFactor, (float)(dz - outerBoundary) / 8.0f);
        }
        int caveBoundary = nearFeature.size * 2 * 8 - 8;
        int hollowCeiling = TFWorld.SEALEVEL + 16;
        int offset = Math.min(Math.abs(dx), Math.abs(dz));
        hollowCeiling = TFWorld.SEALEVEL + 40 - offset * 4;
        if (dx >= -caveBoundary && dz >= -caveBoundary && dx <= caveBoundary && dz <= caveBoundary) {
            hollowCeiling = TFWorld.SEALEVEL + 16;
        }
        hollowCeiling -= offset / 6;
        hollowCeiling = Math.min(hollowCeiling, TFWorld.SEALEVEL + 16);
        int hollowFloor = TFWorld.SEALEVEL - 1 + offset / 6;
        if (squishFactor > 0.0f) {
            int newGround = -1;
            for (y = 0; y <= 127; ++y) {
                Block currentTerrain = primer.func_177856_a(x, y, z).func_177230_c();
                if (currentTerrain == Blocks.field_150348_b || newGround != -1) continue;
                int oldGround = y;
                topHeight = (int)((float)topHeight + (float)(oldGround - topHeight) * squishFactor);
                hollowFloor = (int)((float)hollowFloor + (float)(oldGround - hollowFloor) * squishFactor);
                newGround = oldGround;
            }
        }
        for (y = 0; y <= 127; ++y) {
            Block b = primer.func_177856_a(x, y, z).func_177230_c();
            if (y < topHeight && (b == Blocks.field_150350_a || b == Blocks.field_150355_j)) {
                primer.func_177855_a(x, y, z, Blocks.field_150348_b.func_176223_P());
            }
            if (y > hollowFloor && y < hollowCeiling) {
                primer.func_177855_a(x, y, z, Blocks.field_150350_a.func_176223_P());
            }
            if (y != hollowFloor || y >= hollowCeiling || y >= TFWorld.SEALEVEL + 3) continue;
            primer.func_177855_a(x, y, z, Blocks.field_150403_cj.func_176223_P());
        }
    }

    private void deformTerrainForTrollCloud2(ChunkPrimer primer, TFFeature nearFeature, int cx, int cz, int hx, int hz) {
        for (int bx = 0; bx < 4; ++bx) {
            for (int bz = 0; bz < 4; ++bz) {
                int dx = bx * 4 - hx - 2;
                int dz = bz * 4 - hz - 2;
                int regionX = cx + 8 >> 4;
                int regionZ = cz + 8 >> 4;
                long seed = (long)(regionX * 3129871) ^ (long)regionZ * 116129781L;
                seed = seed * seed * 42317861L + seed * 7L;
                int num0 = (int)(seed >> 12 & 3L);
                int num1 = (int)(seed >> 15 & 3L);
                int num2 = (int)(seed >> 18 & 3L);
                int num3 = (int)(seed >> 21 & 3L);
                int num4 = (int)(seed >> 9 & 3L);
                int num5 = (int)(seed >> 6 & 3L);
                int num6 = (int)(seed >> 3 & 3L);
                int num7 = (int)(seed >> 0 & 3L);
                int dx2 = dx + num0 * 5 - num1 * 4;
                int dz2 = dz + num2 * 4 - num3 * 5;
                int dx3 = dx + num4 * 5 - num5 * 4;
                int dz3 = dz + num6 * 4 - num7 * 5;
                double dist0 = Math.sqrt(dx * dx + dz * dz) / 4.0;
                double dist2 = Math.sqrt(dx2 * dx2 + dz2 * dz2) / 3.5;
                double dist3 = Math.sqrt(dx3 * dx3 + dz3 * dz3) / 4.5;
                double dist = Math.min(dist0, Math.min(dist2, dist3));
                float pr = this.world.field_73012_v.nextFloat();
                double cv = dist - 7.0 - (double)(pr * 3.0f);
                int y = 166;
                int depth = 4;
                if (pr < 0.1f) {
                    ++y;
                }
                if (pr > 0.6f) {
                    ++depth;
                }
                if (pr > 0.9f) {
                    ++depth;
                }
                for (int sx = 0; sx < 4; ++sx) {
                    for (int sz = 0; sz < 4; ++sz) {
                        int d;
                        int lx = bx * 4 + sx;
                        int lz = bz * 4 + sz;
                        if (dist < 7.0 || cv < (double)0.05f) {
                            primer.func_177855_a(lx, y, lz, TFBlocks.wispy_cloud.func_176223_P());
                            for (d = 1; d < depth; ++d) {
                                primer.func_177855_a(lx, y - d, lz, TFBlocks.fluffy_cloud.func_176223_P());
                            }
                            primer.func_177855_a(lx, y - depth, lz, TFBlocks.wispy_cloud.func_176223_P());
                            continue;
                        }
                        if (!(dist < 8.0) && !(cv < 1.0)) continue;
                        for (d = 1; d < depth; ++d) {
                            primer.func_177855_a(lx, y - d, lz, TFBlocks.fluffy_cloud.func_176223_P());
                        }
                    }
                }
            }
        }
    }

    protected final boolean allowSurfaceLakes(Biome biome) {
        if (biome.field_76760_I instanceof TFBiomeDecorator) {
            return !((TFBiomeDecorator)biome.field_76760_I).hasCanopy;
        }
        return true;
    }

    public final boolean shouldGenerateBedrock() {
        return this.shouldGenerateBedrock;
    }

    public boolean func_185933_a(Chunk chunk, int x, int z) {
        return false;
    }

    public List<Biome.SpawnListEntry> func_177458_a(EnumCreatureType creatureType, BlockPos pos) {
        TFFeature nearestFeature = TFFeature.getFeatureForRegionPos(pos.func_177958_n(), pos.func_177952_p(), this.world);
        if (nearestFeature != TFFeature.NOTHING) {
            if (this.isStructureConquered(pos)) {
                return Collections.emptyList();
            }
            int spawnListIndex = nearestFeature.getFeatureGenerator().getSpawnListIndexAt(pos);
            if (spawnListIndex >= 0) {
                return nearestFeature.getSpawnableList(creatureType, spawnListIndex);
            }
        }
        Biome biome = this.world.func_180494_b(pos);
        if (pos.func_177956_o() < TFWorld.SEALEVEL && creatureType == EnumCreatureType.MONSTER && biome instanceof TFBiomeBase) {
            return ((TFBiomeBase)biome).getUndergroundSpawnableList();
        }
        return biome.func_76747_a(creatureType);
    }

    @Nullable
    public BlockPos func_180513_a(World world, String structureName, BlockPos position, boolean findUnexplored) {
        TFFeature feature = TFFeature.getFeatureByName(new ResourceLocation(structureName));
        if (feature != TFFeature.NOTHING) {
            return TFFeature.findNearestFeaturePosBySpacing(world, feature, position, 20, 11, 10387313, true, 100, findUnexplored);
        }
        return null;
    }

    public void setStructureConquered(int mapX, int mapY, int mapZ, boolean flag) {
        TFFeature.getFeatureForRegionPos(mapX, mapZ, this.world).getFeatureGenerator().setStructureConquered(mapX, mapY, mapZ, flag);
    }

    public boolean isStructureLocked(BlockPos pos, int lockIndex) {
        return TFFeature.getFeatureForRegionPos(pos.func_177958_n(), pos.func_177952_p(), this.world).getFeatureGenerator().isStructureLocked(pos, lockIndex);
    }

    public boolean isBlockInStructureBB(BlockPos pos) {
        return TFFeature.getFeatureForRegionPos(pos.func_177958_n(), pos.func_177952_p(), this.world).getFeatureGenerator().func_175795_b(pos);
    }

    @Nullable
    public StructureBoundingBox getSBBAt(BlockPos pos) {
        return TFFeature.getFeatureForRegionPos(pos.func_177958_n(), pos.func_177952_p(), this.world).getFeatureGenerator().getSBBAt(pos);
    }

    public boolean isBlockProtected(BlockPos pos) {
        return TFFeature.getFeatureForRegionPos(pos.func_177958_n(), pos.func_177952_p(), this.world).getFeatureGenerator().isBlockProtectedAt(pos);
    }

    public boolean isStructureConquered(BlockPos pos) {
        return TFFeature.getFeatureForRegionPos(pos.func_177958_n(), pos.func_177952_p(), this.world).getFeatureGenerator().isStructureConquered(pos);
    }

    public boolean isBlockInFullStructure(int x, int z) {
        return TFFeature.getFeatureForRegionPos(x, z, this.world).getFeatureGenerator().isBlockInFullStructure(x, z);
    }

    public boolean isBlockNearFullStructure(int x, int z, int range) {
        return TFFeature.getFeatureForRegionPos(x, z, this.world).getFeatureGenerator().isBlockNearFullStructure(x, z, range);
    }

    @Nullable
    public StructureBoundingBox getFullSBBNear(int mapX, int mapZ, int range) {
        return TFFeature.getFeatureForRegionPos(mapX, mapZ, this.world).getFeatureGenerator().getFullSBBNear(mapX, mapZ, range);
    }

    public TFFeature getFeatureAt(BlockPos pos) {
        return TFFeature.getFeatureForRegionPos(pos.func_177958_n(), pos.func_177952_p(), this.world).getFeatureGenerator().getFeatureAt(pos);
    }

    public void func_180514_a(Chunk chunk, int x, int z) {
        for (TFFeature feature : TFFeature.values()) {
            if (feature == TFFeature.NOTHING) continue;
            feature.getFeatureGenerator().func_186125_a(this.world, x, z, null);
        }
    }

    public boolean func_193414_a(World world, String structureName, BlockPos pos) {
        TFFeature feature = TFFeature.getFeatureByName(new ResourceLocation(structureName));
        return feature != TFFeature.NOTHING && this.getFeatureAt(pos) == feature;
    }
}

