/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.structures.minotaurmaze;

import java.util.List;
import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraft.world.gen.structure.template.TemplateManager;
import twilightforest.TFConfig;
import twilightforest.TFFeature;
import twilightforest.block.BlockTFMazestone;
import twilightforest.block.TFBlocks;
import twilightforest.enums.MazestoneVariant;
import twilightforest.structures.StructureTFComponentOld;
import twilightforest.structures.TFMaze;
import twilightforest.structures.minotaurmaze.ComponentTFMazeCorridor;
import twilightforest.structures.minotaurmaze.ComponentTFMazeCorridorIronFence;
import twilightforest.structures.minotaurmaze.ComponentTFMazeCorridorRoots;
import twilightforest.structures.minotaurmaze.ComponentTFMazeCorridorShrooms;
import twilightforest.structures.minotaurmaze.ComponentTFMazeDeadEnd;
import twilightforest.structures.minotaurmaze.ComponentTFMazeDeadEndChest;
import twilightforest.structures.minotaurmaze.ComponentTFMazeDeadEndFountain;
import twilightforest.structures.minotaurmaze.ComponentTFMazeDeadEndFountainLava;
import twilightforest.structures.minotaurmaze.ComponentTFMazeDeadEndPainting;
import twilightforest.structures.minotaurmaze.ComponentTFMazeDeadEndRoots;
import twilightforest.structures.minotaurmaze.ComponentTFMazeDeadEndShrooms;
import twilightforest.structures.minotaurmaze.ComponentTFMazeDeadEndTorches;
import twilightforest.structures.minotaurmaze.ComponentTFMazeDeadEndTrappedChest;
import twilightforest.structures.minotaurmaze.ComponentTFMazeMushRoom;
import twilightforest.structures.minotaurmaze.ComponentTFMazeRoom;
import twilightforest.structures.minotaurmaze.ComponentTFMazeRoomBoss;
import twilightforest.structures.minotaurmaze.ComponentTFMazeRoomCollapse;
import twilightforest.structures.minotaurmaze.ComponentTFMazeRoomExit;
import twilightforest.structures.minotaurmaze.ComponentTFMazeRoomFountain;
import twilightforest.structures.minotaurmaze.ComponentTFMazeRoomSpawnerChests;
import twilightforest.structures.minotaurmaze.ComponentTFMazeRoomVault;

public class ComponentTFMinotaurMaze
extends StructureTFComponentOld {
    TFMaze maze;
    int[] rcoords;
    private int level;

    public ComponentTFMinotaurMaze() {
    }

    public ComponentTFMinotaurMaze(TFFeature feature, int index, int x, int y, int z, int entranceX, int entranceZ, int level) {
        super(feature, index);
        this.func_186164_a(EnumFacing.SOUTH);
        this.level = level;
        this.field_74887_e = StructureTFComponentOld.getComponentToAddBoundingBox(x, y, z, -this.getRadius(), 0, -this.getRadius(), this.getRadius() * 2, 5, this.getRadius() * 2, EnumFacing.SOUTH);
        this.maze = new TFMaze(this.getMazeSize(), this.getMazeSize());
        this.setFixedMazeSeed();
        int nrooms = 7;
        this.rcoords = new int[nrooms * 2];
        this.addRoomsToMaze(entranceX, entranceZ, nrooms);
        this.maze.generateRecursiveBacktracker(0, 0);
    }

    private void addRoomsToMaze(int entranceX, int entranceZ, int nrooms) {
        this.rcoords[0] = entranceX;
        this.rcoords[1] = entranceZ;
        this.maze.carveRoom1(entranceX, entranceZ);
        for (int i = 1; i < nrooms; ++i) {
            int rz;
            int rx;
            while (this.isNearRoom(rx = this.maze.rand.nextInt(this.getMazeSize() - 2) + 1, rz = this.maze.rand.nextInt(this.getMazeSize() - 2) + 1, this.rcoords, i == 1 ? 7 : 4)) {
            }
            this.maze.carveRoom1(rx, rz);
            this.rcoords[i * 2] = rx;
            this.rcoords[i * 2 + 1] = rz;
        }
    }

    private void setFixedMazeSeed() {
        this.maze.setSeed(this.field_74887_e.field_78897_a * 90342903 + this.field_74887_e.field_78895_b * 90342903 ^ this.field_74887_e.field_78896_c);
    }

    public ComponentTFMinotaurMaze(TFFeature feature, int index, int x, int y, int z, int level) {
        this(feature, index, x, y, z, 11, 11, level);
    }

    @Override
    protected void func_143012_a(NBTTagCompound tagCompound) {
        super.func_143012_a(tagCompound);
        tagCompound.func_74768_a("mazeLevel", this.level);
        tagCompound.func_74783_a("roomCoords", this.rcoords);
    }

    @Override
    protected void func_143011_b(NBTTagCompound tagCompound, TemplateManager templateManager) {
        super.func_143011_b(tagCompound, templateManager);
        this.level = tagCompound.func_74762_e("mazeLevel");
        this.rcoords = tagCompound.func_74759_k("roomCoords");
        this.maze = new TFMaze(this.getMazeSize(), this.getMazeSize());
        this.setFixedMazeSeed();
        for (int i = 2; i < this.rcoords.length; ++i) {
            this.rcoords[i] = 0;
        }
        this.addRoomsToMaze(this.rcoords[0], this.rcoords[1], (this.rcoords.length + 1) / 2);
        this.maze.generateRecursiveBacktracker(0, 0);
    }

    protected ComponentTFMazeRoom makeRoom(Random random, int i, int dx, int dz) {
        ComponentTFMazeRoom room = null;
        int worldX = this.field_74887_e.field_78897_a + dx * 5 - 4;
        int worldY = this.field_74887_e.field_78895_b;
        int worldZ = this.field_74887_e.field_78896_c + dz * 5 - 4;
        room = i == 0 ? new ComponentTFMazeRoom(this.getFeatureType(), 3 + i, random, worldX, worldY, worldZ) : (i == 1 ? (this.level == 1 ? new ComponentTFMazeRoomExit(this.getFeatureType(), 3 + i, random, worldX, worldY, worldZ) : new ComponentTFMazeRoomBoss(this.getFeatureType(), 3 + i, random, worldX, worldY, worldZ)) : (i == 2 || i == 3 ? (this.level == 1 ? new ComponentTFMazeRoomCollapse(this.getFeatureType(), 3 + i, random, worldX, worldY, worldZ) : new ComponentTFMazeMushRoom(this.getFeatureType(), 3 + i, random, worldX, worldY, worldZ)) : (i == 4 ? (this.level == 1 ? new ComponentTFMazeRoomFountain(this.getFeatureType(), 3 + i, random, worldX, worldY, worldZ) : new ComponentTFMazeRoomVault(this.getFeatureType(), 3 + i, random, worldX, worldY, worldZ)) : new ComponentTFMazeRoomSpawnerChests(this.getFeatureType(), 3 + i, random, worldX, worldY, worldZ))));
        return room;
    }

    protected void decorateDeadEndsCorridors(Random random, List<StructureComponent> list) {
        for (int x = 0; x < this.maze.width; ++x) {
            for (int z = 0; z < this.maze.depth; ++z) {
                StructureTFComponentOld component = null;
                if (!this.maze.isWall(x, z, x - 1, z) && this.maze.isWall(x, z, x + 1, z) && this.maze.isWall(x, z, x, z - 1) && this.maze.isWall(x, z, x, z + 1)) {
                    component = this.makeDeadEnd(random, x, z, EnumFacing.EAST);
                }
                if (this.maze.isWall(x, z, x - 1, z) && !this.maze.isWall(x, z, x + 1, z) && this.maze.isWall(x, z, x, z - 1) && this.maze.isWall(x, z, x, z + 1)) {
                    component = this.makeDeadEnd(random, x, z, EnumFacing.WEST);
                }
                if (this.maze.isWall(x, z, x - 1, z) && this.maze.isWall(x, z, x + 1, z) && !this.maze.isWall(x, z, x, z - 1) && this.maze.isWall(x, z, x, z + 1)) {
                    component = this.makeDeadEnd(random, x, z, EnumFacing.SOUTH);
                }
                if (this.maze.isWall(x, z, x - 1, z) && this.maze.isWall(x, z, x + 1, z) && this.maze.isWall(x, z, x, z - 1) && !this.maze.isWall(x, z, x, z + 1)) {
                    component = this.makeDeadEnd(random, x, z, EnumFacing.NORTH);
                }
                if (!this.maze.isWall(x, z, x - 1, z) && !this.maze.isWall(x, z, x + 1, z) && this.maze.isWall(x, z, x, z - 1) && this.maze.isWall(x, z, x, z + 1) && this.maze.isWall(x - 1, z, x - 1, z - 1) && this.maze.isWall(x - 1, z, x - 1, z + 1) && this.maze.isWall(x + 1, z, x + 1, z - 1) && this.maze.isWall(x + 1, z, x + 1, z + 1)) {
                    component = this.makeCorridor(random, x, z, EnumFacing.WEST);
                }
                if (!this.maze.isWall(x, z, x, z - 1) && !this.maze.isWall(x, z, x, z + 1) && this.maze.isWall(x, z, x - 1, z) && this.maze.isWall(x, z, x + 1, z) && this.maze.isWall(x, z - 1, x - 1, z - 1) && this.maze.isWall(x, z - 1, x + 1, z - 1) && this.maze.isWall(x, z + 1, x - 1, z + 1) && this.maze.isWall(x, z + 1, x + 1, z + 1)) {
                    component = this.makeCorridor(random, x, z, EnumFacing.SOUTH);
                }
                if (component == null) continue;
                list.add(component);
                component.func_74861_a(this, list, random);
            }
        }
    }

    protected ComponentTFMazeDeadEnd makeDeadEnd(Random random, int dx, int dz, EnumFacing rotation) {
        int worldX = this.field_74887_e.field_78897_a + dx * 5 + 1;
        int worldY = this.field_74887_e.field_78895_b;
        int worldZ = this.field_74887_e.field_78896_c + dz * 5 + 1;
        int decorationType = random.nextInt(8);
        switch (decorationType) {
            default: {
                return new ComponentTFMazeDeadEnd(this.getFeatureType(), 4, worldX, worldY, worldZ, rotation);
            }
            case 1: {
                return new ComponentTFMazeDeadEndChest(this.getFeatureType(), 4, worldX, worldY, worldZ, rotation);
            }
            case 2: {
                return new ComponentTFMazeDeadEndTrappedChest(this.getFeatureType(), 4, worldX, worldY, worldZ, rotation);
            }
            case 3: {
                return new ComponentTFMazeDeadEndTorches(this.getFeatureType(), 4, worldX, worldY, worldZ, rotation);
            }
            case 4: {
                return new ComponentTFMazeDeadEndFountain(this.getFeatureType(), 4, worldX, worldY, worldZ, rotation);
            }
            case 5: {
                return new ComponentTFMazeDeadEndFountainLava(this.getFeatureType(), 4, worldX, worldY, worldZ, rotation);
            }
            case 6: {
                return new ComponentTFMazeDeadEndPainting(this.getFeatureType(), 4, worldX, worldY, worldZ, rotation);
            }
            case 7: 
        }
        return this.level == 1 ? new ComponentTFMazeDeadEndRoots(this.getFeatureType(), 4, worldX, worldY, worldZ, rotation) : new ComponentTFMazeDeadEndShrooms(this.getFeatureType(), 4, worldX, worldY, worldZ, rotation);
    }

    protected ComponentTFMazeCorridor makeCorridor(Random random, int dx, int dz, EnumFacing rotation) {
        int worldX = this.field_74887_e.field_78897_a + dx * 5 + 1;
        int worldY = this.field_74887_e.field_78895_b;
        int worldZ = this.field_74887_e.field_78896_c + dz * 5 + 1;
        int decorationType = random.nextInt(5);
        switch (decorationType) {
            default: {
                return null;
            }
            case 1: {
                return new ComponentTFMazeCorridor(this.getFeatureType(), 4, worldX, worldY, worldZ, rotation);
            }
            case 2: {
                return new ComponentTFMazeCorridorIronFence(this.getFeatureType(), 4, worldX, worldY, worldZ, rotation);
            }
            case 3: {
                return null;
            }
            case 4: 
        }
        return this.level == 1 ? new ComponentTFMazeCorridorRoots(this.getFeatureType(), 4, worldX, worldY, worldZ, rotation) : new ComponentTFMazeCorridorShrooms(this.getFeatureType(), 4, worldX, worldY, worldZ, rotation);
    }

    public void func_74861_a(StructureComponent structurecomponent, List<StructureComponent> list, Random random) {
        super.func_74861_a(structurecomponent, list, random);
        if (this.level == 1) {
            int centerX = this.field_74887_e.field_78897_a + (this.field_74887_e.field_78893_d - this.field_74887_e.field_78897_a) / 2;
            int centerZ = this.field_74887_e.field_78896_c + (this.field_74887_e.field_78892_f - this.field_74887_e.field_78896_c) / 2;
            ComponentTFMinotaurMaze maze = new ComponentTFMinotaurMaze(this.getFeatureType(), 1, centerX, this.field_74887_e.field_78895_b - 10, centerZ, this.rcoords[2], this.rcoords[3], 2);
            list.add(maze);
            maze.func_74861_a(this, list, random);
        }
        for (int i = 0; i < this.rcoords.length / 2; ++i) {
            int dx = this.rcoords[i * 2];
            int dz = this.rcoords[i * 2 + 1];
            ComponentTFMazeRoom room = this.makeRoom(random, i, dx, dz);
            list.add(room);
            room.func_74861_a(this, list, random);
        }
        this.decorateDeadEndsCorridors(random, list);
    }

    public boolean func_74875_a(World world, Random rand, StructureBoundingBox sbb) {
        if (this.level == 2) {
            this.func_175804_a(world, sbb, 0, -1, 0, this.getDiameter() + 2, 6, this.getDiameter() + 2, Blocks.field_150357_h.func_176223_P(), AIR, false);
        }
        this.func_74878_a(world, sbb, 1, 1, 1, this.getDiameter(), 4, this.getDiameter());
        boolean onlyReplaceCeiling = this.level == 1 && !TFConfig.dimension.skylightForest;
        this.func_175804_a(world, sbb, 1, 5, 1, this.getDiameter(), 5, this.getDiameter(), TFBlocks.maze_stone.func_176223_P().func_177226_a(BlockTFMazestone.VARIANT, (Comparable)((Object)MazestoneVariant.PLAIN)), Blocks.field_150348_b.func_176223_P(), onlyReplaceCeiling);
        this.func_175804_a(world, sbb, 1, 0, 1, this.getDiameter(), 0, this.getDiameter(), TFBlocks.maze_stone.func_176223_P().func_177226_a(BlockTFMazestone.VARIANT, (Comparable)((Object)MazestoneVariant.MOSAIC)), Blocks.field_150348_b.func_176223_P(), false);
        this.maze.headBlockState = TFBlocks.maze_stone.func_176223_P().func_177226_a(BlockTFMazestone.VARIANT, (Comparable)((Object)MazestoneVariant.DECORATIVE));
        this.maze.wallBlockState = TFBlocks.maze_stone.func_176223_P().func_177226_a(BlockTFMazestone.VARIANT, (Comparable)((Object)MazestoneVariant.BRICK));
        this.maze.rootBlockState = TFBlocks.maze_stone.func_176223_P().func_177226_a(BlockTFMazestone.VARIANT, (Comparable)((Object)MazestoneVariant.DECORATIVE));
        this.maze.pillarBlockState = TFBlocks.maze_stone.func_176223_P().func_177226_a(BlockTFMazestone.VARIANT, (Comparable)((Object)MazestoneVariant.CHISELED));
        this.maze.wallVar0State = TFBlocks.maze_stone.func_176223_P().func_177226_a(BlockTFMazestone.VARIANT, (Comparable)((Object)MazestoneVariant.CRACKED));
        this.maze.wallVarRarity = 0.2f;
        this.maze.torchRarity = 0.05f;
        this.maze.tall = 2;
        this.maze.head = 1;
        this.maze.roots = 1;
        this.maze.oddBias = 4;
        this.maze.copyToStructure(world, 1, 2, 1, this, sbb);
        return true;
    }

    public int getMazeSize() {
        return 22;
    }

    public int getRadius() {
        return (int)((double)this.getMazeSize() * 2.5);
    }

    public int getDiameter() {
        return this.getMazeSize() * 5;
    }

    protected boolean isNearRoom(int dx, int dz, int[] rcoords, int range) {
        if (dx == 1 && dz == 1) {
            return true;
        }
        for (int i = 0; i < rcoords.length / 2; ++i) {
            int rx = rcoords[i * 2];
            int rz = rcoords[i * 2 + 1];
            if (rx == 0 && rz == 0 || Math.abs(dx - rx) >= range || Math.abs(dz - rz) >= range) continue;
            return true;
        }
        return false;
    }
}

