/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.item;

import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntitySkull;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import twilightforest.TwilightForestMod;
import twilightforest.block.BlockTFTrophy;
import twilightforest.block.TFBlocks;
import twilightforest.client.renderer.TileEntityTFTrophyRenderer;
import twilightforest.enums.BossVariant;
import twilightforest.item.ItemTF;
import twilightforest.item.TFItems;

@Mod.EventBusSubscriber(modid="twilightforest", value={Side.CLIENT})
@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class ItemTFTrophy
extends ItemTF {
    @SideOnly(value=Side.CLIENT)
    private static TileEntityTFTrophyRenderer.BakedModel dummyModel;

    public ItemTFTrophy() {
        this.func_77637_a(TFItems.creativeTab);
        this.func_77656_e(0);
        this.func_77627_a(true);
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        if (this.func_194125_a(tab)) {
            for (BossVariant v : BossVariant.values()) {
                if (v == BossVariant.ALPHA_YETI) continue;
                list.add((Object)new ItemStack((Item)this, 1, v.ordinal()));
            }
        }
    }

    public String func_77653_i(ItemStack stack) {
        return I18n.func_74837_a((String)this.func_77667_c(stack), (Object[])new Object[]{I18n.func_74838_a((String)("entity.twilightforest." + BossVariant.values()[stack.func_77960_j() % BossVariant.values().length].func_176610_l().toLowerCase(Locale.ROOT) + ".name"))});
    }

    @Override
    @Nonnull
    public EnumRarity func_77613_e(ItemStack stack) {
        return TwilightForestMod.getRarity();
    }

    @Nonnull
    public EnumActionResult func_180614_a(EntityPlayer playerIn, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack itemstack;
        IBlockState iblockstate;
        Block block;
        boolean flag;
        if (facing == EnumFacing.DOWN) {
            return EnumActionResult.FAIL;
        }
        if (worldIn.func_180495_p(pos).func_177230_c().func_176200_f((IBlockAccess)worldIn, pos)) {
            facing = EnumFacing.UP;
            pos = pos.func_177977_b();
        }
        if (!(flag = (block = (iblockstate = worldIn.func_180495_p(pos)).func_177230_c()).func_176200_f((IBlockAccess)worldIn, pos))) {
            if (!worldIn.func_180495_p(pos).func_185904_a().func_76220_a() && !worldIn.isSideSolid(pos, facing, true)) {
                return EnumActionResult.FAIL;
            }
            pos = pos.func_177972_a(facing);
        }
        if (playerIn.func_175151_a(pos, facing, itemstack = playerIn.func_184586_b(hand)) && TFBlocks.trophy.func_176196_c(worldIn, pos)) {
            TileEntity tileentity;
            if (worldIn.field_72995_K) {
                return EnumActionResult.SUCCESS;
            }
            worldIn.func_180501_a(pos, TFBlocks.trophy.func_176223_P().func_177226_a((IProperty)BlockTFTrophy.field_176418_a, (Comparable)facing), 11);
            int i = 0;
            if (facing == EnumFacing.UP) {
                i = MathHelper.func_76128_c((double)((double)(playerIn.field_70177_z * 16.0f / 360.0f) + 0.5)) & 0xF;
            }
            if ((tileentity = worldIn.func_175625_s(pos)) instanceof TileEntitySkull) {
                TileEntitySkull tileentityskull = (TileEntitySkull)tileentity;
                tileentityskull.func_152107_a(itemstack.func_77960_j());
                tileentityskull.func_145903_a(i);
            }
            itemstack.func_190918_g(1);
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.FAIL;
    }

    @Nonnull
    public String func_77667_c(ItemStack stack) {
        return "item.twilightforest.tf_trophy.name";
    }

    public boolean isValidArmor(ItemStack stack, EntityEquipmentSlot armorType, Entity entity) {
        return armorType == EntityEquipmentSlot.HEAD;
    }

    @Nullable
    public EntityEquipmentSlot getEquipmentSlot(ItemStack stack) {
        return EntityEquipmentSlot.HEAD;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModel() {
        for (int i = 0; i < BossVariant.values().length; ++i) {
            if (BossVariant.values()[i] == BossVariant.ALPHA_YETI) continue;
            ModelLoader.setCustomModelResourceLocation((Item)this, (int)i, (ModelResourceLocation)new ModelResourceLocation("twilightforest:trophy_tesr", "inventory"));
        }
        TileEntityTFTrophyRenderer tesr = new TileEntityTFTrophyRenderer();
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityTFTrophyRenderer.DummyTile.class, (TileEntitySpecialRenderer)tesr);
        dummyModel = tesr.baked;
        for (int i = 0; i < BossVariant.values().length; ++i) {
            if (BossVariant.values()[i] == BossVariant.ALPHA_YETI) continue;
            ForgeHooksClient.registerTESRItemStack((Item)this, (int)i, TileEntityTFTrophyRenderer.DummyTile.class);
        }
        ModelBakery.registerItemVariants((Item)this, (ResourceLocation[])new ResourceLocation[]{new ModelResourceLocation(new ResourceLocation("twilightforest", "trophy"), "inventory"), new ModelResourceLocation(new ResourceLocation("twilightforest", "trophy_minor"), "inventory"), new ModelResourceLocation(new ResourceLocation("twilightforest", "trophy_quest"), "inventory")});
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void onModelBake(ModelBakeEvent event) {
        event.getModelRegistry().func_82595_a((Object)new ModelResourceLocation("twilightforest:trophy_tesr", "inventory"), (Object)dummyModel);
    }
}

