/*
 * Decompiled with CFR 0.152.
 */
package com.carpentersblocks.util.states;

import com.carpentersblocks.renderer.Quad;
import com.carpentersblocks.util.states.StatePart;
import com.carpentersblocks.util.states.factory.AbstractState;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.Vec3d;

public class StateUtil {
    public static void calcCanSeeSky(AbstractState state) {
        List<StatePart> stateParts = state.getStateParts();
        Collections.sort(stateParts, new Comparator<StatePart>(){

            @Override
            public int compare(StatePart part1, StatePart part2) {
                if (part1.getVertexMax().field_72448_b > part2.getVertexMax().field_72448_b) {
                    return 1;
                }
                return -1;
            }
        });
        ArrayList<StatePart> _canSeeSky = new ArrayList<StatePart>();
        block0: for (StatePart statePart : stateParts) {
            if (_canSeeSky.isEmpty()) {
                _canSeeSky.add(statePart);
                continue;
            }
            boolean visible = false;
            for (StatePart highPart : _canSeeSky) {
                if (!(statePart.getVertexMax().field_72450_a > highPart.getVertexMax().field_72450_a || statePart.getVertexMax().field_72449_c > highPart.getVertexMax().field_72449_c || statePart.getVertexMin().field_72450_a < highPart.getVertexMin().field_72450_a) && !(statePart.getVertexMin().field_72449_c < highPart.getVertexMin().field_72449_c)) continue;
                _canSeeSky.add(statePart);
                continue block0;
            }
        }
        for (StatePart statePart : stateParts) {
            statePart.setCanSeeSky(_canSeeSky.contains(statePart));
        }
    }

    public static List<Quad> getQuads(StatePart statePart) {
        ArrayList<Quad> list = new ArrayList<Quad>();
        Vec3d min = statePart.getVertexMin();
        Vec3d max = statePart.getVertexMax();
        for (EnumFacing enumFacing : statePart.getRenderFaces()) {
            switch (enumFacing) {
                case DOWN: {
                    list.add(Quad.getQuad(enumFacing, new Vec3d(min.field_72450_a, min.field_72448_b, max.field_72449_c), new Vec3d(min.field_72450_a, min.field_72448_b, min.field_72449_c), new Vec3d(max.field_72450_a, min.field_72448_b, min.field_72449_c), new Vec3d(max.field_72450_a, min.field_72448_b, max.field_72449_c)));
                    break;
                }
                case UP: {
                    list.add(Quad.getQuad(enumFacing, new Vec3d(min.field_72450_a, max.field_72448_b, min.field_72449_c), new Vec3d(min.field_72450_a, max.field_72448_b, max.field_72449_c), new Vec3d(max.field_72450_a, max.field_72448_b, max.field_72449_c), new Vec3d(max.field_72450_a, max.field_72448_b, min.field_72449_c)));
                    break;
                }
                case NORTH: {
                    list.add(Quad.getQuad(enumFacing, new Vec3d(max.field_72450_a, max.field_72448_b, min.field_72449_c), new Vec3d(max.field_72450_a, min.field_72448_b, min.field_72449_c), new Vec3d(min.field_72450_a, min.field_72448_b, min.field_72449_c), new Vec3d(min.field_72450_a, max.field_72448_b, min.field_72449_c)));
                    break;
                }
                case SOUTH: {
                    list.add(Quad.getQuad(enumFacing, new Vec3d(min.field_72450_a, max.field_72448_b, max.field_72449_c), new Vec3d(min.field_72450_a, min.field_72448_b, max.field_72449_c), new Vec3d(max.field_72450_a, min.field_72448_b, max.field_72449_c), new Vec3d(max.field_72450_a, max.field_72448_b, max.field_72449_c)));
                    break;
                }
                case WEST: {
                    list.add(Quad.getQuad(enumFacing, new Vec3d(min.field_72450_a, max.field_72448_b, min.field_72449_c), new Vec3d(min.field_72450_a, min.field_72448_b, min.field_72449_c), new Vec3d(min.field_72450_a, min.field_72448_b, max.field_72449_c), new Vec3d(min.field_72450_a, max.field_72448_b, max.field_72449_c)));
                    break;
                }
                case EAST: {
                    list.add(Quad.getQuad(enumFacing, new Vec3d(max.field_72450_a, max.field_72448_b, max.field_72449_c), new Vec3d(max.field_72450_a, min.field_72448_b, max.field_72449_c), new Vec3d(max.field_72450_a, min.field_72448_b, min.field_72449_c), new Vec3d(max.field_72450_a, max.field_72448_b, min.field_72449_c)));
                    break;
                }
            }
        }
        TextureMap map = Minecraft.func_71410_x().func_147117_R();
        for (Quad quad : list) {
            quad.setMaxBrightness(statePart.isMaxBrightness());
            quad.setRenderLayer(statePart.getRenderLayer());
            quad.setRgb(statePart.getRgb());
            quad.setSprite(map.func_110572_b(statePart.getIconName()));
        }
        return list;
    }

    public static void rotate(AbstractState state, EnumFacing facing, double radians) {
        if (EnumFacing.AxisDirection.POSITIVE.equals((Object)facing.func_176743_c())) {
            radians = -radians;
        }
        for (StatePart statePart : state.getStateParts()) {
            Vec3d vec1 = null;
            Vec3d vec2 = null;
            switch (facing) {
                case DOWN: 
                case UP: {
                    vec1 = StateUtil.rotateAroundY(statePart.getVertexMin(), radians);
                    vec2 = StateUtil.rotateAroundY(statePart.getVertexMax(), radians);
                    break;
                }
                case NORTH: 
                case SOUTH: {
                    vec1 = StateUtil.rotateAroundZ(statePart.getVertexMin(), radians);
                    vec2 = StateUtil.rotateAroundZ(statePart.getVertexMax(), radians);
                    break;
                }
                case WEST: 
                case EAST: {
                    vec1 = StateUtil.rotateAroundX(statePart.getVertexMin(), radians);
                    vec2 = StateUtil.rotateAroundX(statePart.getVertexMax(), radians);
                }
            }
            statePart.setVertexMin(new Vec3d(Math.min(vec1.field_72450_a, vec2.field_72450_a), Math.min(vec1.field_72448_b, vec2.field_72448_b), Math.min(vec1.field_72449_c, vec2.field_72449_c)));
            statePart.setVertexMax(new Vec3d(Math.max(vec1.field_72450_a, vec2.field_72450_a), Math.max(vec1.field_72448_b, vec2.field_72448_b), Math.max(vec1.field_72449_c, vec2.field_72449_c)));
        }
    }

    private static Vec3d rotateAroundX(Vec3d vec3d, double angle) {
        double y = 0.5 + (vec3d.field_72449_c - 0.5) * Math.sin(angle) + (vec3d.field_72448_b - 0.5) * Math.cos(angle);
        double z = 0.5 + (vec3d.field_72449_c - 0.5) * Math.cos(angle) - (vec3d.field_72448_b - 0.5) * Math.sin(angle);
        return new Vec3d(vec3d.field_72450_a, y, z);
    }

    private static Vec3d rotateAroundY(Vec3d vec3d, double angle) {
        double z = 0.5 + (vec3d.field_72450_a - 0.5) * Math.sin(angle) + (vec3d.field_72449_c - 0.5) * Math.cos(angle);
        double x = 0.5 + (vec3d.field_72450_a - 0.5) * Math.cos(angle) - (vec3d.field_72449_c - 0.5) * Math.sin(angle);
        return new Vec3d(x, vec3d.field_72448_b, z);
    }

    private static Vec3d rotateAroundZ(Vec3d vec3d, double angle) {
        double y = 0.5 + (vec3d.field_72450_a - 0.5) * Math.sin(angle) + (vec3d.field_72448_b - 0.5) * Math.cos(angle);
        double x = 0.5 + (vec3d.field_72450_a - 0.5) * Math.cos(angle) - (vec3d.field_72448_b - 0.5) * Math.sin(angle);
        return new Vec3d(x, y, vec3d.field_72449_c);
    }
}

