/*
 * Decompiled with CFR 0.152.
 */
package com.carpentersblocks.util.handler;

import com.carpentersblocks.util.block.BlockUtil;
import com.carpentersblocks.util.handler.ChatHandler;
import com.carpentersblocks.util.registry.ConfigRegistry;
import com.carpentersblocks.util.registry.SpriteRegistry;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class OverlayHandler {
    public static Map overlayMap = new HashMap();

    public static void init() {
        for (String name : ConfigRegistry.overlayItems) {
            String itemName = name.substring(0, name.indexOf(":"));
            if (overlayMap.containsKey(itemName)) continue;
            String overlayType = name.substring(name.indexOf(":") + 1).toLowerCase();
            if (overlayType.equalsIgnoreCase("grass")) {
                overlayMap.put(itemName, Overlay.GRASS);
                continue;
            }
            if (overlayType.equalsIgnoreCase("snow")) {
                overlayMap.put(itemName, Overlay.SNOW);
                continue;
            }
            if (overlayType.equalsIgnoreCase("web")) {
                overlayMap.put(itemName, Overlay.WEB);
                continue;
            }
            if (overlayType.equalsIgnoreCase("vine")) {
                overlayMap.put(itemName, Overlay.VINE);
                continue;
            }
            if (overlayType.equalsIgnoreCase("hay")) {
                overlayMap.put(itemName, Overlay.HAY);
                continue;
            }
            if (!overlayType.equalsIgnoreCase("mycelium")) continue;
            overlayMap.put(itemName, Overlay.MYCELIUM);
        }
    }

    public static boolean coversFullSide(Overlay overlay, EnumFacing facing) {
        switch (overlay) {
            case GRASS: 
            case SNOW: 
            case HAY: 
            case MYCELIUM: {
                return EnumFacing.UP.equals((Object)facing);
            }
            case WEB: 
            case VINE: {
                return true;
            }
        }
        return true;
    }

    public static Overlay getOverlayType(ItemStack itemStack) {
        Object object = overlayMap.get(itemStack.func_82833_r());
        if (object == null) {
            object = overlayMap.get(ChatHandler.getDefaultTranslation(itemStack));
        }
        return object == null ? Overlay.NONE : (Overlay)((Object)object);
    }

    @SideOnly(value=Side.CLIENT)
    public static TextureAtlasSprite getOverlaySprite(Overlay overlay, EnumFacing facing) {
        ItemStack itemStack = overlay.getItemStack();
        switch (overlay) {
            case GRASS: {
                switch (facing) {
                    case DOWN: {
                        return null;
                    }
                    case UP: {
                        return Minecraft.func_71410_x().func_147117_R().func_110572_b("minecraft:blocks/grass_top");
                    }
                }
                Minecraft.func_71410_x();
                if (Minecraft.func_71375_t()) {
                    return Minecraft.func_71410_x().func_147117_R().func_110572_b("minecraft:blocks/grass_side_overlay");
                }
                return SpriteRegistry.sprite_overlay_fast_grass_side;
            }
            case SNOW: 
            case HAY: 
            case MYCELIUM: {
                switch (facing) {
                    case DOWN: {
                        return null;
                    }
                    case UP: {
                        return BlockUtil.getParticleTexture(itemStack);
                    }
                }
                switch (overlay) {
                    case SNOW: {
                        return SpriteRegistry.sprite_overlay_snow_side;
                    }
                    case HAY: {
                        return SpriteRegistry.sprite_overlay_hay_side;
                    }
                    case MYCELIUM: {
                        return SpriteRegistry.sprite_overlay_mycelium_side;
                    }
                }
                return null;
            }
            case WEB: 
            case VINE: {
                return BlockUtil.getParticleTexture(itemStack);
            }
        }
        return null;
    }

    public static enum Overlay {
        NONE(new ItemStack(Blocks.field_150350_a)),
        GRASS(new ItemStack((Block)Blocks.field_150349_c)),
        SNOW(new ItemStack(Blocks.field_150433_aE)),
        WEB(new ItemStack(Blocks.field_150321_G)),
        VINE(new ItemStack(Blocks.field_150395_bd)),
        HAY(new ItemStack(Blocks.field_150407_cf)),
        MYCELIUM(new ItemStack((Block)Blocks.field_150391_bh));

        private ItemStack itemStack;

        private Overlay(ItemStack itemStack) {
            this.itemStack = itemStack;
        }

        public ItemStack getItemStack() {
            return this.itemStack;
        }
    }
}

