/*
 * Decompiled with CFR 0.152.
 */
package com.carpentersblocks.util.block;

import com.carpentersblocks.tileentity.CbTileEntity;
import com.carpentersblocks.util.attribute.EnumAttributeLocation;
import com.carpentersblocks.util.attribute.EnumAttributeType;
import com.carpentersblocks.util.block.BlockUtil;
import com.carpentersblocks.util.block.DataUtil;
import com.carpentersblocks.util.block.IDataFacing;
import com.carpentersblocks.util.states.factory.AbstractState;
import com.carpentersblocks.util.states.factory.PressurePlateState;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;

public class PressurePlateUtil
extends DataUtil
implements IDataFacing {
    public static final byte POLARITY_POS = 0;
    public static final byte POLARITY_NEG = 1;
    public static final byte STATE_NORMAL = 0;
    public static final byte STATE_DEPRESSED = 1;
    public static final byte TRIGGER_PLAYER = 0;
    public static final byte TRIGGER_MONSTER = 1;
    public static final byte TRIGGER_ANIMAL = 2;
    public static final byte TRIGGER_ALL = 3;

    public PressurePlateUtil(CbTileEntity cbTileEntity) {
        super(cbTileEntity.getCbMetadata());
    }

    public PressurePlateUtil(int cbMetadata) {
        super(cbMetadata);
    }

    @Override
    public boolean setFacing(CbTileEntity cbTileEntity, EnumFacing facing) {
        int temp = cbTileEntity.getCbMetadata() & 0xFFFFFFF8 | facing.ordinal();
        return cbTileEntity.setCbMetadata(temp);
    }

    @Override
    public EnumFacing getFacing() {
        return EnumFacing.func_82600_a((int)(this.getData() & 7));
    }

    public int getState(CbTileEntity cbTileEntity) {
        return (cbTileEntity.getCbMetadata() & 8) >> 3;
    }

    public void setState(CbTileEntity cbTileEntity, int state, boolean playSound) {
        IBlockState blockState;
        int temp = cbTileEntity.getCbMetadata() & 0xFFFFFFF7 | state << 3;
        World world = cbTileEntity.func_145831_w();
        if (!world.field_72995_K && (blockState = BlockUtil.getAttributeBlockState(cbTileEntity.getAttributeHelper(), EnumAttributeLocation.HOST, EnumAttributeType.COVER)) != null && !Material.field_151580_n.equals(blockState.func_185904_a()) && playSound && this.getState(cbTileEntity) != state) {
            world.func_184133_a(null, cbTileEntity.func_174877_v().func_177963_a(0.05, 0.5, 0.5), Blocks.field_150471_bO.func_185467_w().func_185845_c(), SoundCategory.BLOCKS, 0.3f, this.getState(cbTileEntity) == 1 ? 0.5f : 0.6f);
        }
        cbTileEntity.setCbMetadata(temp);
    }

    private int getPolarity(CbTileEntity cbTileEntity) {
        return (this.getData() & 0x10) >> 4;
    }

    private void setPolarity(CbTileEntity cbTileEntity, int polarity) {
        int temp = this.getData() & 0xFFFFFFEF | polarity << 4;
        cbTileEntity.setCbMetadata(temp);
    }

    public int getTriggerEntity(CbTileEntity cbTileEntity) {
        return (cbTileEntity.getCbMetadata() & 0x60) >> 5;
    }

    public void setTriggerEntity(CbTileEntity cbTileEntity, int trigger) {
        int temp = cbTileEntity.getCbMetadata() & 0xFFFFFF9F | trigger << 5;
        cbTileEntity.setCbMetadata(temp);
    }

    public boolean isDepressed(CbTileEntity cbTileEntity) {
        return this.getState(cbTileEntity) == 1;
    }

    public boolean isEmitting(CbTileEntity cbTileEntity) {
        return 0 == this.getPolarity(cbTileEntity) && 1 == this.getState(cbTileEntity) || 1 == this.getPolarity(cbTileEntity) && 0 == this.getState(cbTileEntity);
    }

    public void togglePolarity(CbTileEntity cbTileEntity) {
        if (this.isPositivePolarity(cbTileEntity)) {
            this.setPolarity(cbTileEntity, 1);
        } else {
            this.setPolarity(cbTileEntity, 0);
        }
    }

    public boolean isPositivePolarity(CbTileEntity cbTileEntity) {
        return this.getPolarity(cbTileEntity) == 0;
    }

    public void setNextTriggerType(CbTileEntity cbTileEntity) {
        int trigger = this.getTriggerEntity(cbTileEntity);
        if (++trigger > 3) {
            trigger = 0;
        }
        this.setTriggerEntity(cbTileEntity, trigger);
    }

    public AbstractState getCbState(CbTileEntity cbTileEntity) {
        return new PressurePlateState(cbTileEntity);
    }
}

