/*
 * Decompiled with CFR 0.152.
 */
package com.carpentersblocks.util.block;

import com.carpentersblocks.tileentity.CbTileEntity;
import com.carpentersblocks.util.block.DataUtil;
import com.carpentersblocks.util.block.IDataFacing;
import com.carpentersblocks.util.handler.EventHandler;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;

public class CollapsibleUtil
extends DataUtil
implements IDataFacing {
    public double CENTER_YMAX;
    public double offset_XZNN;
    public double offset_XZNP;
    public double offset_XZPN;
    public double offset_XZPP;
    public static final int QUAD_XZNN = 0;
    public static final int QUAD_XZNP = 1;
    public static final int QUAD_XZPN = 2;
    public static final int QUAD_XZPP = 3;

    public CollapsibleUtil(CbTileEntity cbTileEntity) {
        super(cbTileEntity.getCbMetadata());
    }

    public CollapsibleUtil(int cbMetadata) {
        super(cbMetadata);
    }

    public static int getHitQuad() {
        if (EventHandler.eventHitVector != null) {
            if (Math.round(EventHandler.eventHitVector.field_72450_a) == 0L) {
                if (Math.round(EventHandler.eventHitVector.field_72449_c) == 0L) {
                    return 0;
                }
                return 1;
            }
            if (Math.round(EventHandler.eventHitVector.field_72449_c) == 0L) {
                return 2;
            }
            return 3;
        }
        return 0;
    }

    public boolean isPlanar() {
        for (int quad = 0; quad < 4; ++quad) {
            if (this.getQuadDepth(quad) <= 0) continue;
            return false;
        }
        return true;
    }

    public boolean isFullCube() {
        for (int quad = 0; quad < 4; ++quad) {
            if (this.getQuadDepth(quad) >= 16) continue;
            return false;
        }
        return true;
    }

    public void computeOffsets() {
        double BIAS = this.isPlanar() ? 9.765625E-4 : 0.0;
        this.offset_XZNN = (double)this.getQuadDepth(0) / 16.0 + BIAS;
        this.offset_XZNP = (double)this.getQuadDepth(1) / 16.0 + BIAS;
        this.offset_XZPN = (double)this.getQuadDepth(2) / 16.0 + BIAS;
        this.offset_XZPP = (double)this.getQuadDepth(3) / 16.0 + BIAS;
        double NW_SE = this.offset_XZNN + this.offset_XZPP;
        double NE_SW = this.offset_XZPN + this.offset_XZNP;
        this.CENTER_YMAX = NW_SE < NE_SW ? NE_SW / 2.0 : NW_SE / 2.0;
    }

    public float getBoundsMaxDepth() {
        float maxDepth = 0.0f;
        for (int quad = 0; quad < 4; ++quad) {
            maxDepth = Math.max(maxDepth, (float)this.getQuadDepth(quad) / 16.0f);
        }
        return maxDepth;
    }

    public AxisAlignedBB genQuadBoundingBox(int quad) {
        float xMin = 0.0f;
        float zMin = 0.0f;
        float xMax = 1.0f;
        float zMax = 1.0f;
        switch (quad) {
            case 0: {
                xMax = 0.5f;
                zMax = 0.5f;
                break;
            }
            case 1: {
                xMax = 0.5f;
                zMin = 0.5f;
                break;
            }
            case 2: {
                xMin = 0.5f;
                zMax = 0.5f;
                break;
            }
            case 3: {
                xMin = 0.5f;
                zMin = 0.5f;
            }
        }
        float maxDepth = this.getBoundsMaxDepth();
        float depth = (float)this.getQuadDepth(quad) / 16.0f;
        if (this.isPositive()) {
            if (maxDepth - depth > 0.5f) {
                depth = maxDepth - 0.5f;
            }
            return new AxisAlignedBB((double)xMin, 0.0, (double)zMin, (double)xMax, (double)depth, (double)zMax);
        }
        return new AxisAlignedBB((double)xMin, (double)(1.0f - depth), (double)zMin, (double)xMax, 1.0, (double)zMax);
    }

    public static void setQuadDepth(CbTileEntity cbTileEntity, int quad, int depth) {
        if (depth < 0 || depth > 16) {
            return;
        }
        int data = cbTileEntity.getCbMetadata();
        switch (quad) {
            case 0: {
                data &= 0xFF83FFFF;
                data |= depth << 18;
                break;
            }
            case 1: {
                data &= 0xFFFC1FFF;
                data |= depth << 13;
                break;
            }
            case 2: {
                data &= 0xFFFFE0FF;
                data |= depth << 8;
                break;
            }
            case 3: {
                data &= 0xFFFFFF07;
                data |= depth << 3;
            }
        }
        cbTileEntity.setCbMetadata(data);
    }

    public int getQuadDepth(int quad) {
        int depth = 0;
        int cbMetadata = this.getData();
        switch (quad) {
            case 0: {
                depth = (cbMetadata &= 0x7C0000) >> 18;
                break;
            }
            case 1: {
                depth = (cbMetadata &= 0x3E000) >> 13;
                break;
            }
            case 2: {
                depth = (cbMetadata &= 0x1F00) >> 8;
                break;
            }
            case 3: {
                depth = (cbMetadata &= 0xF8) >> 3;
            }
        }
        return depth;
    }

    public boolean isSideSolid(EnumFacing facing) {
        if (this.isFullCube()) {
            return true;
        }
        switch (facing) {
            case DOWN: {
                return this.isPositive();
            }
            case UP: {
                return !this.isPositive();
            }
            case NORTH: {
                return this.getQuadDepth(0) + this.getQuadDepth(2) == 32;
            }
            case SOUTH: {
                return this.getQuadDepth(1) + this.getQuadDepth(3) == 32;
            }
            case WEST: {
                return this.getQuadDepth(1) + this.getQuadDepth(0) == 32;
            }
            case EAST: {
                return this.getQuadDepth(2) + this.getQuadDepth(3) == 32;
            }
        }
        return true;
    }

    @Override
    public boolean setFacing(CbTileEntity cbTileEntity, EnumFacing facing) {
        int temp = cbTileEntity.getCbMetadata() & 0xFFFFFFF8 | facing.ordinal();
        return cbTileEntity.setCbMetadata(temp);
    }

    @Override
    public EnumFacing getFacing() {
        return EnumFacing.func_82600_a((int)(this.getData() & 7));
    }

    public boolean isPositive() {
        return this.getFacing().equals((Object)EnumFacing.UP);
    }
}

