/*
 * Decompiled with CFR 0.152.
 */
package com.carpentersblocks.util.attribute;

import com.carpentersblocks.util.attribute.AbstractAttribute;
import com.carpentersblocks.util.attribute.AttributeItemStack;
import com.carpentersblocks.util.attribute.EnumAttributeLocation;
import com.carpentersblocks.util.attribute.EnumAttributeType;
import com.carpentersblocks.util.block.BlockUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;

public class AttributeHelper {
    private Map<AbstractAttribute.Key, AbstractAttribute> _map;

    public AttributeHelper(Map<AbstractAttribute.Key, AbstractAttribute> map) {
        this._map = map;
    }

    public boolean hasAttribute(AbstractAttribute.Key key) {
        return this._map.containsKey(key);
    }

    public boolean hasAttribute(EnumAttributeLocation location, EnumAttributeType type) {
        return this.hasAttribute(AbstractAttribute.generateKey(location, type));
    }

    public AbstractAttribute getAttribute(AbstractAttribute.Key key) {
        return this._map.get(key);
    }

    public AbstractAttribute getLastAddedDroppableAttribute(EnumAttributeLocation location) {
        AbstractAttribute attribute = null;
        for (AbstractAttribute.Key key : this._map.keySet()) {
            if (!location.equals((Object)key.getLocation()) || !this._map.get(key).isDroppable()) continue;
            attribute = this._map.get(key);
        }
        return attribute;
    }

    public AbstractAttribute getAttribute(EnumAttributeLocation location, EnumAttributeType type) {
        return this.getAttribute(AbstractAttribute.generateKey(location, type));
    }

    public Map<AbstractAttribute.Key, AbstractAttribute> copyMap() {
        HashMap<AbstractAttribute.Key, AbstractAttribute> map = new HashMap<AbstractAttribute.Key, AbstractAttribute>();
        for (Map.Entry<AbstractAttribute.Key, AbstractAttribute> pair : this._map.entrySet()) {
            map.put(pair.getKey(), pair.getValue().copy());
        }
        return map;
    }

    public List<IBlockState> getAttributeBlockStates() {
        ArrayList<IBlockState> list = new ArrayList<IBlockState>();
        for (Map.Entry<AbstractAttribute.Key, AbstractAttribute> pair : this._map.entrySet()) {
            IBlockState blockState;
            if (!(pair.getValue() instanceof AttributeItemStack) || (blockState = BlockUtil.getBlockState((ItemStack)((AttributeItemStack)pair.getValue()).getModel())) == null) continue;
            list.add(blockState);
        }
        return list;
    }
}

