/*
 * Decompiled with CFR 0.152.
 */
package com.carpentersblocks.renderer;

import com.carpentersblocks.renderer.Quad;
import com.carpentersblocks.renderer.UV;
import com.carpentersblocks.util.attribute.EnumAttributeLocation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeMap;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;

public class VecUtil {
    public static Vec2l getVec2l(EnumFacing facing, Vec3d Vec3d2) {
        return new Vec2l(facing, Vec3d2);
    }

    private static Vec2l[] getBoundingPlane(EnumFacing facing, Vec3d[] vecs) {
        long minU = Long.MAX_VALUE;
        long maxU = Long.MIN_VALUE;
        long minV = Long.MAX_VALUE;
        long maxV = Long.MIN_VALUE;
        for (Vec3d vec : vecs) {
            Vec2l vec2l = new Vec2l(facing, vec);
            minU = Math.min(minU, vec2l.getU());
            maxU = Math.max(maxU, vec2l.getU());
            minV = Math.min(minV, vec2l.getV());
            maxV = Math.max(maxV, vec2l.getV());
        }
        switch (facing) {
            case DOWN: {
                return new Vec2l[]{new Vec2l(minU, maxV), new Vec2l(minU, minV), new Vec2l(maxU, minV), new Vec2l(maxU, maxV)};
            }
            case UP: {
                return new Vec2l[]{new Vec2l(minU, minV), new Vec2l(minU, maxV), new Vec2l(maxU, maxV), new Vec2l(maxU, minV)};
            }
            case NORTH: {
                return new Vec2l[]{new Vec2l(maxU, maxV), new Vec2l(maxU, minV), new Vec2l(minU, minV), new Vec2l(minU, maxV)};
            }
            case SOUTH: {
                return new Vec2l[]{new Vec2l(minU, maxV), new Vec2l(minU, minV), new Vec2l(maxU, minV), new Vec2l(maxU, maxV)};
            }
            case WEST: {
                return new Vec2l[]{new Vec2l(minU, maxV), new Vec2l(minU, minV), new Vec2l(maxU, minV), new Vec2l(maxU, maxV)};
            }
            case EAST: {
                return new Vec2l[]{new Vec2l(maxU, maxV), new Vec2l(maxU, minV), new Vec2l(minU, minV), new Vec2l(minU, maxV)};
            }
        }
        return null;
    }

    public static boolean isValid(Quad quad) {
        if (quad == null || quad.getVecs() == null || quad.getVecs().length != 4) {
            return false;
        }
        Vec3d[] vecs = quad.getVecs();
        Comparator<Vec3d> comparator = new Comparator<Vec3d>(){

            @Override
            public int compare(Vec3d vec1, Vec3d vec2) {
                if (MathHelper.func_180185_a((float)((float)vec1.field_72450_a), (float)((float)vec2.field_72450_a)) && MathHelper.func_180185_a((float)((float)vec1.field_72448_b), (float)((float)vec2.field_72448_b)) && MathHelper.func_180185_a((float)((float)vec1.field_72449_c), (float)((float)vec2.field_72449_c))) {
                    return 0;
                }
                return 1;
            }
        };
        HashSet<Vec3d> set = new HashSet<Vec3d>(Arrays.asList(vecs));
        return set.size() >= 3;
    }

    private static long squareDistanceTo(EnumFacing facing, Vec2l vec2l, Vec3d Vec3d2) {
        Vec2l vec2l2 = new Vec2l(facing, Vec3d2);
        long u = vec2l2.getU() - vec2l.getU();
        long v = vec2l2.getV() - vec2l.getV();
        return u * u + v * v;
    }

    public static Vec3d[] buildVecs(EnumFacing facing, Vec3d[] vecs) {
        HashSet<Vec3d> set = new HashSet<Vec3d>(Arrays.asList(vecs));
        if (set.size() == 3) {
            return VecUtil.sortTriangle(facing, set.toArray(new Vec3d[set.size()]));
        }
        if (set.size() == 4) {
            return VecUtil.sortQuad(facing, vecs);
        }
        return null;
    }

    private static Vec3d[] sortQuad(EnumFacing facing, Vec3d[] vecs) {
        LinkedList<Vec3d> consumables = new LinkedList<Vec3d>(Arrays.asList(vecs));
        Vec3d[] newVecs = new Vec3d[]{vecs[0], vecs[1], vecs[2], vecs[3]};
        Vec2l[] bounds = VecUtil.getBoundingPlane(facing, vecs);
        for (int i = 0; i < bounds.length; ++i) {
            Vec3d closest = null;
            long minDist = 0L;
            for (Vec3d Vec3d2 : consumables) {
                long dist = VecUtil.squareDistanceTo(facing, bounds[i], Vec3d2);
                if (closest != null && dist >= minDist) continue;
                minDist = dist;
                closest = Vec3d2;
            }
            consumables.remove(closest);
            newVecs[i] = closest;
        }
        return newVecs;
    }

    private static Vec3d[] sortTriangle(EnumFacing facing, Vec3d[] inVecs) {
        int i;
        ArrayList<Vec3d> vecs = new ArrayList<Vec3d>(Arrays.asList(inVecs));
        List[] cornerList = new List[]{new ArrayList(), new ArrayList(), new ArrayList(), new ArrayList()};
        Vec2l[] bounds = VecUtil.getBoundingPlane(facing, inVecs);
        for (int i2 = 0; i2 < bounds.length; ++i2) {
            TreeMap map = new TreeMap();
            for (Vec3d vec3d : vecs) {
                long dist = VecUtil.squareDistanceTo(facing, bounds[i2], vec3d);
                if (!map.containsKey(dist)) {
                    map.put(dist, new ArrayList());
                }
                ((List)map.get(dist)).add(vec3d);
            }
            cornerList[i2].addAll((Collection)map.get(map.firstKey()));
        }
        ArrayList<Vec3d> removeList = new ArrayList<Vec3d>();
        for (i = 0; i < cornerList.length; ++i) {
            if (cornerList[i] == null || cornerList[i].size() != 1) continue;
            removeList.add((Vec3d)cornerList[i].get(0));
        }
        for (i = 0; i < cornerList.length; ++i) {
            if (cornerList[i] == null || cornerList[i].size() <= 1) continue;
            cornerList[i].removeAll(removeList);
        }
        Vec3d[] finalVecs = new Vec3d[4];
        for (int i3 = 0; i3 < cornerList.length; ++i3) {
            List list = cornerList[i3];
            if (list.size() <= 0) continue;
            finalVecs[i3] = (Vec3d)list.get(0);
        }
        int emptyCorner = 0;
        for (int i4 = 0; i4 < cornerList.length; ++i4) {
            if (!cornerList[i4].isEmpty()) continue;
            ++emptyCorner;
        }
        if (emptyCorner > 0) {
            if (finalVecs[0] == null) {
                finalVecs[0] = finalVecs[1];
            } else if (finalVecs[1] == null) {
                finalVecs[1] = finalVecs[0];
            }
            if (finalVecs[2] == null) {
                finalVecs[2] = finalVecs[3];
            } else if (finalVecs[3] == null) {
                finalVecs[3] = finalVecs[2];
            }
        }
        return finalVecs;
    }

    public static UV[] getUV(Quad quad, boolean floatY, EnumAttributeLocation location) {
        if (quad.isObliqueSlope()) {
            return VecUtil.getUVObliqueSlope(quad, floatY, location);
        }
        if (quad.getFacing().ordinal() != location.ordinal() && !location.equals((Object)EnumAttributeLocation.HOST)) {
            return VecUtil.getUVSideCover(quad, floatY, location);
        }
        return VecUtil.getUV(quad, floatY);
    }

    public static UV[] getUVObliqueSlope(Quad quad, boolean floatY, EnumAttributeLocation location) {
        Vec3d[] vecs = quad.getVecs();
        boolean[] midPt = new boolean[4];
        if (vecs[0].equals((Object)vecs[1])) {
            if (Quad.compare(vecs[0].field_72448_b, vecs[3].field_72448_b) < 0) {
                midPt[3] = true;
            } else if (Quad.compare(vecs[0].field_72448_b, vecs[2].field_72448_b) > 0) {
                midPt[2] = true;
            }
        } else if (Quad.compare(vecs[0].field_72448_b, vecs[3].field_72448_b) > 0) {
            midPt[0] = true;
        } else if (Quad.compare(vecs[1].field_72448_b, vecs[2].field_72448_b) < 0) {
            midPt[1] = true;
        }
        if (!EnumAttributeLocation.HOST.equals((Object)location)) {
            quad = new Quad(quad);
            vecs = quad.getVecs();
            double translation = EnumFacing.DOWN.equals((Object)quad.getYSlope()) ? -1.0 * Math.min(vecs[1].field_72448_b, vecs[2].field_72448_b) : -1.0 * (Math.max(vecs[0].field_72448_b, vecs[3].field_72448_b) - 1.0);
            if (Double.compare(0.0, translation) != 0) {
                for (int i = 0; i < vecs.length; ++i) {
                    vecs[i] = vecs[i].func_72441_c(0.0, translation, 0.0);
                }
            }
        }
        switch (quad.getCardinalFacing()) {
            case NORTH: {
                if (floatY && midPt[0]) {
                    return new UV[]{new UV(0.5, 0.0).invertU(), new UV(vecs[1].field_72450_a, vecs[0].field_72448_b - vecs[1].field_72448_b).invertU(), new UV(vecs[2].field_72450_a, vecs[0].field_72448_b - vecs[2].field_72448_b).invertU(), new UV(vecs[3].field_72450_a, vecs[0].field_72448_b - vecs[3].field_72448_b).invertU()};
                }
                return new UV[]{new UV(midPt[0] ? 0.5 : vecs[0].field_72450_a, vecs[0].field_72448_b).invertUV(), new UV(midPt[1] ? 0.5 : vecs[1].field_72450_a, vecs[1].field_72448_b).invertUV(), new UV(midPt[2] ? 0.5 : vecs[2].field_72450_a, vecs[2].field_72448_b).invertUV(), new UV(midPt[3] ? 0.5 : vecs[3].field_72450_a, vecs[3].field_72448_b).invertUV()};
            }
            case SOUTH: {
                if (floatY && midPt[0]) {
                    return new UV[]{new UV(0.5, 0.0), new UV(vecs[1].field_72450_a, vecs[0].field_72448_b - vecs[1].field_72448_b), new UV(vecs[2].field_72450_a, vecs[0].field_72448_b - vecs[2].field_72448_b), new UV(vecs[3].field_72450_a, vecs[0].field_72448_b - vecs[3].field_72448_b)};
                }
                return new UV[]{new UV(midPt[0] ? 0.5 : vecs[0].field_72450_a, vecs[0].field_72448_b).invertV(), new UV(midPt[1] ? 0.5 : vecs[1].field_72450_a, vecs[1].field_72448_b).invertV(), new UV(midPt[2] ? 0.5 : vecs[2].field_72450_a, vecs[2].field_72448_b).invertV(), new UV(midPt[3] ? 0.5 : vecs[3].field_72450_a, vecs[3].field_72448_b).invertV()};
            }
            case WEST: {
                if (floatY && midPt[0]) {
                    return new UV[]{new UV(0.5, 0.0), new UV(vecs[1].field_72449_c, vecs[0].field_72448_b - vecs[1].field_72448_b), new UV(vecs[2].field_72449_c, vecs[0].field_72448_b - vecs[2].field_72448_b), new UV(vecs[3].field_72449_c, vecs[0].field_72448_b - vecs[3].field_72448_b)};
                }
                return new UV[]{new UV(midPt[0] ? 0.5 : vecs[0].field_72449_c, vecs[0].field_72448_b).invertV(), new UV(midPt[1] ? 0.5 : vecs[1].field_72449_c, vecs[1].field_72448_b).invertV(), new UV(midPt[2] ? 0.5 : vecs[2].field_72449_c, vecs[2].field_72448_b).invertV(), new UV(midPt[3] ? 0.5 : vecs[3].field_72449_c, vecs[3].field_72448_b).invertV()};
            }
        }
        if (floatY && midPt[0]) {
            return new UV[]{new UV(0.5, 0.0).invertU(), new UV(vecs[1].field_72449_c, vecs[0].field_72448_b - vecs[1].field_72448_b).invertU(), new UV(vecs[2].field_72449_c, vecs[0].field_72448_b - vecs[2].field_72448_b).invertU(), new UV(vecs[3].field_72449_c, vecs[0].field_72448_b - vecs[3].field_72448_b).invertU()};
        }
        return new UV[]{new UV(midPt[0] ? 0.5 : vecs[0].field_72449_c, vecs[0].field_72448_b).invertUV(), new UV(midPt[1] ? 0.5 : vecs[1].field_72449_c, vecs[1].field_72448_b).invertUV(), new UV(midPt[2] ? 0.5 : vecs[2].field_72449_c, vecs[2].field_72448_b).invertUV(), new UV(midPt[3] ? 0.5 : vecs[3].field_72449_c, vecs[3].field_72448_b).invertUV()};
    }

    public static UV[] getUV(Quad quad, boolean floatY) {
        Vec3d[] vecs = quad.getVecs();
        switch (quad.getFacing()) {
            case DOWN: {
                return new UV[]{new UV(vecs[0].field_72450_a, vecs[0].field_72449_c).invertV(), new UV(vecs[1].field_72450_a, vecs[1].field_72449_c).invertV(), new UV(vecs[2].field_72450_a, vecs[2].field_72449_c).invertV(), new UV(vecs[3].field_72450_a, vecs[3].field_72449_c).invertV()};
            }
            case UP: {
                return new UV[]{new UV(vecs[0].field_72450_a, vecs[0].field_72449_c), new UV(vecs[1].field_72450_a, vecs[1].field_72449_c), new UV(vecs[2].field_72450_a, vecs[2].field_72449_c), new UV(vecs[3].field_72450_a, vecs[3].field_72449_c)};
            }
            case NORTH: {
                if (floatY) {
                    return new UV[]{new UV(vecs[0].field_72450_a, 0.0).invertU(), new UV(vecs[1].field_72450_a, vecs[0].field_72448_b - vecs[1].field_72448_b).invertU(), new UV(vecs[2].field_72450_a, vecs[3].field_72448_b - vecs[2].field_72448_b).invertU(), new UV(vecs[3].field_72450_a, 0.0).invertU()};
                }
                return new UV[]{new UV(vecs[0].field_72450_a, vecs[0].field_72448_b).invertUV(), new UV(vecs[1].field_72450_a, vecs[1].field_72448_b).invertUV(), new UV(vecs[2].field_72450_a, vecs[2].field_72448_b).invertUV(), new UV(vecs[3].field_72450_a, vecs[3].field_72448_b).invertUV()};
            }
            case SOUTH: {
                if (floatY) {
                    return new UV[]{new UV(vecs[0].field_72450_a, 0.0), new UV(vecs[1].field_72450_a, vecs[0].field_72448_b - vecs[1].field_72448_b), new UV(vecs[2].field_72450_a, vecs[3].field_72448_b - vecs[2].field_72448_b), new UV(vecs[3].field_72450_a, 0.0)};
                }
                return new UV[]{new UV(vecs[0].field_72450_a, vecs[0].field_72448_b).invertV(), new UV(vecs[1].field_72450_a, vecs[1].field_72448_b).invertV(), new UV(vecs[2].field_72450_a, vecs[2].field_72448_b).invertV(), new UV(vecs[3].field_72450_a, vecs[3].field_72448_b).invertV()};
            }
            case WEST: {
                if (floatY) {
                    return new UV[]{new UV(vecs[0].field_72449_c, 0.0), new UV(vecs[1].field_72449_c, vecs[0].field_72448_b - vecs[1].field_72448_b), new UV(vecs[2].field_72449_c, vecs[3].field_72448_b - vecs[2].field_72448_b), new UV(vecs[3].field_72449_c, 0.0)};
                }
                return new UV[]{new UV(vecs[0].field_72449_c, vecs[0].field_72448_b).invertV(), new UV(vecs[1].field_72449_c, vecs[1].field_72448_b).invertV(), new UV(vecs[2].field_72449_c, vecs[2].field_72448_b).invertV(), new UV(vecs[3].field_72449_c, vecs[3].field_72448_b).invertV()};
            }
            case EAST: {
                if (floatY) {
                    return new UV[]{new UV(vecs[0].field_72449_c, 0.0).invertU(), new UV(vecs[1].field_72449_c, vecs[0].field_72448_b - vecs[1].field_72448_b).invertU(), new UV(vecs[2].field_72449_c, vecs[3].field_72448_b - vecs[2].field_72448_b).invertU(), new UV(vecs[3].field_72449_c, 0.0).invertU()};
                }
                return new UV[]{new UV(vecs[0].field_72449_c, vecs[0].field_72448_b).invertUV(), new UV(vecs[1].field_72449_c, vecs[1].field_72448_b).invertUV(), new UV(vecs[2].field_72449_c, vecs[2].field_72448_b).invertUV(), new UV(vecs[3].field_72449_c, vecs[3].field_72448_b).invertUV()};
            }
        }
        return null;
    }

    private static UV[] getUVSideCover(Quad quad, boolean floatY, EnumAttributeLocation location) {
        Vec3d[] vecs = quad.getVecs();
        double depth = 0.0625;
        switch (quad.getFacing()) {
            case DOWN: {
                switch (location) {
                    case NORTH: {
                        depth = vecs[0].field_72449_c - vecs[1].field_72449_c;
                        return new UV[]{new UV(vecs[0].field_72450_a, 1.0).invertV(), new UV(vecs[1].field_72450_a, 1.0 - depth).invertV(), new UV(vecs[2].field_72450_a, 1.0 - depth).invertV(), new UV(vecs[3].field_72450_a, 1.0).invertV()};
                    }
                    case SOUTH: {
                        depth = vecs[0].field_72449_c - vecs[1].field_72449_c;
                        return new UV[]{new UV(vecs[0].field_72450_a, depth).invertV(), new UV(vecs[1].field_72450_a, 0.0).invertV(), new UV(vecs[2].field_72450_a, 0.0).invertV(), new UV(vecs[3].field_72450_a, depth).invertV()};
                    }
                    case WEST: {
                        depth = vecs[3].field_72450_a - vecs[0].field_72450_a;
                        return new UV[]{new UV(1.0 - depth, vecs[0].field_72449_c).invertV(), new UV(1.0 - depth, vecs[1].field_72449_c).invertV(), new UV(1.0, vecs[2].field_72449_c).invertV(), new UV(1.0, vecs[3].field_72449_c).invertV()};
                    }
                }
                depth = vecs[3].field_72450_a - vecs[0].field_72450_a;
                return new UV[]{new UV(0.0, vecs[0].field_72449_c).invertV(), new UV(0.0, vecs[1].field_72449_c).invertV(), new UV(depth, vecs[2].field_72449_c).invertV(), new UV(depth, vecs[3].field_72449_c).invertV()};
            }
            case UP: {
                switch (location) {
                    case NORTH: {
                        depth = vecs[1].field_72449_c - vecs[0].field_72449_c;
                        return new UV[]{new UV(vecs[0].field_72450_a, depth).invertV(), new UV(vecs[1].field_72450_a, 0.0).invertV(), new UV(vecs[2].field_72450_a, 0.0).invertV(), new UV(vecs[3].field_72450_a, depth).invertV()};
                    }
                    case SOUTH: {
                        depth = vecs[1].field_72449_c - vecs[0].field_72449_c;
                        return new UV[]{new UV(vecs[0].field_72450_a, 1.0).invertV(), new UV(vecs[1].field_72450_a, 1.0 - depth).invertV(), new UV(vecs[2].field_72450_a, 1.0 - depth).invertV(), new UV(vecs[3].field_72450_a, 1.0).invertV()};
                    }
                    case WEST: {
                        depth = vecs[3].field_72450_a - vecs[0].field_72450_a;
                        return new UV[]{new UV(1.0 - depth, vecs[0].field_72449_c), new UV(1.0 - depth, vecs[1].field_72449_c), new UV(1.0, vecs[2].field_72449_c), new UV(1.0, vecs[3].field_72449_c)};
                    }
                }
                depth = vecs[3].field_72450_a - vecs[0].field_72450_a;
                return new UV[]{new UV(0.0, vecs[0].field_72449_c), new UV(0.0, vecs[1].field_72449_c), new UV(depth, vecs[2].field_72449_c), new UV(depth, vecs[3].field_72449_c)};
            }
            case NORTH: {
                switch (location) {
                    case DOWN: {
                        depth = vecs[0].field_72448_b - vecs[1].field_72448_b;
                        if (floatY) {
                            return new UV[]{new UV(vecs[0].field_72450_a, 0.0).invertU(), new UV(vecs[1].field_72450_a, depth).invertU(), new UV(vecs[2].field_72450_a, depth).invertU(), new UV(vecs[3].field_72450_a, 0.0).invertU()};
                        }
                        return new UV[]{new UV(vecs[0].field_72450_a, 0.0).invertU(), new UV(vecs[1].field_72450_a, depth).invertU(), new UV(vecs[2].field_72450_a, depth).invertU(), new UV(vecs[3].field_72450_a, 0.0).invertU()};
                    }
                    case UP: {
                        depth = vecs[0].field_72448_b - vecs[1].field_72448_b;
                        if (floatY) {
                            return new UV[]{new UV(vecs[0].field_72450_a, 0.0).invertU(), new UV(vecs[1].field_72450_a, depth).invertU(), new UV(vecs[2].field_72450_a, depth).invertU(), new UV(vecs[3].field_72450_a, 0.0).invertU()};
                        }
                        return new UV[]{new UV(vecs[0].field_72450_a, depth).invertUV(), new UV(vecs[1].field_72450_a, 0.0).invertUV(), new UV(vecs[2].field_72450_a, 0.0).invertUV(), new UV(vecs[3].field_72450_a, depth).invertUV()};
                    }
                    case WEST: {
                        depth = vecs[0].field_72450_a - vecs[3].field_72450_a;
                        if (floatY) {
                            return new UV[]{new UV(0.0, 0.0), new UV(0.0, vecs[0].field_72448_b - vecs[1].field_72448_b), new UV(depth, vecs[3].field_72448_b - vecs[2].field_72448_b), new UV(depth, 0.0)};
                        }
                        return new UV[]{new UV(0.0, vecs[0].field_72448_b).invertV(), new UV(0.0, vecs[1].field_72448_b).invertV(), new UV(depth, vecs[2].field_72448_b).invertV(), new UV(depth, vecs[3].field_72448_b).invertV()};
                    }
                }
                depth = vecs[0].field_72450_a - vecs[3].field_72450_a;
                if (floatY) {
                    return new UV[]{new UV(depth, 0.0).invertU(), new UV(depth, vecs[0].field_72448_b - vecs[1].field_72448_b).invertU(), new UV(0.0, vecs[3].field_72448_b - vecs[2].field_72448_b).invertU(), new UV(0.0, 0.0).invertU()};
                }
                return new UV[]{new UV(depth, vecs[0].field_72448_b).invertUV(), new UV(depth, vecs[1].field_72448_b).invertUV(), new UV(0.0, vecs[2].field_72448_b).invertUV(), new UV(0.0, vecs[3].field_72448_b).invertUV()};
            }
            case SOUTH: {
                switch (location) {
                    case DOWN: {
                        depth = vecs[0].field_72448_b - vecs[1].field_72448_b;
                        if (floatY) {
                            return new UV[]{new UV(vecs[0].field_72450_a, 0.0), new UV(vecs[1].field_72450_a, depth), new UV(vecs[2].field_72450_a, depth), new UV(vecs[3].field_72450_a, 0.0)};
                        }
                        return new UV[]{new UV(vecs[0].field_72450_a, 0.0), new UV(vecs[1].field_72450_a, depth), new UV(vecs[2].field_72450_a, depth), new UV(vecs[3].field_72450_a, 0.0)};
                    }
                    case UP: {
                        depth = vecs[0].field_72448_b - vecs[1].field_72448_b;
                        if (floatY) {
                            return new UV[]{new UV(vecs[0].field_72450_a, 0.0), new UV(vecs[1].field_72450_a, depth), new UV(vecs[2].field_72450_a, depth), new UV(vecs[3].field_72450_a, 0.0)};
                        }
                        return new UV[]{new UV(vecs[0].field_72450_a, depth).invertV(), new UV(vecs[1].field_72450_a, 0.0).invertV(), new UV(vecs[2].field_72450_a, 0.0).invertV(), new UV(vecs[3].field_72450_a, depth).invertV()};
                    }
                    case WEST: {
                        depth = vecs[0].field_72450_a - vecs[3].field_72450_a;
                        if (floatY) {
                            return new UV[]{new UV(depth, 0.0).invertU(), new UV(depth, vecs[0].field_72448_b - vecs[1].field_72448_b).invertU(), new UV(0.0, vecs[3].field_72448_b - vecs[2].field_72448_b).invertU(), new UV(0.0, 0.0).invertU()};
                        }
                        return new UV[]{new UV(depth, vecs[0].field_72448_b).invertUV(), new UV(depth, vecs[1].field_72448_b).invertUV(), new UV(0.0, vecs[2].field_72448_b).invertUV(), new UV(0.0, vecs[3].field_72448_b).invertUV()};
                    }
                }
                depth = vecs[0].field_72450_a - vecs[3].field_72450_a;
                if (floatY) {
                    return new UV[]{new UV(0.0, 0.0), new UV(0.0, vecs[0].field_72448_b - vecs[1].field_72448_b), new UV(depth, vecs[3].field_72448_b - vecs[2].field_72448_b), new UV(depth, 0.0)};
                }
                return new UV[]{new UV(0.0, vecs[0].field_72448_b).invertV(), new UV(0.0, vecs[1].field_72448_b).invertV(), new UV(depth, vecs[2].field_72448_b).invertV(), new UV(depth, vecs[3].field_72448_b).invertV()};
            }
            case WEST: {
                switch (location) {
                    case DOWN: {
                        depth = vecs[0].field_72448_b - vecs[1].field_72448_b;
                        if (floatY) {
                            return new UV[]{new UV(vecs[0].field_72449_c, 0.0), new UV(vecs[1].field_72449_c, depth), new UV(vecs[2].field_72449_c, depth), new UV(vecs[3].field_72449_c, 0.0)};
                        }
                        return new UV[]{new UV(vecs[0].field_72449_c, 0.0), new UV(vecs[1].field_72449_c, depth), new UV(vecs[2].field_72449_c, depth), new UV(vecs[3].field_72449_c, 0.0)};
                    }
                    case UP: {
                        depth = vecs[0].field_72448_b - vecs[1].field_72448_b;
                        if (floatY) {
                            return new UV[]{new UV(vecs[0].field_72449_c, 0.0), new UV(vecs[1].field_72449_c, depth), new UV(vecs[2].field_72449_c, depth), new UV(vecs[3].field_72449_c, 0.0)};
                        }
                        return new UV[]{new UV(vecs[0].field_72449_c, depth).invertV(), new UV(vecs[1].field_72449_c, 0.0).invertV(), new UV(vecs[2].field_72449_c, 0.0).invertV(), new UV(vecs[3].field_72449_c, depth).invertV()};
                    }
                    case NORTH: {
                        depth = vecs[3].field_72449_c - vecs[0].field_72449_c;
                        if (floatY) {
                            return new UV[]{new UV(depth, 0.0).invertU(), new UV(depth, vecs[0].field_72448_b - vecs[1].field_72448_b).invertU(), new UV(0.0, vecs[3].field_72448_b - vecs[2].field_72448_b).invertU(), new UV(0.0, 0.0).invertU()};
                        }
                        return new UV[]{new UV(depth, vecs[0].field_72448_b).invertUV(), new UV(depth, vecs[1].field_72448_b).invertUV(), new UV(0.0, vecs[2].field_72448_b).invertUV(), new UV(0.0, vecs[3].field_72448_b).invertUV()};
                    }
                }
                depth = vecs[3].field_72449_c - vecs[0].field_72449_c;
                if (floatY) {
                    return new UV[]{new UV(0.0, 0.0), new UV(0.0, vecs[0].field_72448_b - vecs[1].field_72448_b), new UV(depth, vecs[3].field_72448_b - vecs[2].field_72448_b), new UV(depth, 0.0)};
                }
                return new UV[]{new UV(0.0, vecs[0].field_72448_b).invertV(), new UV(0.0, vecs[1].field_72448_b).invertV(), new UV(depth, vecs[2].field_72448_b).invertV(), new UV(depth, vecs[3].field_72448_b).invertV()};
            }
        }
        switch (location) {
            case DOWN: {
                depth = vecs[0].field_72448_b - vecs[1].field_72448_b;
                if (floatY) {
                    return new UV[]{new UV(vecs[0].field_72449_c, 0.0).invertU(), new UV(vecs[1].field_72449_c, depth).invertU(), new UV(vecs[2].field_72449_c, depth).invertU(), new UV(vecs[3].field_72449_c, 0.0).invertU()};
                }
                return new UV[]{new UV(vecs[0].field_72449_c, 0.0).invertU(), new UV(vecs[1].field_72449_c, depth).invertU(), new UV(vecs[2].field_72449_c, depth).invertU(), new UV(vecs[3].field_72449_c, 0.0).invertU()};
            }
            case UP: {
                depth = vecs[0].field_72448_b - vecs[1].field_72448_b;
                if (floatY) {
                    return new UV[]{new UV(vecs[0].field_72449_c, 0.0).invertU(), new UV(vecs[1].field_72449_c, depth).invertU(), new UV(vecs[2].field_72449_c, depth).invertU(), new UV(vecs[3].field_72449_c, 0.0).invertU()};
                }
                return new UV[]{new UV(vecs[0].field_72449_c, depth).invertUV(), new UV(vecs[1].field_72449_c, 0.0).invertUV(), new UV(vecs[2].field_72449_c, 0.0).invertUV(), new UV(vecs[3].field_72449_c, depth).invertUV()};
            }
            case NORTH: {
                depth = vecs[0].field_72449_c - vecs[3].field_72449_c;
                if (floatY) {
                    return new UV[]{new UV(0.0, 0.0), new UV(0.0, vecs[0].field_72448_b - vecs[1].field_72448_b), new UV(depth, vecs[3].field_72448_b - vecs[2].field_72448_b), new UV(depth, 0.0)};
                }
                return new UV[]{new UV(0.0, vecs[0].field_72448_b).invertV(), new UV(0.0, vecs[1].field_72448_b).invertV(), new UV(depth, vecs[2].field_72448_b).invertV(), new UV(depth, vecs[3].field_72448_b).invertV()};
            }
        }
        depth = vecs[0].field_72449_c - vecs[3].field_72449_c;
        if (floatY) {
            return new UV[]{new UV(depth, 0.0).invertU(), new UV(depth, vecs[0].field_72448_b - vecs[1].field_72448_b).invertU(), new UV(0.0, vecs[3].field_72448_b - vecs[2].field_72448_b).invertU(), new UV(0.0, 0.0).invertU()};
        }
        return new UV[]{new UV(depth, vecs[0].field_72448_b).invertUV(), new UV(depth, vecs[1].field_72448_b).invertUV(), new UV(0.0, vecs[2].field_72448_b).invertUV(), new UV(0.0, vecs[3].field_72448_b).invertUV()};
    }

    public static List<Quad> getPerpendicularQuads(Quad quad, double depth) {
        ArrayList<Quad> list = new ArrayList<Quad>();
        Vec3d[] vecs = quad.getVecs();
        switch (quad.getSideCoverOffset()) {
            case DOWN: {
                list.add(Quad.getQuad(EnumFacing.NORTH, vecs[2].func_72441_c(0.0, 0.0, 0.0), vecs[2].func_72441_c(0.0, -depth, 0.0), vecs[1].func_72441_c(0.0, -depth, 0.0), vecs[1].func_72441_c(0.0, 0.0, 0.0)));
                list.add(Quad.getQuad(EnumFacing.SOUTH, vecs[0].func_72441_c(0.0, 0.0, 0.0), vecs[0].func_72441_c(0.0, -depth, 0.0), vecs[3].func_72441_c(0.0, -depth, 0.0), vecs[3].func_72441_c(0.0, 0.0, 0.0)));
                list.add(Quad.getQuad(EnumFacing.WEST, vecs[1].func_72441_c(0.0, 0.0, 0.0), vecs[1].func_72441_c(0.0, -depth, 0.0), vecs[0].func_72441_c(0.0, -depth, 0.0), vecs[0].func_72441_c(0.0, 0.0, 0.0)));
                list.add(Quad.getQuad(EnumFacing.EAST, vecs[3].func_72441_c(0.0, 0.0, 0.0), vecs[3].func_72441_c(0.0, -depth, 0.0), vecs[2].func_72441_c(0.0, -depth, 0.0), vecs[2].func_72441_c(0.0, 0.0, 0.0)));
                break;
            }
            case UP: {
                list.add(Quad.getQuad(EnumFacing.NORTH, vecs[3].func_72441_c(0.0, depth, 0.0), vecs[3].func_72441_c(0.0, 0.0, 0.0), vecs[0].func_72441_c(0.0, 0.0, 0.0), vecs[0].func_72441_c(0.0, depth, 0.0)));
                list.add(Quad.getQuad(EnumFacing.SOUTH, vecs[1].func_72441_c(0.0, depth, 0.0), vecs[1].func_72441_c(0.0, 0.0, 0.0), vecs[2].func_72441_c(0.0, 0.0, 0.0), vecs[2].func_72441_c(0.0, depth, 0.0)));
                list.add(Quad.getQuad(EnumFacing.WEST, vecs[0].func_72441_c(0.0, depth, 0.0), vecs[0].func_72441_c(0.0, 0.0, 0.0), vecs[1].func_72441_c(0.0, 0.0, 0.0), vecs[1].func_72441_c(0.0, depth, 0.0)));
                list.add(Quad.getQuad(EnumFacing.EAST, vecs[2].func_72441_c(0.0, depth, 0.0), vecs[2].func_72441_c(0.0, 0.0, 0.0), vecs[3].func_72441_c(0.0, 0.0, 0.0), vecs[3].func_72441_c(0.0, depth, 0.0)));
                break;
            }
            case NORTH: {
                list.add(Quad.getQuad(EnumFacing.DOWN, vecs[2].func_72441_c(0.0, 0.0, 0.0), vecs[2].func_72441_c(0.0, 0.0, -depth), vecs[1].func_72441_c(0.0, 0.0, -depth), vecs[1].func_72441_c(0.0, 0.0, 0.0)));
                list.add(Quad.getQuad(EnumFacing.UP, vecs[3].func_72441_c(0.0, 0.0, -depth), vecs[3].func_72441_c(0.0, 0.0, 0.0), vecs[0].func_72441_c(0.0, 0.0, 0.0), vecs[0].func_72441_c(0.0, 0.0, -depth)));
                list.add(Quad.getQuad(EnumFacing.WEST, vecs[3].func_72441_c(0.0, 0.0, 0.0), vecs[2].func_72441_c(0.0, 0.0, 0.0), vecs[2].func_72441_c(0.0, 0.0, -depth), vecs[3].func_72441_c(0.0, 0.0, -depth)));
                list.add(Quad.getQuad(EnumFacing.EAST, vecs[0].func_72441_c(0.0, 0.0, 0.0), vecs[1].func_72441_c(0.0, 0.0, 0.0), vecs[1].func_72441_c(0.0, 0.0, -depth), vecs[0].func_72441_c(0.0, 0.0, -depth)));
                break;
            }
            case SOUTH: {
                list.add(Quad.getQuad(EnumFacing.DOWN, vecs[1].func_72441_c(0.0, 0.0, depth), vecs[1].func_72441_c(0.0, 0.0, 0.0), vecs[2].func_72441_c(0.0, 0.0, 0.0), vecs[2].func_72441_c(0.0, 0.0, depth)));
                list.add(Quad.getQuad(EnumFacing.UP, vecs[0].func_72441_c(0.0, 0.0, 0.0), vecs[0].func_72441_c(0.0, 0.0, depth), vecs[3].func_72441_c(0.0, 0.0, depth), vecs[3].func_72441_c(0.0, 0.0, 0.0)));
                list.add(Quad.getQuad(EnumFacing.WEST, vecs[0].func_72441_c(0.0, 0.0, 0.0), vecs[1].func_72441_c(0.0, 0.0, 0.0), vecs[1].func_72441_c(0.0, 0.0, depth), vecs[0].func_72441_c(0.0, 0.0, depth)));
                list.add(Quad.getQuad(EnumFacing.EAST, vecs[3].func_72441_c(0.0, 0.0, depth), vecs[2].func_72441_c(0.0, 0.0, depth), vecs[2].func_72441_c(0.0, 0.0, 0.0), vecs[3].func_72441_c(0.0, 0.0, 0.0)));
                break;
            }
            case WEST: {
                list.add(Quad.getQuad(EnumFacing.DOWN, vecs[2].func_72441_c(-depth, 0.0, 0.0), vecs[1].func_72441_c(-depth, 0.0, 0.0), vecs[1].func_72441_c(0.0, 0.0, 0.0), vecs[2].func_72441_c(0.0, 0.0, 0.0)));
                list.add(Quad.getQuad(EnumFacing.UP, vecs[0].func_72441_c(-depth, 0.0, 0.0), vecs[3].func_72441_c(-depth, 0.0, 0.0), vecs[3].func_72441_c(0.0, 0.0, 0.0), vecs[0].func_72441_c(0.0, 0.0, 0.0)));
                list.add(Quad.getQuad(EnumFacing.NORTH, vecs[0].func_72441_c(0.0, 0.0, 0.0), vecs[1].func_72441_c(0.0, 0.0, 0.0), vecs[1].func_72441_c(-depth, 0.0, 0.0), vecs[0].func_72441_c(-depth, 0.0, 0.0)));
                list.add(Quad.getQuad(EnumFacing.SOUTH, vecs[3].func_72441_c(-depth, 0.0, 0.0), vecs[2].func_72441_c(-depth, 0.0, 0.0), vecs[2].func_72441_c(0.0, 0.0, 0.0), vecs[3].func_72441_c(0.0, 0.0, 0.0)));
                break;
            }
            case EAST: {
                list.add(Quad.getQuad(EnumFacing.DOWN, vecs[1].func_72441_c(0.0, 0.0, 0.0), vecs[2].func_72441_c(0.0, 0.0, 0.0), vecs[2].func_72441_c(depth, 0.0, 0.0), vecs[1].func_72441_c(depth, 0.0, 0.0)));
                list.add(Quad.getQuad(EnumFacing.UP, vecs[3].func_72441_c(0.0, 0.0, 0.0), vecs[0].func_72441_c(0.0, 0.0, 0.0), vecs[0].func_72441_c(depth, 0.0, 0.0), vecs[3].func_72441_c(depth, 0.0, 0.0)));
                list.add(Quad.getQuad(EnumFacing.NORTH, vecs[3].func_72441_c(depth, 0.0, 0.0), vecs[2].func_72441_c(depth, 0.0, 0.0), vecs[2].func_72441_c(0.0, 0.0, 0.0), vecs[3].func_72441_c(0.0, 0.0, 0.0)));
                list.add(Quad.getQuad(EnumFacing.SOUTH, vecs[0].func_72441_c(0.0, 0.0, 0.0), vecs[1].func_72441_c(0.0, 0.0, 0.0), vecs[1].func_72441_c(depth, 0.0, 0.0), vecs[0].func_72441_c(depth, 0.0, 0.0)));
            }
        }
        while (list.remove(null)) {
        }
        return list;
    }

    public static class Vec2l {
        private long _u;
        private long _v;

        public Vec2l(long u, long v) {
            this._u = u;
            this._v = v;
        }

        public Vec2l(EnumFacing facing, Vec3d vec3d) {
            switch (facing.func_176740_k()) {
                case X: {
                    this._u = Math.round(vec3d.field_72449_c * 16.0);
                    this._v = Math.round(vec3d.field_72448_b * 16.0);
                    break;
                }
                case Y: {
                    this._u = Math.round(vec3d.field_72450_a * 16.0);
                    this._v = Math.round(vec3d.field_72449_c * 16.0);
                    break;
                }
                case Z: {
                    this._u = Math.round(vec3d.field_72450_a * 16.0);
                    this._v = Math.round(vec3d.field_72448_b * 16.0);
                }
            }
        }

        public long getU() {
            return this._u;
        }

        public long getV() {
            return this._v;
        }
    }
}

