/*
 * Decompiled with CFR 0.152.
 */
package com.carpentersblocks.renderer;

import com.carpentersblocks.renderer.Quad;
import com.carpentersblocks.renderer.VecUtil;
import com.carpentersblocks.util.RotationUtil;
import com.carpentersblocks.util.attribute.EnumAttributeLocation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.init.Blocks;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;

public class QuadContainer {
    private List<Quad> _quads = new ArrayList<Quad>();
    private EnumAttributeLocation _location;
    private static final double MAX_UP_SLOPE = Math.sin(0.6108652381980153);
    private static final double MAX_SIDE_SLOPE = -Math.sin(0.9599310885968813);

    public QuadContainer(EnumAttributeLocation location) {
        this._location = location;
    }

    public List<BakedQuad> bakeQuads() {
        ArrayList<BakedQuad> list = new ArrayList<BakedQuad>();
        for (Quad quad : this._quads) {
            Quad cpyQuad = new Quad(quad);
            list.add(cpyQuad.bake(this._location));
        }
        return list;
    }

    public List<Quad> getQuads(IBlockState blockState, EnumFacing ... facings) {
        this.transformForBlockState(false, blockState);
        ArrayList<Quad> quads = new ArrayList<Quad>();
        for (Quad quad : this._quads) {
            if (facings.length == 0) {
                quads.add(new Quad(quad));
                continue;
            }
            for (EnumFacing facing : facings) {
                if (!facing.equals((Object)quad.getFacing())) continue;
                quads.add(new Quad(quad));
            }
        }
        return quads;
    }

    public void addAll(Collection<Quad> collection) {
        this._quads.addAll(collection);
    }

    public void add(Quad quad) {
        if (VecUtil.isValid(quad)) {
            this._quads.add(quad);
        }
    }

    public QuadContainer toSideLocation(IBlockState blockState, EnumAttributeLocation location, double depth) {
        QuadContainer quadContainer = new QuadContainer(location);
        EnumFacing facing = EnumFacing.func_82600_a((int)location.ordinal());
        for (Quad quad : this._quads) {
            EnumFacing offsetFacing = quad.getSideCoverOffset();
            if (!facing.equals((Object)offsetFacing)) continue;
            Quad sideQuad = new Quad(quad);
            sideQuad.applyFacing(offsetFacing);
            if (sideQuad == null) continue;
            quadContainer.add(sideQuad.offset((double)sideQuad.getFacing().func_82601_c() * depth, (double)sideQuad.getFacing().func_96559_d() * depth, (double)sideQuad.getFacing().func_82599_e() * depth));
            for (Quad perpQuad : VecUtil.getPerpendicularQuads(sideQuad, depth)) {
                quadContainer.add(new Quad(perpQuad));
            }
        }
        if (quadContainer._quads.size() > 6) {
            ArrayList<Quad> list = new ArrayList<Quad>(quadContainer._quads);
            QuadComparator comparator = new QuadComparator();
            Iterator<Quad> iter = quadContainer._quads.iterator();
            block2: while (iter.hasNext()) {
                Quad q1 = iter.next();
                for (Quad q2 : list) {
                    if (q1 == q2 || comparator.compare(q1, q2) != 0) continue;
                    iter.remove();
                    continue block2;
                }
            }
        }
        return quadContainer;
    }

    public List<BakedQuad> bakeQuads(List<Quad> quads) {
        ArrayList<BakedQuad> list = new ArrayList<BakedQuad>();
        for (Quad quad : quads) {
            Quad cpyQuad = new Quad(quad);
            list.add(cpyQuad.bake(this._location));
        }
        return list;
    }

    public List<BakedQuad> getBakedQuads(EnumFacing facing) {
        ArrayList<BakedQuad> list = new ArrayList<BakedQuad>();
        for (Quad quad : this._quads) {
            list.add(quad.bake(this._location));
        }
        return list;
    }

    public Set<BlockRenderLayer> getRenderLayers(boolean renderAttribute) {
        HashSet<BlockRenderLayer> set = new HashSet<BlockRenderLayer>();
        for (Quad quad : this._quads) {
            set.add(quad.getRenderLayer());
        }
        return set;
    }

    public boolean hasCoverOverride() {
        for (Quad quad : this._quads) {
            if (quad.canCover()) continue;
            return true;
        }
        return false;
    }

    public boolean isCoverable(BlockRenderLayer renderLayer) {
        for (Quad quad : this._quads) {
            if (!quad.canCover() || !renderLayer.equals((Object)quad.getRenderLayer())) continue;
            return true;
        }
        return false;
    }

    public void rotate(RotationUtil.Rotation rotation) {
        for (Quad quad : this._quads) {
            quad.rotate(rotation);
        }
    }

    public void transformForBlockState(boolean isSideCover, IBlockState blockState) {
        if (!isSideCover && blockState == null) {
            return;
        }
        ArrayList<Quad> list = new ArrayList<Quad>();
        for (Quad quad : this._quads) {
            if (quad.isSloped(EnumFacing.Axis.Y)) {
                Quad newQuad;
                if (isSideCover) {
                    if (!EnumFacing.Axis.Y.equals((Object)quad.getFacing())) {
                        newQuad = new Quad(quad);
                        newQuad.applyFacing(quad.getNormal().field_72448_b > 0.0 ? EnumFacing.UP : EnumFacing.DOWN);
                        list.add(newQuad);
                        continue;
                    }
                    list.add(new Quad(quad));
                    continue;
                }
                if (Blocks.field_150349_c.equals(blockState.func_177230_c())) {
                    newQuad = new Quad(quad);
                    if (Quad.compare(quad.getNormal().field_72448_b, MAX_UP_SLOPE) >= 0) {
                        if (!EnumFacing.UP.equals((Object)quad.getFacing())) {
                            newQuad.applyFacing(EnumFacing.UP);
                        }
                    } else if (Quad.compare(quad.getNormal().field_72448_b, MAX_SIDE_SLOPE) >= 0) {
                        if (!quad.getCardinalFacing().equals((Object)quad.getFacing())) {
                            newQuad.applyFacing(quad.getCardinalFacing());
                        }
                    } else if (!EnumFacing.DOWN.equals((Object)quad.getFacing())) {
                        newQuad.applyFacing(EnumFacing.DOWN);
                    }
                    list.add(newQuad);
                    continue;
                }
                newQuad = new Quad(quad);
                if (!quad.getCardinalFacing().equals((Object)quad.getFacing())) {
                    newQuad.applyFacing(quad.getCardinalFacing());
                }
                list.add(newQuad);
                continue;
            }
            list.add(new Quad(quad));
        }
        this._quads.clear();
        this._quads.addAll(list);
    }

    private class QuadComparator
    implements Comparator<Quad> {
        private QuadComparator() {
        }

        @Override
        public int compare(Quad q1, Quad q2) {
            ArrayList<Vec3d> tempList = new ArrayList<Vec3d>();
            tempList.addAll(Arrays.asList(q1.getVecs()));
            Iterator iter = tempList.iterator();
            block0: while (iter.hasNext()) {
                Vec3d v1 = (Vec3d)iter.next();
                for (Vec3d v2 : q2.getVecs()) {
                    if (!MathHelper.func_180185_a((float)((float)v1.field_72450_a), (float)((float)v2.field_72450_a)) || !MathHelper.func_180185_a((float)((float)v1.field_72448_b), (float)((float)v2.field_72448_b)) || !MathHelper.func_180185_a((float)((float)v1.field_72449_c), (float)((float)v2.field_72449_c))) continue;
                    iter.remove();
                    continue block0;
                }
            }
            if (tempList.isEmpty()) {
                return 0;
            }
            return -1;
        }
    }
}

