/*
 * Decompiled with CFR 0.152.
 */
package com.carpentersblocks.renderer;

import com.carpentersblocks.block.data.SlopeData;
import com.carpentersblocks.block.state.Property;
import com.carpentersblocks.renderer.RenderPkg;
import com.carpentersblocks.renderer.UV;
import com.carpentersblocks.renderer.VecUtil;
import com.carpentersblocks.util.ModLogger;
import com.carpentersblocks.util.RotationUtil;
import com.carpentersblocks.util.attribute.EnumAttributeLocation;
import com.carpentersblocks.util.registry.BlockRegistry;
import com.carpentersblocks.util.registry.SpriteRegistry;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.client.model.pipeline.UnpackedBakedQuad;

public class Quad {
    private static final float FULL_BRIGHT = 0.0073243305f;
    private static final String GRASS_SIDE_OVERLAY = "minecraft:blocks/grass_side_overlay";
    private Vec3d[] _vecs;
    private EnumFacing _facing;
    private TextureAtlasSprite _sprite;
    private int _rgb;
    private boolean _maxBrightness;
    private BlockRenderLayer _renderLayer;
    private Vec3d _normal;
    boolean _isOblique;

    private Quad() {
    }

    private Quad(EnumFacing facing, Vec3d ... vecs) {
        this._vecs = vecs;
        this.applyFacing(facing);
    }

    public Quad(Quad srcQuad) {
        Vec3d[] srcVecs = srcQuad.getVecs();
        Vec3d[] vecs = new Vec3d[srcVecs.length];
        for (int i = 0; i < srcVecs.length; ++i) {
            vecs[i] = new Vec3d(srcVecs[i].field_72450_a, srcVecs[i].field_72448_b, srcVecs[i].field_72449_c);
        }
        this._vecs = vecs;
        this._facing = srcQuad.getFacing();
        this._maxBrightness = srcQuad.isMaxBrightness();
        this._renderLayer = srcQuad.getRenderLayer();
        this._rgb = srcQuad.getRgb();
        this._sprite = srcQuad.getSprite();
        this._normal = new Vec3d(srcQuad.getNormal().field_72450_a, srcQuad.getNormal().field_72448_b, srcQuad.getNormal().field_72449_c);
        this._isOblique = srcQuad.isObliqueSlope();
    }

    public static Quad getQuad(EnumFacing facing, Vec3d ... inVecs) {
        return Quad.getQuad(facing, SpriteRegistry.sprite_uncovered_full, inVecs);
    }

    public static Quad getQuad(EnumFacing facing, TextureAtlasSprite sprite, Vec3d ... inVecs) {
        Vec3d[] vec3ds = VecUtil.buildVecs(facing, inVecs);
        return Quad.getQuad(facing, sprite, 0xFFFFFF, false, BlockRenderLayer.CUTOUT_MIPPED, inVecs);
    }

    public static Quad getQuad(EnumFacing facing, TextureAtlasSprite sprite, int rgb, Vec3d ... inVecs) {
        Vec3d[] vec3ds = VecUtil.buildVecs(facing, inVecs);
        if (vec3ds == null || vec3ds.length != 4) {
            return null;
        }
        return Quad.getQuad(facing, sprite, rgb, false, BlockRenderLayer.CUTOUT_MIPPED, inVecs);
    }

    public static Quad getQuad(EnumFacing facing, TextureAtlasSprite sprite, int rgb, boolean maxBrightness, BlockRenderLayer renderLayer, Vec3d ... inVecs) {
        Vec3d[] vec3ds = VecUtil.buildVecs(facing, inVecs);
        if (vec3ds == null || vec3ds.length != 4) {
            return null;
        }
        Quad quad = new Quad(facing, vec3ds);
        quad.setSprite(sprite);
        quad.setMaxBrightness(maxBrightness);
        quad.setRenderLayer(renderLayer);
        quad.setRgb(rgb);
        return quad;
    }

    public Quad offset(double x, double y, double z) {
        Quad quad = new Quad(this);
        for (int i = 0; i < quad._vecs.length; ++i) {
            quad._vecs[i] = quad._vecs[i].func_72441_c(x, y, z);
        }
        return quad;
    }

    public EnumFacing getFacing() {
        return this._facing;
    }

    public Vec3d[] getVecs() {
        return this._vecs;
    }

    public TextureAtlasSprite getSprite() {
        return this._sprite;
    }

    public void setSprite(TextureAtlasSprite sprite) {
        this._sprite = sprite;
    }

    public int getRgb() {
        return this._rgb;
    }

    public void setRgb(int rgb) {
        this._rgb = rgb;
    }

    public boolean isMaxBrightness() {
        return this._maxBrightness;
    }

    public void setMaxBrightness(boolean maxBrightness) {
        this._maxBrightness = maxBrightness;
    }

    public BlockRenderLayer getRenderLayer() {
        return this._renderLayer;
    }

    public void setRenderLayer(BlockRenderLayer renderLayer) {
        this._renderLayer = renderLayer;
    }

    public boolean canCover() {
        return this.getSprite().func_94215_i().contains("uncovered_");
    }

    public BakedQuad bake(EnumAttributeLocation location) {
        VertexFormat vertexFormat = RenderPkg._threadLocalVertexFormat.get();
        UnpackedBakedQuad.Builder builder = new UnpackedBakedQuad.Builder(vertexFormat);
        builder.setTexture(this._sprite);
        boolean floatY = this._sprite.func_94215_i().equals(GRASS_SIDE_OVERLAY) || this._sprite.func_94215_i().contains("overlay/overlay_") && this._sprite.func_94215_i().endsWith("_side");
        Block block = (Block)RenderPkg.getThreadedProperty(Property.BLOCK_TYP);
        Integer cbMetadata = (Integer)RenderPkg.getThreadedProperty(Property.CB_METADATA);
        if (BlockRegistry.blockCarpentersSlope.equals(block) && this._isOblique) {
            switch (SlopeData.getType(cbMetadata)) {
                case OBLIQUE_EXTERIOR: {
                    break;
                }
                case OBLIQUE_INTERIOR: {
                    break;
                }
            }
        } else if (BlockRegistry.blockCarpentersCollapsibleBlock.equals(block) && (this.isSloped(EnumFacing.Axis.X) || this.isSloped(EnumFacing.Axis.Y) || this.isSloped(EnumFacing.Axis.Z))) {
            this._facing = (EnumFacing)RenderPkg.getThreadedProperty(Property.FACING);
            this._isOblique = false;
            floatY = false;
        }
        UV[] uv = VecUtil.getUV(this, floatY, location);
        for (int i = 0; i < 4; ++i) {
            block11: for (int idx = 0; idx < vertexFormat.func_177345_h(); ++idx) {
                switch (vertexFormat.func_177348_c(idx).func_177375_c()) {
                    case POSITION: {
                        builder.put(idx, new float[]{(float)this._vecs[i].field_72450_a, (float)this._vecs[i].field_72448_b, (float)this._vecs[i].field_72449_c, 1.0f});
                        continue block11;
                    }
                    case COLOR: {
                        builder.put(idx, new float[]{(float)((this._rgb & 0xFF0000) >> 16) / 255.0f, (float)((this._rgb & 0xFF00) >> 8) / 255.0f, (float)(this._rgb & 0xFF) / 255.0f, 1.0f});
                        continue block11;
                    }
                    case UV: {
                        if (vertexFormat.func_177348_c(idx).func_177369_e() == 0) {
                            builder.put(idx, new float[]{this._sprite.func_94214_a(uv[i].getU()), this._sprite.func_94207_b(uv[i].getV()), 0.0f, 1.0f});
                            continue block11;
                        }
                        if (vertexFormat.func_177348_c(idx).func_177369_e() != 1) continue block11;
                        float brightness = this._maxBrightness ? 0.0073243305f : 0.0f;
                        builder.put(idx, new float[]{brightness, brightness});
                        continue block11;
                    }
                    case NORMAL: {
                        builder.put(idx, new float[]{(float)this._normal.field_72450_a, (float)this._normal.field_72448_b, (float)this._normal.field_72449_c, 0.0f});
                        continue block11;
                    }
                    default: {
                        builder.put(idx, new float[0]);
                    }
                }
            }
        }
        return builder.build();
    }

    public void rotate(RotationUtil.Rotation rotation) {
        Vec3d[] newVecs = new Vec3d[this._vecs.length];
        EnumFacing newFacing = rotation.getRotatedFacing(this._facing);
        for (int i = 0; i < this._vecs.length; ++i) {
            Vec3d vec3d = this._vecs[i];
            Vec3d vec3dRot = vec3d.func_178787_e(Vec3d.field_186680_a);
            if (rotation.getRadians(EnumFacing.Axis.X) > 0.0) {
                vec3dRot = this.rotateAroundX(vec3dRot, rotation.getRadians(EnumFacing.Axis.X));
            }
            if (rotation.getRadians(EnumFacing.Axis.Y) > 0.0) {
                vec3dRot = this.rotateAroundY(vec3dRot, rotation.getRadians(EnumFacing.Axis.Y));
            }
            if (rotation.getRadians(EnumFacing.Axis.Z) > 0.0) {
                vec3dRot = this.rotateAroundZ(vec3dRot, rotation.getRadians(EnumFacing.Axis.Z));
            }
            newVecs[i] = vec3dRot;
        }
        this._vecs = newVecs;
        this.applyFacing(newFacing);
    }

    private Vec3d rotateAroundX(Vec3d vec3d, double radians) {
        double y = 0.5 + (vec3d.field_72449_c - 0.5) * Math.sin(radians) + (vec3d.field_72448_b - 0.5) * Math.cos(radians);
        double z = 0.5 + (vec3d.field_72449_c - 0.5) * Math.cos(radians) - (vec3d.field_72448_b - 0.5) * Math.sin(radians);
        return new Vec3d(vec3d.field_72450_a, y, z);
    }

    private Vec3d rotateAroundY(Vec3d vec3d, double radians) {
        double z = 0.5 + (vec3d.field_72450_a - 0.5) * Math.sin(radians) + (vec3d.field_72449_c - 0.5) * Math.cos(radians);
        double x = 0.5 + (vec3d.field_72450_a - 0.5) * Math.cos(radians) - (vec3d.field_72449_c - 0.5) * Math.sin(radians);
        return new Vec3d(x, vec3d.field_72448_b, z);
    }

    private Vec3d rotateAroundZ(Vec3d vec3d, double radians) {
        double x = 0.5 + (vec3d.field_72448_b - 0.5) * Math.sin(radians) + (vec3d.field_72450_a - 0.5) * Math.cos(radians);
        double y = 0.5 + (vec3d.field_72448_b - 0.5) * Math.cos(radians) - (vec3d.field_72450_a - 0.5) * Math.sin(radians);
        return new Vec3d(x, y, vec3d.field_72449_c);
    }

    public EnumFacing getYSlope() {
        return this._normal.field_72448_b > 0.0 ? EnumFacing.UP : EnumFacing.DOWN;
    }

    public boolean isSloped(EnumFacing.Axis axis) {
        double axis1 = EnumFacing.Axis.X.equals((Object)axis) ? this._normal.field_72450_a : (EnumFacing.Axis.Y.equals((Object)axis) ? this._normal.field_72448_b : this._normal.field_72449_c);
        return Quad.compare(axis1, -1.0) > 0 && Quad.compare(axis1, 0.0) != 0 && Quad.compare(axis1, 1.0) < 0;
    }

    public EnumFacing getCardinalFacing() {
        if (!this.isSloped(EnumFacing.Axis.Y)) {
            ModLogger.warning("getCardinalFacing called for non-sloping Y-axis", new Object[0]);
        }
        return EnumFacing.func_176737_a((float)((float)this._normal.field_72450_a), (float)0.0f, (float)((float)this._normal.field_72449_c));
    }

    public void applyFacing(EnumFacing facing) {
        this._facing = facing;
        this._vecs = VecUtil.buildVecs(facing, this._vecs);
        Vec3d[] vecs1 = new LinkedHashSet<Vec3d>(Arrays.asList(this.getVecs())).toArray(new Vec3d[this.getVecs().length]);
        this._normal = vecs1[1].func_178788_d(vecs1[0]).func_72431_c(vecs1[2].func_178788_d(vecs1[1])).func_72432_b();
        this._isOblique = this.isSloped(EnumFacing.Axis.X) && this.isSloped(EnumFacing.Axis.Y) && this.isSloped(EnumFacing.Axis.Z);
    }

    public static int compare(double d1, double d2) {
        double diff = d1 - d2;
        double epsilon = 1.0E-4;
        if (diff < -epsilon) {
            return -1;
        }
        if (diff > epsilon) {
            return 1;
        }
        return 0;
    }

    public Vec3d getNormal() {
        return this._normal;
    }

    public boolean isObliqueSlope() {
        return this._isOblique;
    }

    private boolean isTriangle() {
        return new HashSet<Vec3d>(Arrays.asList(this.getVecs())).size() < 4;
    }

    public EnumFacing getSideCoverOffset() {
        if (this.isSloped(EnumFacing.Axis.Y)) {
            if (this._normal.field_72448_b > 0.0) {
                return EnumFacing.UP;
            }
            return EnumFacing.DOWN;
        }
        return this._facing;
    }

    public static enum Rotation {
        QUARTER(1.5707963267948966),
        HALF(Math.PI),
        THREE_QUARTER(4.71238898038469);

        private double _value;

        private Rotation(double value) {
            this._value = value;
        }

        public double getValue() {
            return this._value;
        }
    }
}

