/*
 * Decompiled with CFR 0.152.
 */
package com.carpentersblocks.block.data;

import com.carpentersblocks.block.data.RotatableData;
import com.carpentersblocks.tileentity.CbTileEntity;

public class SlopeData
extends RotatableData {
    private static final int TYPE_BITMASK = 1984;
    private static final int TYPE_BITSHIFT = 6;
    private static final int TYPE_WEDGE = 0;
    private static final int TYPE_OBL_INT = 1;
    private static final int TYPE_OBL_EXT = 2;
    private static final int TYPE_PRISM = 3;
    private static final int TYPE_PRISM_1P = 4;
    private static final int TYPE_PRISM_2P = 5;
    private static final int TYPE_PRISM_3P = 6;
    private static final int TYPE_PRISM_4P = 7;
    private static final int TYPE_PRISM_WEDGE = 8;

    public static Type getType(int cbMetadata) {
        int temp = (cbMetadata & 0x7C0) >> 6;
        for (Type type : Type.values()) {
            if (type.ordinal() != temp) continue;
            return type;
        }
        return Type.WEDGE;
    }

    public static void setNextType(CbTileEntity cbTileEntity) {
        Type type = SlopeData.getType(cbTileEntity.getCbMetadata());
        int newType = type.ordinal() + 1;
        if (newType > Type.values().length) {
            newType = 0;
        }
        int temp = cbTileEntity.getCbMetadata();
        temp &= 0xFFFFF83F;
        cbTileEntity.setCbMetadata(temp |= newType << 6);
    }

    public static enum Type {
        WEDGE,
        OBLIQUE_INTERIOR,
        OBLIQUE_EXTERIOR;

    }
}

