/*
 * Decompiled with CFR 0.152.
 */
package com.carpentersblocks.block;

import com.carpentersblocks.api.ICarpentersChisel;
import com.carpentersblocks.api.ICarpentersHammer;
import com.carpentersblocks.block.IStateImplementor;
import com.carpentersblocks.block.state.Property;
import com.carpentersblocks.tileentity.CbTileEntity;
import com.carpentersblocks.util.EntityLivingUtil;
import com.carpentersblocks.util.attribute.AbstractAttribute;
import com.carpentersblocks.util.attribute.EnumAttributeLocation;
import com.carpentersblocks.util.attribute.EnumAttributeType;
import com.carpentersblocks.util.block.BlockUtil;
import com.carpentersblocks.util.handler.DesignHandler;
import com.carpentersblocks.util.handler.EventHandler;
import com.carpentersblocks.util.handler.OverlayHandler;
import com.carpentersblocks.util.protection.PlayerPermissions;
import com.carpentersblocks.util.protection.ProtectedObject;
import com.carpentersblocks.util.registry.ConfigRegistry;
import com.carpentersblocks.util.states.factory.StateFactory;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.StringUtils;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class BlockCoverable
extends Block {
    public static int EVENT_ID_DROP_ATTR = 0x40000000;
    protected final int METADATA_DROP_ATTR_ONLY = 16;

    public BlockCoverable(Material material) {
        super(material);
    }

    protected void setBlockBounds(float minX, float minY, float minZ, float maxX, float maxY, float maxZ, EnumFacing facing) {
    }

    protected AxisAlignedBB getGlobalBoundingBox(IBlockState blockState, IBlockAccess blockAccess, BlockPos blockPos) {
        return super.func_185496_a(blockState, blockAccess, blockPos).func_186670_a(blockPos);
    }

    @Nullable
    public RayTraceResult func_180636_a(IBlockState blockState, World world, BlockPos blockPos, Vec3d start, Vec3d end) {
        if (this instanceof IStateImplementor) {
            ArrayList list = Lists.newArrayList();
            CbTileEntity cbTileEntity = this.getTileEntity((IBlockAccess)world, blockPos);
            if (cbTileEntity != null) {
                for (AxisAlignedBB aabb : StateFactory.getState(cbTileEntity).getAxisAlignedBBs()) {
                    list.add(this.func_185503_a(blockPos, start, end, aabb));
                }
            } else {
                return super.func_180636_a(blockState, world, blockPos, start, end);
            }
            RayTraceResult finalRayTraceResult = null;
            double d1 = 0.0;
            for (RayTraceResult rayTraceResult : list) {
                double d0;
                if (rayTraceResult == null || !((d0 = rayTraceResult.field_72307_f.func_72436_e(end)) > d1)) continue;
                finalRayTraceResult = rayTraceResult;
                d1 = d0;
            }
            return finalRayTraceResult;
        }
        return super.func_180636_a(blockState, world, blockPos, start, end);
    }

    public boolean func_189539_a(IBlockState blockState, World world, BlockPos blockPos, int id, int param) {
        CbTileEntity cbTileEntity;
        if (id == EVENT_ID_DROP_ATTR && (cbTileEntity = this.getSimpleTileEntity((IBlockAccess)world, blockPos)) != null) {
            AbstractAttribute.Key key = new AbstractAttribute.Key(param);
            if (cbTileEntity.getAttributeHelper().hasAttribute(key)) {
                ItemStack itemStack = cbTileEntity.getDroppedItemStack(key);
                if (cbTileEntity.onAttrDropped(key)) {
                    BlockCoverable.func_180635_a((World)world, (BlockPos)blockPos, (ItemStack)itemStack);
                    return true;
                }
                return false;
            }
        }
        return super.func_189539_a(blockState, world, blockPos, id, param);
    }

    protected ItemStack getItemDrop(World world, int metadata) {
        return new ItemStack(this.func_180660_a(this.func_176223_P(), world.field_73012_v, 0), 1, metadata);
    }

    protected CbTileEntity[] getAdjacentTileEntities(World world, BlockPos blockPos) {
        return new CbTileEntity[]{this.getSimpleTileEntity((IBlockAccess)world, blockPos.func_177982_a(0, -1, 0)), this.getSimpleTileEntity((IBlockAccess)world, blockPos.func_177982_a(0, 1, 0)), this.getSimpleTileEntity((IBlockAccess)world, blockPos.func_177982_a(0, 0, -1)), this.getSimpleTileEntity((IBlockAccess)world, blockPos.func_177982_a(0, 0, 1)), this.getSimpleTileEntity((IBlockAccess)world, blockPos.func_177982_a(-1, 0, 0)), this.getSimpleTileEntity((IBlockAccess)world, blockPos.func_177982_a(1, 0, 0))};
    }

    protected CbTileEntity getSimpleTileEntity(IBlockAccess blockAccess, BlockPos blockPos) {
        TileEntity tileEntity = blockAccess.func_175625_s(blockPos);
        return tileEntity instanceof CbTileEntity ? (CbTileEntity)tileEntity : null;
    }

    protected CbTileEntity getTileEntity(IBlockAccess blockAccess, BlockPos blockPos) {
        CbTileEntity cbTileEntity = this.getSimpleTileEntity(blockAccess, blockPos);
        return cbTileEntity != null && blockAccess.func_180495_p(blockPos).func_177230_c().equals((Object)this) ? cbTileEntity : null;
    }

    protected boolean canPlayerActivate(CbTileEntity cbTileEntity, EntityPlayer entityPlayer) {
        return true;
    }

    public void func_180649_a(World world, BlockPos blockPos, EntityPlayer entityPlayer) {
        if (world.field_72995_K) {
            return;
        }
        CbTileEntity cbTileEntity = this.getTileEntity((IBlockAccess)world, blockPos);
        if (cbTileEntity == null || !PlayerPermissions.hasElevatedPermission(cbTileEntity, entityPlayer, false)) {
            return;
        }
        ItemStack itemStack = entityPlayer.func_184586_b(EventHandler.eventHand);
        if (itemStack.func_190926_b()) {
            return;
        }
        ActionResult actionResult = new ActionResult();
        EnumAttributeLocation location = BlockUtil.getAttributeLocationForFacing(cbTileEntity, EventHandler.eventFace);
        Item item = itemStack.func_77973_b();
        if (item instanceof ICarpentersHammer && ((ICarpentersHammer)item).canUseHammer(world, entityPlayer, EnumHand.MAIN_HAND)) {
            this.preOnBlockClicked(cbTileEntity, entityPlayer, actionResult);
            if (!actionResult.altered) {
                if (entityPlayer.func_70093_af()) {
                    this.dropLastAddedAttribute(cbTileEntity, location);
                    actionResult.setAltered();
                } else if (this.onHammerLeftClick(cbTileEntity, entityPlayer)) {
                    actionResult.setAltered();
                }
                actionResult.setAltered();
            }
        } else if (item instanceof ICarpentersChisel && ((ICarpentersChisel)item).canUseChisel(world, entityPlayer, EnumHand.MAIN_HAND)) {
            if (entityPlayer.func_70093_af() && cbTileEntity.getAttributeHelper().hasAttribute(location, EnumAttributeType.DESIGN_CHISEL)) {
                cbTileEntity.removeAttribute(location, EnumAttributeType.DESIGN_CHISEL);
            } else if (cbTileEntity.getAttributeHelper().hasAttribute(location, EnumAttributeType.COVER)) {
                this.onChiselClick(cbTileEntity, location, EventHandler.eventHand, true);
            }
        }
        if (actionResult.altered) {
            cbTileEntity.func_70296_d();
            IBlockState blockState = world.func_180495_p(blockPos);
            world.func_184138_a(blockPos, blockState, blockState, 3);
        }
    }

    private void dropLastAddedAttribute(CbTileEntity cbTileEntity, EnumAttributeLocation location) {
        cbTileEntity.removeLastAddedDroppableAttribute(location);
    }

    public boolean func_180639_a(World world, BlockPos blockPos, IBlockState blockState, EntityPlayer entityPlayer, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        CbTileEntity cbTileEntity = this.getTileEntity((IBlockAccess)world, blockPos);
        if (cbTileEntity == null) {
            return false;
        }
        if (!this.canPlayerActivate(cbTileEntity, entityPlayer)) {
            return false;
        }
        EnumAttributeLocation location = BlockUtil.getAttributeLocationForFacing(cbTileEntity, facing);
        cbTileEntity = this.getTileEntityForBlockActivation(cbTileEntity);
        ActionResult actionResult = new ActionResult();
        this.preOnBlockActivated(cbTileEntity, entityPlayer, facing, hitX, hitY, hitZ, actionResult);
        if (!actionResult.altered && PlayerPermissions.hasElevatedPermission(cbTileEntity, entityPlayer, false) && !entityPlayer.func_184586_b(hand).func_190926_b()) {
            ItemStack itemStack = entityPlayer.func_184586_b(hand);
            if (itemStack.func_77973_b() instanceof ICarpentersHammer && ((ICarpentersHammer)itemStack.func_77973_b()).canUseHammer(world, entityPlayer, hand)) {
                if (this.onHammerRightClick(cbTileEntity, entityPlayer)) {
                    actionResult.setAltered();
                }
            } else if (ConfigRegistry.enableChisel && itemStack.func_77973_b() instanceof ICarpentersChisel && ((ICarpentersChisel)itemStack.func_77973_b()).canUseChisel(world, entityPlayer, hand)) {
                if (cbTileEntity.getAttributeHelper().hasAttribute(location, EnumAttributeType.COVER) && this.onChiselClick(cbTileEntity, location, hand, false)) {
                    actionResult.setAltered();
                }
            } else if (ConfigRegistry.enableCovers && BlockUtil.isCover(itemStack)) {
                Block block = BlockUtil.toBlock(itemStack);
                ItemStack tempStack = itemStack.func_77946_l();
                if (EnumAttributeLocation.HOST.equals((Object)location) && (!this.canSupportCover(cbTileEntity, location) || cbTileEntity.getAttributeHelper().hasAttribute(EnumAttributeLocation.HOST, EnumAttributeType.COVER))) {
                    location = EnumAttributeLocation.valueOf(facing.ordinal());
                }
                if (this.canSupportCover(cbTileEntity, location) && !cbTileEntity.getAttributeHelper().hasAttribute(location, EnumAttributeType.COVER)) {
                    cbTileEntity.addAttribute(location, EnumAttributeType.COVER, tempStack);
                    actionResult.setAltered().decInventory().setSoundSource(itemStack);
                }
            } else if (entityPlayer.func_70093_af()) {
                if (ConfigRegistry.enableIllumination && BlockUtil.isIlluminator(itemStack)) {
                    if (!cbTileEntity.getAttributeHelper().hasAttribute(location, EnumAttributeType.ILLUMINATOR)) {
                        cbTileEntity.addAttribute(location, EnumAttributeType.ILLUMINATOR, itemStack);
                        actionResult.setAltered().decInventory().setSoundSource(itemStack);
                    }
                } else if (ConfigRegistry.enableOverlays && BlockUtil.isOverlay(itemStack)) {
                    if (!cbTileEntity.getAttributeHelper().hasAttribute(location, EnumAttributeType.OVERLAY)) {
                        cbTileEntity.addAttribute(location, EnumAttributeType.OVERLAY, itemStack);
                        actionResult.setAltered().decInventory().setSoundSource(itemStack);
                    }
                } else if (ConfigRegistry.enableDyeColors && BlockUtil.isDye(itemStack, false) && !cbTileEntity.getAttributeHelper().hasAttribute(location, EnumAttributeType.DYE)) {
                    cbTileEntity.addAttribute(location, EnumAttributeType.DYE, itemStack);
                    actionResult.setAltered().decInventory().setSoundSource(itemStack);
                }
            }
        }
        if (!actionResult.altered) {
            this.postOnBlockActivated(cbTileEntity, entityPlayer, facing, hitX, hitY, hitZ, actionResult);
        } else {
            if (actionResult.itemStack == null) {
                // empty if block
            }
            this.damageItemWithChance(world, entityPlayer, hand);
        }
        if (actionResult.altered) {
            cbTileEntity.update(true);
        }
        if (actionResult.decInv) {
            EntityLivingUtil.decrementCurrentSlot(entityPlayer);
        }
        return actionResult.altered;
    }

    public boolean onChiselClick(CbTileEntity cbTileEntity, EnumAttributeLocation location, EnumHand hand, boolean leftClick) {
        String design = "";
        if (cbTileEntity.getAttributeHelper().hasAttribute(location, EnumAttributeType.DESIGN_CHISEL)) {
            design = (String)cbTileEntity.getAttributeHelper().getAttribute(location, EnumAttributeType.DESIGN_CHISEL).getModel();
        }
        String designAdj = "";
        if (StringUtils.func_151246_b((String)design)) {
            CbTileEntity[] cbTileEntity_list;
            World world = cbTileEntity.func_145831_w();
            for (CbTileEntity cbTileEntity_current : cbTileEntity_list = this.getAdjacentTileEntities(world, cbTileEntity.func_174877_v())) {
                if (cbTileEntity_current == null || !cbTileEntity_current.getAttributeHelper().hasAttribute(location, EnumAttributeType.DESIGN_CHISEL)) continue;
                designAdj = design = (String)cbTileEntity_current.getAttributeHelper().getAttribute(location, EnumAttributeType.DESIGN_CHISEL).getModel();
                break;
            }
        }
        if (StringUtils.func_151246_b((String)designAdj) && EnumHand.MAIN_HAND.equals((Object)hand)) {
            String string = design = leftClick ? DesignHandler.getNext(DesignHandler.DesignType.CHISEL, design) : DesignHandler.getPrev(DesignHandler.DesignType.CHISEL, design);
        }
        if (!StringUtils.func_151246_b((String)design)) {
            cbTileEntity.removeAttribute(location, EnumAttributeType.DESIGN_CHISEL);
            cbTileEntity.addAttribute(location, EnumAttributeType.DESIGN_CHISEL, design);
        }
        return true;
    }

    public void onNeighborChange(IBlockAccess blockAccess, BlockPos blockPos, BlockPos neighborBlockPos) {
        CbTileEntity cbTileEntity = this.getTileEntity(blockAccess, blockPos);
        if (cbTileEntity != null) {
            for (EnumFacing facing : EnumFacing.values()) {
                EnumAttributeLocation location = EnumAttributeLocation.valueOf(facing.ordinal());
                if (!cbTileEntity.getAttributeHelper().hasAttribute(location, EnumAttributeType.COVER)) continue;
                if (!this.canSupportCover(cbTileEntity, location)) {
                    cbTileEntity.removeAttributes(location);
                    continue;
                }
                if (!blockAccess.isSideSolid(blockPos.func_177972_a(facing), facing.func_176734_d(), false) || !this.isSideSolid(this.func_176223_P(), blockAccess, blockPos.func_177972_a(facing), facing.func_176734_d())) continue;
                cbTileEntity.removeAttributes(location);
            }
        }
    }

    public int func_180656_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos blockPos, EnumFacing facing) {
        CbTileEntity cbTileEntity = this.getTileEntity(blockAccess, blockPos);
        int power = 0;
        HashSet sides = new HashSet();
        for (EnumAttributeLocation location : EnumAttributeLocation.values()) {
            IBlockState tempBlockState = BlockUtil.getAttributeBlockState(cbTileEntity.getAttributeHelper(), location, EnumAttributeType.COVER);
            if (tempBlockState == null) continue;
            if (!EnumAttributeLocation.HOST.equals((Object)location)) {
                for (EnumFacing tempFacing : EnumFacing.values()) {
                    int tempPower = tempBlockState.func_177230_c().func_180656_a(tempBlockState, blockAccess, blockPos, tempFacing);
                    power = Math.max(power, tempPower);
                }
                continue;
            }
            int tempPower = tempBlockState.func_177230_c().func_180656_a(tempBlockState, blockAccess, blockPos, facing);
            power = Math.max(power, tempPower);
        }
        return power;
    }

    public int func_176211_b(IBlockState blockState, IBlockAccess blockAccess, BlockPos blockPos, EnumFacing facing) {
        IBlockState hostBlockState;
        CbTileEntity cbTileEntity = this.getTileEntity(blockAccess, blockPos);
        int power = 0;
        HashSet<IBlockState> blockStates = new HashSet<IBlockState>();
        IBlockState sideBlockState = BlockUtil.getAttributeBlockState(cbTileEntity.getAttributeHelper(), EnumAttributeLocation.valueOf(facing.func_176734_d().ordinal()), EnumAttributeType.COVER);
        if (sideBlockState != null) {
            blockStates.add(sideBlockState);
        }
        if ((hostBlockState = BlockUtil.getAttributeBlockState(cbTileEntity.getAttributeHelper(), EnumAttributeLocation.HOST, EnumAttributeType.COVER)) != null) {
            blockStates.add(hostBlockState);
        }
        for (IBlockState setBlockState : blockStates) {
            int tempPower = hostBlockState.func_177230_c().func_176211_b(setBlockState, blockAccess, blockPos, facing);
            power = Math.max(power, tempPower);
        }
        return power;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addDestroyEffects(World world, BlockPos blockPos, ParticleManager particleManager) {
        EntityPlayer entityPlayer;
        CbTileEntity cbTileEntity = this.getTileEntity((IBlockAccess)world, blockPos);
        return cbTileEntity != null && (entityPlayer = world.func_184137_a((double)blockPos.func_177958_n(), (double)blockPos.func_177956_o(), (double)blockPos.func_177952_p(), 6.5, false)) != null && this.suppressDestroyBlock(entityPlayer);
        {
        }
    }

    public int getLightValue(IBlockState blockState, IBlockAccess blockAccess, BlockPos blockPos) {
        CbTileEntity cbTileEntity = this.getSimpleTileEntity(blockAccess, blockPos);
        if (cbTileEntity != null) {
            return cbTileEntity.getLightValue();
        }
        return 0;
    }

    public void func_180657_a(World world, EntityPlayer entityPlayer, BlockPos blockPos, IBlockState blockState, TileEntity tileEntity, ItemStack itemStack) {
    }

    protected boolean suppressDestroyBlock(EntityPlayer entityPlayer) {
        if (entityPlayer == null) {
            return false;
        }
        ItemStack itemStack = entityPlayer.func_184614_ca();
        if (!itemStack.func_190926_b()) {
            Item item = itemStack.func_77973_b();
            return entityPlayer.field_71075_bZ.field_75098_d && item != null && (item instanceof ICarpentersHammer || item instanceof ICarpentersChisel);
        }
        return false;
    }

    protected void destroyBlock(World world, BlockPos blockPos, boolean dropBlock) {
        List<ItemStack> items = this.getDrops((IBlockAccess)world, blockPos, this.func_176223_P(), 1);
        for (ItemStack itemStack : items) {
        }
        world.func_175698_g(blockPos);
    }

    public boolean removedByPlayer(IBlockState blockState, World world, BlockPos blockPos, EntityPlayer entityPlayer, boolean willHarvest) {
        if (world.field_72995_K) {
            return super.removedByPlayer(blockState, world, blockPos, entityPlayer, willHarvest);
        }
        List<ItemStack> itemStacks = this.getDrops((IBlockAccess)world, blockPos, blockState, 1);
        if (!this.suppressDestroyBlock(entityPlayer) && super.removedByPlayer(blockState, world, blockPos, entityPlayer, willHarvest)) {
            for (ItemStack itemStack : itemStacks) {
                BlockCoverable.func_180635_a((World)world, (BlockPos)blockPos, (ItemStack)itemStack);
            }
            return true;
        }
        return false;
    }

    public List<ItemStack> getDrops(IBlockAccess blockAccess, BlockPos blockPos, IBlockState blockState, int fortune) {
        List list = super.getDrops(blockAccess, blockPos, blockState, fortune);
        CbTileEntity cbTileEntity = this.getSimpleTileEntity(blockAccess, blockPos);
        if (cbTileEntity != null) {
            list.addAll(cbTileEntity.getAllDroppableAttributes());
        }
        return list;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState blockState, World world, BlockPos blockPos, Random rand) {
        CbTileEntity cbTileEntity = this.getTileEntity((IBlockAccess)world, blockPos);
        if (cbTileEntity != null) {
            // empty if block
        }
    }

    public boolean canSustainPlant(IBlockState blockState, IBlockAccess blockAccess, BlockPos blockPos, EnumFacing facing, IPlantable plantable) {
        CbTileEntity cbTileEntity = this.getTileEntity(blockAccess, blockPos);
        if (cbTileEntity != null) {
            if (!this.isSideSolid(blockState, blockAccess, blockPos, facing)) {
                return false;
            }
            HashSet<Object> blocks = new HashSet<Object>();
            EnumAttributeLocation location = BlockUtil.getAttributeLocationForFacing(cbTileEntity, facing);
            if (cbTileEntity.getAttributeHelper().hasAttribute(location, EnumAttributeType.COVER)) {
                IBlockState sideBlockState = BlockUtil.getAttributeBlockState(cbTileEntity.getAttributeHelper(), location, EnumAttributeType.COVER);
                blocks.add(sideBlockState.func_177230_c());
                Material material = sideBlockState.func_177230_c().func_149688_o(sideBlockState);
                if (material.equals(Material.field_151577_b)) {
                    blocks.add(Blocks.field_150349_c);
                } else if (material.equals(Material.field_151578_c)) {
                    blocks.add(Blocks.field_150346_d);
                } else if (material.equals(Material.field_151595_p)) {
                    blocks.add(Blocks.field_150354_m);
                }
            }
            if (cbTileEntity.getAttributeHelper().hasAttribute(location, EnumAttributeType.OVERLAY)) {
                blocks.add(BlockUtil.toBlock(OverlayHandler.getOverlayType((ItemStack)cbTileEntity.getAttributeHelper().getAttribute(location, EnumAttributeType.OVERLAY).getModel()).getItemStack()));
            }
            switch (plantable.getPlantType(blockAccess, blockPos.func_177982_a(0, 1, 0))) {
                case Desert: {
                    return blocks.contains(Blocks.field_150354_m);
                }
                case Nether: {
                    return blocks.contains(Blocks.field_150425_aM);
                }
                case Plains: {
                    return blocks.contains(Blocks.field_150349_c) || blocks.contains(Blocks.field_150346_d);
                }
                case Beach: {
                    boolean isBeach = blocks.contains(Blocks.field_150349_c) || blocks.contains(Blocks.field_150346_d) || blocks.contains(Blocks.field_150354_m);
                    boolean hasWater = blockAccess.func_180495_p(blockPos.func_177982_a(-1, 0, 0)).func_185904_a() == Material.field_151586_h || blockAccess.func_180495_p(blockPos.func_177982_a(1, 0, 0)).func_185904_a() == Material.field_151586_h || blockAccess.func_180495_p(blockPos.func_177982_a(0, 0, -1)).func_185904_a() == Material.field_151586_h || blockAccess.func_180495_p(blockPos.func_177982_a(0, 0, 1)).func_185904_a() == Material.field_151586_h;
                    return isBeach && hasWater;
                }
            }
        }
        return super.canSustainPlant(blockState, blockAccess, blockPos, facing, plantable);
    }

    protected boolean isBlockSolid(IBlockAccess blockAccess, BlockPos blockPos) {
        CbTileEntity cbTileEntity = this.getTileEntity(blockAccess, blockPos);
        if (cbTileEntity != null) {
            return !cbTileEntity.getAttributeHelper().hasAttribute(EnumAttributeLocation.HOST, EnumAttributeType.COVER) || BlockUtil.getAttributeBlockState(cbTileEntity.getAttributeHelper(), EnumAttributeLocation.HOST, EnumAttributeType.COVER).func_185914_p();
        }
        return false;
    }

    public void func_180633_a(World world, BlockPos blockPos, IBlockState blockState, EntityLivingBase entityLivingBase, ItemStack itemStack) {
        CbTileEntity cbTileEntity;
        if (!world.field_72995_K && (cbTileEntity = this.getTileEntity((IBlockAccess)world, blockPos)) != null) {
            cbTileEntity.setOwner(new ProtectedObject((EntityPlayer)entityLivingBase));
        }
    }

    @Deprecated
    public float func_180647_a(IBlockState blockState, EntityPlayer entityPlayer, World world, BlockPos blockPos) {
        Item item;
        ItemStack itemStack = entityPlayer.func_184586_b(EventHandler.eventHand);
        if (!itemStack.func_190926_b() && ((item = itemStack.func_77973_b()) instanceof ICarpentersHammer || item instanceof ICarpentersChisel)) {
            return -1.0f;
        }
        CbTileEntity cbTileEntity = this.getTileEntity((IBlockAccess)world, blockPos);
        if (cbTileEntity != null) {
            IBlockState outBlockState = BlockUtil.getAttributeBlockState(cbTileEntity.getAttributeHelper(), EnumAttributeLocation.HOST, EnumAttributeType.COVER);
            if (outBlockState == null) {
                outBlockState = blockState;
            }
            return ForgeHooks.blockStrength((IBlockState)outBlockState, (EntityPlayer)entityPlayer, (World)world, (BlockPos)blockPos);
        }
        return super.func_180647_a(blockState, entityPlayer, world, blockPos);
    }

    public boolean canRenderInLayer(IBlockState blockState, BlockRenderLayer blockRenderLayer) {
        return true;
    }

    protected boolean shareFaces(CbTileEntity cbTileEntity_adj, CbTileEntity cbTileEntity_src, EnumFacing facing_adj, EnumFacing facing_src) {
        return cbTileEntity_adj.func_145838_q().isSideSolid(this.func_176223_P(), (IBlockAccess)cbTileEntity_adj.func_145831_w(), cbTileEntity_adj.func_174877_v(), facing_adj) && cbTileEntity_src.func_145838_q().isSideSolid(this.func_176223_P(), (IBlockAccess)cbTileEntity_src.func_145831_w(), cbTileEntity_src.func_174877_v(), facing_src);
    }

    public void func_176206_d(World worldIn, BlockPos pos, IBlockState state) {
        super.func_176206_d(worldIn, pos, state);
    }

    public boolean func_149710_n(IBlockState blockState) {
        return true;
    }

    public TileEntity createTileEntity(World world, IBlockState blockState) {
        return new CbTileEntity();
    }

    public boolean hasTileEntity(IBlockState blockState) {
        return true;
    }

    protected void damageItemWithChance(World world, EntityPlayer entityPlayer, EnumHand hand) {
        Item item = entityPlayer.func_184586_b(hand).func_77973_b();
        if (item instanceof ICarpentersHammer) {
            ((ICarpentersHammer)item).onHammerUse(world, entityPlayer, hand);
        } else if (item instanceof ICarpentersChisel) {
            ((ICarpentersChisel)item).onChiselUse(world, entityPlayer, hand);
        }
    }

    protected void preOnBlockClicked(CbTileEntity cbTileEntity, EntityPlayer entityPlayer, ActionResult actionResult) {
    }

    protected void preOnBlockActivated(CbTileEntity cbTileEntity, EntityPlayer entityPlayer, EnumFacing facing, float hitX, float hitY, float hitZ, ActionResult actionResult) {
    }

    protected void postOnBlockActivated(CbTileEntity cbTileEntity, EntityPlayer entityPlayer, EnumFacing facing, float hitX, float hitY, float hitZ, ActionResult actionResult) {
    }

    protected boolean onHammerLeftClick(CbTileEntity cbTileEntity, EntityPlayer entityPlayer) {
        return false;
    }

    protected boolean onHammerRightClick(CbTileEntity cbTileEntity, EntityPlayer entityPlayer) {
        return false;
    }

    protected boolean canSupportCover(CbTileEntity cbTileEntity, EnumAttributeLocation location) {
        return true;
    }

    protected CbTileEntity getTileEntityForBlockActivation(CbTileEntity cbTileEntity) {
        return cbTileEntity;
    }

    protected BlockStateContainer func_180661_e() {
        return new ExtendedBlockState((Block)this, Property._listedProperties, Property._unlistedProperties.toArray(new IUnlistedProperty[Property._unlistedProperties.size()]));
    }

    public IBlockState getExtendedState(IBlockState blockState, IBlockAccess blockAccess, BlockPos blockPos) {
        if (blockState instanceof IExtendedBlockState) {
            CbTileEntity cbTileEntity = this.getTileEntity(blockAccess, blockPos);
            return ((IExtendedBlockState)blockState).withProperty(Property.BLOCK_TYP, (Object)this).withProperty(Property.BLOCK_POS, (Object)blockPos).withProperty(Property.CB_METADATA, (Object)cbTileEntity.getCbMetadata()).withProperty(Property.RENDER_FACE, (Object)new Boolean[]{this.func_176225_a(blockState, blockAccess, blockPos, EnumFacing.DOWN), this.func_176225_a(blockState, blockAccess, blockPos, EnumFacing.UP), this.func_176225_a(blockState, blockAccess, blockPos, EnumFacing.NORTH), this.func_176225_a(blockState, blockAccess, blockPos, EnumFacing.SOUTH), this.func_176225_a(blockState, blockAccess, blockPos, EnumFacing.WEST), this.func_176225_a(blockState, blockAccess, blockPos, EnumFacing.EAST)}).withProperty(Property.ATTR_MAP, cbTileEntity.getAttributeHelper().copyMap());
        }
        return blockState;
    }

    public EnumBlockRenderType func_149645_b(IBlockState blockState) {
        return EnumBlockRenderType.MODEL;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    protected class ActionResult {
        public ItemStack itemStack;
        public boolean playSound = true;
        public boolean altered = false;
        public boolean decInv = false;

        protected ActionResult() {
        }

        public ActionResult setSoundSource(ItemStack itemStack) {
            this.itemStack = itemStack;
            return this;
        }

        public ActionResult setNoSound() {
            this.playSound = false;
            return this;
        }

        public ActionResult setAltered() {
            this.altered = true;
            return this;
        }

        public ActionResult decInventory() {
            this.decInv = true;
            return this;
        }
    }
}

