/*
 * Decompiled with CFR 0.152.
 */
package com.carpentersblocks.block;

import com.carpentersblocks.block.BlockCoverable;
import com.carpentersblocks.block.data.SlopeData;
import com.carpentersblocks.tileentity.CbTileEntity;
import com.carpentersblocks.util.handler.EventHandler;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockCarpentersSlope
extends BlockCoverable {
    public static final String[] slopeType = new String[]{"wedge", "obliqueInterior", "obliqueExterior", "prism", "prismWedge"};
    public static final int META_WEDGE = 0;
    public static final int META_OBLIQUE_INT = 1;
    public static final int META_OBLIQUE_EXT = 2;
    public static final int META_PRISM = 3;
    public static final int META_PRISM_SLOPE = 4;
    private boolean rayTracing;
    private final int CORNER_SE = 0;
    private final int CORNER_NE = 1;
    private final int CORNER_NW = 2;
    private final int CORNER_SW = 3;

    public BlockCarpentersSlope(Material material) {
        super(material);
    }

    @Override
    protected boolean onHammerLeftClick(CbTileEntity cbTileEntity, EntityPlayer entityPlayer) {
        return this.rotateBlock(cbTileEntity.func_145831_w(), cbTileEntity.func_174877_v(), EventHandler.eventFace);
    }

    @Override
    protected boolean onHammerRightClick(CbTileEntity cbTileEntity, EntityPlayer entityPlayer) {
        new SlopeData();
        SlopeData.setNextType(cbTileEntity);
        return true;
    }

    @Override
    protected boolean shareFaces(CbTileEntity cbTileEntity_adj, CbTileEntity cbTileEntity_src, EnumFacing side_adj, EnumFacing side_src) {
        return false;
    }

    private int getCorner(float rotationYaw) {
        switch ((MathHelper.func_76141_d((float)(rotationYaw * 4.0f / 360.0f)) & 3) % 4) {
            case 0: {
                return 1;
            }
            case 1: {
                return 0;
            }
            case 2: {
                return 3;
            }
        }
        return 2;
    }

    public EnumFacing[] getValidRotations(World world, BlockPos blockPos) {
        return new EnumFacing[]{EnumFacing.UP, EnumFacing.DOWN};
    }

    public boolean rotateBlock(World world, BlockPos blockPos, EnumFacing facing) {
        CbTileEntity cbTileEntity = this.getTileEntity((IBlockAccess)world, blockPos);
        if (cbTileEntity != null) {
            new SlopeData();
            SlopeData.rotate(cbTileEntity, facing.func_176740_k());
            return true;
        }
        return false;
    }

    public boolean func_149662_c(IBlockState blockState) {
        return false;
    }

    public boolean func_149686_d(IBlockState blockState) {
        return false;
    }

    public boolean doesSideBlockRendering(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing face) {
        return false;
    }
}

