/*
 * Decompiled with CFR 0.152.
 */
package com.carpentersblocks.block;

import com.carpentersblocks.block.BlockFacing;
import com.carpentersblocks.block.IStateImplementor;
import com.carpentersblocks.block.state.Property;
import com.carpentersblocks.tileentity.CbTileEntity;
import com.carpentersblocks.util.block.PressurePlateUtil;
import com.carpentersblocks.util.handler.ChatHandler;
import com.carpentersblocks.util.states.StateMap;
import com.carpentersblocks.util.states.factory.StateFactory;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.IExtendedBlockState;

public class BlockCarpentersPressurePlate
extends BlockFacing
implements IStateImplementor {
    private static final String PROP_FULL_BOUNDS = "FULL_BOUNDS";
    private static StateMap _stateMap;

    public BlockCarpentersPressurePlate(Material material, StateMap stateMap) {
        super(material);
        _stateMap = stateMap;
    }

    @Override
    protected boolean onHammerLeftClick(CbTileEntity cbTileEntity, EntityPlayer entityPlayer) {
        PressurePlateUtil util = new PressurePlateUtil(cbTileEntity);
        util.togglePolarity(cbTileEntity);
        this.notifyBlocksOfPowerChange(cbTileEntity.func_145831_w(), this.func_176223_P(), cbTileEntity.func_174877_v());
        if (util.isPositivePolarity(cbTileEntity)) {
            ChatHandler.sendMessageToPlayer("message.polarity_neg.name", entityPlayer);
        } else {
            ChatHandler.sendMessageToPlayer("message.polarity_pos.name", entityPlayer);
        }
        return true;
    }

    @Override
    protected boolean onHammerRightClick(CbTileEntity cbTileEntity, EntityPlayer entityPlayer) {
        PressurePlateUtil util = new PressurePlateUtil(cbTileEntity);
        util.setNextTriggerType(cbTileEntity);
        this.notifyBlocksOfPowerChange(cbTileEntity.func_145831_w(), this.func_176223_P(), cbTileEntity.func_174877_v());
        switch (util.getTriggerEntity(cbTileEntity)) {
            case 3: {
                ChatHandler.sendMessageToPlayer("message.trigger_all.name", entityPlayer);
                break;
            }
            case 2: {
                ChatHandler.sendMessageToPlayer("message.trigger_animal.name", entityPlayer);
                break;
            }
            case 1: {
                ChatHandler.sendMessageToPlayer("message.trigger_monster.name", entityPlayer);
                break;
            }
            case 0: {
                ChatHandler.sendMessageToPlayer("message.trigger_player.name", entityPlayer);
            }
        }
        return true;
    }

    public AxisAlignedBB func_185496_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos blockPos) {
        CbTileEntity cbTileEntity = this.getTileEntity(blockAccess, blockPos);
        if (cbTileEntity != null) {
            if (Boolean.TRUE.equals(cbTileEntity.getProperty(PROP_FULL_BOUNDS))) {
                return field_185505_j;
            }
            return StateFactory.getState(cbTileEntity).getAxisAlignedBB();
        }
        return super.func_185496_a(blockState, blockAccess, blockPos);
    }

    @Deprecated
    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos blockPos) {
        return field_185506_k;
    }

    @Override
    public void func_180650_b(World world, BlockPos blockPos, IBlockState blockState, Random random) {
        CbTileEntity cbTileEntity;
        if (!world.field_72995_K && (cbTileEntity = this.getTileEntity((IBlockAccess)world, blockPos)) != null) {
            PressurePlateUtil util = new PressurePlateUtil(cbTileEntity);
            boolean depressed = false;
            if (util.isDepressed(cbTileEntity)) {
                depressed = this.hasTriggerInBounds(cbTileEntity);
            }
            if (depressed) {
                world.func_180497_b(blockPos, (Block)this, this.func_149738_a(world), 0);
            } else if (util.isDepressed(cbTileEntity)) {
                util.setState(cbTileEntity, 0, true);
                this.notifyBlocksOfPowerChange(cbTileEntity.func_145831_w(), this.func_176223_P(), cbTileEntity.func_174877_v());
            }
        }
        super.func_180650_b(world, blockPos, blockState, random);
    }

    public void func_180634_a(World world, BlockPos blockPos, IBlockState blockState, Entity entity) {
        CbTileEntity cbTileEntity;
        if (!world.field_72995_K && (cbTileEntity = this.getTileEntity((IBlockAccess)world, blockPos)) != null && this.canEntityTrigger(cbTileEntity, entity)) {
            PressurePlateUtil util = new PressurePlateUtil(cbTileEntity);
            if (!util.isDepressed(cbTileEntity)) {
                util.setState(cbTileEntity, 1, true);
                this.notifyBlocksOfPowerChange(cbTileEntity.func_145831_w(), this.func_176223_P(), cbTileEntity.func_174877_v());
            }
            cbTileEntity.func_145831_w().func_180497_b(cbTileEntity.func_174877_v(), (Block)this, 0, 0);
        }
    }

    private boolean hasTriggerInBounds(CbTileEntity cbTileEntity) {
        cbTileEntity.setProperty(PROP_FULL_BOUNDS, Boolean.TRUE);
        AxisAlignedBB globalAABB = this.getGlobalBoundingBox(this.func_176223_P(), (IBlockAccess)cbTileEntity.func_145831_w(), cbTileEntity.func_174877_v());
        List entityList = cbTileEntity.func_145831_w().func_72872_a(Entity.class, globalAABB);
        cbTileEntity.removeProperty(PROP_FULL_BOUNDS);
        if (!entityList.isEmpty()) {
            for (Entity entity : entityList) {
                if (!this.canEntityTrigger(cbTileEntity, entity)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean func_149744_f(IBlockState blockState) {
        return true;
    }

    @Override
    public int getPowerOutput(CbTileEntity cbTileEntity) {
        PressurePlateUtil util = new PressurePlateUtil(cbTileEntity);
        return util.isEmitting(cbTileEntity) ? 15 : 0;
    }

    private boolean canEntityTrigger(CbTileEntity cbTileEntity, Entity entity) {
        if (entity == null) {
            return false;
        }
        PressurePlateUtil util = new PressurePlateUtil(cbTileEntity);
        switch (util.getTriggerEntity(cbTileEntity)) {
            case 2: {
                return entity.isCreatureType(EnumCreatureType.CREATURE, false);
            }
            case 1: {
                return entity.isCreatureType(EnumCreatureType.MONSTER, false);
            }
            case 0: {
                return entity instanceof EntityPlayer;
            }
        }
        return true;
    }

    @Override
    public void setFacing(CbTileEntity cbTileEntity, EnumFacing facing) {
        PressurePlateUtil util = new PressurePlateUtil(cbTileEntity);
        util.setFacing(cbTileEntity, facing);
    }

    @Override
    public EnumFacing getFacing(CbTileEntity cbTileEntity) {
        PressurePlateUtil util = new PressurePlateUtil(cbTileEntity);
        return util.getFacing();
    }

    public boolean func_149662_c(IBlockState blockState) {
        return false;
    }

    public boolean func_149686_d(IBlockState blockState) {
        return false;
    }

    public boolean func_176205_b(IBlockAccess blockAccess, BlockPos blockPos) {
        return true;
    }

    public boolean func_181623_g() {
        return true;
    }

    @Override
    public IBlockState getExtendedState(IBlockState blockState, IBlockAccess blockAccess, BlockPos blockPos) {
        if (blockState instanceof IExtendedBlockState) {
            CbTileEntity cbTileEntity = this.getTileEntity(blockAccess, blockPos);
            return ((IExtendedBlockState)super.getExtendedState(blockState, blockAccess, blockPos)).withProperty(Property.CB_STATE, (Object)StateFactory.getState(cbTileEntity));
        }
        return blockState;
    }

    @Override
    public StateMap getStateMap() {
        return _stateMap;
    }

    @Override
    public String getStateDescriptor(CbTileEntity cbTileEntity) {
        PressurePlateUtil util = new PressurePlateUtil(cbTileEntity);
        if (util.isDepressed(cbTileEntity)) {
            return "depressed";
        }
        return "default";
    }
}

