/*
 * Decompiled with CFR 0.152.
 */
package com.carpentersblocks;

import com.carpentersblocks.util.ModLogger;
import com.carpentersblocks.util.handler.DesignHandler;
import com.google.common.base.Charsets;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.ResourcePackFileNotFoundException;
import net.minecraft.client.resources.SimpleReloadableResourceManager;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.client.FMLFileResourcePack;
import net.minecraftforge.fml.common.DummyModContainer;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.ModMetadata;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.io.FilenameUtils;
import org.apache.logging.log4j.Level;

@SideOnly(value=Side.CLIENT)
public class CarpentersBlocksCachedResources
extends DummyModContainer {
    public static final CarpentersBlocksCachedResources INSTANCE = new CarpentersBlocksCachedResources();
    private String MODID = "CarpentersBlocksCachedResources";
    private String resourceDir;
    private static ZipFile resourcePackZipFile;
    private static ArrayList<Object[]> resources;
    private final int RESOURCE_PATH = 0;
    private final int RESOURCE_IMAGE = 1;

    private CarpentersBlocksCachedResources() {
        super(new ModMetadata());
        this.resourceDir = FilenameUtils.normalizeNoEndSeparator((String)Minecraft.func_71410_x().field_71412_D.getAbsolutePath()) + File.separator + "mods" + File.separator + "carpentersblocks".toLowerCase();
        this.RESOURCE_PATH = 0;
        this.RESOURCE_IMAGE = 1;
        ModMetadata meta = this.getMetadata();
        meta.modId = this.MODID;
        meta.name = "Carpenter's Blocks Cached Resources";
        meta.description = "Holds dynamically-created resources used with Carpenter's Blocks.";
    }

    public void init() {
        FMLClientHandler.instance().addModAsResource((ModContainer)this);
        ((SimpleReloadableResourceManager)Minecraft.func_71410_x().func_110442_L()).func_110545_a(FMLClientHandler.instance().getResourcePackFor(this.MODID));
    }

    public File getSource() {
        return new File(this.resourceDir, this.MODID + ".zip");
    }

    public Class<?> getCustomResourcePackClass() {
        return DynamicFileResourcePack.class;
    }

    public void addResource(String path, BufferedImage bufferedImage) {
        resources.add(new Object[]{path, bufferedImage});
    }

    private void createResourceZipFile() {
        try {
            if (this.createDirectory()) {
                this.createZip(this.resourceDir, this.MODID + ".zip");
                resourcePackZipFile = new ZipFile(this.getSource());
            }
        }
        catch (Exception e) {
            ModLogger.log(Level.WARN, "Cache rebuild failed: " + e.getMessage(), new Object[0]);
        }
    }

    private boolean createDirectory() {
        File dir = new File(this.resourceDir);
        if (!dir.exists()) {
            dir.mkdir();
        }
        return dir.exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createZip(String dir, String fileName) {
        File file = null;
        DeflaterOutputStream out = null;
        try {
            file = new File(dir, fileName);
            out = new ZipOutputStream(new FileOutputStream(file));
            for (Object[] object : resources) {
                ((ZipOutputStream)out).putNextEntry(new ZipEntry("assets/" + this.MODID.toLowerCase() + (String)object[0] + ".png"));
                ImageIO.write((RenderedImage)((BufferedImage)object[1]), "png", out);
                ((ZipOutputStream)out).closeEntry();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            if (out != null) {
                try {
                    out.flush();
                    ((ZipOutputStream)out).close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public void rebuildCache() {
        DesignHandler.addResources(Minecraft.func_71410_x().func_110442_L());
        this.createResourceZipFile();
        resources.clear();
    }

    static {
        resources = new ArrayList();
    }

    public static class DynamicFileResourcePack
    extends FMLFileResourcePack {
        public DynamicFileResourcePack(ModContainer container) {
            super(container);
        }

        public ZipFile func_110599_c() {
            if (resourcePackZipFile == null) {
                INSTANCE.rebuildCache();
            }
            return resourcePackZipFile;
        }

        protected InputStream func_110591_a(String resourceName) throws IOException {
            ZipFile zipfile = this.func_110599_c();
            ZipEntry zipentry = zipfile.getEntry(resourceName);
            try {
                if ("pack.mcmeta".equals(resourceName)) {
                    return new ByteArrayInputStream(("{\n \"pack\": {\n   \"description\": \"dummy FML pack for " + this.func_130077_b() + "\",\n   \"pack_format\": 1\n}\n}").getBytes(Charsets.UTF_8));
                }
                return zipfile.getInputStream(zipentry);
            }
            catch (IOException e) {
                throw new ResourcePackFileNotFoundException(this.field_110597_b, resourceName);
            }
        }

        public boolean func_110593_b(String resourceName) {
            return this.func_110599_c().getEntry(resourceName) != null;
        }
    }
}

