/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.common.block;

import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import team.chisel.Chisel;
import team.chisel.common.block.TileAutoChisel;
import team.chisel.common.init.ChiselTabs;

@ParametersAreNonnullByDefault
public class BlockAutoChisel
extends Block {
    private static final ImmutableList<AxisAlignedBB> BOXES = ImmutableList.builder().add((Object)new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.625, 1.0)).add((Object)new AxisAlignedBB(0.0, 0.625, 0.0, 0.0625, 1.0, 1.0)).add((Object)new AxisAlignedBB(0.9375, 0.625, 0.0, 1.0, 1.0, 1.0)).add((Object)new AxisAlignedBB(0.0, 0.625, 0.0, 1.0, 1.0, 0.0625)).add((Object)new AxisAlignedBB(0.0, 0.625, 0.9375, 1.0, 1.0, 1.0)).add((Object)new AxisAlignedBB(0.0, 0.9375, 0.0, 1.0, 1.0, 1.0)).build();

    public BlockAutoChisel() {
        super(Material.field_151573_f);
        this.func_149711_c(2.5f);
        this.setHarvestLevel("pickaxe", 1);
        this.func_149663_c("chisel.autochisel");
        this.func_149647_a(ChiselTabs.tab);
        this.field_149783_u = true;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileAutoChisel();
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!worldIn.field_72995_K) {
            playerIn.openGui((Object)Chisel.instance, 1, worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
        return true;
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileEntity tileentity;
        super.func_180633_a(worldIn, pos, state, placer, stack);
        if (stack.func_82837_s() && (tileentity = worldIn.func_175625_s(pos)) instanceof TileAutoChisel) {
            ((TileAutoChisel)tileentity).setCustomName(stack.func_82833_r());
        }
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity instanceof TileAutoChisel) {
            TileAutoChisel autochisel = (TileAutoChisel)tileentity;
            this.dumpItems(worldIn, pos, autochisel.getInputInv());
            this.dumpItems(worldIn, pos, autochisel.getOtherInv());
            this.dumpItems(worldIn, pos, autochisel.getOutputInv());
            worldIn.func_175666_e(pos, (Block)this);
        }
        super.func_180663_b(worldIn, pos, state);
    }

    private void dumpItems(World worldIn, BlockPos pos, IItemHandler inv) {
        double x = pos.func_177958_n();
        double y = pos.func_177956_o();
        double z = pos.func_177952_p();
        for (int i = 0; i < inv.getSlots(); ++i) {
            ItemStack stack = inv.getStackInSlot(i);
            if (stack.func_190926_b()) continue;
            InventoryHelper.func_180173_a((World)worldIn, (double)x, (double)y, (double)z, (ItemStack)stack);
        }
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean p_185477_7_) {
        BOXES.forEach(bb -> BlockAutoChisel.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, (List)collidingBoxes, (AxisAlignedBB)bb));
    }

    public boolean doesSideBlockRendering(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing face) {
        return face == EnumFacing.DOWN;
    }

    public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
        return layer == BlockRenderLayer.SOLID || layer == BlockRenderLayer.CUTOUT;
    }
}

