/*
 * Decompiled with CFR 0.152.
 */
package com.github.lunatrius.schematica.world.schematic;

import com.github.lunatrius.schematica.api.ISchematic;
import com.github.lunatrius.schematica.api.event.PostSchematicCaptureEvent;
import com.github.lunatrius.schematica.reference.Reference;
import com.github.lunatrius.schematica.world.schematic.SchematicAlpha;
import com.github.lunatrius.schematica.world.schematic.SchematicStructure;
import com.github.lunatrius.schematica.world.schematic.SchematicUtil;
import com.github.lunatrius.schematica.world.schematic.UnsupportedFormatException;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.zip.GZIPOutputStream;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public abstract class SchematicFormat {
    public static final Map<String, SchematicFormat> FORMATS = new LinkedHashMap<String, SchematicFormat>();
    public static String FORMAT_DEFAULT;

    public abstract ISchematic readFromNBT(NBTTagCompound var1);

    public abstract boolean writeToNBT(NBTTagCompound var1, ISchematic var2);

    public abstract String getName();

    public abstract String getExtension();

    public static ISchematic readFromFile(File file) {
        try {
            SchematicFormat schematicFormat;
            NBTTagCompound tagCompound = SchematicUtil.readTagCompoundFromFile(file);
            if (tagCompound.func_74764_b("Materials")) {
                String format = tagCompound.func_74779_i("Materials");
                schematicFormat = FORMATS.get(format);
                if (schematicFormat == null) {
                    throw new UnsupportedFormatException(format);
                }
            } else {
                schematicFormat = FORMATS.get("Structure");
            }
            return schematicFormat.readFromNBT(tagCompound);
        }
        catch (Exception ex) {
            Reference.logger.error("Failed to read schematic!", (Throwable)ex);
            return null;
        }
    }

    public static ISchematic readFromFile(File directory, String filename) {
        return SchematicFormat.readFromFile(new File(directory, filename));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean writeToFile(File file, @Nullable String format, ISchematic schematic) {
        try {
            if (format == null) {
                format = FORMAT_DEFAULT;
            }
            if (!FORMATS.containsKey(format)) {
                throw new UnsupportedFormatException(format);
            }
            PostSchematicCaptureEvent event = new PostSchematicCaptureEvent(schematic);
            MinecraftForge.EVENT_BUS.post((Event)event);
            NBTTagCompound tagCompound = new NBTTagCompound();
            FORMATS.get(format).writeToNBT(tagCompound, schematic);
            try (DataOutputStream dataOutputStream = new DataOutputStream(new GZIPOutputStream(new FileOutputStream(file)));){
                NBTTagCompound.func_150298_a((String)"Schematic", (NBTBase)tagCompound, (DataOutput)dataOutputStream);
            }
            return true;
        }
        catch (Exception ex) {
            Reference.logger.error("Failed to write schematic!", (Throwable)ex);
            return false;
        }
    }

    public static boolean writeToFile(File directory, String filename, @Nullable String format, ISchematic schematic) {
        return SchematicFormat.writeToFile(new File(directory, filename), format, schematic);
    }

    public static void writeToFileAndNotify(File file, @Nullable String format, ISchematic schematic, EntityPlayer player) {
        boolean success = SchematicFormat.writeToFile(file, format, schematic);
        String message = success ? "schematica.command.save.saveSucceeded" : "schematica.command.save.saveFailed";
        player.func_145747_a((ITextComponent)new TextComponentTranslation(message, new Object[]{file.getName()}));
    }

    public static String getFormatName(String format) {
        if (!FORMATS.containsKey(format)) {
            Reference.logger.warn("No format with id {}; returning invalid for name", (Object)format, (Object)new UnsupportedFormatException(format).fillInStackTrace());
            return "schematica.format.invalid";
        }
        return FORMATS.get(format).getName();
    }

    public static String getExtension(@Nullable String format) {
        if (format == null) {
            format = FORMAT_DEFAULT;
        }
        if (!FORMATS.containsKey(format)) {
            Reference.logger.warn("No format with id {}; returning default extension", (Object)format, (Object)new UnsupportedFormatException(format).fillInStackTrace());
            format = FORMAT_DEFAULT;
        }
        return FORMATS.get(format).getExtension();
    }

    static {
        FORMATS.put("Alpha", new SchematicAlpha());
        FORMATS.put("Structure", new SchematicStructure());
        FORMAT_DEFAULT = "Alpha";
    }
}

