/*
 * Decompiled with CFR 0.152.
 */
package com.github.lunatrius.schematica.handler;

import com.github.lunatrius.schematica.reference.Reference;
import com.github.lunatrius.schematica.world.chunk.SchematicContainer;
import com.github.lunatrius.schematica.world.schematic.SchematicFormat;
import java.util.ArrayDeque;
import java.util.Queue;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class QueueTickHandler {
    public static final QueueTickHandler INSTANCE = new QueueTickHandler();
    private final Queue<SchematicContainer> queue = new ArrayDeque<SchematicContainer>();

    private QueueTickHandler() {
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            return;
        }
        try {
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            if (player != null && player.field_71174_a != null && !player.field_71174_a.func_147298_b().func_150731_c()) {
                this.processQueue();
            }
        }
        catch (Exception e) {
            Reference.logger.error("Something went wrong...", (Throwable)e);
        }
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            return;
        }
        this.processQueue();
    }

    private void processQueue() {
        if (this.queue.size() == 0) {
            return;
        }
        SchematicContainer container = this.queue.poll();
        if (container == null) {
            return;
        }
        if (container.hasNext()) {
            if (container.isFirst()) {
                TextComponentTranslation component = new TextComponentTranslation("schematica.command.save.started", new Object[]{container.chunkCount, container.file.getName()});
                container.player.func_145747_a((ITextComponent)component);
            }
            container.next();
        }
        if (container.hasNext()) {
            this.queue.offer(container);
        } else {
            SchematicFormat.writeToFileAndNotify(container.file, container.format, container.schematic, container.player);
        }
    }

    public void queueSchematic(SchematicContainer container) {
        this.queue.offer(container);
    }
}

