/*
 * Decompiled with CFR 0.152.
 */
package openmods.utils.bitstream;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import openmods.utils.bitstream.InputBitStreamBase;
import openmods.utils.io.IByteSource;

public abstract class InputVarBitStream
extends InputBitStreamBase {
    private InputVarBitStream() {
        super(64);
    }

    public static InputVarBitStream readAll(IByteSource source) throws IOException {
        int b;
        final ByteBuf buf = Unpooled.buffer();
        do {
            b = source.nextByte();
            buf.writeByte(b);
        } while ((b & 0x80) != 0);
        buf.readerIndex(0);
        final int size = buf.readableBytes();
        return new InputVarBitStream(){

            @Override
            protected int nextByte() {
                return buf.readUnsignedByte();
            }

            @Override
            public int bytesRead() {
                return size;
            }
        };
    }

    public static InputVarBitStream create(final IByteSource source) {
        return new InputVarBitStream(){
            private int byteCounter;

            @Override
            protected int nextByte() throws IOException {
                int nextByte = source.nextByte();
                ++this.byteCounter;
                return nextByte;
            }

            @Override
            public int bytesRead() {
                return this.byteCounter;
            }
        };
    }
}

