/*
 * Decompiled with CFR 0.152.
 */
package openmods.utils;

import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.Event;

public class BlockManipulator {
    public final World world;
    public final EntityPlayer player;
    public BlockPos blockPos;
    private boolean spawnProtection = true;
    private boolean eventCheck = true;
    private boolean silentTeRemove = false;
    private int blockPlaceFlags = 3;

    public BlockManipulator(@Nonnull World world, @Nonnull EntityPlayer player, BlockPos blockPos) {
        Preconditions.checkNotNull((Object)world);
        this.world = world;
        Preconditions.checkNotNull((Object)player);
        this.player = player;
        this.blockPos = blockPos;
    }

    public BlockManipulator setSpawnProtection(boolean value) {
        this.spawnProtection = value;
        return this;
    }

    public BlockManipulator setEventCheck(boolean value) {
        this.eventCheck = value;
        return this;
    }

    public BlockManipulator setSilentTeRemove(boolean value) {
        this.silentTeRemove = value;
        return this;
    }

    public BlockManipulator setBlockPlaceFlags(int value) {
        this.blockPlaceFlags = value;
        return this;
    }

    public boolean remove() {
        if (!this.world.func_175667_e(this.blockPos)) {
            return false;
        }
        if (this.spawnProtection && !this.world.func_175660_a(this.player, this.blockPos)) {
            return false;
        }
        if (this.eventCheck) {
            IBlockState blockState = this.world.func_180495_p(this.blockPos);
            BlockEvent.BreakEvent event = new BlockEvent.BreakEvent(this.world, this.blockPos, blockState, this.player);
            event.setExpToDrop(0);
            MinecraftForge.EVENT_BUS.post((Event)event);
            if (event.isCanceled()) {
                return false;
            }
        }
        if (this.silentTeRemove) {
            this.world.func_175713_t(this.blockPos);
        }
        return this.world.func_175698_g(this.blockPos);
    }

    public boolean place(IBlockState state, EnumFacing direction, EnumHand hand) {
        if (!this.world.func_175667_e(this.blockPos)) {
            return false;
        }
        if (this.spawnProtection && !this.world.func_175660_a(this.player, this.blockPos)) {
            return false;
        }
        BlockSnapshot snapshot = BlockSnapshot.getBlockSnapshot((World)this.world, (BlockPos)this.blockPos);
        if (!this.world.func_180501_a(this.blockPos, state, this.blockPlaceFlags)) {
            return false;
        }
        if (ForgeEventFactory.onPlayerBlockPlace((EntityPlayer)this.player, (BlockSnapshot)snapshot, (EnumFacing)direction, (EnumHand)hand).isCanceled()) {
            this.world.restoringBlockSnapshots = true;
            snapshot.restore(true, false);
            this.world.restoringBlockSnapshots = false;
            return false;
        }
        return true;
    }
}

