/*
 * Decompiled with CFR 0.152.
 */
package openmods.utils;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import openmods.utils.ByteUtils;

public class BitSet {
    private byte[] bits;

    public BitSet() {
        this.bits = new byte[0];
    }

    public BitSet(int bitCount) {
        this.resize(bitCount);
    }

    private static int byteCount(int bitCount) {
        return bitCount + 7 >> 3;
    }

    public void resize(int bitCount) {
        int count = BitSet.byteCount(bitCount);
        this.bits = new byte[count];
    }

    public void setBit(int bit) {
        int field = bit >> 3;
        int pos = bit & 7;
        int n = field;
        this.bits[n] = (byte)(this.bits[n] | 1 << pos);
    }

    public void clearBit(int bit) {
        int field = bit >> 3;
        int pos = bit & 7;
        int n = field;
        this.bits[n] = (byte)(this.bits[n] & ~(1 << pos));
    }

    public boolean testBit(int bit) {
        int field = bit >> 3;
        int pos = bit & 7;
        return (this.bits[field] & 1 << pos) != 0;
    }

    public void writeToStream(DataOutput output) throws IOException {
        ByteUtils.writeVLI(output, this.bits.length);
        output.write(this.bits);
    }

    public void writeToBuffer(PacketBuffer output) {
        output.func_179250_a(this.bits);
    }

    public void readFromStream(DataInput input) throws IOException {
        int size = ByteUtils.readVLI(input);
        this.bits = new byte[size];
        input.readFully(this.bits);
    }

    public void readFromBuffer(PacketBuffer input) {
        this.bits = input.func_179251_a();
    }

    public void writeToNBT(NBTTagCompound tag) {
        tag.func_74773_a("Bits", this.bits);
    }

    public void readFromNBT(NBTTagCompound tag) {
        this.bits = (byte[])tag.func_74770_j("Bits").clone();
    }

    public boolean checkSize(int bitSize) {
        return BitSet.byteCount(bitSize) <= this.bits.length;
    }
}

