/*
 * Decompiled with CFR 0.152.
 */
package openmods.liquids;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class SingleFluidBucketHandler
implements IFluidHandlerItem {
    private final int volume;
    private final FluidStack contents;
    @Nonnull
    private final ItemStack emptyContainer;
    @Nonnull
    private final ItemStack filledContainer;
    private boolean isFilled = true;
    private final IFluidTankProperties properties;

    public SingleFluidBucketHandler(@Nonnull ItemStack filledContainer, @Nonnull ItemStack emptyContainer, @Nonnull Fluid fluid, final int volume) {
        this.volume = volume;
        this.filledContainer = filledContainer;
        this.emptyContainer = emptyContainer;
        this.contents = new FluidStack(fluid, volume);
        this.properties = new IFluidTankProperties(){

            public FluidStack getContents() {
                return SingleFluidBucketHandler.this.isFilled ? SingleFluidBucketHandler.this.contents.copy() : null;
            }

            public int getCapacity() {
                return volume;
            }

            public boolean canFillFluidType(FluidStack fluidStack) {
                return SingleFluidBucketHandler.this.contents.isFluidEqual(fluidStack);
            }

            public boolean canFill() {
                return true;
            }

            public boolean canDrainFluidType(FluidStack fluidStack) {
                return SingleFluidBucketHandler.this.contents.isFluidEqual(fluidStack);
            }

            public boolean canDrain() {
                return true;
            }
        };
    }

    public IFluidTankProperties[] getTankProperties() {
        return new IFluidTankProperties[]{this.properties};
    }

    private boolean isResourceValid(@Nullable FluidStack resource) {
        return this.contents.isFluidEqual(resource) && resource.amount >= this.volume;
    }

    private ItemStack getContainerRaw() {
        return this.isFilled ? this.filledContainer : this.emptyContainer;
    }

    private boolean isContainerSingleItem() {
        return this.getContainerRaw().func_190916_E() == 1;
    }

    public int fill(@Nullable FluidStack resource, boolean doFill) {
        if (this.isFilled || !this.isResourceValid(resource) || !this.isContainerSingleItem()) {
            return 0;
        }
        if (doFill) {
            this.isFilled = true;
        }
        return this.volume;
    }

    @Nullable
    public FluidStack drain(@Nullable FluidStack resource, boolean doDrain) {
        if (!(this.isFilled && this.isResourceValid(resource) && this.isContainerSingleItem())) {
            return null;
        }
        if (doDrain) {
            this.isFilled = false;
        }
        return this.contents.copy();
    }

    @Nullable
    public FluidStack drain(int maxDrain, boolean doDrain) {
        if (!this.isFilled || maxDrain < this.volume || !this.isContainerSingleItem()) {
            return null;
        }
        if (doDrain) {
            this.isFilled = false;
        }
        return this.contents.copy();
    }

    public ItemStack getContainer() {
        return this.getContainerRaw().func_77946_l();
    }
}

