/*
 * Decompiled with CFR 0.152.
 */
package openmods.infobook;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.SortedMap;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.RegistryNamespaced;
import openmods.Log;
import openmods.OpenMods;
import openmods.gui.component.BaseComponent;
import openmods.gui.component.GuiComponentBook;
import openmods.gui.component.page.ItemStackTocPage;
import openmods.gui.component.page.StandardRecipePage;
import openmods.infobook.BookDocumentation;
import openmods.infobook.ICustomBookEntryProvider;
import openmods.utils.CachedInstanceFactory;
import openmods.utils.TranslationUtils;

public class PageBuilder {
    private static final CachedInstanceFactory<ICustomBookEntryProvider> PROVIDERS = CachedInstanceFactory.create();
    private final SortedMap<String, Entry> pages = Maps.newTreeMap();
    private Set<String> modIds;
    private List<ItemStackTocPage> tocPages;

    protected String getMediaLink(String modId, String type, String id) {
        String lang = (String)OpenMods.proxy.getLanguage().or((Object)"unknown");
        return "https://videos.openmods.info/" + lang + "/tutorial." + modId + "." + type + "." + id;
    }

    public <T> void addPages(String type, RegistryNamespaced<ResourceLocation, T> registry, StackProvider<T> provider) {
        Set ids = registry.func_148742_b();
        for (ResourceLocation id : ids) {
            BookDocumentation doc;
            Object obj = registry.func_82594_a((Object)id);
            if (obj == null) continue;
            Class<?> cls = obj.getClass();
            try {
                doc = cls.getAnnotation(BookDocumentation.class);
            }
            catch (Throwable t) {
                Log.warn(t, "Failed to get annotation from %s", cls);
                continue;
            }
            if (doc == null) continue;
            String modId = id.func_110624_b().toLowerCase(Locale.ENGLISH);
            if (this.modIds != null && !this.modIds.contains(modId)) continue;
            String itemId = id.func_110623_a();
            Class<? extends ICustomBookEntryProvider> customProviderCls = doc.customProvider();
            if (customProviderCls == BookDocumentation.EMPTY.class) {
                ItemStack stack = provider.createStack(modId, itemId, obj);
                if (stack.func_190926_b()) continue;
                String customName = doc.customName();
                this.addPage(Strings.isNullOrEmpty((String)customName) ? itemId : customName, modId, type, doc.hasVideo(), stack);
                continue;
            }
            ICustomBookEntryProvider customProvider = (ICustomBookEntryProvider)PROVIDERS.getOrCreate(customProviderCls);
            for (ICustomBookEntryProvider.Entry e : customProvider.getBookEntries()) {
                this.addPage(e.name, modId, type, doc.hasVideo(), e.stack);
            }
        }
    }

    public void insertTocPages(GuiComponentBook book, int rows, int columns, float scale) {
        ItemStackTocPage page;
        Preconditions.checkState((this.tocPages == null ? 1 : 0) != 0, (Object)"Table Of Contents page already added");
        this.tocPages = Lists.newArrayList();
        for (int tocEntriesCount = this.pages.size(); tocEntriesCount > 0; tocEntriesCount -= page.getCapacity()) {
            page = new ItemStackTocPage(rows, columns, scale);
            this.tocPages.add(page);
            book.addPage(page);
        }
    }

    public void insertPages(GuiComponentBook book) {
        for (Entry e : this.pages.values()) {
            if (this.tocPages != null) {
                int target = book.getNumberOfPages();
                this.addToToc(book, e.stack, target);
            }
            book.addPage(e.getPage());
        }
    }

    private void addToToc(GuiComponentBook book, @Nonnull ItemStack stack, int target) {
        for (ItemStackTocPage tocPage : this.tocPages) {
            if (!tocPage.addEntry(stack, (component, x, y, button) -> book.changePage(target))) continue;
            return;
        }
        throw new IllegalStateException(String.format("Tried to add more TOC entries than allocated", new Object[0]));
    }

    private void addPage(String id, String modId, String type, boolean hasVideo, @Nonnull ItemStack stack) {
        String nameKey = this.getTranslationKey(id, modId, type, "name");
        String descriptionKey = this.getTranslationKey(id, modId, type, "description");
        String translatedName = TranslationUtils.translateToLocal(nameKey);
        if (hasVideo) {
            String mediaKey = this.getMediaLink(modId, type, id);
            this.pages.put(translatedName + ":" + id, new Entry(stack, nameKey, descriptionKey, (Optional<String>)Optional.of((Object)mediaKey)));
        } else {
            this.pages.put(translatedName + ":" + id, new Entry(stack, nameKey, descriptionKey, (Optional<String>)Optional.absent()));
        }
    }

    protected String getTranslationKey(String name, String modId, String type, String category) {
        return String.format("%s.%s.%s.%s", type, modId, name, category);
    }

    public void includeModId(String modid) {
        if (this.modIds == null) {
            this.modIds = Sets.newHashSet();
        }
        this.modIds.add(modid.toLowerCase(Locale.ENGLISH));
    }

    public void addItemPages(StackProvider<Item> provider) {
        this.addPages("item", Item.field_150901_e, provider);
    }

    public void createItemPages() {
        this.addItemPages((itemModId, itemName, item) -> new ItemStack(item));
    }

    public void addBlockPages(StackProvider<Block> provider) {
        this.addPages("tile", (RegistryNamespaced)Block.field_149771_c, provider);
    }

    public void createBlockPages() {
        this.addBlockPages((blockModId, blockName, block) -> new ItemStack(block));
    }

    private static class Entry {
        @Nonnull
        public final ItemStack stack;
        public final String nameKey;
        public final String descriptionKey;
        public final Optional<String> mediaKey;

        public Entry(@Nonnull ItemStack stack, String nameKey, String descriptionKey, Optional<String> mediaKey) {
            this.stack = stack;
            this.nameKey = nameKey;
            this.descriptionKey = descriptionKey;
            this.mediaKey = mediaKey;
        }

        public BaseComponent getPage() {
            if (this.mediaKey.isPresent()) {
                return new StandardRecipePage(this.nameKey, this.descriptionKey, (String)this.mediaKey.get(), this.stack);
            }
            return new StandardRecipePage(this.nameKey, this.descriptionKey, this.stack);
        }
    }

    public static interface StackProvider<T> {
        @Nonnull
        public ItemStack createStack(String var1, String var2, T var3);
    }
}

