/*
 * Decompiled with CFR 0.152.
 */
package openmods.colors;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IStringSerializable;
import net.minecraftforge.oredict.OreDictionary;
import openmods.colors.CYMK;
import openmods.colors.RGB;
import org.apache.commons.lang3.text.WordUtils;

public enum ColorMeta implements IStringSerializable
{
    BLACK("black", 0x1E1B1B, EnumDyeColor.BLACK),
    RED("red", 11743532, EnumDyeColor.RED),
    GREEN("green", 3887386, EnumDyeColor.GREEN),
    BROWN("brown", 5320730, EnumDyeColor.BROWN),
    BLUE("blue", 2437522, EnumDyeColor.BLUE),
    PURPLE("purple", 8073150, EnumDyeColor.PURPLE),
    CYAN("cyan", 2651799, EnumDyeColor.CYAN),
    LIGHT_GRAY("lightGray", "silver", 0xABABAB, EnumDyeColor.SILVER),
    GRAY("gray", 0x434343, EnumDyeColor.GRAY),
    PINK("pink", 14188952, EnumDyeColor.PINK),
    LIME("lime", 4312372, EnumDyeColor.LIME),
    YELLOW("yellow", 14602026, EnumDyeColor.YELLOW),
    LIGHT_BLUE("lightBlue", "light_blue", 6719955, EnumDyeColor.LIGHT_BLUE),
    MAGENTA("magenta", 12801229, EnumDyeColor.MAGENTA),
    ORANGE("orange", 15435844, EnumDyeColor.ORANGE),
    WHITE("white", 0xF0F0F0, EnumDyeColor.WHITE);

    public final int rgb;
    public final int vanillaDyeId;
    public final int vanillaBlockId;
    public final EnumDyeColor vanillaEnum;
    public final int oreId;
    public final int bitmask;
    public final String oreName;
    public final String name;
    public final String unlocalizedName;
    public final String textureName;
    public final RGB rgbWrap;
    public final CYMK cymkWrap;
    static final ColorMeta[] VALUES;
    private static final Map<String, ColorMeta> COLORS_BY_ORE_NAME;
    private static final Map<String, ColorMeta> COLORS_BY_NAME;
    private static final Map<Integer, ColorMeta> COLORS_BY_ORE_ID;
    private static final Map<Integer, ColorMeta> COLORS_BY_BITMASK;
    private static final Map<EnumDyeColor, ColorMeta> COLORS_BY_VANILLA_ENUM;

    @Nonnull
    public ItemStack createStack(Block block, int amount) {
        return new ItemStack(block, amount, this.vanillaBlockId);
    }

    @Nonnull
    public ItemStack createStack(Item item, int amount) {
        return new ItemStack(item, amount, this.vanillaDyeId);
    }

    private ColorMeta(String name, int rgb, EnumDyeColor vanilla) {
        this(name, name, rgb, vanilla);
    }

    private ColorMeta(String name, String textureName, int rgb, EnumDyeColor vanilla) {
        this.oreName = "dye" + WordUtils.capitalize((String)name);
        this.oreId = OreDictionary.getOreID((String)this.oreName);
        this.textureName = textureName;
        this.name = name.toLowerCase(Locale.ENGLISH);
        this.unlocalizedName = "openmodslib.color." + name;
        this.rgb = rgb;
        this.vanillaEnum = vanilla;
        this.vanillaDyeId = vanilla.func_176767_b();
        this.vanillaBlockId = vanilla.func_176765_a();
        this.bitmask = 1 << this.vanillaBlockId;
        this.rgbWrap = new RGB(rgb);
        this.cymkWrap = this.rgbWrap.toCYMK();
    }

    public static Set<ColorMeta> fromStack(@Nonnull ItemStack stack) {
        Set result = Sets.newIdentityHashSet();
        for (int oreId : OreDictionary.getOreIDs((ItemStack)stack)) {
            ColorMeta meta = COLORS_BY_ORE_ID.get(oreId);
            if (meta == null) continue;
            result.add(meta);
        }
        return result;
    }

    public static ColorMeta fromOreId(int oreId) {
        return COLORS_BY_ORE_ID.get(oreId);
    }

    public static ColorMeta fromOreName(String oreName) {
        return COLORS_BY_ORE_NAME.get(oreName);
    }

    public static ColorMeta fromName(String name) {
        return COLORS_BY_NAME.get(name.toLowerCase(Locale.ENGLISH));
    }

    public static ColorMeta fromBitmask(int bitmask) {
        return COLORS_BY_BITMASK.get(bitmask);
    }

    public static ColorMeta fromVanillaEnum(EnumDyeColor color) {
        return COLORS_BY_VANILLA_ENUM.get(color);
    }

    public static ColorMeta fromBlockMeta(int meta) {
        EnumDyeColor vanilla = EnumDyeColor.func_176764_b((int)meta);
        return ColorMeta.fromVanillaEnum(vanilla);
    }

    public static ColorMeta fromDyeDamage(int damage) {
        EnumDyeColor vanilla = EnumDyeColor.func_176766_a((int)damage);
        return ColorMeta.fromVanillaEnum(vanilla);
    }

    public static Collection<ColorMeta> getAllColors() {
        return ImmutableList.copyOf((Object[])VALUES);
    }

    public String func_176610_l() {
        return this.name;
    }

    static {
        VALUES = ColorMeta.values();
        COLORS_BY_ORE_NAME = Maps.newHashMap();
        COLORS_BY_NAME = Maps.newHashMap();
        COLORS_BY_ORE_ID = Maps.newHashMap();
        COLORS_BY_BITMASK = Maps.newHashMap();
        COLORS_BY_VANILLA_ENUM = Maps.newEnumMap(EnumDyeColor.class);
        for (ColorMeta color : ColorMeta.values()) {
            COLORS_BY_NAME.put(color.name, color);
            COLORS_BY_ORE_NAME.put(color.oreName, color);
            COLORS_BY_ORE_ID.put(color.oreId, color);
            COLORS_BY_BITMASK.put(color.bitmask, color);
            COLORS_BY_VANILLA_ENUM.put(color.vanillaEnum, color);
        }
    }
}

