/*
 * Decompiled with CFR 0.152.
 */
package info.openmods.calc.types.multi;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import info.openmods.calc.Calculator;
import info.openmods.calc.Compilers;
import info.openmods.calc.Environment;
import info.openmods.calc.ExecutionErrorException;
import info.openmods.calc.ExprType;
import info.openmods.calc.Frame;
import info.openmods.calc.FrameFactory;
import info.openmods.calc.executable.BinaryOperator;
import info.openmods.calc.executable.IExecutable;
import info.openmods.calc.executable.Operator;
import info.openmods.calc.executable.OperatorDictionary;
import info.openmods.calc.executable.UnaryOperator;
import info.openmods.calc.math.Complex;
import info.openmods.calc.parsing.BasicCompilerMapFactory;
import info.openmods.calc.parsing.ConstantSymbolStateTransition;
import info.openmods.calc.parsing.DefaultExecutableListBuilder;
import info.openmods.calc.parsing.ITokenStreamCompiler;
import info.openmods.calc.parsing.IValueParser;
import info.openmods.calc.parsing.PostfixCompiler;
import info.openmods.calc.parsing.ast.IAstParser;
import info.openmods.calc.parsing.ast.IModifierStateTransition;
import info.openmods.calc.parsing.ast.IOperatorDictionary;
import info.openmods.calc.parsing.ast.MappedParserState;
import info.openmods.calc.parsing.ast.OperatorAssociativity;
import info.openmods.calc.parsing.node.BinaryOpNode;
import info.openmods.calc.parsing.node.DefaultExprNodeFactory;
import info.openmods.calc.parsing.node.IExprNode;
import info.openmods.calc.parsing.node.MappedExprNodeFactory;
import info.openmods.calc.parsing.node.SquareBracketContainerNode;
import info.openmods.calc.parsing.node.SymbolGetNode;
import info.openmods.calc.parsing.node.UnaryOpNode;
import info.openmods.calc.parsing.node.ValueNode;
import info.openmods.calc.parsing.postfix.IExecutableListBuilder;
import info.openmods.calc.parsing.postfix.IPostfixParserState;
import info.openmods.calc.parsing.postfix.MappedPostfixParser;
import info.openmods.calc.parsing.token.Token;
import info.openmods.calc.parsing.token.Tokenizer;
import info.openmods.calc.symbol.BinaryFunction;
import info.openmods.calc.symbol.FixedCallable;
import info.openmods.calc.symbol.GenericFunctions;
import info.openmods.calc.symbol.ICallable;
import info.openmods.calc.symbol.ISymbol;
import info.openmods.calc.symbol.LocalSymbolMap;
import info.openmods.calc.symbol.NullaryFunction;
import info.openmods.calc.symbol.SingleReturnCallable;
import info.openmods.calc.symbol.SymbolMap;
import info.openmods.calc.symbol.TopSymbolMap;
import info.openmods.calc.symbol.UnaryFunction;
import info.openmods.calc.types.multi.AltExpressionFactory;
import info.openmods.calc.types.multi.ApplyCallNode;
import info.openmods.calc.types.multi.ArgBracketNode;
import info.openmods.calc.types.multi.BindPatternTranslator;
import info.openmods.calc.types.multi.CallableGetModifierTransition;
import info.openmods.calc.types.multi.CallableGetPostfixCompilerState;
import info.openmods.calc.types.multi.CallableValue;
import info.openmods.calc.types.multi.Code;
import info.openmods.calc.types.multi.CodePostfixCompilerState;
import info.openmods.calc.types.multi.CodeStateTransition;
import info.openmods.calc.types.multi.CompositeSymbolMap;
import info.openmods.calc.types.multi.Cons;
import info.openmods.calc.types.multi.DictSymbol;
import info.openmods.calc.types.multi.DoExpressionFactory;
import info.openmods.calc.types.multi.DotExprNode;
import info.openmods.calc.types.multi.EvalSymbol;
import info.openmods.calc.types.multi.IConverter;
import info.openmods.calc.types.multi.IfExpressionFactory;
import info.openmods.calc.types.multi.IntegerAttrs;
import info.openmods.calc.types.multi.LambdaExpressionFactory;
import info.openmods.calc.types.multi.LazyArgsSymbolTransition;
import info.openmods.calc.types.multi.LazyBinaryOperatorNode;
import info.openmods.calc.types.multi.LetExpressionFactory;
import info.openmods.calc.types.multi.LibFunctional;
import info.openmods.calc.types.multi.LibListFunctions;
import info.openmods.calc.types.multi.LibRandom;
import info.openmods.calc.types.multi.ListBracketNode;
import info.openmods.calc.types.multi.LogicFunction;
import info.openmods.calc.types.multi.MatchExpressionFactory;
import info.openmods.calc.types.multi.MetaObject;
import info.openmods.calc.types.multi.MetaObjectSymbols;
import info.openmods.calc.types.multi.MetaObjectUtils;
import info.openmods.calc.types.multi.OptionalType;
import info.openmods.calc.types.multi.PatternSymbol;
import info.openmods.calc.types.multi.PromiseExpressionFactory;
import info.openmods.calc.types.multi.QuotePostfixCompilerState;
import info.openmods.calc.types.multi.QuoteStateTransition;
import info.openmods.calc.types.multi.RawCodeExprNode;
import info.openmods.calc.types.multi.RegexSymbol;
import info.openmods.calc.types.multi.SimpleNamespace;
import info.openmods.calc.types.multi.SimpleTypedFunction;
import info.openmods.calc.types.multi.SliceCallNode;
import info.openmods.calc.types.multi.SlotCallableValueSymbol;
import info.openmods.calc.types.multi.StringAttrs;
import info.openmods.calc.types.multi.StringInterpolate;
import info.openmods.calc.types.multi.StructSymbol;
import info.openmods.calc.types.multi.StructWrapper;
import info.openmods.calc.types.multi.Symbol;
import info.openmods.calc.types.multi.TypeDomain;
import info.openmods.calc.types.multi.TypeUserdata;
import info.openmods.calc.types.multi.TypedBinaryOperator;
import info.openmods.calc.types.multi.TypedCalcUtils;
import info.openmods.calc.types.multi.TypedFunction;
import info.openmods.calc.types.multi.TypedUnaryOperator;
import info.openmods.calc.types.multi.TypedValue;
import info.openmods.calc.types.multi.TypedValueComparator;
import info.openmods.calc.types.multi.TypedValueParser;
import info.openmods.calc.types.multi.TypedValuePrinter;
import info.openmods.calc.types.multi.UnitType;
import info.openmods.calc.types.multi.VarArgSymbolCallNode;
import info.openmods.calc.utils.OptionalInt;
import info.openmods.calc.utils.Stack;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class TypedValueCalculatorFactory {
    private static final Function<BigInteger, Integer> INT_UNWRAP = BigInteger::intValue;
    private static final int PRIORITY_MAX = 185;
    private static final int PRIORITY_UNARY = 180;
    private static final int PRIORITY_NULL_AWARE = 175;
    private static final int PRIORITY_EXP = 170;
    private static final int PRIORITY_MULTIPLY = 160;
    private static final int PRIORITY_ADD = 150;
    private static final int PRIORITY_BITSHIFT = 140;
    private static final int PRIORITY_BITWISE_AND = 130;
    private static final int PRIORITY_BITWISE_XOR = 120;
    private static final int PRIORITY_BITWISE_OR = 110;
    private static final int PRIORITY_COMPARE = 100;
    private static final int PRIORITY_SPACESHIP = 90;
    private static final int PRIORITY_EQUALS = 80;
    private static final int PRIORITY_LOGIC_AND = 70;
    private static final int PRIORITY_LOGIC_XOR = 60;
    private static final int PRIORITY_LOGIC_OR = 50;
    private static final int PRIORITY_CONS = 40;
    private static final int PRIORITY_LAMBDA = 30;
    private static final int PRIORITY_SPLIT = 20;
    private static final int PRIORITY_ASSIGN = 10;
    private static final Set<Class<?>> NUMBER_TYPES = ImmutableSet.of(Double.class, Boolean.class, BigInteger.class, Complex.class);

    private static UnaryOperator<TypedValue> createUnaryNegation(String id, TypeDomain domain) {
        return new TypedUnaryOperator.Builder(id, 180).registerOperation(new TypedUnaryOperator.ISimpleOperation<BigInteger, BigInteger>(){

            @Override
            public BigInteger apply(BigInteger value) {
                return value.negate();
            }
        }).registerOperation(new TypedUnaryOperator.ISimpleOperation<Boolean, BigInteger>(){

            @Override
            public BigInteger apply(Boolean value) {
                return value != false ? BigInteger.valueOf(-1L) : BigInteger.ZERO;
            }
        }).registerOperation(new TypedUnaryOperator.ISimpleOperation<Double, Double>(){

            @Override
            public Double apply(Double value) {
                return -value.doubleValue();
            }
        }).registerOperation(new TypedUnaryOperator.ISimpleOperation<Complex, Complex>(){

            @Override
            public Complex apply(Complex value) {
                return value.negate();
            }
        }).build(domain);
    }

    private static boolean isNumericValueNode(IExprNode<TypedValue> node) {
        if (node instanceof ValueNode) {
            ValueNode valueNode = (ValueNode)node;
            return NUMBER_TYPES.contains(((TypedValue)valueNode.value).type);
        }
        return false;
    }

    private static List<Object> consToUnwrappedList(Cons pair, final TypedValue expectedTerminator) {
        final ArrayList result = Lists.newArrayList();
        pair.visit(new Cons.LinearVisitor(){

            @Override
            public void value(TypedValue value, boolean isLast) {
                result.add(value.value);
            }

            @Override
            public void end(TypedValue terminator) {
                if (terminator != expectedTerminator) {
                    throw new IllegalArgumentException("Not null terminated list");
                }
            }

            @Override
            public void begin() {
            }
        });
        return result;
    }

    public static Calculator<TypedValue, ExprType> create() {
        final TypeDomain domain = new TypeDomain(MetaObject.builder().set(MetaObjectUtils.USE_VALUE_EQUALS).build());
        final TypedValueParser valueParser = new TypedValueParser(domain);
        domain.registerType(TypeUserdata.class, "type", TypeUserdata.defaultMetaObject(domain).build());
        SimpleNamespace.register(domain);
        TypedValue nullType = domain.create(TypeUserdata.class, new TypeUserdata("<null>", UnitType.class));
        domain.registerType(UnitType.class, "<null>", MetaObject.builder().set(MetaObjectUtils.BOOL_ALWAYS_FALSE).set(new MetaObject.SlotLength(){

            @Override
            public int length(TypedValue self, Frame<TypedValue> frame) {
                return 0;
            }
        }).set(MetaObjectUtils.strConst("null")).set(MetaObjectUtils.reprConst("null")).set(MetaObjectUtils.typeConst(nullType)).build(), UnitType.INSTANCE);
        final TypedValue nullValue = domain.getDefault(UnitType.class);
        final TypedValuePrinter valuePrinter = new TypedValuePrinter(nullValue);
        HashMap basicTypes = Maps.newHashMap();
        TypedValue intType = domain.create(TypeUserdata.class, new TypeUserdata("int", BigInteger.class), TypeUserdata.defaultMetaObject(domain).set(MetaObjectUtils.callableAdapter(new SimpleTypedFunction(domain){

            @TypedFunction.Variant
            public BigInteger convert(@TypedFunction.DispatchArg(extra={Boolean.class}) BigInteger value) {
                return value;
            }

            @TypedFunction.Variant
            public BigInteger convert(@TypedFunction.DispatchArg Double value) {
                return BigInteger.valueOf(value.longValue());
            }

            @TypedFunction.Variant
            public BigInteger convert(@TypedFunction.DispatchArg String value, @TypedFunction.OptionalArgs Optional<BigInteger> radix) {
                int usedRadix = (Integer)radix.transform(INT_UNWRAP).or((Object)valuePrinter.base);
                Pair<BigInteger, Double> result = TypedValueParser.NUMBER_PARSER.parseString(value, usedRadix);
                Preconditions.checkArgument((result.getRight() == null ? 1 : 0) != 0, (String)"Fractional part in argument to 'int': %s", (Object)value);
                return (BigInteger)result.getLeft();
            }
        })).build());
        basicTypes.put("int", intType);
        IntegerAttrs integerAttrs = new IntegerAttrs();
        domain.registerType(BigInteger.class, "int", MetaObject.builder().set(new MetaObject.SlotBool(){

            @Override
            public boolean bool(TypedValue value, Frame<TypedValue> frame) {
                return !value.as(BigInteger.class).equals(BigInteger.ZERO);
            }
        }).set(integerAttrs.createAttrSlot()).set(integerAttrs.createDirSlot()).set(MetaObjectUtils.typeConst(intType)).set(new MetaObject.SlotStr(){

            @Override
            public String str(TypedValue self, Frame<TypedValue> frame) {
                return valuePrinter.str(self.as(BigInteger.class));
            }
        }).set(new MetaObject.SlotRepr(){

            @Override
            public String repr(TypedValue self, Frame<TypedValue> frame) {
                return valuePrinter.repr(self.as(BigInteger.class));
            }
        }).set(MetaObjectUtils.USE_VALUE_EQUALS).build());
        TypedValue floatType = domain.create(TypeUserdata.class, new TypeUserdata("float", Double.class), TypeUserdata.defaultMetaObject(domain).set(MetaObjectUtils.callableAdapter(new SimpleTypedFunction(domain){

            @TypedFunction.Variant
            public Double convert(@TypedFunction.DispatchArg(extra={BigInteger.class, Boolean.class}) Double value) {
                return value;
            }

            @TypedFunction.Variant
            public Double convert(@TypedFunction.DispatchArg String value, @TypedFunction.OptionalArgs Optional<BigInteger> radix) {
                int usedRadix = (Integer)radix.transform(INT_UNWRAP).or((Object)valuePrinter.base);
                Pair<BigInteger, Double> result = TypedValueParser.NUMBER_PARSER.parseString(value, usedRadix);
                return ((BigInteger)result.getLeft()).doubleValue() + (Double)result.getRight();
            }
        })).build());
        basicTypes.put("float", floatType);
        domain.registerType(Double.class, "float", MetaObject.builder().set(new MetaObject.SlotBool(){

            @Override
            public boolean bool(TypedValue value, Frame<TypedValue> frame) {
                return value.as(Double.class) != 0.0;
            }
        }).set(MetaObjectUtils.typeConst(floatType)).set(new MetaObject.SlotStr(){

            @Override
            public String str(TypedValue self, Frame<TypedValue> frame) {
                return valuePrinter.str(self.as(Double.class));
            }
        }).set(new MetaObject.SlotRepr(){

            @Override
            public String repr(TypedValue self, Frame<TypedValue> frame) {
                return valuePrinter.repr(self.as(Double.class));
            }
        }).set(MetaObjectUtils.USE_VALUE_EQUALS).build());
        TypedValue boolType = domain.create(TypeUserdata.class, new TypeUserdata("bool", Boolean.class), TypeUserdata.defaultMetaObject(domain).set(MetaObjectUtils.callableAdapter(new SlotCaller(){

            @Override
            protected TypedValue callSlot(Frame<TypedValue> frame, TypedValue value, MetaObject metaObject) {
                return domain.create(Boolean.class, MetaObjectUtils.boolValue(frame, value));
            }
        })).build());
        basicTypes.put("bool", boolType);
        domain.registerType(Boolean.class, "bool", MetaObject.builder().set(new MetaObject.SlotBool(){

            @Override
            public boolean bool(TypedValue value, Frame<TypedValue> frame) {
                return value.as(Boolean.class);
            }
        }).set(MetaObjectUtils.typeConst(boolType)).set(new MetaObject.SlotStr(){

            @Override
            public String str(TypedValue self, Frame<TypedValue> frame) {
                return valuePrinter.str(self.as(Boolean.class));
            }
        }).set(new MetaObject.SlotRepr(){

            @Override
            public String repr(TypedValue self, Frame<TypedValue> frame) {
                return valuePrinter.repr(self.as(Boolean.class));
            }
        }).set(MetaObjectUtils.USE_VALUE_EQUALS).build());
        TypedValue strType = domain.create(TypeUserdata.class, new TypeUserdata("str", String.class), TypeUserdata.defaultMetaObject(domain).set(MetaObjectUtils.callableAdapter((ICallable<TypedValue>)new UnaryFunction.Direct<TypedValue>(){

            @Override
            protected TypedValue call(TypedValue value) {
                return value.domain.create(String.class, valuePrinter.str(value));
            }
        })).build());
        basicTypes.put("str", strType);
        StringAttrs stringAttrs = new StringAttrs(nullValue);
        domain.registerType(String.class, "str", MetaObject.builder().set(new MetaObject.SlotLength(){

            @Override
            public int length(TypedValue self, Frame<TypedValue> frame) {
                return self.as(String.class).length();
            }
        }).set(new MetaObject.SlotSlice(){

            @Override
            public TypedValue slice(TypedValue self, TypedValue range, Frame<TypedValue> frame) {
                String target = self.as(String.class);
                String result = range.is(Cons.class) ? this.substr(target, range.as(Cons.class)) : this.charAt(target, range.unwrap(BigInteger.class));
                return domain.create(String.class, result);
            }

            private String substr(String str, Cons range) {
                int left = this.calculateBoundary(range.car, str.length());
                int right = this.calculateBoundary(range.cdr, str.length());
                return str.substring(left, right);
            }

            private int calculateBoundary(TypedValue v, int length) {
                int i = v.unwrap(BigInteger.class).intValue();
                return i >= 0 ? i : length + i;
            }

            private String charAt(String str, BigInteger index) {
                int i = index.intValue();
                if (i < 0) {
                    i = str.length() + i;
                }
                return String.valueOf(str.charAt(i));
            }
        }).set(new MetaObject.SlotBool(){

            @Override
            public boolean bool(TypedValue value, Frame<TypedValue> frame) {
                return !value.as(String.class).isEmpty();
            }
        }).set(stringAttrs.createAttrSlot()).set(stringAttrs.createDirSlot()).set(MetaObjectUtils.typeConst(strType)).set(new MetaObject.SlotStr(){

            @Override
            public String str(TypedValue self, Frame<TypedValue> frame) {
                return valuePrinter.str(self.as(String.class));
            }
        }).set(new MetaObject.SlotRepr(){

            @Override
            public String repr(TypedValue self, Frame<TypedValue> frame) {
                return valuePrinter.repr(self.as(String.class));
            }
        }).set(MetaObjectUtils.USE_VALUE_EQUALS).build());
        TypedValue complexType = domain.create(TypeUserdata.class, new TypeUserdata("complex", Complex.class), TypeUserdata.defaultMetaObject(domain).set(MetaObjectUtils.callableAdapter(new SimpleTypedFunction(domain){

            @TypedFunction.Variant
            public Complex convert(Double re, Double im) {
                return Complex.cartesian(re, im);
            }
        })).build());
        basicTypes.put("complex", complexType);
        domain.registerType(Complex.class, "complex", MetaObject.builder().set(new MetaObject.SlotBool(){

            @Override
            public boolean bool(TypedValue value, Frame<TypedValue> frame) {
                return !value.as(Complex.class).equals(Complex.ZERO);
            }
        }).set(MetaObjectUtils.typeConst(complexType)).set(new MetaObject.SlotStr(){

            @Override
            public String str(TypedValue self, Frame<TypedValue> frame) {
                return valuePrinter.str(self.as(Complex.class));
            }
        }).set(new MetaObject.SlotRepr(){

            @Override
            public String repr(TypedValue self, Frame<TypedValue> frame) {
                return valuePrinter.repr(self.as(Complex.class));
            }
        }).set(MetaObjectUtils.USE_VALUE_EQUALS).build());
        TypedValue consType = domain.create(TypeUserdata.class, new TypeUserdata("cons", Cons.class), TypeUserdata.defaultMetaObject(domain).set(MetaObjectUtils.callableAdapter((ICallable<TypedValue>)new BinaryFunction.Direct<TypedValue>(){

            @Override
            protected TypedValue call(TypedValue left, TypedValue right) {
                return domain.create(Cons.class, new Cons(left, right));
            }
        })).build());
        basicTypes.put("cons", consType);
        domain.registerType(Cons.class, "cons", MetaObject.builder().set(new MetaObject.SlotLength(){

            @Override
            public int length(TypedValue self, Frame<TypedValue> frame) {
                return self.as(Cons.class).length();
            }
        }).set(MetaObjectUtils.BOOL_ALWAYS_TRUE).set(MetaObjectUtils.typeConst(consType)).set(new MetaObject.SlotStr(){

            @Override
            public String str(TypedValue self, Frame<TypedValue> frame) {
                return valuePrinter.str(self.as(Cons.class));
            }
        }).set(new MetaObject.SlotRepr(){

            @Override
            public String repr(TypedValue self, Frame<TypedValue> frame) {
                return valuePrinter.repr(self.as(Cons.class));
            }
        }).set(MetaObjectUtils.USE_VALUE_EQUALS).build());
        TypedValue symbolType = domain.create(TypeUserdata.class, new TypeUserdata("symbol", Symbol.class), TypeUserdata.defaultMetaObject(domain).set(MetaObjectUtils.callableAdapter(new SimpleTypedFunction(domain){

            @TypedFunction.Variant
            public Symbol symbol(String value) {
                return Symbol.get(value);
            }
        })).build());
        basicTypes.put("symbol", symbolType);
        domain.registerType(Symbol.class, "symbol", MetaObject.builder().set(MetaObjectUtils.BOOL_ALWAYS_TRUE).set(MetaObjectUtils.typeConst(symbolType)).set(new MetaObject.SlotStr(){

            @Override
            public String str(TypedValue self, Frame<TypedValue> frame) {
                return valuePrinter.str(self.as(Symbol.class));
            }
        }).set(new MetaObject.SlotRepr(){

            @Override
            public String repr(TypedValue self, Frame<TypedValue> frame) {
                return valuePrinter.repr(self.as(Symbol.class));
            }
        }).set(MetaObjectUtils.USE_VALUE_EQUALS).build());
        TypedValue functionType = domain.create(TypeUserdata.class, new TypeUserdata("function", CallableValue.class));
        basicTypes.put("function", functionType);
        domain.registerType(CallableValue.class, "function", MetaObject.builder().set(new MetaObject.SlotCall(){

            @Override
            public void call(TypedValue self, OptionalInt argCount, OptionalInt returnsCount, Frame<TypedValue> frame) {
                CallableValue function = self.as(CallableValue.class);
                function.call(self, argCount, returnsCount, frame);
            }
        }).set(MetaObjectUtils.BOOL_ALWAYS_TRUE).set(MetaObjectUtils.typeConst(functionType)).build());
        TypedValue envType = domain.create(TypeUserdata.class, new TypeUserdata("env", EnvHolder.class));
        basicTypes.put("env", envType);
        domain.registerType(EnvHolder.class, "env", MetaObject.builder().set(new MetaObject.SlotAttr(){

            @Override
            public Optional<TypedValue> attr(TypedValue self, String key, Frame<TypedValue> frame) {
                EnvHolder target = self.as(EnvHolder.class);
                ISymbol<TypedValue> result = target.symbols.get(key);
                if (result == null) {
                    return Optional.absent();
                }
                return Optional.of(result.get());
            }
        }).set(MetaObjectUtils.typeConst(envType)).build());
        TypedValue codeType = domain.create(TypeUserdata.class, new TypeUserdata("code", Code.class));
        basicTypes.put("code", codeType);
        domain.registerType(Code.class, "code", MetaObject.builder().set(MetaObjectUtils.BOOL_ALWAYS_TRUE).set(MetaObjectUtils.typeConst(codeType)).build());
        domain.registerConverter(new IConverter<Boolean, BigInteger>(){

            @Override
            public BigInteger convert(Boolean value) {
                return value != false ? BigInteger.ONE : BigInteger.ZERO;
            }
        });
        domain.registerConverter(new IConverter<Boolean, Double>(){

            @Override
            public Double convert(Boolean value) {
                return value != false ? 1.0 : 0.0;
            }
        });
        domain.registerConverter(new IConverter<Boolean, Complex>(){

            @Override
            public Complex convert(Boolean value) {
                return value != false ? Complex.ONE : Complex.ZERO;
            }
        });
        domain.registerConverter(new IConverter<BigInteger, Double>(){

            @Override
            public Double convert(BigInteger value) {
                return value.doubleValue();
            }
        });
        domain.registerConverter(new IConverter<BigInteger, Complex>(){

            @Override
            public Complex convert(BigInteger value) {
                return Complex.real(value.doubleValue());
            }
        });
        domain.registerConverter(new IConverter<Double, Complex>(){

            @Override
            public Complex convert(Double value) {
                return Complex.real(value);
            }
        });
        domain.registerSymmetricCoercionRule(Boolean.class, BigInteger.class, TypeDomain.Coercion.TO_RIGHT);
        domain.registerSymmetricCoercionRule(Boolean.class, Double.class, TypeDomain.Coercion.TO_RIGHT);
        domain.registerSymmetricCoercionRule(Boolean.class, Complex.class, TypeDomain.Coercion.TO_RIGHT);
        domain.registerSymmetricCoercionRule(BigInteger.class, Double.class, TypeDomain.Coercion.TO_RIGHT);
        domain.registerSymmetricCoercionRule(BigInteger.class, Complex.class, TypeDomain.Coercion.TO_RIGHT);
        domain.registerSymmetricCoercionRule(Double.class, Complex.class, TypeDomain.Coercion.TO_RIGHT);
        final OperatorDictionary operators = new OperatorDictionary();
        final BinaryOperator<TypedValue> addOperator = operators.registerOperator(new TypedBinaryOperator.Builder("+", 150).registerOperation(new TypedBinaryOperator.ISimpleCoercedOperation<BigInteger, BigInteger>(){

            @Override
            public BigInteger apply(BigInteger left, BigInteger right) {
                return left.add(right);
            }
        }).registerOperation(new TypedBinaryOperator.ISimpleCoercedOperation<Complex, Complex>(){

            @Override
            public Complex apply(Complex left, Complex right) {
                return left.add(right);
            }
        }).registerOperation(new TypedBinaryOperator.ISimpleCoercedOperation<Double, Double>(){

            @Override
            public Double apply(Double left, Double right) {
                return left + right;
            }
        }).registerOperation(new TypedBinaryOperator.ISimpleCoercedOperation<String, String>(){

            @Override
            public String apply(String left, String right) {
                return left + right;
            }
        }).registerOperation(new TypedBinaryOperator.ISimpleCoercedOperation<Boolean, BigInteger>(){

            @Override
            public BigInteger apply(Boolean left, Boolean right) {
                return BigInteger.valueOf((left != false ? 1 : 0) + (right != false ? 1 : 0));
            }
        }).build(domain)).unwrap();
        operators.registerOperator(new UnaryOperator.Direct<TypedValue>("+"){

            @Override
            public TypedValue execute(TypedValue value) {
                Preconditions.checkState((boolean)NUMBER_TYPES.contains(value.type), (String)"Not a number: %s", (Object)value);
                return value;
            }
        });
        final UnaryOperator varArgMarker = operators.registerOperator(new MarkerUnaryOperator("*")).unwrap();
        operators.registerOperator(new TypedBinaryOperator.Builder("-", 150).registerOperation(new TypedBinaryOperator.ISimpleCoercedOperation<BigInteger, BigInteger>(){

            @Override
            public BigInteger apply(BigInteger left, BigInteger right) {
                return left.subtract(right);
            }
        }).registerOperation(new TypedBinaryOperator.ISimpleCoercedOperation<Double, Double>(){

            @Override
            public Double apply(Double left, Double right) {
                return left - right;
            }
        }).registerOperation(new TypedBinaryOperator.ISimpleCoercedOperation<Complex, Complex>(){

            @Override
            public Complex apply(Complex left, Complex right) {
                return left.subtract(right);
            }
        }).registerOperation(new TypedBinaryOperator.ISimpleCoercedOperation<Boolean, BigInteger>(){

            @Override
            public BigInteger apply(Boolean left, Boolean right) {
                return BigInteger.valueOf((left != false ? 1 : 0) - (right != false ? 1 : 0));
            }
        }).build(domain));
        operators.registerOperator(TypedValueCalculatorFactory.createUnaryNegation("-", domain));
        operators.registerOperator(TypedValueCalculatorFactory.createUnaryNegation("neg", domain));
        final BinaryOperator<TypedValue> multiplyOperator = operators.registerOperator(new TypedBinaryOperator.Builder("*", 160).registerOperation(new TypedBinaryOperator.ISimpleCoercedOperation<BigInteger, BigInteger>(){

            @Override
            public BigInteger apply(BigInteger left, BigInteger right) {
                return left.multiply(right);
            }
        }).registerOperation(new TypedBinaryOperator.ISimpleCoercedOperation<Double, Double>(){

            @Override
            public Double apply(Double left, Double right) {
                return left * right;
            }
        }).registerOperation(new TypedBinaryOperator.ISimpleCoercedOperation<Complex, Complex>(){

            @Override
            public Complex apply(Complex left, Complex right) {
                return left.multiply(right);
            }
        }).registerOperation(new TypedBinaryOperator.ISimpleCoercedOperation<Boolean, BigInteger>(){

            @Override
            public BigInteger apply(Boolean left, Boolean right) {
                return BigInteger.valueOf((left != false ? 1 : 0) * (right != false ? 1 : 0));
            }
        }).registerOperation(new TypedBinaryOperator.ISimpleVariantOperation<String, BigInteger, String>(){

            @Override
            public String apply(String left, BigInteger right) {
                return StringUtils.repeat((String)left, (int)right.intValue());
            }
        }).build(domain)).unwrap();
        final BinaryOperator<TypedValue> divideOperator = operators.registerOperator(new TypedBinaryOperator.Builder("/", 160).registerOperation(new TypedBinaryOperator.ISimpleCoercedOperation<Double, Double>(){

            @Override
            public Double apply(Double left, Double right) {
                return left / right;
            }
        }).registerOperation(new TypedBinaryOperator.ISimpleCoercedOperation<BigInteger, Double>(){

            @Override
            public Double apply(BigInteger left, BigInteger right) {
                return left.doubleValue() / right.doubleValue();
            }
        }).registerOperation(new TypedBinaryOperator.ISimpleCoercedOperation<Complex, Complex>(){

            @Override
            public Complex apply(Complex left, Complex right) {
                return left.divide(right);
            }
        }).registerOperation(new TypedBinaryOperator.ISimpleCoercedOperation<Boolean, Double>(){

            @Override
            public Double apply(Boolean left, Boolean right) {
                return (left != false ? 1.0 : 0.0) / (right != false ? 1.0 : 0.0);
            }
        }).build(domain)).unwrap();
        operators.registerOperator(new TypedBinaryOperator.Builder("%", 160).registerOperation(new TypedBinaryOperator.ISimpleCoercedOperation<Boolean, BigInteger>(){

            @Override
            public BigInteger apply(Boolean left, Boolean right) {
                return BigInteger.valueOf((left != false ? 1 : 0) % (right != false ? 1 : 0));
            }
        }).registerOperation(new TypedBinaryOperator.ISimpleCoercedOperation<BigInteger, BigInteger>(){

            @Override
            public BigInteger apply(BigInteger left, BigInteger right) {
                return left.mod(right);
            }
        }).registerOperation(new TypedBinaryOperator.ISimpleCoercedOperation<Double, Double>(){

            @Override
            public Double apply(Double left, Double right) {
                return left % right;
            }
        }).setDefaultOperation(new TypedBinaryOperator.IDefaultOperation(){

            @Override
            public Optional<TypedValue> apply(TypeDomain domain, TypedValue left, TypedValue right) {
                Object[] objectArray;
                if (!left.is(String.class)) {
                    return Optional.absent();
                }
                String template = left.as(String.class);
                if (right.is(Cons.class)) {
                    objectArray = TypedValueCalculatorFactory.consToUnwrappedList(right.as(Cons.class), nullValue).toArray();
                } else {
                    Object[] objectArray2 = new Object[1];
                    objectArray = objectArray2;
                    objectArray2[0] = right.value;
                }
                Object[] args = objectArray;
                String result = String.format(template, args);
                return Optional.of((Object)domain.create(String.class, result));
            }
        }).build(domain));
        operators.registerOperator(new TypedBinaryOperator.Builder("//", 160).registerOperation(new TypedBinaryOperator.ISimpleCoercedOperation<Boolean, BigInteger>(){

            @Override
            public BigInteger apply(Boolean left, Boolean right) {
                return BigInteger.valueOf((left != false ? 1 : 0) / (right != false ? 1 : 0));
            }
        }).registerOperation(new TypedBinaryOperator.ISimpleCoercedOperation<BigInteger, BigInteger>(){

            @Override
            public BigInteger apply(BigInteger left, BigInteger right) {
                return left.divide(right);
            }
        }).registerOperation(new TypedBinaryOperator.ISimpleCoercedOperation<Double, Double>(){

            @Override
            public Double apply(Double left, Double right) {
                return Math.floor(left / right);
            }
        }).build(domain));
        operators.registerOperator(new TypedBinaryOperator.Builder("**", 170).registerOperation(new TypedBinaryOperator.ISimpleCoercedOperation<Boolean, BigInteger>(){

            @Override
            public BigInteger apply(Boolean left, Boolean right) {
                return BigInteger.valueOf((left != false ? 0 : 1) * (right != false ? 0 : 1));
            }
        }).registerOperation(new TypedBinaryOperator.ICoercedOperation<BigInteger>(){

            @Override
            public TypedValue apply(TypeDomain domain, BigInteger left, BigInteger right) {
                int exp = right.intValue();
                return exp >= 0 ? domain.create(BigInteger.class, left.pow(exp)) : domain.create(Double.class, Math.pow(left.doubleValue(), exp));
            }
        }).registerOperation(new TypedBinaryOperator.ISimpleCoercedOperation<Double, Double>(){

            @Override
            public Double apply(Double left, Double right) {
                return Math.pow(left, right);
            }
        }).build(domain));
        operators.registerOperator(new UnaryOperator.StackBased<TypedValue>("!"){

            @Override
            public void executeOnStack(Frame<TypedValue> frame) {
                TypedValue selfValue = frame.stack().pop();
                boolean boolValue = MetaObjectUtils.boolValue(frame, selfValue);
                frame.stack().push(domain.create(Boolean.class, !boolValue));
            }
        });
        abstract class BinaryLogicOperator
        extends BinaryOperator.StackBased<TypedValue> {
            public BinaryLogicOperator(String id, int precendence) {
                super(id, precendence);
            }

            @Override
            public void executeOnStack(Frame<TypedValue> frame) {
                Stack<TypedValue> stack = frame.stack();
                TypedValue right = stack.pop();
                TypedValue left = stack.pop();
                Frame<TypedValue> truthFrame = FrameFactory.newLocalFrame(frame);
                truthFrame.stack().push(left);
                boolean flag = MetaObjectUtils.boolValue(frame, left);
                stack.push(this.select(flag, left, right));
            }

            protected abstract TypedValue select(boolean var1, TypedValue var2, TypedValue var3);
        }
        final BinaryOperator andOperator = operators.registerOperator(new BinaryLogicOperator("&&", 70){
            {
                super(id, precendence);
            }

            @Override
            public TypedValue select(boolean firstBool, TypedValue left, TypedValue right) {
                Preconditions.checkArgument((left.domain == right.domain ? 1 : 0) != 0, (String)"Values from different domains: %s, %s", (Object)left, (Object)right);
                return firstBool ? right : left;
            }
        }).unwrap();
        final BinaryOperator orOperator = operators.registerOperator(new BinaryLogicOperator("||", 50){
            {
                super(id, precendence);
            }

            @Override
            public TypedValue select(boolean firstBool, TypedValue left, TypedValue right) {
                Preconditions.checkArgument((left.domain == right.domain ? 1 : 0) != 0, (String)"Values from different domains: %s, %s", (Object)left, (Object)right);
                return firstBool ? left : right;
            }
        }).unwrap();
        operators.registerOperator(new BinaryOperator.StackBased<TypedValue>("^^", 60){

            @Override
            public void executeOnStack(Frame<TypedValue> frame) {
                Stack<TypedValue> stack = frame.stack();
                TypedValue right = stack.peek(0);
                Boolean rightValue = MetaObjectUtils.boolValue(frame, right);
                TypedValue left = stack.peek(0);
                Boolean leftValue = MetaObjectUtils.boolValue(frame, left);
                stack.push(left.domain.create(Boolean.class, leftValue ^ rightValue));
            }
        });
        final BinaryOperator nonNullOperator = operators.registerOperator(new BinaryOperator.Direct<TypedValue>("??", 175){

            @Override
            public TypedValue execute(TypedValue left, TypedValue right) {
                return left != nullValue ? left : right;
            }
        }).unwrap();
        operators.registerOperator(new TypedUnaryOperator.Builder("~", 180).registerOperation(new TypedUnaryOperator.ISimpleOperation<Boolean, BigInteger>(){

            @Override
            public BigInteger apply(Boolean value) {
                return value != false ? BigInteger.ZERO : BigInteger.ONE;
            }
        }).registerOperation(new TypedUnaryOperator.ISimpleOperation<BigInteger, BigInteger>(){

            @Override
            public BigInteger apply(BigInteger value) {
                return value.not();
            }
        }).build(domain));
        operators.registerOperator(new TypedBinaryOperator.Builder("&", 130).registerOperation(new TypedBinaryOperator.ISimpleCoercedOperation<Boolean, Boolean>(){

            @Override
            public Boolean apply(Boolean left, Boolean right) {
                return left & right;
            }
        }).registerOperation(new TypedBinaryOperator.ISimpleCoercedOperation<BigInteger, BigInteger>(){

            @Override
            public BigInteger apply(BigInteger left, BigInteger right) {
                return left.and(right);
            }
        }).build(domain));
        operators.registerOperator(new TypedBinaryOperator.Builder("|", 110).registerOperation(new TypedBinaryOperator.ISimpleCoercedOperation<Boolean, Boolean>(){

            @Override
            public Boolean apply(Boolean left, Boolean right) {
                return left | right;
            }
        }).registerOperation(new TypedBinaryOperator.ISimpleCoercedOperation<BigInteger, BigInteger>(){

            @Override
            public BigInteger apply(BigInteger left, BigInteger right) {
                return left.or(right);
            }
        }).build(domain));
        operators.registerOperator(new TypedBinaryOperator.Builder("^", 120).registerOperation(new TypedBinaryOperator.ISimpleCoercedOperation<Boolean, Boolean>(){

            @Override
            public Boolean apply(Boolean left, Boolean right) {
                return left ^ right;
            }
        }).registerOperation(new TypedBinaryOperator.ISimpleCoercedOperation<BigInteger, BigInteger>(){

            @Override
            public BigInteger apply(BigInteger left, BigInteger right) {
                return left.xor(right);
            }
        }).build(domain));
        operators.registerOperator(new TypedBinaryOperator.Builder("<<", 140).registerOperation(new TypedBinaryOperator.ISimpleCoercedOperation<Boolean, BigInteger>(){

            @Override
            public BigInteger apply(Boolean left, Boolean right) {
                return BigInteger.valueOf((left != false ? 1 : 0) << (right != false ? 1 : 0));
            }
        }).registerOperation(new TypedBinaryOperator.ISimpleCoercedOperation<BigInteger, BigInteger>(){

            @Override
            public BigInteger apply(BigInteger left, BigInteger right) {
                return left.shiftLeft(right.intValue());
            }
        }).build(domain));
        operators.registerOperator(new TypedBinaryOperator.Builder(">>", 140).registerOperation(new TypedBinaryOperator.ISimpleCoercedOperation<Boolean, BigInteger>(){

            @Override
            public BigInteger apply(Boolean left, Boolean right) {
                return BigInteger.valueOf((left != false ? 1 : 0) >> (right != false ? 1 : 0));
            }
        }).registerOperation(new TypedBinaryOperator.ISimpleCoercedOperation<BigInteger, BigInteger>(){

            @Override
            public BigInteger apply(BigInteger left, BigInteger right) {
                return left.shiftRight(right.intValue());
            }
        }).build(domain));
        final TypedValueComparator comparator = new TypedValueComparator();
        abstract class BooleanComparatorOperator
        extends BinaryOperator.StackBased<TypedValue> {
            final /* synthetic */ TypedValueComparator val$comparator;
            final /* synthetic */ TypeDomain val$domain;

            public BooleanComparatorOperator(String id, int precendence) {
                this.val$comparator = typedValueComparator;
                this.val$domain = typeDomain;
                super(id, precendence);
            }

            @Override
            public void executeOnStack(Frame<TypedValue> frame) {
                TypedValue result;
                Stack<TypedValue> stack = frame.stack();
                TypedValue right = stack.pop();
                TypedValue left = stack.pop();
                MetaObject.SlotBinaryOp slot = left.getMetaObject().slotsBinaryOps.get(this.id());
                if (slot != null) {
                    result = slot.op(left, right, frame);
                } else {
                    int comparisionResult = this.val$comparator.compare(left, right);
                    result = this.val$domain.create(Boolean.class, this.interpret(comparisionResult));
                }
                stack.push(result);
            }

            protected abstract boolean interpret(int var1);
        }
        BinaryOperator ltOperator = operators.registerOperator(new BooleanComparatorOperator("<", 100){
            {
                super(id, precendence, typedValueComparator, typeDomain);
            }

            @Override
            protected boolean interpret(int value) {
                return value < 0;
            }
        }).unwrap();
        BinaryOperator gtOperator = operators.registerOperator(new BooleanComparatorOperator(">", 100){
            {
                super(id, precendence, typedValueComparator, typeDomain);
            }

            @Override
            protected boolean interpret(int value) {
                return value > 0;
            }
        }).unwrap();
        abstract class EqualsOperator
        extends BinaryOperator.StackBased<TypedValue> {
            final /* synthetic */ TypeDomain val$domain;

            public EqualsOperator(String id, int precendence) {
                this.val$domain = var3_3;
                super(id, precendence);
            }

            @Override
            public void executeOnStack(Frame<TypedValue> frame) {
                Stack<TypedValue> stack = frame.stack();
                TypedValue right = stack.pop();
                TypedValue left = stack.pop();
                boolean result = TypedCalcUtils.isEqual(frame, left, right);
                stack.push(this.val$domain.create(Boolean.class, this.interpret(result)));
            }

            public abstract boolean interpret(boolean var1);
        }
        operators.registerOperator(new EqualsOperator("==", 80){
            {
                super(id, precendence, typeDomain);
            }

            @Override
            public boolean interpret(boolean isEqual) {
                return isEqual;
            }
        });
        operators.registerOperator(new EqualsOperator("!=", 80){
            {
                super(id, precendence, typeDomain);
            }

            @Override
            public boolean interpret(boolean isEqual) {
                return !isEqual;
            }
        });
        operators.registerOperator(new BooleanComparatorOperator("<=", 100){
            {
                super(id, precendence, typedValueComparator, typeDomain);
            }

            @Override
            public boolean interpret(int value) {
                return value <= 0;
            }
        });
        operators.registerOperator(new BooleanComparatorOperator(">=", 100){
            {
                super(id, precendence, typedValueComparator, typeDomain);
            }

            @Override
            public boolean interpret(int value) {
                return value >= 0;
            }
        });
        class DotOperator
        extends BinaryOperator.StackBased<TypedValue> {
            public DotOperator(String id, int precendence) {
                super(id, precendence);
            }

            @Override
            public void executeOnStack(Frame<TypedValue> frame) {
                String key = frame.stack().pop().as(String.class, "attribute name");
                TypedValue target = frame.stack().pop();
                MetaObject.SlotAttr slotAttr = target.getMetaObject().slotAttr;
                Preconditions.checkState((slotAttr != null ? 1 : 0) != 0, (String)"Value %s has no attributes", (Object)target);
                Optional<TypedValue> attr = slotAttr.attr(target, key, frame);
                Preconditions.checkState((boolean)attr.isPresent(), (String)"Value '%s' has no attribute '%s'", (Object)target, (Object)key);
                frame.stack().push((TypedValue)attr.get());
            }
        }
        final BinaryOperator dotOperator = operators.registerOperator(new DotOperator(".", 185)).unwrap();
        final BinaryOperator nullAwareDotOperator = operators.registerOperator(new DotOperator("?.", 185)).unwrap();
        operators.registerOperator(new BinaryOperator.Direct<TypedValue>("<=>", 90){

            @Override
            public TypedValue execute(TypedValue left, TypedValue right) {
                return domain.create(BigInteger.class, BigInteger.valueOf(comparator.compare(left, right)));
            }
        });
        final BinaryOperator lambdaOperator = operators.registerOperator(new MarkerBinaryOperator("->", 30, OperatorAssociativity.RIGHT)).unwrap();
        final BinaryOperator splitOperator = operators.registerOperator(new MarkerBinaryOperator("\\", 20, OperatorAssociativity.RIGHT)).unwrap();
        BinaryOperator colonOperator = operators.registerOperator(new BinaryOperator.Direct<TypedValue>(":", 40, OperatorAssociativity.RIGHT){

            @Override
            public TypedValue execute(TypedValue left, TypedValue right) {
                return domain.create(Cons.class, new Cons(left, right));
            }
        }).unwrap();
        final BinaryOperator assignOperator = operators.registerOperator(new BinaryOperator.Direct<TypedValue>("=", 10){

            @Override
            public TypedValue execute(TypedValue left, TypedValue right) {
                return domain.create(Cons.class, new Cons(left, right));
            }
        }).unwrap();
        final BinaryOperator defaultOperator = operators.registerDefaultOperator(new MarkerBinaryOperator("<?>", 185));
        final BinaryOperator nullAwareOperator = operators.registerOperator(new MarkerBinaryOperator("?", 185)).unwrap();
        class TypedValueSymbolMap
        extends TopSymbolMap<TypedValue> {
            final /* synthetic */ TypeDomain val$domain;

            TypedValueSymbolMap(TypeDomain typeDomain) {
                this.val$domain = typeDomain;
            }

            @Override
            protected ISymbol<TypedValue> createSymbol(ICallable<TypedValue> callable) {
                return CallableValue.from(callable).toSymbol(this.val$domain);
            }

            @Override
            protected ISymbol<TypedValue> createSymbol(TypedValue value) {
                if (value.is(CallableValue.class)) {
                    return value.as(CallableValue.class).toSymbol(value);
                }
                if (MetaObjectUtils.isCallable(value)) {
                    return new SlotCallableValueSymbol(value);
                }
                return super.createSymbol(value);
            }
        }
        final TypedValueSymbolMap coreMap = new TypedValueSymbolMap(domain);
        coreMap.put("null", nullValue);
        coreMap.put("true", domain.create(Boolean.class, Boolean.TRUE));
        coreMap.put("false", domain.create(Boolean.class, Boolean.FALSE));
        coreMap.put("NAN", domain.create(Double.class, Double.NaN));
        coreMap.put("INF", domain.create(Double.class, Double.POSITIVE_INFINITY));
        coreMap.put("I", domain.create(Complex.class, Complex.I));
        Environment<TypedValue> env = new Environment<TypedValue>(nullValue){

            @Override
            protected Frame<TypedValue> createTopMap() {
                LocalSymbolMap mainSymbolMap = new LocalSymbolMap(coreMap);
                return new Frame<TypedValue>(mainSymbolMap, new Stack());
            }
        };
        final SymbolMap<TypedValue> envMap = env.topFrame().symbols();
        for (Map.Entry e : basicTypes.entrySet()) {
            envMap.put((String)e.getKey(), (TypedValue)e.getValue());
        }
        GenericFunctions.createStackManipulationFunctions(env);
        env.setGlobalSymbol("E", domain.create(Double.class, Math.E));
        env.setGlobalSymbol("PI", domain.create(Double.class, Math.PI));
        env.setGlobalSymbol("iscallable", (TypedValue)((Object)new UnaryFunction.Direct<TypedValue>(){

            @Override
            protected TypedValue call(TypedValue value) {
                return value.domain.create(Boolean.class, MetaObjectUtils.isCallable(value));
            }
        }));
        env.setGlobalSymbol("isnumber", (TypedValue)((Object)new UnaryFunction.Direct<TypedValue>(){

            @Override
            protected TypedValue call(TypedValue value) {
                return value.domain.create(Boolean.class, NUMBER_TYPES.contains(value.type));
            }
        }));
        env.setGlobalSymbol("type", (TypedValue)((Object)new SlotCaller(){

            @Override
            protected TypedValue callSlot(Frame<TypedValue> frame, TypedValue value, MetaObject metaObject) {
                MetaObject.SlotType slotType = value.getMetaObject().slotType;
                return slotType != null ? slotType.type(value, frame) : nullValue;
            }
        }));
        env.setGlobalSymbol("repr", (TypedValue)((Object)new UnaryFunction.Direct<TypedValue>(){

            @Override
            protected TypedValue call(TypedValue value) {
                return value.domain.create(String.class, valuePrinter.repr(value));
            }
        }));
        TypedValue polar = domain.create(CallableValue.class, CallableValue.from(new SimpleTypedFunction(domain){

            @TypedFunction.Variant
            public Complex convert(Double r, Double phase) {
                return Complex.polar(r, phase);
            }
        }), MetaObject.builder().set(new MetaObject.SlotDecompose(){

            @Override
            public Optional<List<TypedValue>> tryDecompose(TypedValue self, TypedValue input, int variableCount, Frame<TypedValue> frame) {
                Preconditions.checkState((variableCount == 2 ? 1 : 0) != 0, (String)"'polar' can provide 2 values, but code expects %s", (int)variableCount);
                if (input.is(Complex.class)) {
                    Complex value = input.as(Complex.class);
                    TypedValue abs = domain.create(Double.class, value.abs());
                    TypedValue theta = domain.create(Double.class, value.phase());
                    ImmutableList result = ImmutableList.of((Object)abs, (Object)theta);
                    return Optional.of((Object)result);
                }
                return Optional.absent();
            }
        }).update(domain.getDefaultMetaObject(CallableValue.class)));
        env.setGlobalSymbol("polar", polar);
        TypedValue cartesian = domain.create(CallableValue.class, CallableValue.from(new SimpleTypedFunction(domain){

            @TypedFunction.Variant
            public Complex convert(Double x, Double y) {
                return Complex.cartesian(x, y);
            }
        }), MetaObject.builder().set(new MetaObject.SlotDecompose(){

            @Override
            public Optional<List<TypedValue>> tryDecompose(TypedValue self, TypedValue input, int variableCount, Frame<TypedValue> frame) {
                Preconditions.checkState((variableCount == 2 ? 1 : 0) != 0, (String)"'cartesian' can provide 2 values, but code expects %s", (int)variableCount);
                if (input.is(Complex.class)) {
                    Complex value = input.as(Complex.class);
                    TypedValue x = domain.create(Double.class, value.re);
                    TypedValue y = domain.create(Double.class, value.im);
                    ImmutableList result = ImmutableList.of((Object)x, (Object)y);
                    return Optional.of((Object)result);
                }
                return Optional.absent();
            }
        }).update(domain.getDefaultMetaObject(CallableValue.class)));
        env.setGlobalSymbol("cartesian", cartesian);
        env.setGlobalSymbol("number", (TypedValue)((Object)new SimpleTypedFunction(domain){

            @TypedFunction.Variant
            @TypedFunction.RawReturn
            public TypedValue convert(@TypedFunction.RawDispatchArg(value={Boolean.class, BigInteger.class, Double.class, Complex.class}) TypedValue value) {
                return value;
            }

            @TypedFunction.Variant
            @TypedFunction.RawReturn
            public TypedValue convert(@TypedFunction.DispatchArg String value, @TypedFunction.OptionalArgs Optional<BigInteger> radix) {
                int usedRadix = (Integer)radix.transform(INT_UNWRAP).or((Object)valuePrinter.base);
                Pair<BigInteger, Double> result = TypedValueParser.NUMBER_PARSER.parseString(value, usedRadix);
                return TypedValueParser.mergeNumberParts(domain, result);
            }
        }));
        env.setGlobalSymbol("parse", (TypedValue)((Object)new SimpleTypedFunction(domain){
            private final Tokenizer tokenizer;
            {
                super(domain);
                this.tokenizer = new Tokenizer();
            }

            @TypedFunction.Variant
            @TypedFunction.RawReturn
            public TypedValue parse(String value) {
                try {
                    ArrayList tokens = Lists.newArrayList((Iterator)((Object)this.tokenizer.tokenize(value)));
                    Preconditions.checkState((tokens.size() == 1 ? 1 : 0) != 0, (String)"Expected single token from '%', got %s", (Object)value, (int)tokens.size());
                    return valueParser.parseToken((Token)tokens.get(0));
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Failed to parse '" + value + "'", e);
                }
            }
        }));
        env.setGlobalSymbol("isnan", (TypedValue)((Object)new SimpleTypedFunction(domain){

            @TypedFunction.Variant
            public Boolean isNan(Double v) {
                return v.isNaN();
            }
        }));
        env.setGlobalSymbol("isinf", (TypedValue)((Object)new SimpleTypedFunction(domain){

            @TypedFunction.Variant
            public Boolean isInf(Double v) {
                return v.isInfinite();
            }
        }));
        env.setGlobalSymbol("abs", (TypedValue)((Object)new SimpleTypedFunction(domain){

            @TypedFunction.Variant
            public Boolean abs(@TypedFunction.DispatchArg Boolean v) {
                return v;
            }

            @TypedFunction.Variant
            public BigInteger abs(@TypedFunction.DispatchArg BigInteger v) {
                return v.abs();
            }

            @TypedFunction.Variant
            public Double abs(@TypedFunction.DispatchArg Double v) {
                return Math.abs(v);
            }

            @TypedFunction.Variant
            public Double abs(@TypedFunction.DispatchArg Complex v) {
                return v.abs();
            }
        }));
        env.setGlobalSymbol("sqrt", (TypedValue)((Object)new SimpleTypedFunction(domain){

            @TypedFunction.Variant
            public Double sqrt(Double v) {
                return Math.sqrt(v);
            }
        }));
        env.setGlobalSymbol("floor", (TypedValue)((Object)new SimpleTypedFunction(domain){

            @TypedFunction.Variant
            @TypedFunction.RawReturn
            public TypedValue floor(@TypedFunction.RawDispatchArg(value={BigInteger.class, Boolean.class}) TypedValue v) {
                return v;
            }

            @TypedFunction.Variant
            public Double floor(@TypedFunction.DispatchArg Double v) {
                return Math.floor(v);
            }
        }));
        env.setGlobalSymbol("ceil", (TypedValue)((Object)new SimpleTypedFunction(domain){

            @TypedFunction.Variant
            @TypedFunction.RawReturn
            public TypedValue ceil(@TypedFunction.RawDispatchArg(value={BigInteger.class, Boolean.class}) TypedValue v) {
                return v;
            }

            @TypedFunction.Variant
            public Double ceil(@TypedFunction.DispatchArg Double v) {
                return Math.ceil(v);
            }
        }));
        env.setGlobalSymbol("cos", (TypedValue)((Object)new SimpleTypedFunction(domain){

            @TypedFunction.Variant
            public Double cos(Double v) {
                return Math.cos(v);
            }
        }));
        env.setGlobalSymbol("cosh", (TypedValue)((Object)new SimpleTypedFunction(domain){

            @TypedFunction.Variant
            public Double cosh(Double v) {
                return Math.cosh(v);
            }
        }));
        env.setGlobalSymbol("acos", (TypedValue)((Object)new SimpleTypedFunction(domain){

            @TypedFunction.Variant
            public Double acos(Double v) {
                return Math.acos(v);
            }
        }));
        env.setGlobalSymbol("acosh", (TypedValue)((Object)new SimpleTypedFunction(domain){

            @TypedFunction.Variant
            public Double acosh(Double v) {
                return Math.log(v + Math.sqrt(v * v - 1.0));
            }
        }));
        env.setGlobalSymbol("sin", (TypedValue)((Object)new SimpleTypedFunction(domain){

            @TypedFunction.Variant
            public Double sin(Double v) {
                return Math.sin(v);
            }
        }));
        env.setGlobalSymbol("sinh", (TypedValue)((Object)new SimpleTypedFunction(domain){

            @TypedFunction.Variant
            public Double sinh(Double v) {
                return Math.sinh(v);
            }
        }));
        env.setGlobalSymbol("asin", (TypedValue)((Object)new SimpleTypedFunction(domain){

            @TypedFunction.Variant
            public Double asin(Double v) {
                return Math.asin(v);
            }
        }));
        env.setGlobalSymbol("asinh", (TypedValue)((Object)new SimpleTypedFunction(domain){

            @TypedFunction.Variant
            public Double asinh(Double v) {
                return v.isInfinite() ? v : Math.log(v + Math.sqrt(v * v + 1.0));
            }
        }));
        env.setGlobalSymbol("tan", (TypedValue)((Object)new SimpleTypedFunction(domain){

            @TypedFunction.Variant
            public Double tan(Double v) {
                return Math.tan(v);
            }
        }));
        env.setGlobalSymbol("atan", (TypedValue)((Object)new SimpleTypedFunction(domain){

            @TypedFunction.Variant
            public Double atan(Double v) {
                return Math.atan(v);
            }
        }));
        env.setGlobalSymbol("atan2", (TypedValue)((Object)new SimpleTypedFunction(domain){

            @TypedFunction.Variant
            public Double atan2(Double x, Double y) {
                return Math.atan2(x, y);
            }
        }));
        env.setGlobalSymbol("tanh", (TypedValue)((Object)new SimpleTypedFunction(domain){

            @TypedFunction.Variant
            public Double tanh(Double v) {
                return Math.tanh(v);
            }
        }));
        env.setGlobalSymbol("atanh", (TypedValue)((Object)new SimpleTypedFunction(domain){

            @TypedFunction.Variant
            public Double atanh(Double v) {
                return Math.log((1.0 + v) / (1.0 - v)) / 2.0;
            }
        }));
        env.setGlobalSymbol("exp", (TypedValue)((Object)new SimpleTypedFunction(domain){

            @TypedFunction.Variant
            public Double exp(@TypedFunction.DispatchArg(extra={Boolean.class, BigInteger.class}) Double v) {
                return Math.exp(v);
            }

            @TypedFunction.Variant
            public Complex exp(@TypedFunction.DispatchArg Complex v) {
                return v.exp();
            }
        }));
        env.setGlobalSymbol("ln", (TypedValue)((Object)new SimpleTypedFunction(domain){

            @TypedFunction.Variant
            public Double ln(@TypedFunction.DispatchArg(extra={Boolean.class, BigInteger.class}) Double v) {
                return Math.log(v);
            }

            @TypedFunction.Variant
            public Complex ln(@TypedFunction.DispatchArg Complex v) {
                return v.ln();
            }
        }));
        env.setGlobalSymbol("log", (TypedValue)((Object)new SimpleTypedFunction(domain){

            @TypedFunction.Variant
            public Double log(Double v, @TypedFunction.OptionalArgs Optional<Double> base) {
                if (base.isPresent()) {
                    return Math.log(v) / Math.log((Double)base.get());
                }
                return Math.log10(v);
            }
        }));
        env.setGlobalSymbol("sgn", (TypedValue)((Object)new SimpleTypedFunction(domain){

            @TypedFunction.Variant
            public BigInteger sgn(@TypedFunction.DispatchArg(extra={Boolean.class}) BigInteger v) {
                return BigInteger.valueOf(v.signum());
            }

            @TypedFunction.Variant
            public Double sgn(@TypedFunction.DispatchArg Double v) {
                return Math.signum(v);
            }
        }));
        env.setGlobalSymbol("rad", (TypedValue)((Object)new SimpleTypedFunction(domain){

            @TypedFunction.Variant
            public Double rad(Double v) {
                return Math.toRadians(v);
            }
        }));
        env.setGlobalSymbol("deg", (TypedValue)((Object)new SimpleTypedFunction(domain){

            @TypedFunction.Variant
            public Double deg(Double v) {
                return Math.toDegrees(v);
            }
        }));
        env.setGlobalSymbol("modpow", (TypedValue)((Object)new SimpleTypedFunction(domain){

            @TypedFunction.Variant
            public BigInteger modpow(BigInteger v, BigInteger exp, BigInteger mod) {
                return v.modPow(exp, mod);
            }
        }));
        env.setGlobalSymbol("gcd", (TypedValue)((Object)new SimpleTypedFunction(domain){

            @TypedFunction.Variant
            public BigInteger gcd(BigInteger v1, BigInteger v2) {
                return v1.gcd(v2);
            }
        }));
        env.setGlobalSymbol("re", (TypedValue)((Object)new SimpleTypedFunction(domain){

            @TypedFunction.Variant
            public Double re(@TypedFunction.DispatchArg(extra={Boolean.class, BigInteger.class}) Double v) {
                return v;
            }

            @TypedFunction.Variant
            public Double re(@TypedFunction.DispatchArg Complex v) {
                return v.re;
            }
        }));
        env.setGlobalSymbol("im", (TypedValue)((Object)new SimpleTypedFunction(domain){

            @TypedFunction.Variant
            public Double im(@TypedFunction.DispatchArg(extra={Boolean.class, BigInteger.class}) Double v) {
                return 0.0;
            }

            @TypedFunction.Variant
            public Double im(@TypedFunction.DispatchArg Complex v) {
                return v.im;
            }
        }));
        env.setGlobalSymbol("phase", (TypedValue)((Object)new SimpleTypedFunction(domain){

            @TypedFunction.Variant
            public Double phase(@TypedFunction.DispatchArg(extra={Boolean.class, BigInteger.class}) Double v) {
                return 0.0;
            }

            @TypedFunction.Variant
            public Double phase(@TypedFunction.DispatchArg Complex v) {
                return v.phase();
            }
        }));
        env.setGlobalSymbol("conj", (TypedValue)((Object)new SimpleTypedFunction(domain){

            @TypedFunction.Variant
            public Complex conj(@TypedFunction.DispatchArg(extra={Boolean.class, BigInteger.class}) Double v) {
                return Complex.real(v);
            }

            @TypedFunction.Variant
            public Complex conj(@TypedFunction.DispatchArg Complex v) {
                return v.conj();
            }
        }));
        class SelectionAccumulatorFunction
        extends GenericFunctions.StackBasedAccumulatorFunction<TypedValue> {
            private final IExecutable<TypedValue> predicate;

            public SelectionAccumulatorFunction(TypedValue nullValue, IExecutable<TypedValue> op) {
                super(nullValue);
                this.predicate = op;
            }

            @Override
            protected void accumulate(Frame<TypedValue> frame) {
                Stack<TypedValue> stack = frame.stack();
                TypedValue right = stack.peek(0);
                TypedValue left = stack.peek(1);
                this.predicate.execute(frame);
                TypedValue result = stack.pop();
                boolean selectLeft = MetaObjectUtils.boolValue(frame, result);
                stack.push(selectLeft ? left : right);
            }
        }
        env.setGlobalSymbol("min", (TypedValue)((Object)new SelectionAccumulatorFunction(nullValue, ltOperator)));
        env.setGlobalSymbol("max", (TypedValue)((Object)new SelectionAccumulatorFunction(nullValue, gtOperator)));
        env.setGlobalSymbol("sum", (TypedValue)((Object)new GenericFunctions.StackBasedAccumulatorFunction<TypedValue>(nullValue){

            @Override
            protected void accumulate(Frame<TypedValue> frame) {
                addOperator.execute(frame);
            }
        }));
        env.setGlobalSymbol("avg", (TypedValue)((Object)new GenericFunctions.StackBasedAccumulatorFunction<TypedValue>(nullValue){

            @Override
            protected void accumulate(Frame<TypedValue> frame) {
                addOperator.execute(frame);
            }

            @Override
            protected void process(Frame<TypedValue> frame, int argCount) {
                frame.stack().push(domain.create(BigInteger.class, BigInteger.valueOf(argCount)));
                divideOperator.execute(frame);
            }
        }));
        env.setGlobalSymbol("car", (TypedValue)((Object)new SimpleTypedFunction(domain){

            @TypedFunction.Variant
            @TypedFunction.RawReturn
            public TypedValue car(Cons cons) {
                return cons.car;
            }
        }));
        env.setGlobalSymbol("cdr", (TypedValue)((Object)new SimpleTypedFunction(domain){

            @TypedFunction.Variant
            @TypedFunction.RawReturn
            public TypedValue cdr(Cons cons) {
                return cons.cdr;
            }
        }));
        coreMap.put("list", new SingleReturnCallable<TypedValue>(){

            @Override
            public TypedValue call(Frame<TypedValue> frame, OptionalInt argumentsCount) {
                Integer args = argumentsCount.or(0);
                Stack<TypedValue> stack = frame.stack();
                TypedValue result = nullValue;
                for (int i = 0; i < args; ++i) {
                    result = domain.create(Cons.class, new Cons(stack.pop(), result));
                }
                return result;
            }
        });
        env.setGlobalSymbol("len", (TypedValue)((Object)new SlotCaller(){

            @Override
            protected TypedValue callSlot(Frame<TypedValue> frame, TypedValue value, MetaObject metaObject) {
                MetaObject.SlotLength slotLength = metaObject.slotLength;
                Preconditions.checkState((slotLength != null ? 1 : 0) != 0, (String)"Value %s has no length", (Object)value);
                return domain.create(BigInteger.class, BigInteger.valueOf(slotLength.length(value, frame)));
            }
        }));
        env.setGlobalSymbol("execute", (TypedValue)((Object)new ICallable<TypedValue>(){

            @Override
            public void call(Frame<TypedValue> frame, OptionalInt argumentsCount, OptionalInt returnsCount) {
                TypedCalcUtils.expectExactArgCount(argumentsCount, 1);
                Frame<TypedValue> sandboxFrame = FrameFactory.newProtectionFrameWithSubstack(frame, 1);
                Stack<TypedValue> sandboxStack = sandboxFrame.stack();
                TypedValue top = sandboxStack.pop();
                top.as(Code.class, "first argument").execute(sandboxFrame);
                TypedCalcUtils.expectExactReturnCount(returnsCount, sandboxStack.size());
            }
        }));
        env.setGlobalSymbol("slice", (TypedValue)((Object)new BinaryFunction.WithFrame<TypedValue>(){

            @Override
            public TypedValue call(Frame<TypedValue> frame, TypedValue target, TypedValue range) {
                Optional<TypedValue> attr;
                MetaObject.SlotAttr slotAttr;
                MetaObject.SlotSlice slotSlice = target.getMetaObject().slotSlice;
                if (slotSlice != null) {
                    return slotSlice.slice(target, range, frame);
                }
                if (range.is(String.class) && (slotAttr = target.getMetaObject().slotAttr) != null && (attr = slotAttr.attr(target, range.as(String.class), frame)).isPresent()) {
                    return (TypedValue)attr.get();
                }
                throw new IllegalArgumentException("Cannot 'apply' slice operator to " + target + " for key " + range);
            }
        }));
        coreMap.put("apply", new ICallable<TypedValue>(){

            @Override
            public void call(Frame<TypedValue> frame, OptionalInt argumentsCount, OptionalInt returnsCount) {
                Preconditions.checkArgument((boolean)argumentsCount.isPresent(), (Object)"'apply' cannot be called without argument count");
                int args = argumentsCount.get();
                Preconditions.checkArgument((args >= 1 ? 1 : 0) != 0, (Object)"'apply' requires at least one argument");
                TypedValue target = frame.stack().drop(args - 1);
                try {
                    MetaObjectUtils.call(frame, target, OptionalInt.of(args - 1), returnsCount);
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to execute value " + target, e);
                }
            }
        });
        env.setGlobalSymbol("fail", (TypedValue)((Object)new ICallable<TypedValue>(){

            @Override
            public void call(Frame<TypedValue> frame, OptionalInt argumentsCount, OptionalInt returnsCount) {
                if (argumentsCount.isPresent()) {
                    Integer gotArgs = argumentsCount.get();
                    if (gotArgs == 1) {
                        TypedValue cause = frame.stack().pop();
                        throw new ExecutionErrorException(valuePrinter.repr(cause));
                    }
                    Preconditions.checkArgument((gotArgs == 0 ? 1 : 0) != 0, (String)"'fail' expects at most single argument, got %s", (Object)gotArgs);
                }
                throw new ExecutionErrorException();
            }
        }));
        env.setGlobalSymbol("with", (TypedValue)((Object)new ICallable<TypedValue>(){

            @Override
            public void call(Frame<TypedValue> frame, OptionalInt argumentsCount, OptionalInt returnsCount) {
                TypedCalcUtils.expectExactArgCount(argumentsCount, 2);
                TypedValue code = frame.stack().pop();
                code.checkType(Code.class, "Second(code) 'with' parameter");
                TypedValue target = frame.stack().pop();
                CompositeSymbolMap symbolMap = new CompositeSymbolMap(frame.symbols(), target);
                Frame<TypedValue> newFrame = FrameFactory.newClosureFrame(symbolMap, frame, 0);
                code.as(Code.class).execute(newFrame);
                TypedCalcUtils.expectExactReturnCount(returnsCount, newFrame.stack().size());
            }
        }));
        env.setGlobalSymbol("and", (TypedValue)((Object)new LogicFunction.Eager(nullValue){

            @Override
            protected boolean shouldReturn(Frame<TypedValue> scratch, TypedValue arg) {
                return !MetaObjectUtils.boolValue(scratch, arg);
            }
        }));
        env.setGlobalSymbol("or", (TypedValue)((Object)new LogicFunction.Eager(nullValue){

            @Override
            protected boolean shouldReturn(Frame<TypedValue> scratch, TypedValue arg) {
                return MetaObjectUtils.boolValue(scratch, arg);
            }
        }));
        env.setGlobalSymbol("andthen", (TypedValue)((Object)new LogicFunction.Shorting(nullValue){

            @Override
            protected boolean shouldReturn(Frame<TypedValue> scratch, TypedValue arg) {
                return !MetaObjectUtils.boolValue(scratch, arg);
            }
        }));
        env.setGlobalSymbol("orelse", (TypedValue)((Object)new LogicFunction.Shorting(nullValue){

            @Override
            protected boolean shouldReturn(Frame<TypedValue> scratch, TypedValue arg) {
                return MetaObjectUtils.boolValue(scratch, arg);
            }
        }));
        env.setGlobalSymbol("nonnull", (TypedValue)((Object)new LogicFunction.Shorting(nullValue){

            @Override
            public TypedValue call(Frame<TypedValue> frame, OptionalInt argumentsCount) {
                Object result = super.call((Frame)frame, argumentsCount);
                Preconditions.checkState((result != nullValue ? 1 : 0) != 0, (Object)"Returning null value from 'nonnull'");
                return result;
            }

            @Override
            protected boolean shouldReturn(Frame<TypedValue> scratch, TypedValue arg) {
                return arg != nullValue;
            }
        }));
        env.setGlobalSymbol("nexecute", (TypedValue)((Object)new FixedCallable<TypedValue>(2, 1){

            @Override
            public void call(Frame<TypedValue> frame) {
                Stack<TypedValue> stack = frame.stack();
                Code op = stack.pop().as(Code.class, "second nexecute arg");
                TypedValue value = stack.peek(0);
                if (value != nullValue) {
                    Frame<TypedValue> executionFrame = FrameFactory.newProtectionFrameWithSubstack(frame, 1);
                    op.execute(executionFrame);
                    executionFrame.stack().checkSizeIsExactly(1);
                }
            }
        }));
        OptionalType.register(env, nullValue);
        env.setGlobalSymbol("struct", (TypedValue)((Object)new StructSymbol(nullValue)));
        env.setGlobalSymbol("dict", new DictSymbol(nullValue).value());
        env.setGlobalSymbol("globals", (TypedValue)((Object)new NullaryFunction.Direct<TypedValue>(){

            @Override
            protected TypedValue call() {
                return domain.create(EnvHolder.class, new EnvHolder(envMap));
            }
        }));
        env.setGlobalSymbol("locals", (TypedValue)((Object)new FixedCallable<TypedValue>(0, 1){

            @Override
            public void call(Frame<TypedValue> frame) {
                frame.stack().push(domain.create(EnvHolder.class, new EnvHolder(frame.symbols())));
            }
        }));
        env.setGlobalSymbol("applyvar", (TypedValue)((Object)new ICallable<TypedValue>(){

            @Override
            public void call(Frame<TypedValue> frame, OptionalInt argumentsCount, OptionalInt returnsCount) {
                Preconditions.checkArgument((boolean)argumentsCount.isPresent(), (Object)"'applyvar' cannot be called without argument count");
                int args = argumentsCount.get();
                Preconditions.checkArgument((args >= 2 ? 1 : 0) != 0, (Object)"'applyvar' requires at least two args");
                Stack<TypedValue> stack = frame.stack();
                TypedValue varArgs = stack.pop();
                TypedValue target = stack.drop(args - 1 - 1);
                int totalArgs = args - 1 - 1;
                for (TypedValue varArg : Cons.toIterable(varArgs, nullValue)) {
                    stack.push(varArg);
                    ++totalArgs;
                }
                try {
                    MetaObjectUtils.call(frame, target, OptionalInt.of(totalArgs), returnsCount);
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to execute value " + target, e);
                }
            }
        }));
        env.setGlobalSymbol("dir", (TypedValue)((Object)new UnaryFunction.WithFrame<TypedValue>(){

            @Override
            protected TypedValue call(Frame<TypedValue> frame, TypedValue value) {
                MetaObject.SlotDir slotDir = value.getMetaObject().slotDir;
                Preconditions.checkState((slotDir != null ? 1 : 0) != 0, (String)"Value %s has no dir slot", (Object)value);
                Iterable<String> dir = slotDir.dir(value, frame);
                ArrayList sortedDir = Lists.newArrayList(dir);
                Collections.sort(sortedDir);
                ImmutableList wrappedResults = ImmutableList.copyOf((Iterable)Iterables.transform((Iterable)sortedDir, domain.createWrappingTransformer(String.class)));
                return Cons.createList((List<TypedValue>)wrappedResults, nullValue);
            }
        }));
        env.setGlobalSymbol("random", new LibRandom(domain).type());
        LibListFunctions.register(env);
        LibFunctional.register(env);
        BindPatternTranslator.registerType(domain);
        PatternSymbol.register(coreMap, env);
        MetaObjectSymbols.register(env);
        RegexSymbol.register(env);
        StructWrapper.register(env);
        final IfExpressionFactory ifFactory = new IfExpressionFactory(domain);
        ifFactory.registerSymbol(env);
        final LetExpressionFactory letFactory = new LetExpressionFactory(domain, nullValue, colonOperator, assignOperator, lambdaOperator, varArgMarker);
        letFactory.registerSymbol(env);
        final LambdaExpressionFactory lambdaFactory = new LambdaExpressionFactory(nullValue, varArgMarker);
        lambdaFactory.registerSymbol(env);
        final PromiseExpressionFactory delayFactory = new PromiseExpressionFactory(domain);
        delayFactory.registerSymbols(env);
        final MatchExpressionFactory matchFactory = new MatchExpressionFactory(domain, splitOperator, lambdaOperator);
        matchFactory.registerSymbols(envMap, coreMap);
        final AltExpressionFactory altFactory = new AltExpressionFactory(domain, nullValue, colonOperator, assignOperator, splitOperator);
        altFactory.registerSymbol(env);
        final DoExpressionFactory doFactory = new DoExpressionFactory(domain);
        doFactory.registerSymbol(env);
        class TypedValueCompilersFactory
        extends BasicCompilerMapFactory<TypedValue> {
            TypedValueCompilersFactory() {
            }

            @Override
            protected MappedParserState<IExprNode<TypedValue>> createCompilerState(IAstParser<IExprNode<TypedValue>> parser) {
                return new MappedParserState<IExprNode<TypedValue>>(parser){

                    @Override
                    protected IExprNode<TypedValue> createDefaultSymbolNode(String symbol, List<IExprNode<TypedValue>> children) {
                        return new VarArgSymbolCallNode(varArgMarker, symbol, children);
                    }

                    @Override
                    protected IModifierStateTransition<IExprNode<TypedValue>> createDefaultModifierStateTransition(String modifier) {
                        throw new UnsupportedOperationException(modifier);
                    }
                };
            }

            @Override
            protected void configureCompilerStateCommon(MappedParserState<IExprNode<TypedValue>> compilerState, Environment<TypedValue> environment) {
                compilerState.addStateTransition("quote", new QuoteStateTransition.ForSymbol(domain, nullValue, valueParser));
                compilerState.addStateTransition("code", new CodeStateTransition(domain, compilerState));
                compilerState.addStateTransition("if", ifFactory.createStateTransition(compilerState));
                compilerState.addStateTransition("let", letFactory.createLetStateTransition(compilerState));
                compilerState.addStateTransition("letseq", letFactory.createLetSeqStateTransition(compilerState));
                compilerState.addStateTransition("letrec", letFactory.createLetRecStateTransition(compilerState));
                compilerState.addStateTransition("delay", delayFactory.createStateTransition(compilerState));
                compilerState.addStateTransition("match", matchFactory.createStateTransition(compilerState));
                compilerState.addStateTransition("andthen", new LazyArgsSymbolTransition(compilerState, domain, "andthen"));
                compilerState.addStateTransition("orelse", new LazyArgsSymbolTransition(compilerState, domain, "orelse"));
                compilerState.addStateTransition("nonnull", new LazyArgsSymbolTransition(compilerState, domain, "nonnull"));
                compilerState.addStateTransition("const", new ConstantSymbolStateTransition<TypedValue>(compilerState, environment, "const"));
                compilerState.addStateTransition("alt", altFactory.createStateTransition(compilerState));
                compilerState.addStateTransition("do", doFactory.createStateTransition(compilerState));
                compilerState.addStateTransition("#", new QuoteStateTransition.ForModifier(domain, nullValue, valueParser));
                compilerState.addStateTransition("@", new CallableGetModifierTransition(domain, operators));
                compilerState.addStateTransition("$", new StringInterpolate.StringInterpolateModifier(domain, valuePrinter));
            }

            @Override
            protected DefaultExprNodeFactory<TypedValue> createExprNodeFactory(IValueParser<TypedValue> valueParser2) {
                return new MappedExprNodeFactory<TypedValue>(valueParser2).addFactory(dotOperator, new MappedExprNodeFactory.IBinaryExprNodeFactory<TypedValue>(){

                    @Override
                    public IExprNode<TypedValue> create(IExprNode<TypedValue> leftChild, IExprNode<TypedValue> rightChild) {
                        return new DotExprNode.Basic(varArgMarker, leftChild, rightChild, dotOperator, domain);
                    }
                }).addFactory(nullAwareDotOperator, new MappedExprNodeFactory.IBinaryExprNodeFactory<TypedValue>(){

                    @Override
                    public IExprNode<TypedValue> create(IExprNode<TypedValue> leftChild, IExprNode<TypedValue> rightChild) {
                        return new DotExprNode.NullAware(leftChild, rightChild, nullAwareDotOperator, domain);
                    }
                }).addFactory(lambdaOperator, lambdaFactory.createLambdaExprNodeFactory(lambdaOperator)).addFactory(varArgMarker, new MarkerUnaryOperatorNodeFactory(varArgMarker)).addFactory(assignOperator, new SingularBinaryOperatorNodeFactory(assignOperator)).addFactory(splitOperator, new MarkerBinaryOperatorNodeFactory(splitOperator)).addFactory(andOperator, LazyBinaryOperatorNode.createFactory(andOperator, domain, "andthen")).addFactory(orOperator, LazyBinaryOperatorNode.createFactory(orOperator, domain, "orelse")).addFactory(nonNullOperator, LazyBinaryOperatorNode.createFactory(nonNullOperator, domain, "nonnull")).addFactory(defaultOperator, new MappedExprNodeFactory.IBinaryExprNodeFactory<TypedValue>(){

                    @Override
                    public IExprNode<TypedValue> create(IExprNode<TypedValue> leftChild, IExprNode<TypedValue> rightChild) {
                        if (rightChild instanceof SquareBracketContainerNode) {
                            return new SliceCallNode(leftChild, rightChild);
                        }
                        if (rightChild instanceof ArgBracketNode && !TypedValueCalculatorFactory.isNumericValueNode(leftChild)) {
                            if (leftChild instanceof SymbolGetNode) {
                                String symbol = ((SymbolGetNode)leftChild).symbol();
                                ImmutableList args = ImmutableList.copyOf(rightChild.getChildren());
                                return new VarArgSymbolCallNode(varArgMarker, symbol, (List<? extends IExprNode<TypedValue>>)args);
                            }
                            return new ApplyCallNode(varArgMarker, leftChild, rightChild);
                        }
                        return new BinaryOpNode<TypedValue>(multiplyOperator, leftChild, rightChild);
                    }
                }).addFactory(nullAwareOperator, new MappedExprNodeFactory.IBinaryExprNodeFactory<TypedValue>(){

                    @Override
                    public IExprNode<TypedValue> create(IExprNode<TypedValue> leftChild, IExprNode<TypedValue> rightChild) {
                        if (rightChild instanceof SquareBracketContainerNode) {
                            return new SliceCallNode.NullAware(leftChild, rightChild, domain);
                        }
                        if (rightChild instanceof ArgBracketNode) {
                            return new ApplyCallNode.NullAware(varArgMarker, leftChild, rightChild, domain);
                        }
                        throw new UnsupportedOperationException("Operator '?' cannot be used with " + rightChild);
                    }
                }).addFactory("[", new MappedExprNodeFactory.IBracketExprNodeFactory<TypedValue>(){

                    @Override
                    public IExprNode<TypedValue> create(List<IExprNode<TypedValue>> children) {
                        return new ListBracketNode(children);
                    }
                }).addFactory("(", new MappedExprNodeFactory.IBracketExprNodeFactory<TypedValue>(){

                    @Override
                    public IExprNode<TypedValue> create(List<IExprNode<TypedValue>> children) {
                        return new ArgBracketNode(children);
                    }
                }).addFactory("{", new MappedExprNodeFactory.IBracketExprNodeFactory<TypedValue>(){

                    @Override
                    public IExprNode<TypedValue> create(List<IExprNode<TypedValue>> children) {
                        Preconditions.checkState((children.size() == 1 ? 1 : 0) != 0, (Object)"Expected only one expression in curly brackets");
                        return new RawCodeExprNode(domain, children.get(0));
                    }
                });
            }

            @Override
            protected ITokenStreamCompiler<TypedValue> createPostfixParser(final IValueParser<TypedValue> valueParser2, final IOperatorDictionary<Operator<TypedValue>> operators2, Environment<TypedValue> env) {
                MappedPostfixParser parser = TypedValueCompilersFactory.addConstantEvaluatorState(valueParser2, operators2, env, new MappedPostfixParser<IExecutable<TypedValue>>(){

                    @Override
                    protected IExecutableListBuilder<IExecutable<TypedValue>> createListBuilder() {
                        return new DefaultExecutableListBuilder<TypedValue>(valueParser2, operators2);
                    }
                }).addModifierStateProvider("#", new MappedPostfixParser.IStateProvider<IExecutable<TypedValue>>(){

                    @Override
                    public IPostfixParserState<IExecutable<TypedValue>> createState() {
                        return new QuotePostfixCompilerState(valueParser2, domain);
                    }
                }).addBracketStateProvider("{", new MappedPostfixParser.IStateProvider<IExecutable<TypedValue>>(){

                    @Override
                    public IPostfixParserState<IExecutable<TypedValue>> createState() {
                        DefaultExecutableListBuilder<TypedValue> listBuilder = new DefaultExecutableListBuilder<TypedValue>(valueParser2, operators2);
                        return new CodePostfixCompilerState(domain, listBuilder, "{");
                    }
                }).addModifierStateProvider("@", new MappedPostfixParser.IStateProvider<IExecutable<TypedValue>>(){

                    @Override
                    public IPostfixParserState<IExecutable<TypedValue>> createState() {
                        return new CallableGetPostfixCompilerState(operators2, domain);
                    }
                }).addModifierStateProvider("$", new MappedPostfixParser.IStateProvider<IExecutable<TypedValue>>(){

                    @Override
                    public IPostfixParserState<IExecutable<TypedValue>> createState() {
                        return new StringInterpolate.StringInterpolatePostfixCompilerState(domain, valuePrinter);
                    }
                });
                return new PostfixCompiler<TypedValue>(parser);
            }

            @Override
            protected void setupPrefixTokenizer(Tokenizer tokenizer) {
                super.setupPrefixTokenizer(tokenizer);
                tokenizer.addModifier("#");
                tokenizer.addModifier("...");
                tokenizer.addModifier("@");
                tokenizer.addModifier("$");
            }

            @Override
            protected void setupInfixTokenizer(Tokenizer tokenizer) {
                super.setupInfixTokenizer(tokenizer);
                tokenizer.addModifier("#");
                tokenizer.addModifier("...");
                tokenizer.addModifier("@");
                tokenizer.addModifier("$");
            }

            @Override
            protected void setupPostfixTokenizer(Tokenizer tokenizer) {
                super.setupPostfixTokenizer(tokenizer);
                tokenizer.addModifier("#");
                tokenizer.addModifier("$");
            }
        }
        Compilers<TypedValue, ExprType> compilers = new TypedValueCompilersFactory().create(nullValue, valueParser, operators, env);
        env.setGlobalSymbol("eval", (TypedValue)((Object)new EvalSymbol(compilers)));
        return new Calculator<TypedValue, ExprType>(env, compilers, valuePrinter);
    }

    private static abstract class SlotCaller
    extends FixedCallable<TypedValue> {
        public SlotCaller() {
            super(1, 1);
        }

        @Override
        public void call(Frame<TypedValue> frame) {
            TypedValue value = frame.stack().pop();
            frame.stack().push(this.callSlot(frame, value, value.getMetaObject()));
        }

        protected abstract TypedValue callSlot(Frame<TypedValue> var1, TypedValue var2, MetaObject var3);
    }

    private static class EnvHolder {
        public final SymbolMap<TypedValue> symbols;

        public EnvHolder(SymbolMap<TypedValue> symbols) {
            this.symbols = symbols;
        }
    }

    private static class SingularBinaryOperatorNodeFactory
    implements MappedExprNodeFactory.IBinaryExprNodeFactory<TypedValue> {
        private final BinaryOperator<TypedValue> op;

        public SingularBinaryOperatorNodeFactory(BinaryOperator<TypedValue> op) {
            this.op = op;
        }

        @Override
        public IExprNode<TypedValue> create(IExprNode<TypedValue> leftChild, IExprNode<TypedValue> rightChild) {
            this.checkChild(leftChild);
            this.checkChild(rightChild);
            return new BinaryOpNode<TypedValue>(this.op, leftChild, rightChild);
        }

        private void checkChild(IExprNode<TypedValue> child) {
            if (child instanceof BinaryOpNode) {
                BinaryOpNode childOpNode = (BinaryOpNode)child;
                if (childOpNode.operator == this.op) {
                    throw new UnsupportedOperationException("Operator " + this.op.id + "(" + this.op + ") cannot be chained");
                }
            }
        }
    }

    private static class MarkerBinaryOperatorNodeFactory
    implements MappedExprNodeFactory.IBinaryExprNodeFactory<TypedValue> {
        private final BinaryOperator<TypedValue> op;

        public MarkerBinaryOperatorNodeFactory(BinaryOperator<TypedValue> op) {
            this.op = op;
        }

        @Override
        public IExprNode<TypedValue> create(IExprNode<TypedValue> leftChild, IExprNode<TypedValue> rightChild) {
            return new BinaryOpNode<TypedValue>(this.op, leftChild, rightChild){

                @Override
                public void flatten(List<IExecutable<TypedValue>> output) {
                    throw new UnsupportedOperationException("Operator " + op + " cannot be used in this context");
                }
            };
        }
    }

    private static class MarkerBinaryOperator
    extends BinaryOperator.Direct<TypedValue> {
        private MarkerBinaryOperator(String id, int precendence) {
            super(id, precendence);
        }

        public MarkerBinaryOperator(String id, int precedence, OperatorAssociativity associativity) {
            super(id, precedence, associativity);
        }

        @Override
        public TypedValue execute(TypedValue left, TypedValue right) {
            throw new UnsupportedOperationException();
        }
    }

    private static class MarkerUnaryOperatorNodeFactory
    implements MappedExprNodeFactory.IUnaryExprNodeFactory<TypedValue> {
        private final UnaryOperator<TypedValue> op;

        public MarkerUnaryOperatorNodeFactory(UnaryOperator<TypedValue> op) {
            this.op = op;
        }

        @Override
        public IExprNode<TypedValue> create(IExprNode<TypedValue> arg) {
            return new UnaryOpNode<TypedValue>(this.op, arg){

                @Override
                public void flatten(List<IExecutable<TypedValue>> output) {
                    throw new UnsupportedOperationException("Operator " + op + " cannot be used in this context");
                }
            };
        }
    }

    private static class MarkerUnaryOperator
    extends UnaryOperator.Direct<TypedValue> {
        public MarkerUnaryOperator(String id) {
            super(id, 180);
        }

        @Override
        public TypedValue execute(TypedValue value) {
            throw new UnsupportedOperationException();
        }
    }
}

