/*
 * Decompiled with CFR 0.152.
 */
package info.openmods.calc.types.multi;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Maps;
import com.google.common.collect.Table;
import com.google.common.reflect.TypeToken;
import info.openmods.calc.Frame;
import info.openmods.calc.executable.BinaryOperator;
import info.openmods.calc.parsing.ast.OperatorAssociativity;
import info.openmods.calc.types.multi.MetaObject;
import info.openmods.calc.types.multi.TypeDomain;
import info.openmods.calc.types.multi.TypedValue;
import info.openmods.calc.utils.Stack;
import info.openmods.calc.utils.reflection.TypeVariableHolder;
import info.openmods.calc.utils.reflection.TypeVariableHolderFiller;
import java.lang.reflect.TypeVariable;
import java.util.Map;

public class TypedBinaryOperator {

    private static class NonMeta
    extends BinaryOperator.Direct<TypedValue> {
        private final Logic logic;

        public NonMeta(String id, int precedence, OperatorAssociativity associativity, Logic logic) {
            super(id, precedence, associativity);
            this.logic = logic;
        }

        @Override
        public TypedValue execute(TypedValue left, TypedValue right) {
            return this.logic.execute(left, right);
        }
    }

    private static class Meta
    extends BinaryOperator.StackBased<TypedValue> {
        private final Logic logic;

        public Meta(String id, int precedence, OperatorAssociativity associativity, Logic logic) {
            super(id, precedence, associativity);
            this.logic = logic;
        }

        @Override
        public void executeOnStack(Frame<TypedValue> frame) {
            Stack<TypedValue> stack = frame.stack();
            TypedValue right = stack.pop();
            TypedValue left = stack.pop();
            MetaObject.SlotBinaryOp slotBinaryOp = left.getMetaObject().slotsBinaryOps.get(this.id);
            TypedValue result = slotBinaryOp != null ? slotBinaryOp.op(left, right, frame) : this.logic.execute(left, right);
            stack.push(result);
        }
    }

    private static class Logic {
        private final String id;
        private final Map<Class<?>, IGenericOperation> coercedOperations;
        private final Table<Class<?>, Class<?>, IGenericOperation> variantOperations;
        private final IDefaultOperation defaultOperation;
        private final TypeDomain domain;

        private Logic(String id, TypeDomain domain, Map<Class<?>, IGenericOperation> coercedOperations, Table<Class<?>, Class<?>, IGenericOperation> variantOperations, IDefaultOperation defaultOperation) {
            this.id = id;
            this.coercedOperations = ImmutableMap.copyOf(coercedOperations);
            this.variantOperations = ImmutableTable.copyOf(variantOperations);
            this.defaultOperation = defaultOperation;
            this.domain = domain;
        }

        private TypedValue execute(TypedValue left, TypedValue right) {
            Optional<TypedValue> result;
            IGenericOperation op;
            Preconditions.checkArgument((left.domain == this.domain ? 1 : 0) != 0, (String)"Left argument belongs to different domain: %s", (Object)left);
            Preconditions.checkArgument((right.domain == this.domain ? 1 : 0) != 0, (String)"Right argument belongs different domain: %s", (Object)right);
            TypeDomain.Coercion coercionRule = this.domain.getCoercionRule(left.type, right.type);
            if (coercionRule == TypeDomain.Coercion.TO_LEFT ? (op = this.coercedOperations.get(left.type)) != null : coercionRule == TypeDomain.Coercion.TO_RIGHT && (op = this.coercedOperations.get(right.type)) != null) {
                return op.apply(this.domain, left, right);
            }
            op = (IGenericOperation)this.variantOperations.get(left.type, right.type);
            if (op != null) {
                return op.apply(this.domain, left, right);
            }
            if (this.defaultOperation != null && (result = this.defaultOperation.apply(this.domain, left, right)).isPresent()) {
                return (TypedValue)result.get();
            }
            throw new IllegalArgumentException(String.format("Can't apply operation '%s' on values %s,%s", this.id, left, right));
        }
    }

    public static class Builder {
        private final String id;
        private final int precedence;
        private final OperatorAssociativity associativity;
        private final Map<Class<?>, IGenericOperation> coercedOperations = Maps.newHashMap();
        private final Table<Class<?>, Class<?>, IGenericOperation> variantOperations = HashBasedTable.create();
        private IDefaultOperation defaultOperation;
        private boolean addMetaObjectOverride = true;

        public Builder(String id, int precedence, OperatorAssociativity associativity) {
            this.id = id;
            this.precedence = precedence;
            this.associativity = associativity;
        }

        public Builder(String id, int precedence) {
            this(id, precedence, BinaryOperator.DEFAULT_ASSOCIATIVITY);
        }

        private static <T> Class<T> resolveVariable(TypeToken<?> token, TypeVariable<?> var) {
            return token.resolveType(var).getRawType();
        }

        private Builder registerCoercedOperation(Class<?> type, IGenericOperation op) {
            IGenericOperation prev = this.coercedOperations.put(type, op);
            Preconditions.checkState((prev == null ? 1 : 0) != 0, (String)"Duplicate operation registration on operator '%s', type: %s", (Object)this.id, type);
            return this;
        }

        public <T> Builder registerOperation(Class<T> type, ICoercedOperation<? super T> op) {
            return this.registerCoercedOperation(type, Builder.createOperationWrapper(type, op));
        }

        private static <T> IGenericOperation createOperationWrapper(final Class<T> type, final ICoercedOperation<? super T> op) {
            return new IGenericOperation(){

                @Override
                public TypedValue apply(TypeDomain domain, TypedValue left, TypedValue right) {
                    Object leftValue = left.unwrap(type);
                    Object rightValue = right.unwrap(type);
                    return op.apply(domain, leftValue, rightValue);
                }

                @Override
                public void validate(TypeDomain domain) {
                    Preconditions.checkState((boolean)domain.isKnownType(type), (String)"Type %s not in domain", (Object)type);
                }
            };
        }

        public <T, O> Builder registerOperation(Class<T> type, Class<O> output, ISimpleCoercedOperation<? super T, ? extends O> op) {
            return this.registerCoercedOperation(type, Builder.createOperationWrapper(type, output, op));
        }

        private static <T, O> IGenericOperation createOperationWrapper(final Class<T> type, final Class<O> output, final ISimpleCoercedOperation<? super T, ? extends O> op) {
            return new IGenericOperation(){

                @Override
                public TypedValue apply(TypeDomain domain, TypedValue left, TypedValue right) {
                    Object leftValue = left.unwrap(type);
                    Object rightValue = right.unwrap(type);
                    Object result = op.apply(leftValue, rightValue);
                    return domain.create(output, result);
                }

                @Override
                public void validate(TypeDomain domain) {
                    Preconditions.checkState((boolean)domain.isKnownType(type), (String)"Parameter type %s not in domain", (Object)type);
                    Preconditions.checkState((boolean)domain.isKnownType(output), (String)"Output type %s not in domain", (Object)output);
                }
            };
        }

        public <T> Builder registerOperation(ICoercedOperation<T> op) {
            TypeToken token = TypeToken.of(op.getClass());
            Class<T> type = Builder.resolveVariable(token, TypeVariableHolders.CoercedOperation.T);
            return this.registerOperation(type, op);
        }

        public <T, O> Builder registerOperation(ISimpleCoercedOperation<T, O> op) {
            TypeToken token = TypeToken.of(op.getClass());
            Class<T> type = Builder.resolveVariable(token, TypeVariableHolders.SimpleCoercedOperation.T);
            Class<T> output = Builder.resolveVariable(token, TypeVariableHolders.SimpleCoercedOperation.O);
            return this.registerOperation(type, output, op);
        }

        private Builder registerVariantOperation(Class<?> left, Class<?> right, IGenericOperation op) {
            IGenericOperation prev = (IGenericOperation)this.variantOperations.put(left, right, (Object)op);
            Preconditions.checkState((prev == null ? 1 : 0) != 0, (String)"Duplicate operation registration on operator '%s', types: %s, %s", (Object)this.id, left, right);
            return this;
        }

        public <L, R> Builder registerOperation(Class<? extends L> left, Class<? extends R> right, IVariantOperation<? super L, ? super R> op) {
            return this.registerVariantOperation(left, right, Builder.createOperationWrapper(left, right, op));
        }

        private static <L, R> IGenericOperation createOperationWrapper(final Class<? extends L> left, final Class<? extends R> right, final IVariantOperation<? super L, ? super R> op) {
            return new IGenericOperation(){

                @Override
                public TypedValue apply(TypeDomain domain, TypedValue leftArg, TypedValue rightArg) {
                    Object leftValue = leftArg.unwrap(left);
                    Object rightValue = rightArg.unwrap(right);
                    return op.apply(domain, leftValue, rightValue);
                }

                @Override
                public void validate(TypeDomain domain) {
                    Preconditions.checkState((boolean)domain.isKnownType(left), (String)"Left parameter type %s not in domain", (Object)left);
                    Preconditions.checkState((boolean)domain.isKnownType(right), (String)"Right parameter type %s not in domain", (Object)right);
                }
            };
        }

        public <L, R, O> Builder registerOperation(Class<? extends L> left, Class<? extends R> right, Class<? super O> output, ISimpleVariantOperation<? super L, ? super R, ? extends O> op) {
            return this.registerVariantOperation(left, right, Builder.createOperationWrapper(left, right, output, op));
        }

        private static <O, R, L> IGenericOperation createOperationWrapper(final Class<? extends L> left, final Class<? extends R> right, final Class<? super O> output, final ISimpleVariantOperation<? super L, ? super R, ? extends O> op) {
            return new IGenericOperation(){

                @Override
                public TypedValue apply(TypeDomain domain, TypedValue leftArg, TypedValue rightArg) {
                    Object leftValue = leftArg.unwrap(left);
                    Object rightValue = rightArg.unwrap(right);
                    Object result = op.apply(leftValue, rightValue);
                    return domain.create(output, result);
                }

                @Override
                public void validate(TypeDomain domain) {
                    Preconditions.checkState((boolean)domain.isKnownType(left), (String)"Left parameter type %s not in domain", (Object)left);
                    Preconditions.checkState((boolean)domain.isKnownType(right), (String)"Right parameter type %s not in domain", (Object)right);
                    Preconditions.checkState((boolean)domain.isKnownType(output), (String)"Output type %s not in domain", (Object)output);
                }
            };
        }

        public <L, R> Builder registerOperation(IVariantOperation<L, R> op) {
            TypeToken token = TypeToken.of(op.getClass());
            Class left = Builder.resolveVariable(token, TypeVariableHolders.VariantOperation.L);
            Class right = Builder.resolveVariable(token, TypeVariableHolders.VariantOperation.R);
            return this.registerOperation(left, right, op);
        }

        public <L, R, O> Builder registerOperation(ISimpleVariantOperation<L, R, O> op) {
            TypeToken token = TypeToken.of(op.getClass());
            Class left = Builder.resolveVariable(token, TypeVariableHolders.SimpleVariantOperation.L);
            Class right = Builder.resolveVariable(token, TypeVariableHolders.SimpleVariantOperation.R);
            Class output = Builder.resolveVariable(token, TypeVariableHolders.SimpleVariantOperation.O);
            return this.registerOperation(left, right, output, op);
        }

        public Builder setDefaultOperation(IDefaultOperation defaultOperation) {
            this.defaultOperation = defaultOperation;
            return this;
        }

        public Builder setNoMetaObjectOverride() {
            this.addMetaObjectOverride = false;
            return this;
        }

        public BinaryOperator<TypedValue> build(TypeDomain domain) {
            for (IGenericOperation op : this.coercedOperations.values()) {
                op.validate(domain);
            }
            for (IGenericOperation op : this.variantOperations.values()) {
                op.validate(domain);
            }
            Logic logic = new Logic(this.id, domain, this.coercedOperations, this.variantOperations, this.defaultOperation);
            return this.addMetaObjectOverride ? new Meta(this.id, this.precedence, this.associativity, logic) : new NonMeta(this.id, this.precedence, this.associativity, logic);
        }

        static {
            TypeVariableHolderFiller.instance.initialize(TypeVariableHolders.class);
        }

        private static class TypeVariableHolders {
            private TypeVariableHolders() {
            }

            @TypeVariableHolder(value=ISimpleVariantOperation.class)
            public static class SimpleVariantOperation {
                public static TypeVariable<?> L;
                public static TypeVariable<?> R;
                public static TypeVariable<?> O;
            }

            @TypeVariableHolder(value=IVariantOperation.class)
            public static class VariantOperation {
                public static TypeVariable<?> L;
                public static TypeVariable<?> R;
            }

            @TypeVariableHolder(value=ISimpleCoercedOperation.class)
            public static class SimpleCoercedOperation {
                public static TypeVariable<?> T;
                public static TypeVariable<?> O;
            }

            @TypeVariableHolder(value=ICoercedOperation.class)
            public static class CoercedOperation {
                public static TypeVariable<?> T;
            }
        }
    }

    private static interface IGenericOperation {
        public TypedValue apply(TypeDomain var1, TypedValue var2, TypedValue var3);

        public void validate(TypeDomain var1);
    }

    public static interface IDefaultOperation {
        public Optional<TypedValue> apply(TypeDomain var1, TypedValue var2, TypedValue var3);
    }

    public static interface ISimpleVariantOperation<L, R, O> {
        public O apply(L var1, R var2);
    }

    public static interface IVariantOperation<L, R> {
        public TypedValue apply(TypeDomain var1, L var2, R var3);
    }

    public static interface ISimpleCoercedOperation<T, O> {
        public O apply(T var1, T var2);
    }

    public static interface ICoercedOperation<T> {
        public TypedValue apply(TypeDomain var1, T var2, T var3);
    }
}

