/*
 * Decompiled with CFR 0.152.
 */
package info.openmods.calc.types.multi;

import info.openmods.calc.Frame;
import info.openmods.calc.FrameFactory;
import info.openmods.calc.symbol.SingleReturnCallable;
import info.openmods.calc.types.multi.Code;
import info.openmods.calc.types.multi.TypedValue;
import info.openmods.calc.utils.OptionalInt;
import info.openmods.calc.utils.Stack;
import java.util.Iterator;

public abstract class LogicFunction
extends SingleReturnCallable<TypedValue> {
    private final TypedValue nullValue;

    public LogicFunction(TypedValue nullValue) {
        this.nullValue = nullValue;
    }

    @Override
    public TypedValue call(Frame<TypedValue> frame, OptionalInt argumentsCount) {
        TypedValue arg;
        int argCount = argumentsCount.or(2);
        if (argCount == 0) {
            return this.nullValue;
        }
        Stack<TypedValue> args = frame.stack().substack(argCount);
        Iterator<TypedValue> it = args.iterator();
        Frame<TypedValue> scratchFrame = FrameFactory.newLocalFrame(frame);
        Stack<TypedValue> scratchStack = scratchFrame.stack();
        do {
            this.execute(scratchFrame, it.next());
            arg = scratchStack.pop();
            scratchStack.checkIsEmpty();
        } while (!this.shouldReturn(scratchFrame, arg) && it.hasNext());
        args.clear();
        return arg;
    }

    protected abstract boolean shouldReturn(Frame<TypedValue> var1, TypedValue var2);

    protected abstract void execute(Frame<TypedValue> var1, TypedValue var2);

    public static abstract class Shorting
    extends LogicFunction {
        public Shorting(TypedValue nullValue) {
            super(nullValue);
        }

        @Override
        protected void execute(Frame<TypedValue> scratch, TypedValue value) {
            Code code = value.as(Code.class);
            code.execute(scratch);
            scratch.stack().checkSizeIsExactly(1);
        }
    }

    public static abstract class Eager
    extends LogicFunction {
        public Eager(TypedValue nullValue) {
            super(nullValue);
        }

        @Override
        protected void execute(Frame<TypedValue> scratch, TypedValue value) {
            scratch.stack().push(value);
        }
    }
}

