/*
 * Decompiled with CFR 0.152.
 */
package info.openmods.calc.types.bool;

import info.openmods.calc.Calculator;
import info.openmods.calc.Environment;
import info.openmods.calc.ExprType;
import info.openmods.calc.IValuePrinter;
import info.openmods.calc.SimpleCalculatorFactory;
import info.openmods.calc.executable.BinaryOperator;
import info.openmods.calc.executable.Operator;
import info.openmods.calc.executable.OperatorDictionary;
import info.openmods.calc.executable.UnaryOperator;
import info.openmods.calc.parsing.BasicCompilerMapFactory;
import info.openmods.calc.parsing.CommonSimpleSymbolFactory;
import info.openmods.calc.parsing.IValueParser;
import info.openmods.calc.symbol.NullaryFunction;
import info.openmods.calc.types.bool.BoolParser;
import info.openmods.calc.types.bool.BoolPrinter;
import java.util.Random;

public class BoolCalculatorFactory<M>
extends SimpleCalculatorFactory<Boolean, M> {
    private static final int PRIORITY_AND = 4;
    private static final int PRIORITY_OR = 3;
    private static final int PRIORITY_COMPARE = 2;
    private static final int PRIORITY_ASSIGN = 1;

    @Override
    protected IValueParser<Boolean> getValueParser() {
        return new BoolParser();
    }

    @Override
    protected Boolean getNullValue() {
        return Boolean.FALSE;
    }

    @Override
    protected IValuePrinter<Boolean> createValuePrinter() {
        return new BoolPrinter();
    }

    @Override
    protected void configureEnvironment(Environment<Boolean> env) {
        env.setGlobalSymbol("true", Boolean.TRUE);
        env.setGlobalSymbol("false", Boolean.FALSE);
        final Random random = new Random();
        env.setGlobalSymbol("rand", (Boolean)((Object)new NullaryFunction.Direct<Boolean>(){

            @Override
            protected Boolean call() {
                return random.nextBoolean();
            }
        }));
    }

    @Override
    protected void configureOperators(OperatorDictionary<Operator<Boolean>> operators) {
        operators.registerOperator(new OpNot("~"));
        operators.registerOperator(new OpNot("not"));
        operators.registerOperator(new OpXor("^"));
        operators.registerOperator(new OpXor("xor"));
        operators.registerOperator(new OpXor("!="));
        operators.registerOperator(new OpIff("="));
        operators.registerOperator(new OpIff("<=>"));
        operators.registerOperator(new OpIff("eq"));
        operators.registerOperator(new OpIff("iff"));
        operators.registerOperator(new OpImplies("=>"));
        operators.registerOperator(new OpImplies("implies"));
        operators.registerOperator(new OpOr("|"));
        operators.registerOperator(new OpOr("or"));
        operators.registerOperator(new OpAnd("&"));
        operators.registerOperator(new OpAnd("and"));
    }

    public static Calculator<Boolean, ExprType> createSimple() {
        return new BoolCalculatorFactory().create(new BasicCompilerMapFactory());
    }

    public static Calculator<Boolean, ExprType> createDefault() {
        final CommonSimpleSymbolFactory letFactory = new CommonSimpleSymbolFactory(1, ":");
        return new BoolCalculatorFactory<ExprType>(){

            @Override
            protected void configureOperators(OperatorDictionary<Operator<Boolean>> operators) {
                super.configureOperators(operators);
                letFactory.registerSeparators(operators);
            }
        }.create(letFactory.createCompilerFactory());
    }

    private static class OpNot
    extends UnaryOperator.Direct<Boolean> {
        private OpNot(String id) {
            super(id);
        }

        @Override
        public Boolean execute(Boolean value) {
            return value == false;
        }
    }

    private static class OpXor
    extends BinaryOperator.Direct<Boolean> {
        private OpXor(String id) {
            super(id, 2);
        }

        @Override
        public Boolean execute(Boolean left, Boolean right) {
            return left ^ right;
        }
    }

    private static class OpIff
    extends BinaryOperator.Direct<Boolean> {
        private OpIff(String id) {
            super(id, 2);
        }

        @Override
        public Boolean execute(Boolean left, Boolean right) {
            return left == right;
        }
    }

    private static class OpImplies
    extends BinaryOperator.Direct<Boolean> {
        private OpImplies(String id) {
            super(id, 2);
        }

        @Override
        public Boolean execute(Boolean left, Boolean right) {
            return left == false | right;
        }
    }

    private static class OpOr
    extends BinaryOperator.Direct<Boolean> {
        private OpOr(String id) {
            super(id, 3);
        }

        @Override
        public Boolean execute(Boolean left, Boolean right) {
            return left | right;
        }
    }

    private static class OpAnd
    extends BinaryOperator.Direct<Boolean> {
        private OpAnd(String id) {
            super(id, 4);
        }

        @Override
        public Boolean execute(Boolean left, Boolean right) {
            return left & right;
        }
    }
}

