/*
 * Decompiled with CFR 0.152.
 */
package info.openmods.calc.parsing.node;

import com.google.common.collect.ImmutableList;
import info.openmods.calc.executable.BinaryOperator;
import info.openmods.calc.executable.IExecutable;
import info.openmods.calc.parsing.node.IExprNode;
import java.util.List;

public class BinaryOpNode<E>
implements IExprNode<E> {
    public final BinaryOperator<E> operator;
    public final IExprNode<E> left;
    public final IExprNode<E> right;

    public BinaryOpNode(BinaryOperator<E> operator, IExprNode<E> left, IExprNode<E> right) {
        this.operator = operator;
        this.left = left;
        this.right = right;
    }

    @Override
    public void flatten(List<IExecutable<E>> output) {
        this.left.flatten(output);
        this.right.flatten(output);
        output.add(this.operator);
    }

    public String toString() {
        return "<op: '" + this.operator.id + "', l: " + this.left + ", r: " + this.right + ">";
    }

    @Override
    public Iterable<IExprNode<E>> getChildren() {
        return ImmutableList.of(this.left, this.right);
    }
}

