/*
 * Decompiled with CFR 0.152.
 */
package info.openmods.calc.parsing;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.PeekingIterator;
import info.openmods.calc.Environment;
import info.openmods.calc.ExecutionErrorException;
import info.openmods.calc.ExprType;
import info.openmods.calc.Frame;
import info.openmods.calc.FrameFactory;
import info.openmods.calc.ICompilerMapFactory;
import info.openmods.calc.executable.BinaryOperator;
import info.openmods.calc.executable.IExecutable;
import info.openmods.calc.executable.Operator;
import info.openmods.calc.executable.OperatorDictionary;
import info.openmods.calc.parsing.BasicCompilerMapFactory;
import info.openmods.calc.parsing.ConstantSymbolStateTransition;
import info.openmods.calc.parsing.IValueParser;
import info.openmods.calc.parsing.ast.IParserState;
import info.openmods.calc.parsing.ast.ISymbolCallStateTransition;
import info.openmods.calc.parsing.ast.MappedParserState;
import info.openmods.calc.parsing.ast.SingleStateTransition;
import info.openmods.calc.parsing.node.BinaryOpNode;
import info.openmods.calc.parsing.node.DefaultExprNodeFactory;
import info.openmods.calc.parsing.node.ExprUtils;
import info.openmods.calc.parsing.node.IExprNode;
import info.openmods.calc.parsing.node.MappedExprNodeFactory;
import info.openmods.calc.parsing.node.SingleExecutableNode;
import info.openmods.calc.parsing.node.SquareBracketContainerNode;
import info.openmods.calc.parsing.node.SymbolCallNode;
import info.openmods.calc.parsing.node.SymbolGetNode;
import info.openmods.calc.parsing.token.Token;
import info.openmods.calc.symbol.ICallable;
import info.openmods.calc.symbol.IGettable;
import info.openmods.calc.symbol.SymbolMap;
import info.openmods.calc.utils.OptionalInt;
import info.openmods.calc.utils.Stack;
import info.openmods.calc.utils.StackValidationException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class CommonSimpleSymbolFactory<E> {
    public static final String SYMBOL_LET = "let";
    public static final String SYMBOL_FAIL = "fail";
    public static final String SYMBOL_CONSTANT = "const";
    private final Set<BinaryOperator<E>> keyValueSeparators;
    private final String keyValueSeparatorsIds;

    public CommonSimpleSymbolFactory(int keyValueSeparatorPriority, String ... keyValueSeparatorIds) {
        ImmutableSet.Builder separators = ImmutableSet.builder();
        for (String opId : keyValueSeparatorIds) {
            separators.add(new KeyValueSeparator(opId, keyValueSeparatorPriority));
        }
        this.keyValueSeparators = separators.build();
        this.keyValueSeparatorsIds = Joiner.on((char)',').join((Object[])keyValueSeparatorIds);
    }

    public Collection<BinaryOperator<E>> getKeyValueSeparators() {
        return this.keyValueSeparators;
    }

    private static <E> ISymbolBinder<E> createLetLazyConstant(final String name, IExprNode<E> valueNode) {
        final IExecutable<E> exprExecutable = ExprUtils.flattenNode(valueNode);
        return new ISymbolBinder<E>(){

            @Override
            public void bind(SymbolMap<E> localSymbols, final Frame<E> enclosingFrame) {
                class LazyConstant
                implements IGettable<E> {
                    private boolean isEvaluated;
                    private E value;

                    LazyConstant() {
                    }

                    @Override
                    public E get() {
                        if (!this.isEvaluated) {
                            Frame executionFrame = FrameFactory.newLocalFrame(enclosingFrame);
                            exprExecutable.execute(executionFrame);
                            this.value = executionFrame.stack().popAndExpectEmptyStack();
                        }
                        return this.value;
                    }
                }
                localSymbols.put(name, new LazyConstant());
            }
        };
    }

    private static <E> ISymbolBinder<E> createLetFunction(final String name, SymbolCallNode<E> symbolCallNode, IExprNode<E> valueNode) {
        ArrayList args = Lists.newArrayList();
        for (IExprNode<E> arg : symbolCallNode.getChildren()) {
            Preconditions.checkState((boolean)(arg instanceof SymbolGetNode), (String)"Expected symbol, got %s", arg);
            args.add(((SymbolGetNode)arg).symbol());
        }
        final List reversedArgs = Lists.reverse((List)args);
        final IExecutable<E> exprExecutable = ExprUtils.flattenNode(valueNode);
        return new ISymbolBinder<E>(){

            @Override
            public void bind(SymbolMap<E> localSymbols, final Frame<E> enclosingFrame) {
                class LetFunction
                implements ICallable<E> {
                    LetFunction() {
                    }

                    @Override
                    public void call(Frame<E> callSiteFrame, OptionalInt argumentsCount, OptionalInt returnsCount) {
                        int expectedArgCount = reversedArgs.size();
                        if (!argumentsCount.compareIfPresent(expectedArgCount)) {
                            throw new StackValidationException("Expected %s argument(s) but got %s", expectedArgCount, argumentsCount.get());
                        }
                        Frame executionFrame = FrameFactory.newLocalFrameWithSubstack(enclosingFrame, expectedArgCount);
                        Stack argStack = executionFrame.stack();
                        for (String arg : reversedArgs) {
                            executionFrame.symbols().put(arg, argStack.pop());
                        }
                        exprExecutable.execute(executionFrame);
                        int actualReturns = argStack.size();
                        if (!returnsCount.compareIfPresent(actualReturns)) {
                            throw new StackValidationException("Has %s result(s) but expected %s", actualReturns, returnsCount.get());
                        }
                    }
                }
                localSymbols.put(name, new LetFunction());
            }
        };
    }

    public ISymbolCallStateTransition<IExprNode<E>> createParserTransition(final IParserState<IExprNode<E>> currentState) {
        return new ISymbolCallStateTransition<IExprNode<E>>(){

            @Override
            public IParserState<IExprNode<E>> getState() {
                return currentState;
            }

            @Override
            public IExprNode<E> createRootNode(List<IExprNode<E>> children) {
                Preconditions.checkState((children.size() == 2 ? 1 : 0) != 0, (Object)"Expected two args for 'let' expression");
                return new LetNode(children.get(0), children.get(1));
            }
        };
    }

    public ICompilerMapFactory<E, ExprType> createCompilerFactory() {
        return new ExtendedCompilerMapFactory();
    }

    public void registerSeparators(OperatorDictionary<Operator<E>> operators) {
        for (BinaryOperator<E> separator : this.keyValueSeparators) {
            operators.registerOperator(separator);
        }
    }

    private class LetNode
    implements IExprNode<E> {
        private final IExprNode<E> argsNode;
        private final IExprNode<E> codeNode;

        public LetNode(IExprNode<E> argsNode, IExprNode<E> codeNode) {
            this.argsNode = argsNode;
            this.codeNode = codeNode;
        }

        @Override
        public void flatten(List<IExecutable<E>> output) {
            Preconditions.checkState((boolean)(this.argsNode instanceof SquareBracketContainerNode), (String)"Malformed 'let' expressions: expected brackets, got %s", this.argsNode);
            SquareBracketContainerNode bracketNode = (SquareBracketContainerNode)this.argsNode;
            ImmutableList vars = this.collectVars(bracketNode);
            IExecutable code = ExprUtils.flattenNode(this.codeNode);
            output.add(new LetExecutable(vars, code));
        }

        private ImmutableList<ISymbolBinder<E>> collectVars(SquareBracketContainerNode<E> bracketNode) {
            ImmutableList.Builder varsBuilder = ImmutableList.builder();
            for (IExprNode argNode : bracketNode.getChildren()) {
                this.flattenArgNode(varsBuilder, argNode);
            }
            return varsBuilder.build();
        }

        private void flattenArgNode(ImmutableList.Builder<ISymbolBinder<E>> output, IExprNode<E> argNode) {
            Preconditions.checkState((boolean)(argNode instanceof BinaryOpNode), (String)"Expected expression in from <name>:<expr>, got %s", argNode);
            BinaryOpNode opNode = (BinaryOpNode)argNode;
            Preconditions.checkState((boolean)CommonSimpleSymbolFactory.this.keyValueSeparators.contains(opNode.operator), (String)"Expected operators %s as separator, got %s", (Object)CommonSimpleSymbolFactory.this.keyValueSeparatorsIds, (Object)opNode.operator.id);
            IExprNode nameNode = opNode.left;
            IExprNode valueExprNode = opNode.right;
            if (nameNode instanceof SymbolGetNode) {
                SymbolGetNode symbolGetNode = (SymbolGetNode)nameNode;
                output.add((Object)CommonSimpleSymbolFactory.createLetLazyConstant(symbolGetNode.symbol(), valueExprNode));
            } else if (nameNode instanceof SymbolCallNode) {
                SymbolCallNode symbolCallNode = (SymbolCallNode)nameNode;
                output.add((Object)CommonSimpleSymbolFactory.createLetFunction(symbolCallNode.symbol(), symbolCallNode, valueExprNode));
            } else {
                throw new IllegalStateException("Expected symbol, got " + nameNode);
            }
        }

        @Override
        public Iterable<IExprNode<E>> getChildren() {
            return ImmutableList.of(this.argsNode, this.codeNode);
        }
    }

    private class LetExecutable
    implements IExecutable<E> {
        private final List<ISymbolBinder<E>> variables;
        private final IExecutable<E> expr;

        public LetExecutable(List<ISymbolBinder<E>> variables, IExecutable<E> expr) {
            this.variables = variables;
            this.expr = expr;
        }

        @Override
        public void execute(Frame<E> frame) {
            Frame letFrame = FrameFactory.newLocalFrameWithSubstack(frame, 0);
            for (ISymbolBinder e : this.variables) {
                e.bind(letFrame.symbols(), frame);
            }
            this.expr.execute(letFrame);
        }
    }

    private static interface ISymbolBinder<E> {
        public void bind(SymbolMap<E> var1, Frame<E> var2);
    }

    private static class KeyValueSeparator<E>
    extends BinaryOperator.Direct<E> {
        private KeyValueSeparator(String id, int precendence) {
            super(id, precendence);
        }

        @Override
        public E execute(E left, E right) {
            throw new UnsupportedOperationException();
        }
    }

    public class ExtendedCompilerMapFactory
    extends BasicCompilerMapFactory<E> {
        @Override
        protected DefaultExprNodeFactory<E> createExprNodeFactory(IValueParser<E> valueParser) {
            return SquareBracketContainerNode.install(new MappedExprNodeFactory(valueParser));
        }

        @Override
        protected void configureCompilerStateCommon(MappedParserState<IExprNode<E>> compilerState, Environment<E> environment) {
            super.configureCompilerStateCommon(compilerState, environment);
            compilerState.addStateTransition(CommonSimpleSymbolFactory.SYMBOL_LET, CommonSimpleSymbolFactory.this.createParserTransition(compilerState));
            compilerState.addStateTransition(CommonSimpleSymbolFactory.SYMBOL_FAIL, new FailStateTransition());
            compilerState.addStateTransition(CommonSimpleSymbolFactory.SYMBOL_CONSTANT, new ConstantSymbolStateTransition(compilerState, environment, CommonSimpleSymbolFactory.SYMBOL_CONSTANT));
        }
    }

    private class FailStateTransition
    extends SingleStateTransition.ForSymbol<IExprNode<E>> {
        private FailStateTransition() {
        }

        @Override
        public IExprNode<E> createRootNode(List<IExprNode<E>> children) {
            Preconditions.checkState((children.size() <= 1 ? 1 : 0) != 0, (String)"'fail' expects at most single argument, got %s", (int)children.size());
            if (children.isEmpty()) {
                return new SingleExecutableNode(new IExecutable<E>(){

                    @Override
                    public void execute(Frame<E> frame) {
                        throw new ExecutionErrorException();
                    }
                });
            }
            return children.get(0);
        }

        @Override
        public IExprNode<E> parseSymbol(IParserState<IExprNode<E>> state, PeekingIterator<Token> input) {
            Token arg = (Token)input.next();
            final String failCause = arg.value;
            return new SingleExecutableNode(new IExecutable<E>(){

                @Override
                public void execute(Frame<E> frame) {
                    throw new ExecutionErrorException(failCause);
                }
            });
        }
    }
}

