/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.oddities.feature;

import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiInventory;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IMerchant;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.village.MerchantRecipeList;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.registry.VillagerRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vazkii.arl.network.NetworkHandler;
import vazkii.arl.recipe.RecipeHandler;
import vazkii.quark.base.module.Feature;
import vazkii.quark.base.network.message.MessageHandleBackpack;
import vazkii.quark.oddities.client.gui.GuiBackpackInventory;
import vazkii.quark.oddities.item.ItemBackpack;

public class Backpacks
extends Feature {
    public static Item backpack;
    public static boolean superOpMode;
    boolean enableTrades;
    boolean enableCrafting;
    static int leatherCount;
    static int minEmeralds;
    static int maxEmeralds;
    @SideOnly(value=Side.CLIENT)
    boolean backpackRequested;

    @Override
    public void setupConfig() {
        this.enableTrades = this.loadPropBool("Enable Trade", "Set this to false if you want to disable the villager trade so you can add an alternate acquisition method", true);
        this.enableCrafting = this.loadPropBool("Enable Crafting", "Set this to true to enable a crafting recipe", false);
        superOpMode = this.loadPropBool("Unbalanced Mode", "Set this to true to allow the backpacks to be unequipped even with items in them", false);
        leatherCount = this.loadPropInt("Required Leather", "", 12);
        minEmeralds = this.loadPropInt("Min Required Emeralds", "", 12);
        maxEmeralds = this.loadPropInt("Max Required Emeralds", "", 18);
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        backpack = new ItemBackpack();
        if (this.enableCrafting) {
            RecipeHandler.addOreDictRecipe((ItemStack)new ItemStack(backpack), (Object[])new Object[]{"LLL", "LCL", "LLL", Character.valueOf('L'), new ItemStack(Items.field_151116_aA), Character.valueOf('C'), "chestWood"});
        }
    }

    @SubscribeEvent
    public void onRegisterVillagers(RegistryEvent.Register<VillagerRegistry.VillagerProfession> event) {
        if (!this.enableTrades) {
            return;
        }
        VillagerRegistry.VillagerProfession butcher = (VillagerRegistry.VillagerProfession)event.getRegistry().getValue(new ResourceLocation("minecraft:butcher"));
        VillagerRegistry.VillagerCareer leatherworker = butcher.getCareer(1);
        leatherworker.addTrade(1, new EntityVillager.ITradeList[]{new BackpackTrade()});
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onOpenGUI(GuiOpenEvent event) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (player != null && Backpacks.isInventoryGUI(event.getGui()) && !player.func_184812_l_() && Backpacks.isEntityWearingBackpack((Entity)player)) {
            this.requestBackpack();
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void clientTick(TickEvent.ClientTickEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (Backpacks.isInventoryGUI(mc.field_71462_r) && !this.backpackRequested && Backpacks.isEntityWearingBackpack((Entity)mc.field_71439_g)) {
            this.requestBackpack();
            this.backpackRequested = true;
        } else if (mc.field_71462_r instanceof GuiBackpackInventory) {
            this.backpackRequested = false;
        }
    }

    private void requestBackpack() {
        NetworkHandler.INSTANCE.sendToServer((IMessage)new MessageHandleBackpack(true));
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void removeCurseTooltip(ItemTooltipEvent event) {
        if (!superOpMode && event.getItemStack().func_77973_b() instanceof ItemBackpack) {
            for (String s : event.getToolTip()) {
                if (!s.equals(Enchantments.field_190941_k.func_77316_c(1))) continue;
                event.getToolTip().remove(s);
                return;
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private static boolean isInventoryGUI(GuiScreen gui) {
        return gui != null && gui.getClass() == GuiInventory.class;
    }

    public static boolean isEntityWearingBackpack(Entity e) {
        if (e instanceof EntityLivingBase) {
            EntityLivingBase living = (EntityLivingBase)e;
            ItemStack chestArmor = living.func_184582_a(EntityEquipmentSlot.CHEST);
            return chestArmor.func_77973_b() instanceof ItemBackpack;
        }
        return false;
    }

    public static boolean isEntityWearingBackpack(Entity e, ItemStack stack) {
        if (e instanceof EntityLivingBase) {
            EntityLivingBase living = (EntityLivingBase)e;
            ItemStack chestArmor = living.func_184582_a(EntityEquipmentSlot.CHEST);
            return chestArmor == stack;
        }
        return false;
    }

    @Override
    public boolean requiresMinecraftRestartToEnable() {
        return true;
    }

    @Override
    public boolean hasSubscriptions() {
        return true;
    }

    public static class BackpackTrade
    implements EntityVillager.ITradeList {
        public void func_190888_a(IMerchant merchant, MerchantRecipeList recipeList, Random random) {
            int emeraldCount = random.nextInt(maxEmeralds - minEmeralds) + minEmeralds;
            recipeList.add((Object)new MerchantRecipe(new ItemStack(Items.field_151116_aA, leatherCount), new ItemStack(Items.field_151166_bC, emeraldCount), new ItemStack(backpack)));
        }
    }
}

