/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.misc.feature;

import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import vazkii.quark.base.module.Feature;
import vazkii.quark.misc.block.BlockGlowstoneDust;
import vazkii.quark.misc.block.BlockGunpowder;

public class PlaceVanillaDusts
extends Feature {
    public static Block glowstone_dust_block;
    public static Block gunpowder_block;
    boolean enableGlowstone;
    boolean enableGunpowder;
    public static int gunpowderDelay;
    public static int gunpowderDelayNetherrack;

    @Override
    public void setupConfig() {
        this.enableGlowstone = this.loadPropBool("Enable Glowstone", "", true);
        this.enableGunpowder = this.loadPropBool("Enable Gunpowder", "", true);
        gunpowderDelay = this.loadPropInt("Gunpowder Delay", "Amount of ticks between each piece of gunpowder igniting the next", 10);
        gunpowderDelayNetherrack = this.loadPropInt("Gunpowder Delay on Netherrack", "Amount of ticks between each piece of gunpowder igniting the next, if on Netherrack", 5);
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        if (this.enableGlowstone) {
            glowstone_dust_block = new BlockGlowstoneDust();
        }
        if (this.enableGunpowder) {
            gunpowder_block = new BlockGunpowder();
        }
    }

    @SubscribeEvent
    public void onRightClick(PlayerInteractEvent.RightClickItem event) {
        EntityPlayer player = event.getEntityPlayer();
        World world = event.getWorld();
        EnumHand hand = event.getHand();
        ItemStack stack = event.getItemStack();
        RayTraceResult res = this.rayTrace(world, player, false);
        if (res != null) {
            BlockPos pos = res.func_178782_a();
            EnumFacing face = res.field_178784_b;
            if (this.enableGlowstone && stack.func_77973_b() == Items.field_151114_aO) {
                this.setBlock(player, world, pos, hand, face, glowstone_dust_block);
            } else if (this.enableGunpowder && stack.func_77973_b() == Items.field_151016_H) {
                this.setBlock(player, world, pos, hand, face, gunpowder_block);
            }
        }
    }

    private boolean setBlock(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, Block block) {
        ItemStack itemstack;
        boolean flag = worldIn.func_180495_p(pos).func_177230_c().func_176200_f((IBlockAccess)worldIn, pos);
        BlockPos blockpos = flag ? pos : pos.func_177972_a(facing);
        if (player.func_175151_a(blockpos, facing, itemstack = player.func_184586_b(hand)) && worldIn.func_190527_a(worldIn.func_180495_p(blockpos).func_177230_c(), blockpos, false, facing, null) && block.func_176196_c(worldIn, blockpos)) {
            worldIn.func_175656_a(blockpos, block.func_176223_P());
            if (player instanceof EntityPlayerMP) {
                CriteriaTriggers.field_193137_x.func_193173_a((EntityPlayerMP)player, blockpos, itemstack);
            }
            if (!player.field_71075_bZ.field_75098_d) {
                itemstack.func_190918_g(1);
            }
            player.func_184609_a(hand);
            return true;
        }
        return false;
    }

    @Override
    public boolean hasSubscriptions() {
        return true;
    }

    @Override
    public boolean requiresMinecraftRestartToEnable() {
        return true;
    }

    private RayTraceResult rayTrace(World worldIn, EntityPlayer playerIn, boolean useLiquids) {
        float f = playerIn.field_70125_A;
        float f1 = playerIn.field_70177_z;
        double d0 = playerIn.field_70165_t;
        double d1 = playerIn.field_70163_u + (double)playerIn.func_70047_e();
        double d2 = playerIn.field_70161_v;
        Vec3d vec3d = new Vec3d(d0, d1, d2);
        float f2 = MathHelper.func_76134_b((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f3 = MathHelper.func_76126_a((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = -MathHelper.func_76134_b((float)(-f * ((float)Math.PI / 180)));
        float f5 = MathHelper.func_76126_a((float)(-f * ((float)Math.PI / 180)));
        float f6 = f3 * f4;
        float f7 = f2 * f4;
        double d3 = 5.0;
        if (playerIn instanceof EntityPlayerMP) {
            d3 = ((EntityPlayerMP)playerIn).field_71134_c.getBlockReachDistance();
        }
        Vec3d vec3d1 = vec3d.func_72441_c((double)f6 * d3, (double)f5 * d3, (double)f7 * d3);
        return worldIn.func_147447_a(vec3d, vec3d1, useLiquids, !useLiquids, false);
    }
}

