/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.base.handler;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemArrow;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemMinecart;
import net.minecraft.item.ItemPickaxe;
import net.minecraft.item.ItemPotion;
import net.minecraft.item.ItemSpade;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionUtils;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import vazkii.quark.api.ICustomSorting;
import vazkii.quark.base.lib.LibObfuscation;
import vazkii.quark.base.module.ModuleLoader;
import vazkii.quark.management.feature.InventorySorting;
import vazkii.quark.oddities.inventory.ContainerBackpack;

public final class SortingHandler {
    private static final Comparator<ItemStack> FALLBACK_COMPARATOR = SortingHandler.jointComparator((s1, s2) -> Item.func_150891_b((Item)s1.func_77973_b()) - Item.func_150891_b((Item)s2.func_77973_b()), SortingHandler::damageCompare, (s1, s2) -> s2.func_190916_E() - s1.func_190916_E(), (s1, s2) -> s2.func_82833_r().compareTo(s1.func_82833_r()), (s1, s2) -> s2.hashCode() - s1.hashCode());
    private static final Comparator<ItemStack> FOOD_COMPARATOR = SortingHandler.jointComparator(SortingHandler::foodHealCompare, SortingHandler::foodSaturationCompare);
    private static final Comparator<ItemStack> TOOL_COMPARATOR = SortingHandler.jointComparator(SortingHandler::toolPowerCompare, SortingHandler::enchantmentCompare, SortingHandler::damageCompare);
    private static final Comparator<ItemStack> SWORD_COMPARATOR = SortingHandler.jointComparator(SortingHandler::swordPowerCompare, SortingHandler::enchantmentCompare, SortingHandler::damageCompare);
    private static final Comparator<ItemStack> ARMOR_COMPARATOR = SortingHandler.jointComparator(SortingHandler::armorSlotAndToughnessCompare, SortingHandler::enchantmentCompare, SortingHandler::damageCompare);
    private static final Comparator<ItemStack> BOW_COMPARATOR = SortingHandler.jointComparator(SortingHandler::enchantmentCompare, SortingHandler::damageCompare);

    public static void sortInventory(EntityPlayer player, boolean forcePlayer) {
        if (!ModuleLoader.isFeatureEnabled(InventorySorting.class)) {
            return;
        }
        Container c = player.field_71070_bA;
        if (forcePlayer || c == null) {
            c = player.field_71069_bz;
        }
        boolean backpack = c instanceof ContainerBackpack;
        boolean playerContainer = c == player.field_71069_bz || backpack;
        for (Slot s : c.field_75151_b) {
            IInventory inv = s.field_75224_c;
            if (inv == player.field_71071_by != playerContainer) continue;
            if (!playerContainer && s instanceof SlotItemHandler) {
                SortingHandler.sortInventory(((SlotItemHandler)s).getItemHandler());
                break;
            }
            InvWrapper wrapper = new InvWrapper(inv);
            if (playerContainer) {
                SortingHandler.sortInventory((IItemHandler)wrapper, 9, 36);
                break;
            }
            SortingHandler.sortInventory((IItemHandler)wrapper);
            break;
        }
        if (backpack) {
            for (Slot s : c.field_75151_b) {
                if (!(s instanceof SlotItemHandler)) continue;
                SortingHandler.sortInventory(((SlotItemHandler)s).getItemHandler());
                break;
            }
        }
    }

    public static void sortInventory(IItemHandler handler) {
        SortingHandler.sortInventory(handler, 0);
    }

    public static void sortInventory(IItemHandler handler, int iStart) {
        SortingHandler.sortInventory(handler, iStart, handler.getSlots());
    }

    public static void sortInventory(IItemHandler handler, int iStart, int iEnd) {
        int i;
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (i = iStart; i < iEnd; ++i) {
            ItemStack stackAt = handler.getStackInSlot(i);
            if (stackAt.func_190926_b()) continue;
            stacks.add(stackAt.func_77946_l());
        }
        SortingHandler.mergeStacks(stacks);
        SortingHandler.sortStackList(stacks);
        for (i = iStart; i < iEnd; ++i) {
            int j = i - iStart;
            ItemStack stack = j >= stacks.size() ? ItemStack.field_190927_a : (ItemStack)stacks.get(j);
            handler.extractItem(i, 64, false);
            if (stack.func_190926_b()) continue;
            handler.insertItem(i, stack, false);
        }
    }

    private static void mergeStacks(List<ItemStack> list) {
        for (int i = 0; i < list.size(); ++i) {
            ItemStack set = SortingHandler.mergeStackWithOthers(list, i);
            if (set.func_190926_b()) {
                list.remove(i);
                continue;
            }
            list.set(i, set);
        }
        list.removeIf(stack -> stack.func_190926_b() || stack.func_190916_E() == 0);
    }

    private static ItemStack mergeStackWithOthers(List<ItemStack> list, int index) {
        ItemStack stack = list.get(index);
        if (stack.func_190926_b()) {
            return stack;
        }
        for (int i = 0; i < list.size(); ++i) {
            ItemStack stackAt;
            if (i == index || (stackAt = list.get(i)).func_190926_b() || stackAt.func_190916_E() >= stackAt.func_77976_d() || !ItemStack.func_179545_c((ItemStack)stack, (ItemStack)stackAt) || !ItemStack.func_77970_a((ItemStack)stack, (ItemStack)stackAt)) continue;
            int setSize = stackAt.func_190916_E() + stack.func_190916_E();
            int carryover = Math.max(0, setSize - stackAt.func_77976_d());
            stackAt.func_190920_e(carryover);
            stack.func_190920_e(setSize - carryover);
            if (stack.func_190916_E() != stack.func_77976_d()) continue;
            return stack;
        }
        return stack;
    }

    public static void sortStackList(List<ItemStack> list) {
        Collections.sort(list, SortingHandler::stackCompare);
    }

    private static int stackCompare(ItemStack stack1, ItemStack stack2) {
        ItemType type2;
        ItemType type1;
        if (stack1 == stack2) {
            return 0;
        }
        if (stack1.func_190926_b()) {
            return -1;
        }
        if (stack2.func_190926_b()) {
            return 1;
        }
        if (stack1.func_77973_b() instanceof ICustomSorting && stack2.func_77973_b() instanceof ICustomSorting) {
            ICustomSorting sort1 = (ICustomSorting)stack1.func_77973_b();
            ICustomSorting sort2 = (ICustomSorting)stack2.func_77973_b();
            if (sort1.getSortingCategory().equals(sort2.getSortingCategory())) {
                return sort1.getItemComparator().compare(stack1, stack2);
            }
        }
        if ((type1 = SortingHandler.getType(stack1)) == (type2 = SortingHandler.getType(stack2))) {
            return type1.comparator.compare(stack1, stack2);
        }
        return type1.ordinal() - type2.ordinal();
    }

    private static ItemType getType(ItemStack stack) {
        for (ItemType type : (ItemType[])ItemType.class.getEnumConstants()) {
            if (!type.fitsInType(stack)) continue;
            return type;
        }
        throw new RuntimeException("Having an ItemStack that doesn't fit in any type is impossible.");
    }

    private static Predicate<ItemStack> classPred(Class<? extends Item> clazz) {
        return s -> !s.func_190926_b() && clazz.isInstance(s.func_77973_b());
    }

    private static Predicate<ItemStack> negClassPred(Class<? extends Item> clazz) {
        Predicate<ItemStack> classPred = SortingHandler.classPred(clazz);
        return s -> !classPred.test((ItemStack)s);
    }

    private static Predicate<ItemStack> itemPred(List<Item> list) {
        return s -> !s.func_190926_b() && list.contains(s.func_77973_b());
    }

    public static Comparator<ItemStack> jointComparator(Comparator<ItemStack> finalComparator, Comparator<ItemStack>[] otherComparators) {
        if (otherComparators == null) {
            return SortingHandler.jointComparator(finalComparator);
        }
        Comparator<ItemStack>[] resizedArray = Arrays.copyOf(otherComparators, otherComparators.length + 1);
        resizedArray[otherComparators.length] = finalComparator;
        return SortingHandler.jointComparator(resizedArray);
    }

    public static Comparator<ItemStack> jointComparator(Comparator<ItemStack> ... comparators) {
        return SortingHandler.jointComparatorFallback((s1, s2) -> {
            for (Comparator comparator : comparators) {
                int compare;
                if (comparator == null || (compare = comparator.compare(s1, s2)) == 0) continue;
                return compare;
            }
            return 0;
        }, FALLBACK_COMPARATOR);
    }

    private static Comparator<ItemStack> jointComparatorFallback(Comparator<ItemStack> comparator, Comparator<ItemStack> fallback) {
        return (s1, s2) -> {
            int compare = comparator.compare((ItemStack)s1, (ItemStack)s2);
            if (compare == 0) {
                return fallback == null ? 0 : fallback.compare((ItemStack)s1, (ItemStack)s2);
            }
            return compare;
        };
    }

    private static Comparator<ItemStack> listOrderComparator(List<Item> list) {
        return (stack1, stack2) -> {
            Item i1 = stack1.func_77973_b();
            Item i2 = stack2.func_77973_b();
            if (list.contains(i1)) {
                if (list.contains(i2)) {
                    return list.indexOf(i1) - list.indexOf(i2);
                }
                return 1;
            }
            if (list.contains(i2)) {
                return -1;
            }
            return 0;
        };
    }

    private static List<Item> list(Object ... items) {
        ArrayList<Item> itemList = new ArrayList<Item>();
        for (Object o : items) {
            Item i;
            if (o == null) continue;
            if (o instanceof Item) {
                itemList.add((Item)o);
                continue;
            }
            if (o instanceof Block) {
                itemList.add(Item.func_150898_a((Block)((Block)o)));
                continue;
            }
            if (o instanceof ItemStack) {
                itemList.add(((ItemStack)o).func_77973_b());
                continue;
            }
            if (!(o instanceof String) || (i = Item.func_111206_d((String)((String)o))) == null) continue;
            itemList.add(i);
        }
        return itemList;
    }

    private static int foodHealCompare(ItemStack stack1, ItemStack stack2) {
        return ((ItemFood)stack2.func_77973_b()).func_150905_g(stack2) - ((ItemFood)stack1.func_77973_b()).func_150905_g(stack1);
    }

    private static int foodSaturationCompare(ItemStack stack1, ItemStack stack2) {
        return (int)(((ItemFood)stack2.func_77973_b()).func_150906_h(stack2) * 100.0f - ((ItemFood)stack1.func_77973_b()).func_150906_h(stack1) * 100.0f);
    }

    private static int enchantmentCompare(ItemStack stack1, ItemStack stack2) {
        return SortingHandler.enchantmentPower(stack2) - SortingHandler.enchantmentPower(stack1);
    }

    private static int enchantmentPower(ItemStack stack) {
        if (!stack.func_77948_v()) {
            return 0;
        }
        Map enchs = EnchantmentHelper.func_82781_a((ItemStack)stack);
        int total = 0;
        for (Integer i : enchs.values()) {
            total += i.intValue();
        }
        return total;
    }

    private static int toolPowerCompare(ItemStack stack1, ItemStack stack2) {
        Item.ToolMaterial mat1 = (Item.ToolMaterial)ReflectionHelper.getPrivateValue(ItemTool.class, (Object)((ItemTool)stack1.func_77973_b()), (String[])LibObfuscation.TOOL_MATERIAL);
        Item.ToolMaterial mat2 = (Item.ToolMaterial)ReflectionHelper.getPrivateValue(ItemTool.class, (Object)((ItemTool)stack2.func_77973_b()), (String[])LibObfuscation.TOOL_MATERIAL);
        return (int)(mat2.func_77998_b() * 100.0f - mat1.func_77998_b() * 100.0f);
    }

    private static int swordPowerCompare(ItemStack stack1, ItemStack stack2) {
        return (int)(((ItemSword)stack2.func_77973_b()).func_150931_i() * 100.0f - ((ItemSword)stack1.func_77973_b()).func_150931_i() * 100.0f);
    }

    private static int armorSlotAndToughnessCompare(ItemStack stack1, ItemStack stack2) {
        ItemArmor armor1 = (ItemArmor)stack1.func_77973_b();
        ItemArmor armor2 = (ItemArmor)stack2.func_77973_b();
        EntityEquipmentSlot slot1 = armor1.field_77881_a;
        EntityEquipmentSlot slot2 = armor2.field_77881_a;
        if (slot1 == slot2) {
            return armor2.func_82812_d().func_78044_b(slot2) - armor2.func_82812_d().func_78044_b(slot1);
        }
        return slot2.func_188454_b() - slot1.func_188454_b();
    }

    private static int potionPowerCompare(ItemStack stack1, ItemStack stack2) {
        return SortingHandler.potionPower(stack2) - SortingHandler.potionPower(stack1);
    }

    private static int potionPower(ItemStack stack) {
        List effects = PotionUtils.func_185189_a((ItemStack)stack);
        if (effects.isEmpty()) {
            return 0;
        }
        int totalPower = 0;
        for (PotionEffect effect : effects) {
            totalPower += effect.func_76458_c() * effect.func_76459_b() + Potion.func_188409_a((Potion)effect.func_188419_a());
        }
        return totalPower * effects.size();
    }

    private static int damageCompare(ItemStack stack1, ItemStack stack2) {
        return stack1.func_77952_i() - stack2.func_77952_i();
    }

    static /* synthetic */ Predicate access$100(Class x0) {
        return SortingHandler.classPred(x0);
    }

    static /* synthetic */ Comparator access$200() {
        return FOOD_COMPARATOR;
    }

    static /* synthetic */ List access$300(Object[] x0) {
        return SortingHandler.list(x0);
    }

    static /* synthetic */ Comparator access$400() {
        return TOOL_COMPARATOR;
    }

    static /* synthetic */ Comparator access$500() {
        return SWORD_COMPARATOR;
    }

    static /* synthetic */ Comparator access$600() {
        return ARMOR_COMPARATOR;
    }

    static /* synthetic */ Comparator access$700() {
        return BOW_COMPARATOR;
    }

    static /* synthetic */ Predicate access$800(Class x0) {
        return SortingHandler.negClassPred(x0);
    }

    private static enum ItemType {
        FOOD(SortingHandler.access$100(ItemFood.class), (Comparator<ItemStack>)SortingHandler.access$200()),
        TORCH(SortingHandler.access$300(new Object[]{Blocks.field_150478_aa}), new Comparator[0]),
        TOOL_PICKAXE(SortingHandler.access$100(ItemPickaxe.class), (Comparator<ItemStack>)SortingHandler.access$400()),
        TOOL_SHOVEL(SortingHandler.access$100(ItemSpade.class), (Comparator<ItemStack>)SortingHandler.access$400()),
        TOOL_AXE(SortingHandler.access$100(ItemAxe.class), (Comparator<ItemStack>)SortingHandler.access$400()),
        TOOL_SWORD(SortingHandler.access$100(ItemSword.class), (Comparator<ItemStack>)SortingHandler.access$500()),
        TOOL_GENERIC(SortingHandler.access$100(ItemTool.class), (Comparator<ItemStack>)SortingHandler.access$400()),
        ARMOR(SortingHandler.access$100(ItemArmor.class), (Comparator<ItemStack>)SortingHandler.access$600()),
        BOW(SortingHandler.access$100(ItemBow.class), (Comparator<ItemStack>)SortingHandler.access$700()),
        ARROWS(SortingHandler.access$100(ItemArrow.class)),
        POTION(SortingHandler.access$100(ItemPotion.class)),
        REDSTONE(SortingHandler.access$300(new Object[]{Items.field_151137_ax, Blocks.field_150429_aA, Items.field_151107_aW, Items.field_151132_bS, Blocks.field_150442_at, Blocks.field_150430_aB, Blocks.field_150471_bO}), new Comparator[0]),
        MINECART(SortingHandler.access$100(ItemMinecart.class)),
        RAIL(SortingHandler.access$300(new Object[]{Blocks.field_150448_aq, Blocks.field_150318_D, Blocks.field_150319_E, Blocks.field_150408_cc}), new Comparator[0]),
        DYE(SortingHandler.access$100(ItemDye.class)),
        ANY(SortingHandler.access$800(ItemBlock.class)),
        BLOCK(SortingHandler.access$100(ItemBlock.class));

        private Predicate<ItemStack> pred;
        private Comparator<ItemStack> comparator;

        private ItemType(List<Item> list, Comparator<ItemStack> ... comparators) {
            this(SortingHandler.itemPred(list), SortingHandler.jointComparator((Comparator<ItemStack>)SortingHandler.listOrderComparator(list), comparators));
        }

        private ItemType(Predicate<ItemStack> pred) {
            this(pred, (Comparator<ItemStack>)FALLBACK_COMPARATOR);
        }

        private ItemType(Predicate<ItemStack> pred, Comparator<ItemStack> comparator) {
            this.pred = pred;
            this.comparator = comparator;
        }

        public boolean fitsInType(ItemStack stack) {
            return this.pred.test(stack);
        }
    }
}

