/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.ctm.client.state;

import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateBase;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import team.chisel.ctm.api.model.IModelCTM;
import team.chisel.ctm.api.util.RenderContextList;
import team.chisel.ctm.client.util.ProfileUtil;

@ParametersAreNonnullByDefault
public class CTMExtendedState
extends BlockStateBase
implements IExtendedBlockState {
    private final IBlockState wrapped;
    private final IBlockState clean;
    private final boolean extended;
    @Nullable
    private final IExtendedBlockState extState;
    private final IBlockAccess world;
    private final BlockPos pos;
    @Nullable
    private RenderContextList ctxCache;

    public CTMExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        ProfileUtil.start("ctm_extended_state");
        this.wrapped = state;
        this.world = world;
        this.pos = pos;
        this.extended = this.wrapped instanceof IExtendedBlockState;
        if (this.extended) {
            this.extState = (IExtendedBlockState)this.wrapped;
            this.clean = this.extState.getClean();
        } else {
            this.extState = null;
            this.clean = this.wrapped;
        }
        ProfileUtil.end();
    }

    public CTMExtendedState(IBlockState state, CTMExtendedState parent) {
        this(state, parent.world, parent.pos);
    }

    public RenderContextList getContextList(IBlockState state, IModelCTM model) {
        if (this.ctxCache == null) {
            this.ctxCache = new RenderContextList(state, model.getCTMTextures(), this.world, this.pos);
        }
        return this.ctxCache;
    }

    @Nullable
    public Collection<IUnlistedProperty<?>> getUnlistedNames() {
        return this.extended ? this.extState.getUnlistedNames() : Collections.emptyList();
    }

    @Nullable
    public <V> V getValue(@Nullable IUnlistedProperty<V> property) {
        return (V)(this.extended ? this.extState.getValue(property) : null);
    }

    public <V> IExtendedBlockState withProperty(@Nullable IUnlistedProperty<V> property, @Nullable V value) {
        return this.extended ? new CTMExtendedState((IBlockState)this.extState.withProperty(property, value), this) : this;
    }

    @Nullable
    public ImmutableMap<IUnlistedProperty<?>, Optional<?>> getUnlistedProperties() {
        return this.extended ? this.extState.getUnlistedProperties() : ImmutableMap.of();
    }

    public IBlockState getClean() {
        return this.clean;
    }

    public <T extends Comparable<T>> T func_177229_b(IProperty<T> property) {
        return (T)this.wrapped.func_177229_b(property);
    }

    public <T extends Comparable<T>, V extends T> IBlockState func_177226_a(IProperty<T> property, V value) {
        return new CTMExtendedState(this.wrapped.func_177226_a(property, value), this);
    }

    public <T extends Comparable<T>> IBlockState func_177231_a(IProperty<T> property) {
        return new CTMExtendedState(this.wrapped.func_177231_a(property), this);
    }

    public IBlockAccess getWorld() {
        return this.world;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public Collection<IProperty<?>> func_177227_a() {
        return this.wrapped.func_177227_a();
    }

    public ImmutableMap<IProperty<?>, Comparable<?>> func_177228_b() {
        return this.wrapped.func_177228_b();
    }

    public Block func_177230_c() {
        return this.wrapped.func_177230_c();
    }

    public boolean func_189547_a(World arg0, BlockPos arg1, int arg2, int arg3) {
        return this.wrapped.func_189547_a(arg0, arg1, arg2, arg3);
    }

    public void func_189546_a(World arg0, BlockPos arg1, Block arg2, BlockPos arg3) {
        this.wrapped.func_189546_a(arg0, arg1, arg2, arg3);
    }

    public Material func_185904_a() {
        return this.wrapped.func_185904_a();
    }

    public boolean func_185913_b() {
        return this.wrapped.func_185913_b();
    }

    public boolean func_189884_a(Entity arg0) {
        return this.wrapped.func_189884_a(arg0);
    }

    @Deprecated
    public int func_185891_c() {
        return this.wrapped.func_185891_c();
    }

    public int getLightOpacity(IBlockAccess arg0, BlockPos arg1) {
        return this.wrapped.getLightOpacity(arg0, arg1);
    }

    @Deprecated
    public int func_185906_d() {
        return this.wrapped.func_185906_d();
    }

    public int getLightValue(IBlockAccess arg0, BlockPos arg1) {
        return this.wrapped.getLightValue(arg0, arg1);
    }

    public boolean func_185895_e() {
        return this.wrapped.func_185895_e();
    }

    public boolean func_185916_f() {
        return this.wrapped.func_185916_f();
    }

    public MapColor func_185909_g(IBlockAccess arg0, BlockPos arg1) {
        return this.wrapped.func_185909_g(arg0, arg1);
    }

    public IBlockState func_185907_a(Rotation arg0) {
        return this.wrapped.func_185907_a(arg0);
    }

    public IBlockState func_185902_a(Mirror arg0) {
        return this.wrapped.func_185902_a(arg0);
    }

    public boolean func_185917_h() {
        return this.wrapped.func_185917_h();
    }

    public boolean func_191057_i() {
        return this.wrapped.func_191057_i();
    }

    public EnumBlockRenderType func_185901_i() {
        return this.wrapped.func_185901_i();
    }

    public int func_185889_a(IBlockAccess arg0, BlockPos arg1) {
        return this.wrapped.func_185889_a(arg0, arg1);
    }

    public float func_185892_j() {
        return this.wrapped.func_185892_j();
    }

    public boolean func_185898_k() {
        return this.wrapped.func_185898_k();
    }

    public boolean func_185915_l() {
        return this.wrapped.func_185915_l();
    }

    public boolean func_185897_m() {
        return this.wrapped.func_185897_m();
    }

    public int func_185911_a(IBlockAccess arg0, BlockPos arg1, EnumFacing arg2) {
        return this.wrapped.func_185911_a(arg0, arg1, arg2);
    }

    public boolean func_185912_n() {
        return this.wrapped.func_185912_n();
    }

    public int func_185888_a(World arg0, BlockPos arg1) {
        return this.wrapped.func_185888_a(arg0, arg1);
    }

    public float func_185887_b(World arg0, BlockPos arg1) {
        return this.wrapped.func_185887_b(arg0, arg1);
    }

    public float func_185903_a(EntityPlayer arg0, World arg1, BlockPos arg2) {
        return this.wrapped.func_185903_a(arg0, arg1, arg2);
    }

    public int func_185893_b(IBlockAccess arg0, BlockPos arg1, EnumFacing arg2) {
        return this.wrapped.func_185893_b(arg0, arg1, arg2);
    }

    public EnumPushReaction func_185905_o() {
        return this.wrapped.func_185905_o();
    }

    public IBlockState func_185899_b(IBlockAccess arg0, BlockPos arg1) {
        return this.wrapped.func_185899_b(arg0, arg1);
    }

    public AxisAlignedBB func_185918_c(World arg0, BlockPos arg1) {
        return this.wrapped.func_185918_c(arg0, arg1);
    }

    public boolean func_185894_c(IBlockAccess arg0, BlockPos arg1, EnumFacing arg2) {
        return this.wrapped.func_185894_c(arg0, arg1, arg2);
    }

    public boolean func_185914_p() {
        return this.wrapped.func_185914_p();
    }

    public AxisAlignedBB func_185890_d(IBlockAccess arg0, BlockPos arg1) {
        return this.wrapped.func_185890_d(arg0, arg1);
    }

    public void func_185908_a(World arg0, BlockPos arg1, AxisAlignedBB arg2, List<AxisAlignedBB> arg3, Entity arg4, boolean arg5) {
        this.wrapped.func_185908_a(arg0, arg1, arg2, arg3, arg4, arg5);
    }

    public AxisAlignedBB func_185900_c(IBlockAccess arg0, BlockPos arg1) {
        return this.wrapped.func_185900_c(arg0, arg1);
    }

    public RayTraceResult func_185910_a(World arg0, BlockPos arg1, Vec3d arg2, Vec3d arg3) {
        return this.wrapped.func_185910_a(arg0, arg1, arg2, arg3);
    }

    @Deprecated
    public boolean func_185896_q() {
        return this.wrapped.func_185896_q();
    }

    public boolean doesSideBlockRendering(IBlockAccess arg0, BlockPos arg1, EnumFacing arg2) {
        return this.wrapped.doesSideBlockRendering(arg0, arg1, arg2);
    }

    public boolean isSideSolid(IBlockAccess arg0, BlockPos arg1, EnumFacing arg2) {
        return this.wrapped.isSideSolid(arg0, arg1, arg2);
    }

    public boolean doesSideBlockChestOpening(IBlockAccess arg0, BlockPos arg1, EnumFacing arg2) {
        return this.wrapped.doesSideBlockChestOpening(arg0, arg1, arg2);
    }

    public Vec3d func_191059_e(IBlockAccess arg0, BlockPos arg1) {
        return this.wrapped.func_191059_e(arg0, arg1);
    }

    public boolean func_191058_s() {
        return this.wrapped.func_191058_s();
    }

    public BlockFaceShape func_193401_d(IBlockAccess arg0, BlockPos arg1, EnumFacing arg2) {
        return this.wrapped.func_193401_d(arg0, arg1, arg2);
    }

    static interface Exclusions {
        public <T extends Comparable<T>> T getValue(IProperty<T> var1);

        public <T extends Comparable<T>, V extends T> IBlockState withProperty(IProperty<T> var1, V var2);

        public <T extends Comparable<T>> IBlockState cycleProperty(IProperty<T> var1);
    }
}

