/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.ctm.client.model.parsing;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.block.model.ModelBlock;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import team.chisel.ctm.api.model.IModelCTM;
import team.chisel.ctm.api.model.IModelParser;
import team.chisel.ctm.client.model.ModelCTM;

public class ModelParserV1
implements IModelParser {
    private static final Gson GSON = new Gson();
    private static final ICustomModelLoader VANILLA_LOADER;

    @Override
    @Nonnull
    public IModelCTM fromJson(ResourceLocation res, JsonObject json) {
        ModelBlock modelinfo = ModelBlock.func_178294_a((String)json.toString());
        IModel vanillamodel = VANILLA_LOADER.loadModel(res);
        Map parsed = (Map)GSON.fromJson((JsonElement)json.getAsJsonObject("ctm_overrides"), new TypeToken<Map<String, JsonElement>>(){}.getType());
        if (parsed == null) {
            parsed = Collections.emptyMap();
        }
        Int2ObjectArrayMap replacements = new Int2ObjectArrayMap(parsed.size());
        for (Map.Entry e : parsed.entrySet()) {
            try {
                int index = Integer.parseInt((String)e.getKey());
                replacements.put(index, e.getValue());
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return new ModelCTM(modelinfo, vanillamodel, (Int2ObjectMap<JsonElement>)replacements);
    }

    static {
        try {
            Class<?> cls = Class.forName("net.minecraftforge.client.model.ModelLoader$VanillaLoader");
            VANILLA_LOADER = (ICustomModelLoader)ReflectionHelper.getPrivateValue(cls, null, (String[])new String[]{"INSTANCE"});
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }
}

