/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.world.worldgen;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.storage.WorldSavedData;

public class SlimeIslandData
extends WorldSavedData {
    private final List<StructureBoundingBox> islands = Lists.newArrayList();
    private final Map<ChunkPos, Long> chunksToGenerate = new ConcurrentHashMap<ChunkPos, Long>();

    public SlimeIslandData(String name) {
        super(name);
    }

    public void markChunkForGeneration(int chunkX, int chunkZ, long seed) {
        this.chunksToGenerate.put(new ChunkPos(chunkX, chunkZ), seed);
    }

    public Optional<Long> getSeedForChunkToGenerate(int chunkX, int chunkZ) {
        return Optional.ofNullable(this.chunksToGenerate.get(new ChunkPos(chunkX, chunkZ)));
    }

    public boolean markChunkAsGenerated(int chunkX, int chunkZ) {
        return this.chunksToGenerate.remove(new ChunkPos(chunkX, chunkZ)) != null;
    }

    public List<StructureBoundingBox> getIslands() {
        return this.islands;
    }

    public void func_76184_a(@Nonnull NBTTagCompound nbt) {
        this.islands.clear();
        NBTTagList tagList = nbt.func_150295_c("slimeislands", 11);
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            this.islands.add(new StructureBoundingBox(tagList.func_150306_c(i)));
        }
    }

    @Nonnull
    public NBTTagCompound func_189551_b(@Nonnull NBTTagCompound nbt) {
        NBTTagList tagList = new NBTTagList();
        for (StructureBoundingBox sbb : this.islands) {
            tagList.func_74742_a((NBTBase)sbb.func_151535_h());
        }
        nbt.func_74782_a("slimeislands", (NBTBase)tagList);
        return nbt;
    }
}

