/*
 * Decompiled with CFR 0.152.
 */
package T145.metalchests.items;

import T145.metalchests.api.immutable.ChestType;
import T145.metalchests.api.immutable.RegistryMC;
import T145.metalchests.entities.EntityMinecartMetalChest;
import T145.metalchests.items.ItemMod;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDispenser;
import net.minecraft.block.BlockRailBase;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.dispenser.BehaviorDefaultDispenseItem;
import net.minecraft.dispenser.IBehaviorDispenseItem;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemMetalMinecart
extends ItemMod {
    private static final IBehaviorDispenseItem MINECART_DISPENSER_BEHAVIOR = new BehaviorDefaultDispenseItem(){
        private final BehaviorDefaultDispenseItem dispenseBehavior = new BehaviorDefaultDispenseItem();

        private BlockRailBase.EnumRailDirection getRailDirection(IBlockSource source, BlockPos pos) {
            IBlockState state = source.func_189992_e();
            Block block = state.func_177230_c();
            if (block instanceof BlockRailBase) {
                BlockRailBase rail = (BlockRailBase)block;
                return rail.getRailDirection((IBlockAccess)source.func_82618_k(), pos, state, null);
            }
            return BlockRailBase.EnumRailDirection.NORTH_SOUTH;
        }

        public ItemStack func_82487_b(IBlockSource source, ItemStack stack) {
            EnumFacing front = (EnumFacing)source.func_189992_e().func_177229_b((IProperty)BlockDispenser.field_176441_a);
            BlockPos pos = source.func_180699_d().func_177972_a(front);
            World world = source.func_82618_k();
            IBlockState state = world.func_180495_p(pos);
            double yOffset = 0.0;
            if (BlockRailBase.func_176563_d((IBlockState)state)) {
                yOffset = this.getRailDirection(source, pos).func_177018_c() ? 0.6 : 0.1;
            } else {
                if (state.func_185904_a() != Material.field_151579_a || !BlockRailBase.func_176563_d((IBlockState)world.func_180495_p(pos.func_177977_b()))) {
                    return this.dispenseBehavior.func_82482_a(source, stack);
                }
                yOffset -= front != EnumFacing.DOWN && this.getRailDirection(source, pos.func_177977_b()).func_177018_c() ? 0.4 : 0.9;
            }
            double xOffset = source.func_82615_a() + (double)front.func_82601_c() * 1.125;
            double zOffset = source.func_82616_c() + (double)front.func_82599_e() * 1.125;
            EntityMinecartMetalChest cart = new EntityMinecartMetalChest(world, xOffset, yOffset += Math.floor(source.func_82617_b()) + (double)front.func_96559_d(), zOffset);
            cart.setChestType(ChestType.byMetadata(stack.func_77952_i()));
            world.func_72838_d((Entity)cart);
            stack.func_190918_g(1);
            return stack;
        }

        protected void func_82485_a(IBlockSource source) {
            source.func_82618_k().func_175718_b(1000, source.func_180699_d(), 0);
        }
    };

    public ItemMetalMinecart() {
        super(RegistryMC.RESOURCE_MINECART_METAL_CHEST, ChestType.values());
        this.func_77625_d(1);
        BlockDispenser.field_149943_a.func_82595_a((Object)this, (Object)MINECART_DISPENSER_BEHAVIOR);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        IBlockState state = world.func_180495_p(pos);
        if (!BlockRailBase.func_176563_d((IBlockState)state)) {
            return EnumActionResult.FAIL;
        }
        ItemStack stack = player.func_184586_b(hand);
        if (!world.field_72995_K) {
            BlockRailBase.EnumRailDirection dir = state.func_177230_c() instanceof BlockRailBase ? ((BlockRailBase)state.func_177230_c()).getRailDirection((IBlockAccess)world, pos, state, null) : BlockRailBase.EnumRailDirection.NORTH_SOUTH;
            double yOffset = 0.0;
            if (dir.func_177018_c()) {
                yOffset = 0.5;
            }
            EntityMinecartMetalChest cart = new EntityMinecartMetalChest(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.0625 + yOffset, (double)pos.func_177952_p() + 0.5);
            cart.setChestType(ChestType.byMetadata(stack.func_77952_i()));
            world.func_72838_d((Entity)cart);
        }
        stack.func_190918_g(1);
        return EnumActionResult.SUCCESS;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void prepareCreativeTab(NonNullList<ItemStack> items) {
        for (ChestType type : ChestType.values()) {
            if (!type.isRegistered()) continue;
            items.add((Object)new ItemStack((Item)this, 1, type.ordinal()));
        }
    }
}

