/*
 * Decompiled with CFR 0.152.
 */
package T145.metalchests.blocks;

import T145.metalchests.api.chests.IMetalChest;
import T145.metalchests.api.immutable.ChestType;
import T145.metalchests.api.immutable.RegistryMC;
import T145.metalchests.core.MetalChests;
import T145.metalchests.tiles.TileMetalChest;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class BlockMetalChest
extends Block {
    public BlockMetalChest() {
        super(Material.field_151573_f);
        this.registerResource();
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(IMetalChest.VARIANT, (Comparable)((Object)ChestType.IRON)));
        this.func_149711_c(3.0f);
        this.func_149647_a(MetalChests.TAB);
    }

    protected void registerResource(ResourceLocation resource) {
        this.setRegistryName(resource);
        this.func_149663_c(resource.toString());
    }

    protected void registerResource() {
        this.registerResource(RegistryMC.RESOURCE_METAL_CHEST);
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileMetalChest((ChestType)((Object)state.func_177229_b(IMetalChest.VARIANT)));
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public MapColor func_180659_g(IBlockState state, IBlockAccess world, BlockPos pos) {
        return ((ChestType)((Object)state.func_177229_b(IMetalChest.VARIANT))).getMapColor();
    }

    public Material func_149688_o(IBlockState state) {
        return ((ChestType)((Object)state.func_177229_b(IMetalChest.VARIANT))).getMaterial();
    }

    public SoundType getSoundType(IBlockState state, World world, BlockPos pos, @Nullable Entity entity) {
        return ((ChestType)((Object)state.func_177229_b(IMetalChest.VARIANT))).getSoundType();
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_190946_v(IBlockState state) {
        return true;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return Blocks.field_150477_bB.func_185496_a(state, world, pos);
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return this.func_185496_a(state, world, pos);
    }

    public float getExplosionResistance(World world, BlockPos pos, Entity exploder, Explosion explosion) {
        TileMetalChest chest;
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileMetalChest && (chest = (TileMetalChest)te).getChestType() == ChestType.OBSIDIAN) {
            return 10000.0f;
        }
        return super.getExplosionResistance(world, pos, exploder, explosion);
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileMetalChest) {
            TileMetalChest chest = (TileMetalChest)te;
            for (int i = 0; i < chest.getInventory().getSlots(); ++i) {
                ItemStack stack = chest.getInventory().getStackInSlot(i);
                if (stack.func_190926_b()) continue;
                InventoryHelper.func_180173_a((World)world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)stack);
            }
            world.func_175666_e(pos, (Block)this);
        }
        super.func_180663_b(world, pos, state);
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileMetalChest) {
            TileMetalChest chest = (TileMetalChest)te;
            chest.setFront(placer.func_174811_aO().func_176734_d());
        }
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K && world.func_175625_s(pos) instanceof TileMetalChest && !player.func_70093_af() && !this.isBlocked(world, pos)) {
            player.openGui((Object)"metalchests", 0, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
        return true;
    }

    private boolean isBlocked(World world, BlockPos pos) {
        return this.isBelowSolidBlock(world, pos) || this.isOcelotSittingOnChest(world, pos);
    }

    private boolean isBelowSolidBlock(World world, BlockPos pos) {
        return world.func_180495_p(pos.func_177984_a()).doesSideBlockChestOpening((IBlockAccess)world, pos.func_177984_a(), EnumFacing.DOWN);
    }

    private boolean isOcelotSittingOnChest(World world, BlockPos pos) {
        for (Entity entity : world.func_72872_a(EntityOcelot.class, new AxisAlignedBB((double)pos.func_177958_n(), (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p(), (double)(pos.func_177958_n() + 1), (double)(pos.func_177956_o() + 2), (double)(pos.func_177952_p() + 1)))) {
            EntityOcelot ocelot = (EntityOcelot)entity;
            if (!ocelot.func_70906_o()) continue;
            return true;
        }
        return false;
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState state, World world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileMetalChest) {
            TileMetalChest chest = (TileMetalChest)te;
            return ItemHandlerHelper.calcRedstoneFromInventory((IItemHandler)chest.getInventory());
        }
        return 0;
    }

    public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public int func_180651_a(IBlockState state) {
        return ((ChestType)((Object)state.func_177229_b(IMetalChest.VARIANT))).ordinal();
    }

    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        for (ChestType type : ChestType.values()) {
            if (!type.isRegistered()) continue;
            items.add((Object)new ItemStack((Block)this, 1, type.ordinal()));
        }
    }

    public EnumFacing[] getValidRotations(World world, BlockPos pos) {
        return EnumFacing.Plane.VERTICAL.func_179516_a();
    }

    public boolean rotateBlock(World world, BlockPos pos, EnumFacing axis) {
        if (world.field_72995_K) {
            return false;
        }
        if (axis.func_176740_k().func_176720_b()) {
            TileEntity te = world.func_175625_s(pos);
            if (te instanceof TileMetalChest) {
                TileMetalChest chest = (TileMetalChest)te;
                chest.setFront(chest.getFront().func_176746_e());
            }
            return true;
        }
        return false;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(IMetalChest.VARIANT, (Comparable)((Object)ChestType.byMetadata(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return ((ChestType)((Object)state.func_177229_b(IMetalChest.VARIANT))).ordinal();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{IMetalChest.VARIANT});
    }

    public boolean func_189539_a(IBlockState state, World world, BlockPos pos, int id, int param) {
        super.func_189539_a(state, world, pos, id, param);
        TileEntity te = world.func_175625_s(pos);
        return te != null && te.func_145842_c(id, param);
    }
}

