/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.core.container.elements;

import aroma1997.core.container.ContainerBase;
import aroma1997.core.container.elements.ContainerElementBase;
import aroma1997.core.inventory.ItemInventory;
import aroma1997.core.util.ItemUtil;
import aroma1997.core.util.WorldUtil;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;

public class ContainerElementHandheld
extends ContainerElementBase<ContainerBase<? extends ItemInventory>> {
    private static final String NBT_STACK_IDENTIFIER = "windowID";
    private final int stackIdentifier;
    private final ItemStack referenceStack;

    public ContainerElementHandheld(ContainerBase<? extends ItemInventory> container) {
        super(container);
        this.stackIdentifier = container.player.field_70170_p.field_73012_v.nextInt();
        ItemStack originalStack = ((ItemInventory)container.inventory).item.get();
        originalStack.func_77978_p().func_74768_a(NBT_STACK_IDENTIFIER, this.stackIdentifier);
        this.referenceStack = originalStack.func_77946_l();
        ((ItemInventory)container.inventory).item = this::getItemStack;
    }

    private boolean matches(ItemStack stack) {
        return ItemUtil.areItemsSameMatching(stack, this.referenceStack, ItemUtil.IItemMatchCriteria.DAMAGE, ItemUtil.IItemMatchCriteria.ID) && stack.func_77942_o() && stack.func_77978_p().func_74762_e(NBT_STACK_IDENTIFIER) == this.stackIdentifier;
    }

    private ItemStack getItemStack() {
        for (int i = -1; i < this.container.player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack stack;
            ItemStack itemStack = stack = i == -1 ? this.container.player.field_71071_by.func_70445_o() : this.container.player.field_71071_by.func_70301_a(i);
            if (!this.matches(stack)) continue;
            return stack;
        }
        return this.referenceStack;
    }

    @Override
    public void tick() {
        if (!this.container.player.field_70170_p.field_72995_K && this.getItemStack() == this.referenceStack) {
            ((ItemInventory)this.container.inventory).item = this::getItemStack;
            boolean drop = false;
            for (int i = 0; i < ((ItemInventory)this.container.inventory).func_70302_i_(); ++i) {
                ItemStack stack = ((ItemInventory)this.container.inventory).func_70301_a(i);
                if (!this.matches(stack)) continue;
                ((ItemInventory)this.container.inventory).func_70299_a(i, ItemStack.field_190927_a);
                drop = true;
            }
            if (drop) {
                WorldUtil.dropItems(this.container.player.field_70170_p, this.referenceStack.func_77946_l(), this.container.player.field_70165_t, this.container.player.field_70163_u, this.container.player.field_70161_v);
            }
            this.container.player.func_71053_j();
        }
    }

    @Override
    public void onClosed(EntityPlayer player) {
        this.getItemStack().func_77978_p().func_82580_o(NBT_STACK_IDENTIFIER);
    }
}

